# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'Status': ur'控制器（%s） 系统状态异常（%s）',
               'Temperature Status': ur'控制器（%s） 温度状态异常（%s）',
               'Voltage Status': ur'控制器（%s） 温度状态异常（%s）'}
                
res_desc_en = {'Status': r'Controller(%s) system status abnormal(%s)',
               'Temperature Status': r'Controller(%s) temperature status abnormal(%s)',
               'Voltage Status': r'Controller(%s) voltage status abnormal(%s)'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        ctrlCont = cli.execCmdWithTimout("showcontroller", 600)
        ctrlCont = re.sub(r'Processing....[^\w=]*', '', ctrlCont)        
        ctrlDict = format_cli_info_col(ctrlCont)  
        
        #处理命令执行异常
        if not ctrlDict :  
            return (False, "%s" % (ctrlCont), errMsg)        
         
        for dictIdx in range(0, len(ctrlDict["Controller ID"])):
            for keyIdx in desc:
                if ctrlDict[keyIdx][dictIdx].lower() != "normal":
                    flag = False
                    errorItem = desc[keyIdx] % (ctrlDict["Controller ID"][dictIdx], ctrlDict[keyIdx][dictIdx])
                    errMsg += "%s\n" % (errorItem)                       
         
        return (flag, ctrlCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")         
        