# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'power': ur'框（%s） 电源（%s） 异常 (%s)'}
                
res_desc_en = {'power': r'Enclosure(%s) power(%s) is abnormal(%s)'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        powerCont = cli.execCmdWithTimout("showpower", 600)
        powerCont = re.sub(r'Processing....[^\w=]*', '', powerCont)        
        powerDict = format_cli_info_row(powerCont) 

        #处理命令执行异常
        if not powerDict :  
            return (False, "%s" % (powerCont), errMsg)        
          
        for dictIdx in range(0, len(powerDict["Power ID"])):
            if powerDict["Status"][dictIdx].lower() != "normal":
                flag = False
                errorItem = desc["power"] % (powerDict["Enclosure ID"][dictIdx], powerDict["Power ID"][dictIdx], powerDict["Status"][dictIdx])
                errMsg += "%s\n" % (errorItem)                       
         
        return (flag, powerCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")   
        