# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'fan': ur'框（%s） 风扇（%s） 异常 (%s)'}
                
res_desc_en = {'fan': r'Enclosure(%s) fan(%s) is abnormal(%s)'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        fanCont = cli.execCmdWithTimout("showfan", 600)
        fanCont = re.sub(r'Processing....[^\w=]*', '', fanCont)        
        fanDict = format_cli_info_col(fanCont)   
        
        #处理命令执行异常
        if not fanDict :  
            return (False, "%s" % (fanCont), errMsg)        
        
        for dictIdx in range(0, len(fanDict["Fan ID"])):
            if fanDict["Status"][dictIdx].lower() != "normal":
                flag = False
                errorItem = desc["fan"] % (fanDict["Enclosure ID"][dictIdx], fanDict["Fan ID"][dictIdx], fanDict["Status"][dictIdx])
                errMsg += "%s\n" % (errorItem)                       
         
        return (flag, fanCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")