# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'Status': ur'控制器（%s） 系统盘状态异常（%s）',
               'number': ur'控制器系统盘数量错误'}
                
res_desc_en = {'Status': r'Controller(%s) system disk status abnormal(%s)',
               'number': r'The number of controller system disk is error'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
    rawInfo = "" 
       
    try:
        desc = res_desc[py_java_env.get("lang")]
        ctrlCont = cli.execCmdWithTimout("showcontroller", 600)
        ctrlCont = re.sub(r'Processing....[^\w=]*', '', ctrlCont)        
        ctrlDict = format_cli_info_col(ctrlCont)
                
        diskCont = cli.execCmdWithTimout("showsysdisk", 600)
        diskCont = re.sub(r'Processing....[^\w=]*', '', diskCont)        
        diskDict = format_cli_info_col(diskCont)
        
        #处理命令执行异常
        if not ctrlDict or not diskDict:  
            return (False, "%s\n%s" % (ctrlCont,diskCont), errMsg)
                        
        for dictIdx in range(0, len(diskDict["Controller ID"])):
            if diskDict["State"][dictIdx].lower() != "normal":
                flag = False
                errorItem = desc["Status"] % (diskDict["Controller ID"][dictIdx], diskDict["State"][dictIdx])
                errMsg += "%s\n" % (errorItem)                       
        rawInfo = diskCont
        
        if len(ctrlDict["Controller ID"]) != len(diskDict["Controller ID"]):
            flag = False            
            errMsg += "%s\n" % (desc["number"])
            rawInfo = "%s\n%s" % (ctrlCont, diskCont)
                         
        return (flag, rawInfo, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")         

