# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'Model': ur'控制器间型号不一致',
               'Number': ur'控制器间内核数量不一致',
               'Usage': ur'控制器（%s） CPU使用率异常'}
                
res_desc_en = {'Model': r'The Model of controllers is not consistent',
               'Number': r'The Core Number of controller is not consistent',
               'Usage': r'The CPU Usage of controller(%s) abnormal(%s)'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
    rawInfo = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        ctrlCont = cli.execCmdWithTimout("showcontroller", 600)
        ctrlCont = re.sub(r'Processing....[^\w=]*', '', ctrlCont)        
        ctrlDict = format_cli_info_col(ctrlCont)   
        
        #处理命令执行异常
        if not ctrlDict :  
            return (False, "%s" % (ctrlCont), errMsg)
                    
        for dictIdx in range(0, len(ctrlDict["Controller ID"])):
            cpuCont = cli.execCmdWithTimout("showcpu -c %s" % (ctrlDict["Controller ID"][dictIdx]), 600)                     
            cpuCont = re.sub(r'Processing....[^\w=]*', '', cpuCont)
            rawInfo += "%s\n" %(cpuCont)
        cpuDict = format_cli_info_col(rawInfo) 
        
        if len(set(cpuDict["Model"])) != 1 :
            flag = False
            errMsg += "\n%s" % (desc["Model"])
            
        if len(set(cpuDict["Model"])) != 1 :
            flag = False
            errMsg += "\n%s" % (desc["Number"])

        for dictIdx in range(0, len(ctrlDict["Controller ID"])):
            if int(cpuDict["Usage(%)"][dictIdx]) >= 60:
                flag = False
                errItem = desc["Usage"] % (ctrlDict["Controller ID"][dictIdx])
                errMsg += "\n%s" % (errItem)  
                                                      
        if not flag:
            rawInfo = "%s\n%s" % (ctrlCont, rawInfo)
                     
        return (flag, rawInfo, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")    
        
