# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'Capacity': ur'控制器内存容量不一致',
               'Usage': ur'控制器（%s） 内存使用率异常'}
                
res_desc_en = {'Capacity': r'The Memory Capacity of controller abnormal',
               'Usage': r'The Memory Usage of controller(%s) abnormal'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        memCont = cli.execCmdWithTimout("showmem", 600)
        memCont = re.sub(r'Processing....[^\w=]*', '', memCont)       
        memDict = format_cli_info_row(memCont)
        
        #处理命令执行异常
        if not memDict :  
            return (False, "%s" % (memCont), errMsg)
        
        stdMemSet = set(["49152","98304"])
        memSet = set(memDict["Capacity(M)"])
        if len(memSet) != 1 and len(memSet.difference(stdMemSet)) > 0:
            flag = False
            errMsg += "\n%s" % (desc["Capacity"])
                       
        for dictIdx in range(0, len(memDict["Controller ID"])):
            if int(memDict["Usage(%)"][dictIdx]) >= 60:
                flag = False
                errItem = desc["Usage"] % (memDict["Controller ID"][dictIdx])
                errMsg += "\n%s" % (errItem)                        
         
        return (flag, memCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")         
        