# -*- coding: UTF-8 -*-
import sys,re,time
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'fcerr': ur'控制器（%s）接口模块（%s）端口（%s）存在误码'}
                
res_desc_en = {'fcerr': r'Controller(%s) interface(%s) port(%s) has error code'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
    rawInfo = ""
    
    try:
        desc = res_desc[py_java_env.get("lang")]
        errCont = cli.execCmdWithTimout("showfcber", 600)
        errCont = re.sub(r'Processing....[^\w=]*', '', errCont)        
        errDict1 = format_cli_info_col(errCont)
        
        rawInfo += errCont
        
        time.sleep(2)
        errCont = cli.execCmdWithTimout("showfcber", 600)
        errCont = re.sub(r'Processing....[^\w=]*', '', errCont)        
        errDict2 = format_cli_info_col(errCont)
        
        rawInfo += errCont           

        #处理命令执行异常
        if not errDict1 or not errDict2 :  
            return (True, "%s" % (rawInfo), errMsg)
            
        for dictIdx in range(0, len(errDict2["Control ID"])):
            if (errDict2["Link Status"][dictIdx] == "Link Up") \
               and (int(errDict2["Link Errors Codes"][dictIdx]) > int(errDict1["Link Errors Codes"][dictIdx])):
                flag = False
                errorItem = desc["fcerr"] % (errDict2["Control ID"][dictIdx], errDict2["Interface Module ID"][dictIdx], errDict2["Port ID"][dictIdx])
                errMsg += "%s\n" % (errorItem)

        return (flag, rawInfo, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")