# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'fcerr': ur'控制器（%s）接口模块（%s）端口（%s）速率不匹配'}
                
res_desc_en = {'fcerr': r'Controller(%s) interface(%s) port(%s) speed not consistent'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
    
    try:
        desc = res_desc[py_java_env.get("lang")]
        fcspeedCont = cli.execCmdWithTimout("showfcspeed", 600)        
        fcspeedCont = re.sub(r'Processing....[^\w=]*', '', fcspeedCont)
        fcspeedDict = format_cli_info_row(fcspeedCont) 


        #处理命令执行异常
        if not fcspeedDict :  
            return (True, "%s" % (fcspeedCont), errMsg)
                    
        for dictIdx in range(0, len(fcspeedDict["Controller ID"])):
            if (fcspeedDict["Current Speed"][dictIdx].find("Gbps") != -1) \
               and (fcspeedDict["Configured Speed"][dictIdx].find("Gbps") != -1) \
               and (fcspeedDict["Configured Speed"][dictIdx] != fcspeedDict["Current Speed"][dictIdx]):
                flag = False
                errorItem = desc["fcerr"] % (fcspeedDict["Controller ID"][dictIdx], fcspeedDict["Interface Module ID"][dictIdx], fcspeedDict["Port ID"][dictIdx])
                errMsg += "%s\n" % (errorItem)
        return (flag, fcspeedCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")