# -*- coding: UTF-8 -*-
import sys
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)

from inspect_interface import *

#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'nodeerr': ur'控制器（%s）巡检异常（%s）'}
                
res_desc_en = {'nodeerr': r'Controller(%s) inspect abnormal(%s)'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 
        
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showpower")
    Return             : the checkitem is pass;cli source info
    """
    rawInfo = ""
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliCont = ""
        
        init_interface(cli, PY_LOGGER.debug, res_desc[py_java_env.get("lang")])    
    
        inspectCont = execute_vxinspect(210)
        
        if not inspectCont[0]:
            return inspectCont
            
        cliCont += "%s\n" % (cli.execCmdWithTimout("showhostgroup", 600))
        cliCont += "%s\n" % (cli.execCmdWithTimout("showhost", 600))
        cliCont += "%s\n" % (cli.execCmdWithTimout("showhostport", 600))

        cliCont = re.sub(r'Processing....[^\w=]*', '', cliCont)                         
        rawInfo = "%s\n%s" % (inspectCont[1], cliCont)
        
        return (True, rawInfo, "")
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "") 

