# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'map': ur'磁盘组（%s） 卷（%s） 异常 (%s)'}
                
res_desc_en = {'map': r'DiskGroup(%s) volume(%s) is abnormal(%s)'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        mapCont = cli.execCmdWithTimout("showhostmap", 600)
        mapCont = re.sub(r'Processing....[^\w=]*', '', mapCont)        
        mapDict = format_cli_info_row(mapCont)   
        if not mapDict:
            return (True,"%s" % (mapCont), errMsg)
             
        for dictIdx in range(0, len(mapDict["Map ID"])):
            if mapDict["Status"][dictIdx] != "0" and mapDict["Status"][dictIdx].lower() != "normal":
                flag = False
                errorItem = desc["map"] % (mapDict["DiskGroup Name"][dictIdx], mapDict["Vol Name"][dictIdx], mapDict["Status"][dictIdx])
                errMsg += "%s\n" % (errorItem)                       
         
        return (flag, mapCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")   
        