# -*- coding: UTF-8 -*-
import sys
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)

from inspect_interface import *

#设置异常返回的提示信息，涉及到中英文
#rlinkerr||CTRL ID:1||NAME:rlk_xxx.xxx.xxx.xxx_rvg001||KSTATE:RECOVER||STATE:ACTIVE
res_desc_zh = {'nodeerr': ur'控制器（%s）巡检异常（%s）',
               'rlinkerr': ur'控制器（%s）RLINK（%s）状态异常（KSTATE：%s，STATE：%s，PROTOCOL：%s）'}
                
res_desc_en = {'nodeerr': r'Controller(%s) inspect abnormal(%s)',
               'rlinkerr': r'Controller(%s) rlink(%s) state abnormal(KSTATE:%s, STATE:%s, PROTOCOL:%s)'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 
        
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showpower")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        
        init_interface(cli, PY_LOGGER.debug, res_desc[py_java_env.get("lang")])    
    
        inspectCont = execute_vxinspect(309)
    
        return inspectCont
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")