# -*- coding: UTF-8 -*-
import sys
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)

from inspect_interface import *

#设置异常返回的提示信息，涉及到中英文
#dcoerr||CTRL ID:1||DISKGROUP:mjl||NAME:18_02_05volume002_dcl||ASSOC:gen
res_desc_zh = {'nodeerr': ur'控制器（%s）巡检异常（%s）',
               'dcoerr': ur'控制器（%s）磁盘组（%s）卷名称（%s）ASSOC（%s）dco异常'}
                
res_desc_en = {'nodeerr': r'Controller(%s) inspect abnormal(%s)',
               'dcoerr': r'Controller(%s) diskgroup(%s) volume(%s) ASSOC(%s) dco abnormal'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 
        
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showpower")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        
        init_interface(cli, PY_LOGGER.debug, res_desc[py_java_env.get("lang")])    
    
        inspectCont = execute_vxinspect(318)
    
        return inspectCont
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")