# -*- coding: UTF-8 -*-
import re,sys
import traceback
import xml.dom.minidom

from vistoollib import  *

g_devobj = None
g_desc = None

def init_interface(vobj, vlogger, vdesc):
    '''初始化连接对象'''
    global g_devobj, g_desc
    g_devobj = vobj
    g_desc = vdesc
    init_logger(vlogger)
    
def extract_xml(inputCont) :
    '''从字符串中提取xml正文，去掉前后干扰字符'''
    return inputCont[inputCont.find(r"<?xml"):inputCont.rfind(r"</device>") + len(r"</device>")]
    
    
def execute_vxinspect(itemId, timeout = 3600, othPara = '' ) :
    '''执行CLIvxinspect命令，并取回巡检结果xml文件内容，进行分析''' 
    try:
         
        retCont = g_devobj.execCmdWithTimout("vxinspect -c %d %s" % (itemId, othPara), timeout, [':/>'])
                        
        dom = xml.dom.minidom.parseString(extract_xml(retCont))
        root = dom.documentElement
        node = root.getElementsByTagName("cmditem")[0]
        cmditemId = node.getAttribute('id')
        
        if cmditemId != str(itemId):
            return (False,"","cmd item id is error")
        
        node = node.getElementsByTagName("item")[0]
        itemId = node.getAttribute('id')
        if itemId != "0" :
            return (False,"","item id is error")
        
        # 提取原始信息
        commonValueCont=""
        for listIdx in node.getElementsByTagName("commonvalue"):
            commonValueCont += "%s\n" %(listIdx.childNodes[0].data)
        
        # 提取错误信息
        errorValueCont=""
        for listIdx in node.getElementsByTagName("errorvalue"):
            #先整理参数，去掉冒号和前面的抬头，例如CTRL ID：
            errorValueTuple = tuple(re.split(r'\|\|[^:]*:', listIdx.childNodes[0].data))
            errorItem=g_desc[errorValueTuple[0]] % errorValueTuple[1:]
            errorValueCont += "%s\n" %(errorItem)
        
        # 提取巡检结果
        judgeCont = node.getElementsByTagName("judge")[0].childNodes[0].data
        judgeValue = True
        if judgeCont != "0":
            judgeValue = False        
        
        return (judgeValue, commonValueCont, errorValueCont)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "execute inspect abnomal", "")