# -*- coding: UTF-8 -*-
import sys
import traceback

#########################################
#      巡检后置脚本
#########################################

sys.prefix = "__pyclasspath__"
cur_path = os.path.dirname(__file__)
if cur_path not in sys.path :
    sys.path.append(cur_path)
from vistoollib import  *

init_logger(PY_LOGGER.debug)

from inspect_interface import *

g_devObj = None

#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'success': ur'系统清理通过',
               'except':  ur'系统清理异常',
               'vxconfigderr': ur'控制器 %s vxconfigd异常',
               'sysvxconfigderr': ur'系统主节点vxconfigd异常'}  
                             
res_desc_en = {'success': r'System clean done',
               'except':  r'System clean except',
               'vxconfigderr': r'Controller %s vxconfigd abnormal',
               'sysvxconfigderr': r'The master node vxconfigd abnormal'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 
    

  
    
def execute(devObj):
    try:
        global g_devObj
        g_devObj = devObj
        ssh = g_devObj.get("ssh")
        
        global lang
        lang = g_devObj.get("lang")
        if lang != "zh" :
            lang = "en"            

        init_interface(ssh, PY_LOGGER.debug, res_desc[lang]) 
        
        # 4执行巡检预置命令（主要包括分发vxinspect到其他节点的/OSM/bin/script/）
        inspectCont = execute_vxinspect(901)
        if not inspectCont[0] :
           return ('', dict(flag = False, des = inspectCont[2]))   
        
        # 5再执行一个vx命令，判断是否有挂死现象
        cliCont = ssh.execCmdWithTimout("vxdctl -c mode", 10)
        if cliCont.find("mode: enabled: cluster active") == -1:
            return ('', dict(flag = False, des = res_desc[lang]['sysvxconfigderr']))
                                                                      
        debug_out("clean for inspect successful.")
        return ('', dict(flag = True, des = res_desc[lang]['success'])) 
    except BaseException:
        debug_out(traceback.format_exc())
        return ('', dict(flag = False, des = res_desc[lang]['except']))    
