# -*- coding: UTF-8 -*-
import sys
import traceback
import time
from java.io import File

#########################################
#      巡检前置脚本
# 1检查内存使用率
# 2检查CPU使用率
# 3上载巡检脚本到设备/home/permitdir/bin/script/(/OSM/bin/script/)
# 4执行巡检预置命令（主要包括分发vxinspect到其他节点的/OSM/bin/script/）
#########################################

sys.prefix = "__pyclasspath__"
cur_path = os.path.dirname(__file__)
if cur_path not in sys.path :
    sys.path.append(cur_path)
from vistoollib import  *
init_logger(PY_LOGGER.debug)

from inspect_interface import *

g_devObj = None

MAX_USAGE_MEM = 82
MAX_USAGE_CPU = 82

#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'success': ur'系统检查通过', 
               'except':  ur'系统检查异常', 
               'sysbanormal': ur'系统模式异常，不能执行CLI命令', 
               'memover': ur'控制器 %s 内存使用率（%s%%）超过%d%%',
               'cpuover': ur'控制器 %s CPU %s 使用率（%s%%）超过%d%%',
               'vxconfigderr': ur'控制器 %s vxconfigd异常 ',
               'sysvxconfigderr': ur'系统主节点vxconfigd异常'}
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except',
               'sysbanormal':  r'system status abnormal, can not execute CLI', 
               'memover': r'Controller %s memory usage(%s%%) over %d%%',
               'cpuover': r'Controller %s CPU %s usage(%s%%) over %d%%',
               'vxconfigderr': r'Controller %s vxconfigd abnormal ',
               'sysvxconfigderr': r'The master node vxconfigd abnormal'}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 
    
def execute(devObj):
    try:
        global g_devObj
        g_devObj = devObj
        ssh = g_devObj.get("ssh")
        sftp = g_devObj.get("sftp")
                
        global lang
        lang = g_devObj.get("lang")
        if lang != "zh" :
            lang = "en"
            
        init_interface(ssh, PY_LOGGER.debug, res_desc[lang])
         
        # 0 检查系统当前是否处于CLI模式，防止其他模式下执行CLI命令
        sysInfoDict = format_cli_info_col(ssh.execCmd("showsys")) 
        if "Device Type" not in sysInfoDict :
            debug_out("system status abnormal, can not execute CLI")
            expect_desc = res_desc[lang]['sysbanormal']
            return ('', dict(flag = False, des = expect_desc)) 
              
        # 1 检查内存使用率
        memDict = format_cli_info_row(ssh.execCmd("showmem"))
        for dictIdx in range(0, len(memDict["Controller ID"])) :
            if int(memDict["Usage(%)"][dictIdx]) > MAX_USAGE_MEM:
                debug_out("Controller %s memory usage %s > %d" % (memDict["Controller ID"][dictIdx], memDict["Usage(%)"][dictIdx], MAX_USAGE_MEM))
                expect_desc = res_desc[lang]['memover'] % (memDict["Controller ID"][dictIdx], memDict["Usage(%)"][dictIdx], MAX_USAGE_MEM)
                return ('', dict(flag = False, des = expect_desc))
                
        # 2 检查CPU使用率
        for nodeIdx in memDict["Controller ID"] :
            ctrlCPUDict = format_cli_info_col(ssh.execCmd("showcpu -c %s" % nodeIdx))       
            for dictIdx in range(0, len(ctrlCPUDict["Controller ID"])) :
                if int(ctrlCPUDict["Usage(%)"][dictIdx]) > MAX_USAGE_CPU:
                    debug_out("Controller %s CPU %s usage %s > %d" % (ctrlCPUDict["Controller ID"][dictIdx], \
                            ctrlCPUDict["CPU ID"][dictIdx],ctrlCPUDict["Usage(%)"][dictIdx], MAX_USAGE_CPU))
                    expect_desc = res_desc[lang]['cpuover'] % (ctrlCPUDict["Controller ID"][dictIdx], \
                            ctrlCPUDict["CPU ID"][dictIdx],ctrlCPUDict["Usage(%)"][dictIdx], MAX_USAGE_CPU)
                    return ('', dict(flag = False, des = expect_desc))                         
        
        # 3上载巡检脚本到设备/home/permitdir/bin/script/(/OSM/bin/script/)
                    
        sftp.putFile( File(os.path.dirname(__file__) + r"\\vxinspect") , \
                     r"/OSM/bin/script", None)        
       
        # 4执行巡检预置命令（主要包括分发vxinspect到其他节点的/OSM/bin/script/）
        inspectCont = execute_vxinspect(900)

        if not inspectCont[0] :
           return ('', dict(flag = False, des = inspectCont[2]))   
        
        # 5再执行一个vx命令，判断是否有挂死现象
        cliCont = ssh.execCmdWithTimout("vxdctl -c mode", 10)
        if cliCont.find("mode: enabled: cluster active") == -1:
            return ('', dict(flag = False, des = res_desc[lang]['sysvxconfigderr'])) 
                                                    
        debug_out("prepare for inspect successful.")
        return ('', dict(flag = True, des = res_desc[lang]['success'])) 
    except BaseException:
        debug_out(traceback.format_exc())
        return ('', dict(flag = False, des = res_desc[lang]['except']))    

