# -*- coding: UTF-8 -*-
import re

logger=None

def init_logger(vlogger):
    '''初始化日志系统'''
    global logger
    logger = vlogger;
    
def dict2str(dictCont):
    '''将字典内容转换为字符串用于调试输出字典内容'''
    retCont = ""    
    for key in dictCont.keys():
        retCont += key + ": " + str(dictCont[key]) + "\r\n"
    return retCont

def format_cli_info_col(cliInfo):
    '''格式化分析CLI执行结果，主要是分析竖列形式'''
    cliDict = {}
    infoCont = re.split(r'[\r]*\n', cliInfo)     
    
    #逐行分析CLI信息
    lastkey = ""
    for line in infoCont :
        res = re.search(r'^[ ]*.*[ ]*\|[ ]*.*', line)
        if not res :
            continue  
        
        lineList = map(lambda x: x.strip(), line.split('|'))
        
        #字典中没有此键则就创建，否则追加值到后面   
        if lineList[0] :
            cliDict.setdefault(lineList[0], []).append(lineList[1])
            lastkey = lineList[0]
        else :
            cliDict[lastkey][-1] += "\n" + lineList[1]        
        
    debug_out(dict2str(cliDict))   
    return cliDict

def format_cli_info_vis(cliInfo):
    '''格式化分析VIS的CLI执行结果，主要是分析竖列形式，一行可能存在两条信息'''
    cliDict = {}
    infoCont = re.split(r'[\r]*\n', cliInfo)     
    
    #逐行分析CLI信息   
    for line in infoCont :
        res = re.search(r'([ ]+[\*][^\*]+[\*]){1,2}', line)
        if not res :
            continue             
        
        lineList = map(lambda x: re.split(r'[ ]{2}', x.replace('*', ''), 1), re.findall(r'\*[^\*]+\*', line))
        
        #暂不考虑一个键值对应多行的情况
        #也不考虑电子标签命令，以竖线分隔
        #一行存在1或者2条信息
        for infoIdx in lineList :
            infoDetail = map(lambda x: x.strip(), infoIdx)
            cliDict.setdefault(infoDetail[0], []).append(infoDetail[1])
        
    debug_out(dict2str(cliDict))   
    return cliDict

def format_cli_info_row(cliInfo):
    '''格式化分析CLI执行结果，主要是分析横排形式'''
    cliDict = {}
    keys = []
    hasHeader = False
    
    infoCont = re.split(r'[\r]*\n', cliInfo)
            
    #逐行分析CLI信息    
    for lineIdx in infoCont :
        values = re.split(r'[ |\t]{2,}', lineIdx.strip())
        if len(values) <= 1 :
            continue
        
        #没有记录键名则首先记录键名
        if not hasHeader :
            hasHeader = True
            keys = values
            for key in keys :        
                cliDict[key] = []
        else :
            #记录键值
            for idx in range(0, len(values)):
                cliDict[keys[idx]].append(values[idx])            

        
    debug_out(dict2str(cliDict))   
    return cliDict

def format_vx_info(vxInfo):
    '''分析vx命令执行结果形成字典    '''
    #CTRL ID:0||UID:admin||PID:14352||PPID:1||TIME:00:00:01||CMD:/OSM/bin/sf_agent
    vxDict = {}
    infoCont = re.split(r'[\r]*\n', vxInfo)
    for lineIdx in infoCont :
        #过来无效行
        if lineIdx.find("||") == -1 :
            continue
        if re.sub(r'\|*[^:\|]+:[^\|]+', '', lineIdx) :
            break
        
        for itemIdx in lineIdx.split('||'):
            oneItem = itemIdx.split(':', 1)
            vxDict.setdefault(oneItem[0], []).append(oneItem[1])
    
    debug_out(dict2str(vxDict))
    return vxDict
        
def debug_out(debugInfo):
    '''调试输出信息'''
    if logger :
        logger("\r\n" + debugInfo)
        
