# -*- coding: UTF-8 -*-
import re
import cliResource
import time
import com.huawei.ism.tool.obase.entity.DevNode as DevNode
from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.connection import SshConnectionManager
from cbb.frame.util.common import wrapAllExceptionLogged

CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
DEVELOPER_MODEL_FLAG = "developer:/>"
STORAGE_MODEL_FLAG = "Storage:~ #"
DEBUG_MODEL_FLAG = ":/diagnose>"
MINISYSTEM_MODEL_FLAG = "minisystem>"
CLI_RET_END_FLAG = ":/>"
DIAGNOSE_SYS_SHOW_CLS_CMD = 'sys showcls'
#执行导出命令的超时时间
TIMEOUT_COLLECT = 25 * 60
#执行删除命令的超时时间
TIMEOUT_DELETE = 30
#特定命令所需的指定结束符
endWithSignToAdmin = [":/>", ">", "> "]
endWithSignToDiagnose = [">", "> ", "diagnose>", "/diagnose>"]

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"

def getMsg(lang, msg, args = "", resource = cliResource.MESSAGES_DICT):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.has_key(msg):
            return errMsg

        localeDict = resource.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg

def isChinese(lang):
    '''
    @summary: 判断lang是否为中文
    @param lang: 语言lang
    @return: 
        True: 中文
        False: 非中文
    '''
    if lang == "zh":
        return True
    return False

def isNoneLicense(cliRet):
    '''
    @summary: 判断回显结果里面是否包含需要license
    @param cliRet: cli回显
    @return: 
        True: cli回显包含需要license
        False: cli回显不包含需要license
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "license" in lowerLine and ("error" in lowerLine or "suggestion" in lowerLine):
            return True

    return False

def isNotSupport(cliRet):
    '''
    @summary: 判断回显结果里面是否包含 does not support the VM service
    @param cliRet: cli回显
    @return: 
        True: cli回显包含 does not support the VM service
        False: cli回显不包含does not support the VM service
    '''
    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "use the tab key to check that the command format is correct" in lowerLine:
            return True
        if "error:" in lowerLine and "not support" in lowerLine:
            return True
        # 【注意】升级类工具专用：全是使用admin执行，所以不存在权限不足情况
        if lowerLine.strip() == "^":
            return True
    return False

def isVMNotStarted(cliRet):
    '''
    @summary: 判断回显结果里面是否包含 The VM service is not started
    @param cliRet: cli回显
    @return: 
        True: cli回显包含 The VM service is not started
        False: cli回显不包含The VM service is not started
    '''

    cliRetList = cliRet.splitlines()
    for line in cliRetList:
        lowerLine = line.lower()
        if "the vm service is not started" in lowerLine:
            return True

    return False

def hasCliExecPrivilege(cliRet):
    '''
    @summary: 判断是否具有执行cli命令的权限
    @param cliRet: cli回显
    @return: 
        True: 具有执行cli命令的权限
        False: 不具有执行cli命令的权限
    '''
    for line in cliRet.splitlines():
        if line.strip() == "^":
            return False
        if "does not have the permission" in line:
            return False
    return True

def queryResultWithNoRecord(cliRet):
    '''
    @summary: 判断回显是否为Command executed successfully
    @param cliRet: cli回显
    @return: 
        True: cli回显中包含Command executed successfully
        False: cli回显中不包含Command executed successfully
    '''
    if re.search(CLI_EXECUTE_CMD_SUCCESS, cliRet, re.IGNORECASE):
        return True
    return False

def isInternalError(cliRet):
    '''
    @summary: 判断回显结果是否包含内部错误信息
    @param cliRet: cli回显
    @return: 
        True: cli回显包含内部错误信息
        False: cli回显不包含内部错误信息
    '''
    lowerCliRet = cliRet.lower()
    if "internal error" in lowerCliRet:
        return True
    else:
        return False

def enterDeveloperMode(cli, lang, debugPwd=None):
    '''
    @summary: 进入developer模式
    @param cli: cli对象
    @param lang: 语言lang
    @return: (falg, cliRet, errMsg)
        flag:
            True: 进入developer模式成功
            False: 进入developer模式失败
        cliRet: cli回显
        errMsg: 进入developer模式失败时的错误消息
    '''
    cmd = "change user_mode current_mode user_mode=developer"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    
    #判断是否已经developer模式
    if re.search("Password", cliRet, re.IGNORECASE):
        cliRet = cli.execCmdNoLog(debugPwd)
    
    if isInDeveloperMode(cliRet):
        return (True, cliRet, "")

    #dorado c00进入developer需要进行交互,最多三次
    cliRetAll = cliRet
    for times in range(3):
        if re.search("(y/n)", cliRet, re.IGNORECASE):
            checkFlag, cliRet, errInfo = excuteCmdCommon(cli, "y", lang)
            cliRetAll += cliRet
            if not checkFlag:
                return (False, cliRetAll, errInfo)

        if isInDeveloperMode(cliRet):
            return (True, cliRetAll, "")

    errMsg = getMsg(lang, "has.not.cli.privilege")
    return (RESULT_NOCHECK, cliRetAll, errMsg)

def enterDebugModeFromCliMode(cli, lang, debugPwd=None):
    '''
    @summary: 从cli模式进入debug模式
    '''
    allCliRet = ""

    #进入devoper模式
    checkRet = enterDeveloperMode(cli, lang, debugPwd)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        return checkRet

    cmd = "debug"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], allCliRet, checkRet[2])

    if isInDebugMode(checkRet[1]):
        return (True, allCliRet, "")
    else:
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, allCliRet, errMsg)

def enterMinisystemModeFromDebugMode(cli, lang):
    """
    @summary: 从debug模式进入小系统模式
    """
    allCliRet = ''
    cmd = "exit"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return checkRet

    cmd = "minisystem"
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += "\n" + checkRet[1]
    if checkRet[0] != True:
        return (checkRet[0], allCliRet, checkRet[2])

    if "minisystem>" not in checkRet[1]:
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, allCliRet, checkRet[2])

    return (True, allCliRet, "")

def enterCliModeFromDebugModel(cli, lang):
    '''
    @summary: 从debug模式进入cli模式
    '''
    allCliRet = ""
    cmd = "exit"
    #切换到developer
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet += checkRet[1]
    if checkRet[0] != True:
        return checkRet
    #切换到CLI        
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    return checkRet


def excuteCmdCommon(cli, cmd, lang):
    '''
    @summary: 执行cli命令，只判断是否拿到回显信息
    '''
    cliRet = ""
    errMsg = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (False, cliRet, errMsg)

    try:
        cliRet = cli.execCmd(cmd)
    except:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (False, cliRet, errMsg)

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (False, cliRet, errMsg)

    return (True, cliRet, errMsg)


def enterCliModeFromSomeModel(cli, lang):
    '''
    @summary: 从其他模式进入cli模式
    '''
    excuRet = excuteCmdCommon(cli, "show system general", lang)
    if excuRet[0] == False:
        return excuRet

    if isInDebugMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if isInMinisystemMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if isInDeveloperMode(excuRet[1]) or isInStorageMode(excuRet[1]):
        excuRet = excuteCmdCommon(cli, "exit", lang)
        if "(y/n)" in excuRet[1]:
            excuRet = excuteCmdCommon(cli, "y", lang)

    if excuRet[1].endswith(":/>"):
        return (True, excuRet[1], "")

    return (False, excuRet[1], excuRet[2])


@wrapAllExceptionLogged(logger=None)
def closeCliConnection(cliCon):
    """关闭CLI连接。

    :param cliCon:
    :return:
    """
    if not cliCon:
        cliCon.close()

def isInDebugMode(cliRet):
    '''
    @summary: 判断当前是否在debug模式下
    '''
    if re.search(DEBUG_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False


def isInMinisystemMode(cliRet):
    '''
    @summary: 判断当前是否在minisystem模式下
    '''
    if re.search(MINISYSTEM_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False


def developerMode2CliMode(cli):
    '''
    @summary: developer模式下退回到cli模式
    @param cli: cli对象
    '''
    cliRet = cli.execCmd("exit")
    if "y/n" in cliRet:
        cli.execCmd("n")

    return None

def isInDeveloperMode(cliRet):
    '''
    @summary: 判断当前是否在developer模式下
    @param cliRet: cli回显
    @return: 
        True: 当前在developer模式下
        False: 当前不在developer模式下
    '''
    if re.search(DEVELOPER_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False

def isInStorageMode(cliRet):
    '''
    @summary: 判断当前是否在Storage模式下，debug 版本.
    @param cliRet: cli回显
    @return: 
        True: 当前在Storage模式下
        False: 当前不在Storage模式下
    '''
    if re.search(STORAGE_MODEL_FLAG, cliRet, re.IGNORECASE):
        return True
    return False

    
def checkLineInBlackList(cliLine, lang):
    '''
    @summary: 判断cli语句行是否在黑名单中
    @param cliLine: cli语句行
    @param lang: 语言lang
    @return: 
        True: cli语句行在黑名单中
        False: cli语句行不在黑名单中
    '''
    errMsg = ""

    for dictItems in cliResource.BLACKLIST_DICT:
        if dictItems.get("key_word") in cliLine:
            if isChinese(lang):
                errMsg = dictItems.get("msg_zh")
            else:
                errMsg = dictItems.get("msg_en")
            return (True, errMsg)
    return (False, errMsg)

def excuteCmdInCliMode(cli, cmd, isHasLog, lang, endWithSign=None):
    '''
    @summary: 获取cli模式下执行命令后的回显
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, cliRet, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        cliRet: cli回显
        errMsg: 错误消息
    '''
    errMsg = ""
    cliRet = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (RESULT_NOCHECK, "", errMsg)

    try:
        if isHasLog:
            cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)
        else:
            if endWithSign:
                cliRet = cli.execCmdNoLog(cmd, endWithSign)
            else:
                cliRet = cli.execCmdNoLog(cmd)
    except IsmException:
        #出现异常时，由框架上层处理
        raise

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (False, cliRet, errMsg)

    if not hasCliExecPrivilege(cliRet):
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, cliRet, errMsg)

    if isVMNotStarted(cliRet):
        errMsg = getMsg(lang, r"vm.is.not.started")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNotSupport(cliRet):
        errMsg = getMsg(lang, r"does.not.support.vm")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNoneLicense(cliRet):
        errMsg = getMsg(lang, "has.not.license")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)

    if isInternalError(cliRet):
        return (True, cliRet, errMsg)

    lineList = cliRet.splitlines()
    for line in lineList:
        checkRet = checkLineInBlackList(line, lang)
        if checkRet[0]:
            return (RESULT_NOCHECK, cliRet, checkRet[1])

    return (True, cliRet, errMsg)


def excuteCmdTimeOutInCliMode(cli, cmd, isHasLog, lang, timeOut):
    '''
    @summary: 功能同excuteCmdInCliMode，但可指定命令的执行超时时间
    '''
    errMsg = ""
    cliRet = ""

    if cli is None:
        errMsg = getMsg(lang, "device.connect.abnormal")
        return (RESULT_NOCHECK, "", errMsg)

    try:
        if isHasLog:
            cliRet = cli.execCmdWithTimout(cmd, timeOut)
        else:
            cliRet = cli.execCmdNoLogTimout(cmd, timeOut)
    except IsmException:
        #出现异常时，由框架上层处理
        raise

    if len(cliRet) == 0:
        errMsg = getMsg(lang, "cli.result.is.empty")
        return (False, cliRet, errMsg)

    if not hasCliExecPrivilege(cliRet):
        errMsg = getMsg(lang, "has.not.cli.privilege")
        return (RESULT_NOCHECK, cliRet, errMsg)

    if isVMNotStarted(cliRet):
        errMsg = getMsg(lang, r"vm.is.not.started")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNotSupport(cliRet):
        errMsg = getMsg(lang, r"does.not.support.vm")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if isNoneLicense(cliRet):
        errMsg = getMsg(lang, "has.not.license")
        return (RESULT_NOSUPPORT, cliRet, errMsg)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg)

    if isInternalError(cliRet):
        return (True, cliRet, errMsg)

    lineList = cliRet.splitlines()
    for line in lineList:
        checkRet = checkLineInBlackList(line, lang)
        if checkRet[0]:
            return (False, cliRet, checkRet[1])

    return (True, cliRet, errMsg)


def excuteCmdInDeveloperMode(cli, cmd, isHasLog, lang):
    '''
    @summary: 获取developer模式下执行命令后的回显
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        ret: cli回显
        errMsg: 错误消息
    '''
    try:
        switch = True
        #兼容部分命令视图切换，先尝试在普通用户模式下执行，再尝试在研发模式下执行
        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        if checkRet[0] == True:
            return checkRet

        checkRet, switch = openDeveloperSwitch(cli, lang)
        if checkRet[0] == False:
            return checkRet

        enterDeveloperCheckRet = enterDeveloperMode(cli, lang)
        if enterDeveloperCheckRet[0] != True:
            return enterDeveloperCheckRet

        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        cliRet = checkRet[1]

        if isInDeveloperMode(cliRet):
            developerMode2CliMode(cli)
        return checkRet
    except IsmException:
        #出现异常时，由框架上层处理
        raise
    finally:
        #关闭开关
        if not switch :
            closeDeveloperSwitch(cli, lang)

def excuteCmdInDeveloper(cli, cmd, isHasLog, lang):
    '''
    @summary: 获取developer模式下执行命令后的回显,直接在研发模式下执行，无需在普通模式下尝试
    @param cli: cli对象
    @param cmd: 待执行命令
    @param isHasLog: 是否需要以有log的方式执行cli命令下发
    @param lang: 语言lang
    @return: (falg, ret, errMsg)
        flag:
            True: 执行命令正常
            False: 执行命令不正常
        ret: cli回显
        errMsg: 错误消息
    '''
    try:
        switch = True
        checkRet, switch = openDeveloperSwitch(cli, lang)
        if checkRet[0] == False:
            return checkRet

        enterDeveloperCheckRet = enterDeveloperMode(cli, lang)
        if enterDeveloperCheckRet[0] != True:
            return enterDeveloperCheckRet
        checkRet = excuteCmdInCliMode(cli, cmd, isHasLog, lang)
        cliRet = checkRet[1]
        if isInDeveloperMode(cliRet):
            developerMode2CliMode(cli)
        return checkRet
    except IsmException:
        raise
    finally:
        #关闭开关
        if not switch :
            closeDeveloperSwitch(cli, lang)

def execCmdHasEndWithSign(cli, cmd, endWithSign):
    """
    @summary: 查询执行命令时 是否含有指定结束符
    """
    if endWithSign:
        cliRet = cli.execCmd(cmd, endWithSign)
    else:
        cliRet = cli.execCmd(cmd)
    return cliRet

def excuteCmdInDebugModel(cli, cmd, lang, endWithSign=None, debugPwd=None):
    """
    @summary: 在debug模式下执行命令
    """
    cliRet = ""
    try:
        cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)

        if isInDebugMode(cliRet):
            return (True, cliRet, "")

        if isInMinisystemMode(cliRet):
            cliRet = cli.execCmd("exit")
            if "(y/n)" in cliRet:
                cliRet = cli.execCmd("y")

        if isInDeveloperMode(cliRet):
            cliRet = cli.execCmd("debug")
            if isInDebugMode(cliRet):
                cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)
                return (True, cliRet, "")

            return (False, cliRet, "")

        flag, cliRet, errMsg = enterDebugModeFromCliMode(cli, lang, debugPwd)
        if flag != True:
            return flag, cliRet, errMsg

        cliRet = execCmdHasEndWithSign(cli, cmd, endWithSign)

        return (True, cliRet, "")
    except:
        return (False, cliRet, "")


def excuteCmdInMinisystemModel(cli, cmd, lang):
    """
    @summary: 在minisystem模式下执行命令
    """
    cliRet = cli.execCmd(cmd)
    if "password:" in cliRet:
        return True, cliRet, ''

    if isInMinisystemMode(cliRet):
        return (True, cliRet, "")

    if isInDebugMode(cliRet):
        cliRet = cli.execCmd("exit")
        if "(y/n)" in cliRet:
            cliRet = cli.execCmd("y")

    if isInDeveloperMode(cliRet):
        cliRet = cli.execCmd("minisystem")
        if isInMinisystemMode(cliRet):
            cliRet = cli.execCmd(cmd)
            return (True, cliRet, "")

        return (False, cliRet, "")

    flag, cliRet, errMsg = enterDeveloperMode(cli, lang)
    if flag != True:
        return flag, cliRet, errMsg

    cliRet = cli.execCmd("minisystem")
    if not isInMinisystemMode(cliRet):
        return (False, cliRet, "")

    cliRet = cli.execCmd(cmd)
    return (True, cliRet, "")



def openDeveloperSwitch(cli, lang):
    '''
            打开切换developer模式开关
    '''
    switch = True
    #兼容V3R6版本，查看切developer模式开关是否打开
    developercmd = "show user_mode enabled"
    checkRet = excuteCmdInCliMode(cli, developercmd, True, lang)
    #执行异常等均默认不需要开启模式开关
    if checkRet[0] != True:
        return (True, checkRet[1], checkRet[2]), switch

    cliRetDictList = getVerticalCliRet(checkRet[1])
    developerswitch = ""
    for dict in cliRetDictList:
        if "Developer View" in dict:
            developerswitch = dict.get("Developer View", "")
            break

    if developerswitch == "Disabled":
        switch = False
        #开关关闭则打开 
        opencmd = "change user_mode enabled user_mode=developer enabled=yes"
        checkRet = excuteCmdInCliMode(cli, opencmd, True, lang)
        if checkRet[0] != True:
            return checkRet, switch

    return checkRet, switch


@wrapAllExceptionLogged(logger=None)
def closeDeveloperSwitch(cli, lang):
    '''
    @summary: 关闭developer视图开关
    '''
    closecmd = "change user_mode enabled user_mode=developer enabled=no"
    excuteCmdInCliMode(cli, closecmd, True, lang)


def getHorizontalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        requiredLineLen = tuple_idxs[-1][0]
        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            #标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            if len(line) <= requiredLineLen:
                continue

            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        return dictList
    except:
        return []

def getVerticalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break

        if re.search("^-+\r*\n*$", line):
            dictList.append(lineDict.copy())
            lineDict.clear()

        fields = line.split(" : ")
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)

    if len(lineDict) > 0:
        dictList.append(lineDict.copy())

    return dictList

def getVerticalCliRetFilterElabel(cliRet, isParseElcLabel=True):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合（只处理表格中过滤显示电子标签场景）
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    elcLabel = ""
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break
        
        if re.search("^-+\r*\n*$", line):
            if not isParseElcLabel and lineDict.has_key("Electronic Label"):
                lineDict["Electronic Label"] = lineDict["Electronic Label"] + elcLabel
                elcLabel = ""
                
            dictList.append(lineDict.copy())
            lineDict.clear()
            
        fields = line.split(" : ")
        if len(fields) < 2:
            if isParseElcLabel and "=" in line:
                fields = line.split("=")
            elif "=" in line and re.search("^\s{16,}", line):
                elcLabel += line
                continue
            else:
                continue
        
        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")
        
        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)
    
    if len(lineDict) > 0:
        if not isParseElcLabel and lineDict.has_key("Electronic Label"):
            lineDict["Electronic Label"] = lineDict["Electronic Label"] + elcLabel
        dictList.append(lineDict.copy())
    
    return dictList
	
	
def getHorizontalCliRetFilterElabel(cliRet, getDetail = True):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合（只处理水平表格中过滤显示电子标签场景）
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''

    if not ("Electronic\sLabel" in cliRet and "Electronic Label" in cliRet):
        return None

    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            #标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            #处理电子标签属性行
            if not line.startswith(" "):
                if len(dictList) == 0:
                    continue
                lineDict = dictList[-1]
                eLabelValue = lineDict.get("Electronic Label")
                newELabelValue = eLabelValue + "\n" + line
                lineDict["Electronic Label"] = newELabelValue
                dictList[-1] = lineDict.copy()
                continue

            #处理新行    
            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        #处理电子标签详细属性值
        if getDetail:
            for lineDict in dictList:
                eLabelValue = lineDict.get("Electronic Label")
                eLableLines = eLabelValue.splitlines()
                #没有电子标签场景
                if len(eLableLines) <= 1:
                    lineDict["BoardType"] = ""
                    lineDict["BarCode"] = ""
                    lineDict["Item"] = ""
                    lineDict["Description"] = ""
                    lineDict["Manufactured"] = ""
                    lineDict["VendorName"] = ""
                    lineDict["IssueNumber"] = ""
                #存在电子标签属性
                else:
                    propertyList = []
                    for elabelProperty in eLableLines[1:]:
                        if "=" in elabelProperty:
                            propertyList.append(elabelProperty)
                        else:
                            if len(propertyList) == 0:
                                continue
                            propertyList[-1] += elabelProperty
                    for elabelProperty in propertyList:
                        props = elabelProperty.split("=")
                        propKey = props[0].strip().decode("utf8")
                        propValue = "=".join(props[1:]).strip().decode("utf8")
                        lineDict[propKey] = propValue
        return dictList
    except:
        return []

def getSplitedCliRet(cliRet, splitMark):
    '''
    @summary: 按分割标记从回显中获取仅包含该分割标记对应的的回显
    @param cliRet: cli回显
    @param splitMark: 分割标记 
    '''
    cliRetlist = cliRet.split(splitMark)
    if len(cliRetlist) < 2:
        return ""

    splitedCliRet = cliRetlist[1]
    match = re.search("^.*:(/>)*\r*\n*$", splitedCliRet, re.MULTILINE)
    if match:
        splitedCliRet = splitedCliRet[0:match.start()]

    if len(splitedCliRet.strip()) == 0:
        return ""
    else:
        return splitedCliRet

def getNodeCfg(py_java_env):
    '''
    @summary: Get node config.
    @param cli: CLI connection.
    @param lang: Language.
    @return: (isQrySucc, cliRet, errMsg, nodeIdList) 
    '''

    #Implement this method by execute diangose command 'sys showcls'
    nodeCfg = 0
    cli = py_java_env.get("ssh")
    lang = str(py_java_env.get("lang"))
    debugPassword = py_java_env.get("devInfo").getDeveloperPwd()
    isExeSucc, cliRet, _ = excuteCmdInDebugModel(cli, DIAGNOSE_SYS_SHOW_CLS_CMD, lang, debugPwd=debugPassword)
    if isNotSupport(cliRet):
        flag, __, ipListDict = getContrIpList(cli, lang)
        if not flag:
            del debugPassword
            return False, nodeCfg, getMsg(lang, "failed.to.get.present.nodecfg")
        
        for ip in ipListDict.values():
            cliConn = getCilConnectionByIp(ip, py_java_env)
            if cliConn:
                isExeSucc, cliRet, _ = excuteCmdInDebugModel(cliConn, DIAGNOSE_SYS_SHOW_CLS_CMD, lang, debugPwd=debugPassword)
                # 关闭控制器连接
                current_conn_ip = py_java_env.get("devInfo").getIp()
                if current_conn_ip != ip:
                    SshConnectionManager.releaseConnection(cliConn)
                break
    else:
        enterCliModeFromDebugModel(cli, lang)
    
    
    del debugPassword
    if not isExeSucc:
        return False, nodeCfg, getMsg(lang, "failed.to.get.present.nodecfg")
    
    for line in cliRet.splitlines():
        if "node cfg" not in line:
            continue
        
        fields = line.split(":")
        if len(fields) > 1 and fields[1].strip().isdigit():
            nodeCfg = int(fields[1].strip())
            return True, nodeCfg, ""
        else:
            return False, nodeCfg, getMsg(lang, "failed.to.get.present.nodecfg")

    return False, nodeCfg, getMsg(lang, "failed.to.get.present.nodecfg")


def getContrIpList(cli, lang):
    """
    获取引擎对应下的控制器IP
    :param cli:
    :param lang:
    :return ipListDict: 节点IP。
    """

    ipListDict = {}

    cmd = "show upgrade package"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return (flag, errMsg, ipListDict)

    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = getHorizontalCliRet(cliRet[beginIndex: endIndex])

    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and ip != "--" and contrName != "":
            ipListDict[contrName] = ip
            
    # 控制器未配置管理IP，无法连接控制器。
    if len(ipListDict) == 0:
        errMsg = getMsg(lang, "contr.not.config.ip")
        return (False, errMsg, ipListDict)

    return (True, errMsg, ipListDict)


def getJavaDev(ip, py_java_env):
    """
    @summary: 将连接设备的信息封装为java的DevNode对象
    """
    dev = py_java_env.get("devInfo")
    javaDev = DevNode()
    javaDev.setPort(dev.getPort())
    javaDev.setLoginUser(dev.getLoginUser())
    javaDev.setSshForwardList(dev.getSshForwardList())
    javaDev.setSocks5Proxy(dev.getSocks5Proxy())
    deviceSN = dev.getDeviceSerialNumber()
    #每个设备只有一个SN，而java DevNode初始化时需要为每个控制器传一个不同的SN，此SN只是用来作为框架识别不同的SSH连接，不比是真实的设备SN
    deviceSN = deviceSN + str(time.time())
    javaDev.setDeviceSerialNumber(deviceSN)
    javaDev.setIp(ip)
    return javaDev


def getCilConnectionByIp(ip, py_java_env):
    """
    @summary: 获取指定ip的控制器ssh连接
    """
    cliConnection = None
    try:
        javaDev = getJavaDev(ip, py_java_env)
        cliConnection = py_java_env.get("sshManager").getSshConnection(javaDev)
        return cliConnection
    except:
        if cliConnection is not None:
            py_java_env.get("sshManager").releaseConnection(cliConnection)
        return None