# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import traceback
import shutil
import os
import time
import codecs

'''
 信息收集完成后调用该脚本，在压缩包中添加pkginfo文件夹，内含type_inspector, domain_storage两个空文件，用于回传时确定该包属于哪个领域哪个工具
 处理原则：添加pkginfo文件夹过程中出错不报错，不可影响整体流程。
'''
def execute(devObj):
    '''
    @summary: 框架调用的入口函数
    '''
    logger = devObj.get("logger")
    #1 获取pkginfo创建的绝对路径
    zipFilePath = devObj.get("dir")
    if not zipFilePath:
        logger.error("[creatPkginfo] The absolute path is empty!")
        return (False, "")
    
    if not os.path.exists(zipFilePath):
        logger.error("[creatPkginfo] The absolute path  is not exists: " + zipFilePath)
        return (False, "")
    
    logger.info("[creatPkginfo] The absolute path: " + zipFilePath)
    
    #2 创建pkginfo文件夹及其子文件
    if not creatPkginfo(zipFilePath, devObj):
        return (False, "")
    
    return (True, "")

def getScene(devObj):
    try:
        return "\nscene=%s" % devObj.get("scene")
    except:
        return ""


def get_quality_check_user(dev_obj):
    quality_user = dev_obj.get("qualityCheckUser").encode("utf8")
    return "\nchecked-by={}".format(quality_user).decode("unicode_escape") if quality_user else ""


def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_inspector: 巡检的包
            domain_storage: 存储设备
    '''
    logger = devObj.get("logger")
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_inspector"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    
    fileObj = None
    try:
    
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        codecs.open(typeFile, "w", encoding="utf-8").close()
        shutil.copy(typeFile, domainFile)
        
        #获取SN号，并组成字符串特定的：deciveSN=${SN1},${SN2}的格式
        snStr = "deviceSN="
        devNodes = devObj.get("connectedDevs")    
        for dev in devNodes:
            devSn = dev.getDevNode().getDeviceSerialNumber()
            snStr += '${' + devSn + '},'
        #去掉最后一个“，”,并加换行
        if snStr[-1] == ",":
            snStr = snStr[:-1]
        snStr += "\n"
        
        #创建desc文件，并写入设备sn号，UTC时间
        with codecs.open(descFile, "w", encoding="utf-8") as f:
            f.write(snStr)
            mstime = int(time.time() * 1000)
            dateStr = "fileCreateTime=%d" % mstime
            f.write(dateStr)
            f.write(getScene(devObj))
            f.write(get_quality_check_user(devObj))
            from com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil import getAllToolVersion
            f.write("\ntool-version={{{}}}".format(",\n".join(getAllToolVersion())))
            f = None
        
        logger.info("[creatPkginfo] Creat the pkginfo succeed!")
        return True
    
    except:
        try:
            if fileObj:
                fileObj.close()
                    
            if os.path.exists(pkginfoPath):
                shutil.rmtree(pkginfoPath, True)
                
            logger.error("[creatPkginfo] Creat the pkginfo failed. Except trace back: " + traceback.format_exc())
            return False
        except:
            return False
