# -*- coding: UTF-8 -*-
from com.huawei.ism.tool.diskupgrade.logic.assistant import GZipAssistant
import java.io.BufferedReader
from com.huawei.ism.tool.obase.log import ToolLoggerFactory
from java.lang import Exception as JException


logger = ToolLoggerFactory.getLogger(GZipAssistant)

class GZipHandler():
    '''
    @summary: 该类用于压缩文件的读取或解压
    @param zipFileName: 压缩包的文件路径
    '''
    
    def __init__(self,zipFileName):
        self.zipFileName = zipFileName
    
    def openMemberFile(self, fileName):
        '''
        @summary: 以字节流的形式打开文件
        @param fileName:压缩包中某个文件的路径（相对路径） 
        '''
        ga = GZipAssistant(self.zipFileName)
        br = ga.getFileBuffer(fileName)
        if br == None:
            logger.error("Get the file %s obj failed!" %fileName)
            return None
        return TgzFile(br)
    
      
    def extractFile(self, fileName, destDir):
        '''
        @summary: 解压文件到指定目录
        '''
        try:
            ga = GZipAssistant(self.zipFileName)
            return ga.extractFile(fileName, destDir)
        except JException, je:
            logger.error("Extrace file exception:%s ." %unicode(je))
        except Exception, e:
            logger.error("Extrace file exception:%s ." %unicode(e))
        return
    
    @staticmethod
    def compressToTgz(fileList, destPath, destFileName):
        '''
        @summary: 将多个文件压缩成tgz格式
        @param fileList: 需要打包的原始文件
        @param destPath: 打包后的文件保存路径
        @param destFileName: 打包后的文件名称
        '''
        compressFlag = GZipAssistant.compressToTgz(fileList, destPath, destFileName)
        return compressFlag
    
class TgzFile():
    '''
    @summary: 字节流形式的文件
    @param br:为文件字节流 
    '''
    def __init__(self, br):
        self.br = br
        
    def readFileline(self):
        '''
        @summary: 按行读取文件内容，每次读取一行，再次调用则读取下一行，读取为空则结束
        '''
        line = self.br.readLine()
        if line!= None:
            return line
        return None
    
    def closeFile(self):
        '''
        @summary: 文件信息读取完成后，关闭数据流BufferReader
        '''
        GZipAssistant.closeBufferedReader(self.br)
