# -*- coding: UTF-8 -*-
import json

def jsonStr2Dict(strJson):
    '''
    @summary: 将json字符串转成字典数据结构
    @param strJson: json字符串
    '''
    return json.loads(str(strJson))

def dictList2JsonArray(dictList):
    '''
    @summary: 将字典的集合转换为json数组
    @param dictList: 字典列表集合
    @return: json数组
    '''
    jsonArray = []
    for d in dictList:
        jsonArray.append("{%s}" % ",".join(['"%s":"%s"' % (key, d.get(key)) for key in d.keys()]))
    return "[%s]" % ",".join(jsonArray)

def list2JsonArray(strList):
    '''
    @summary: 将字典的集合转换为json数组
    @param strList: 字符串列表
    @return: json数组
    '''
    return "[%s]" % ",".join(strList)

def jsonArray2DictList(jsonArray):
    '''
    @summary: 将json数组转换为字典的集合
    @param jsonArray: json数组
    @return: json数组对应的字典的集合
    '''
    if jsonArray is None or len(jsonArray) <=2:
        return None
    jsonArray = jsonArray[1:-1]
    resultDictList = []
    for items in jsonArray.split("},{"):
        resultDict = {}
        for item in items.split("\",\""):
            kv = item.replace("{", "").replace("}", "").replace("\"", "").split(":")
            if len(kv) != 2:
                return resultDictList
            resultDict[kv[0]] = kv[1]
        if len(resultDict.keys()) > 0:
            resultDictList.append(resultDict.copy())
    
    return resultDictList
