# -*- coding: UTF-8 -*-
import time
import config
import common
import diskItem
import threading
import time
import math
from frame.context import contextUtil

class RefreshRemainTimeThread(threading.Thread):
    def __init__(self, dataDict, UI_UPDATE_UPGRADE_MSG, priorSpeed=180):
        threading.Thread.__init__(self)
        self.dataDict = dataDict
        self.UI_UPDATE_UPGRADE_MSG = UI_UPDATE_UPGRADE_MSG
        self.startTime = time.clock()
        self.averageTime = priorSpeed
        self.totalDiskNum = int(self.UI_UPDATE_UPGRADE_MSG["totalDisks"])
        self.finishDiskNum = 0 #完成的硬盘数
        self.remainTime = self.averageTime * self.totalDiskNum
        self.SLEEP_TIME = 5
        self.__running = threading.Event()
        self.__running.set()
        self.logger = dataDict.get("logger")
        self.lang = dataDict.get("language")
        self.start()

    def run(self):
        while (self.__running.isSet() and self.totalDiskNum > self.finishDiskNum):
            newFinishDiskNum = int(self.UI_UPDATE_UPGRADE_MSG["finishDisks"])
            self.logger.info("[refreshProgress]newFinishDiskNum:%s" % newFinishDiskNum)
            if newFinishDiskNum > self.finishDiskNum:
                # 有新的盘升级完成，调整平均时间和剩余时间
                durationTime = time.clock() - self.startTime
                self.averageTime = int((durationTime + self.averageTime * (self.totalDiskNum - newFinishDiskNum)) / self.totalDiskNum)
                self.finishDiskNum = newFinishDiskNum
                self.remainTime = self.averageTime * (self.totalDiskNum - newFinishDiskNum)
            else:
                # 一块盘正在升级中，剩余时间每次递减5s
                self.remainTime = self.remainTime - self.SLEEP_TIME

            # 为后续处理预留5s时间
            self.remainTime = self.remainTime if self.remainTime > 5 else 5
            self.logger.info("[refreshProgress]self.remainTime:%s" % self.remainTime)

            self.UI_UPDATE_UPGRADE_MSG["progress"] = formatProgress(self.lang, self.finishDiskNum, self.totalDiskNum, self.remainTime)
            uiObserver = self.dataDict.get("uiObserver")
            dev = self.dataDict.get("dev")
            uiObserver.postMsg(dev, self.UI_UPDATE_UPGRADE_MSG)
            time.sleep(self.SLEEP_TIME)

    def stop(self):
        self.__running.clear()
        self.UI_UPDATE_UPGRADE_MSG["progress"] = "--"
        uiObserver = self.dataDict.get("uiObserver")
        dev = self.dataDict.get("dev")
        uiObserver.postMsg(dev, self.UI_UPDATE_UPGRADE_MSG)




def getPriorSpeed(dataDict, selectedDisks):
    logger = dataDict.get("logger")
    logger.info("begin to compute prior speed.")
    if len(selectedDisks) == 0:
        logger.warn("The selectedDisks is empty")
    importMode = contextUtil.getImportPkgMode(dataDict)
    supportParal = contextUtil.isSupportParallel(dataDict)
    controllerNum = contextUtil.getControllerNum(dataDict)
    isOnlineUpgrade = contextUtil.isOnlineUpgrade(dataDict)
    dev = dataDict.get("dev")
    devVersion = dev.getDevNode().getProductVersion()
    devType = dev.getDevNode().getDeviceType().toString()
    isSupportParallelInSpc = common.isSupportParallelBySpcVersion(devType, devVersion)
    logger.info("importMode=%s,supportParal=%s,controllerNum=%s,isOnlineUpgrade=%s"
                % (importMode, supportParal, controllerNum, isOnlineUpgrade))

    if not supportParal:
        return 180

    if isSupportParallelInSpc:
        parallNum = 2 * controllerNum if isOnlineUpgrade else 8 * controllerNum
        if parallNum == 0:
            logger.warn("The value parallNum couldn't be used as zero")
    else:
        # 补丁方式导包，4个并发
        parallNum = 4

    if not isOnlineUpgrade:
        # 如果除数parallNum 或len(selectedDisks)发生除零危险，则分别用给定的默认值代替
        maxDiskNum = int(math.ceil(float(len(selectedDisks)) / (parallNum if parallNum != 0 else 4)))
        return int((float(maxDiskNum) / (len(selectedDisks) if len(selectedDisks) != 0 else 1)) * 60)

    # 硬盘按硬盘域分类，统计各硬盘域的盘数
    diskMap = {}
    freeDisks = []
    for disk in selectedDisks:
        diskDomainId = disk.get("Disk Domain ID")
        role = disk.get("Role")
        if not common.isMemberDisk(role):
            freeDisks.append(disk)
            continue

        if not diskMap.has_key(diskDomainId):
            diskMap[diskDomainId] = []
        diskMap[diskDomainId].append(disk)


    # 成员盘
    threadManager = ThreadExcuteMangaer(parallNum)
    for diskDomainId in diskMap:
        logger.info("diskDomainId=%s, taskNumber=%s" % (diskDomainId,len(diskMap.get(diskDomainId))))
        threadManager.addTasks(len(diskMap.get(diskDomainId)))

    # 非成员盘
    logger.info("freedisk size=%s" % len(freeDisks))
    if isSupportParallelInSpc:
        for disk in freeDisks:
            threadManager.addTasks(1)
        maxDiskNum = threadManager.getMaxTaskNum()
    else:
        # 如果除数parallNum发生除零危险，则用给定的默认值代替
        freeDiskNum = int(math.ceil(float(len(freeDisks)) / (parallNum if parallNum != 0 else 4)))
        maxDiskNum = threadManager.getMaxTaskNum() + freeDiskNum
    logger.info("the max task num is %s" % maxDiskNum)
    # 如果除数len(selectedDisks)发生除零危险，则用给定的默认值代替
    return int((float(maxDiskNum) / (len(selectedDisks) if len(selectedDisks) != 0 else 1)) * 60)

class ThreadExcuteMangaer():
    def __init__(self, threadNum):
        self.allThreads = {}
        for i in range(threadNum):
            self.allThreads[str(i)] = 0
        self.minTaskIndex = "0"

    def addTasks(self, taskNum):
        # 找到任务最少的线程
        for index in self.allThreads:
            if self.allThreads[index] < self.allThreads[self.minTaskIndex]:
                self.minTaskIndex = index
        self.allThreads[self.minTaskIndex] += taskNum

    def getMaxTaskNum(self):
        # 获取任务最大的线程的任务数
        self.maxTaskIndex = "0"
        for index in self.allThreads:
            if self.allThreads[index] > self.allThreads[self.maxTaskIndex]:
                self.maxTaskIndex = index
        return self.allThreads[self.maxTaskIndex]

def formatProgress(lang, finishNum, totalNum, remainTime=0):
    progressStr = common.getMsg(lang, "diskUpgrade.completed.disk",(finishNum, totalNum))
    if remainTime > 0:
        hour = remainTime / 3600
        minute = (remainTime % 3600) / 60
        second = remainTime % 60
        hourStr = common.getMsg(lang, "hour", hour) if hour != 0 else ""
        minuteStr = common.getMsg(lang, "minute", minute) if minute != 0 else ""
        secondStr = common.getMsg(lang, "second", second) if second != 0 else ""
        remainTimeStr = common.getMsg(lang, "diskUpgrade.remain.time", (hourStr, minuteStr, secondStr))
        progressStr = "%s, %s" % (progressStr, remainTimeStr)
    return progressStr

class UiFactory():
    def __init__(self, dataDict, UI_UPDATE_UPGRADE_MSG):
        self.dataDict = dataDict
        self.UI_UPDATE_UPGRADE_MSG = UI_UPDATE_UPGRADE_MSG
        self.lang = dataDict.get("language")
        self.logger = dataDict.get("logger")
        
    def gettimestr(self): 
        '''
        @summary: 获取当前时间
        @return: 经过格式化处理后的时间
        '''
        return time.strftime('%Y-%m-%d %H:%M:%S', time.localtime())
    
    def setNewUpdateUiMsg(self,iteminfo):
        '''
        @summary: 升级工具，刷新单个项目
        @param status: 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        '''
        upgradeUiMsg = self.UI_UPDATE_UPGRADE_MSG.get("upgradeMoudles")
        
        for item in upgradeUiMsg:
            itemName = item["name"]
            if itemName == iteminfo.name:
                item["status"] = iteminfo.status
                item["reson"] = iteminfo.reson
                item["afterFWVersion"] = iteminfo.afterFWVersion
                item["progress"] = iteminfo.progress
                item["remainTime"] = iteminfo.remainTime
                return 
            
        newGroup = {"name":iteminfo.name,#作为item唯一识别标识
                    "ctrl":"sshhost",   #暂时未用，预留
                    "dtime":self.gettimestr(),
                    "status":iteminfo.status,  # 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过，5忽略，6暂停
                    "beforeFWVersion":iteminfo.beforeFWVersion,
                    "afterFWVersion":iteminfo.afterFWVersion,
                    "reson":iteminfo.reson,
                    "diskId":iteminfo.diskId,
                    "progress": iteminfo.progress,
                    "remainTime": iteminfo.remainTime}
                                                               
        upgradeUiMsg.append(newGroup)
        self.UI_UPDATE_UPGRADE_MSG["upgradeMoudles"] = upgradeUiMsg
        return
    
    def updateUi(self,itemInfo):
        '''
        @summary: 升级工具，刷新界面信息
        @param status:   # 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过，5忽略，6暂停
        '''
        dev = self.dataDict.get("dev")
        uiObserver = self.dataDict.get("uiObserver")
        if itemInfo.cliRet != '':
            itemInfo.reson += common.getRes(self.lang,"upg_disk_cliRet",itemInfo.cliRet)
        
        self.setNewUpdateUiMsg(itemInfo)            
        uiObserver.postMsg(dev, self.UI_UPDATE_UPGRADE_MSG)
        return
    
    def updateUiByFail(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.FAILED
        self.updateUi(itemInfo)
        return
    
    def updateUiBySucc(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.SUCCEEDED
        self.updateUi(itemInfo)
        return
    
    def updateUiByChecking(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.CHECKING
        self.updateUi(itemInfo)
        return
    
    def updateUiByAlarm(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.ALARM
        self.updateUi(itemInfo)
        return
    
    def updateUiByNoSupport(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.NOSUPPORT
        self.updateUi(itemInfo)
        return

    def updateUiByNoPass(self,itemInfo):
        itemInfo.status = config.UPD_ITEM_STATUS.NOTPASS
        self.updateUi(itemInfo)
        return
        
    def updateUpgResult(self,result,errMsg,oper):
        '''
        @summary: 升级工具，刷新界面信息
        @param status: 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        '''
        return (result,errMsg,oper)
    def diskStatusClassify(self):
        upgradeUiMsg = self.UI_UPDATE_UPGRADE_MSG.get("upgradeMoudles")
        diskItemNamePrefix = common.getRes(self.lang, "upg_disk", "")[:-2]
        totalDiskNum = 0
        succeedDiskNum = 0
        failedDiskNum = 0
        notsupportDiskNum = 0
        for item in upgradeUiMsg:
            if item["name"].startswith(diskItemNamePrefix):
                totalDiskNum += 1
                if item["status"] == config.UPD_ITEM_STATUS.SUCCEEDED:
                    succeedDiskNum += 1
                elif item["status"] == config.UPD_ITEM_STATUS.FAILED:
                    failedDiskNum += 1
                elif item["status"] == config.UPD_ITEM_STATUS.NOSUPPORT:
                    notsupportDiskNum += 1

        reason = common.getMsg(self.lang, "diskUpgrade.end",
                               (totalDiskNum, succeedDiskNum, failedDiskNum, notsupportDiskNum))
        return reason

    def updateUpgEnd(self,result,errMsg,oper):
        '''
        @summary: 升级工具，刷新界面信息
        @param status: 0等待检查, 1正在检查, 2警告, 3通过 ,4不通过
        '''
        
        name = common.getRes(self.lang,"upg_disk_end")#作为item唯一识别标识
        iteminfo = diskItem.DiskItem(name)
        iteminfo.reson = self.diskStatusClassify()
        iteminfo.status = config.UPD_ITEM_STATUS.SUCCEEDED
        totalDiskNum = self.UI_UPDATE_UPGRADE_MSG["totalDisks"]
        finishDiskNum = self.UI_UPDATE_UPGRADE_MSG["finishDisks"]
        self.UI_UPDATE_UPGRADE_MSG["progress"] = formatProgress(self.lang, finishDiskNum, totalDiskNum)
        self.updateUi(iteminfo)
        return (result,errMsg,oper)
        
    def updateProcess(self, finishNum, totalNum):

        dev = self.dataDict.get("dev")
        uiObserver = self.dataDict.get("uiObserver")
        process = "%s/%s" %(str(finishNum), str(totalNum))
        self.UI_UPDATE_UPGRADE_MSG["progress"] = process
        uiObserver.postMsg(dev, self.UI_UPDATE_UPGRADE_MSG)
        return
    
    def updateUiByJson(self,itemInfoDict):
        dev = self.dataDict.get("dev")
        uiObserver = self.dataDict.get("uiObserver")
        upgradeUiMsg = self.UI_UPDATE_UPGRADE_MSG.get("upgradeMoudles")
        upgradeUiMsg.append(itemInfoDict)
        self.UI_UPDATE_UPGRADE_MSG["upgradeMoudles"] = upgradeUiMsg
        uiObserver.postMsg(dev, self.UI_UPDATE_UPGRADE_MSG)
        return

class RefreshCallBack():
    def __init__(self, atomInfo, uiFactory):
        self.atomInfo = atomInfo
        self.uiFactory = uiFactory

    def setProgress(self, progress, remainTime):
        self.atomInfo.progress = int(progress)
        self.atomInfo.remainTime = int(remainTime)
        self.uiFactory.updateUi(self.atomInfo)

    def stopRefresh(self):
        return self.atomInfo.status != config.UPD_ITEM_STATUS.CHECKING