# -*- coding: UTF-8 -*-

from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Param, Record
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv import TLVUtils
from com.huawei.ism.tool.protocol.tlv.cmds import CommandConstans
from com.huawei.ism.tool.protocol.sftp import SftpProgressInterface
from com.huawei.ism.tool.protocol.tlv.cmds.CommandConstans import UpgradeStatus
from com.huawei.ism.tool.protocol.tlv.exception import TLVException
from java.lang import Exception as JException

from frame.common import constant
from frame.common import config
from frame.common import common
from frame.context import contextUtil
from frame.common.GZipHandler import GZipHandler
from frame.common import diskItem
from frame.cli import cliUtil
from frameone.adapter import connectionFactory
from frameone.base.exception import TlvCmdException, ErrorCodeSet, ErrorCode

import os
import time
import traceback
import math
import shutil
    
def uploadUpgradePkg(dataDict):
    """
    功能说明：校验阵列状态是否支持升级，将补丁包上传到整列端，并获取阵列端处理结果
    """
    uploadErrMsg = ''
    logger = dataDict.get("logger")
    lang = dataDict.get("language")
    resource = dataDict.get("resource")
    connectionAdapter = connectionFactory.getAdapter(dataDict)

    if checkUploadState(dataDict) == constant.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_DLDING:
        return(False, resource.getString("upgrade.notsupport"))
    try:

        #将硬盘固件包打包成补丁包形式
        if contextUtil.isSupportParallel(dataDict):
            dev = contextUtil.getDevObj(dataDict)
            upgradePkgFile = dev.getUpgradeSetInfo().getUpgradePackageFile()
            hotPatchTgzPkgName = upgradePkgFile.getAbsolutePath()
        else:
            hotPatchTgzPkgName = compressPkg(dataDict)
            if '' == hotPatchTgzPkgName:
                return (False, resource.getString("upload.compress.failed"))

        
        """上传补丁包"""


        upload(dataDict,hotPatchTgzPkgName)
        try:
            time.sleep(5)
        except KeyboardInterrupt:
            logger.error("Interrupted" )

        """轮询获取阵列端处理状态"""
        status = None
        DEVEICE_DLD_QUERY_TIME = 0 # 轮询计数器
        while (constant.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_DLD_SUCCESS != status):
            DEVEICE_DLD_QUERY_TIME = DEVEICE_DLD_QUERY_TIME + 1
            if DEVEICE_DLD_QUERY_TIME > constant.UPLOAD_PACKAGE_POLL_TIMES:
                return (False, resource.getString("upload.failed"))
            #查询处理状态
            status = connectionAdapter.queryExcuteResult()
            if status == constant.OM_MSG_OP_UPD_LST_SYS_PROGRESS.UPD_DLD_FAIL:
                errMsg = connectionAdapter.queryExcuteDetail()
                return (False, errMsg)
            try:
                time.sleep(constant.UPLOAD_PACKAGE_POLL_INTERVAL)
            except KeyboardInterrupt:
                logger.error("Interrupted" ) 
    except TlvCmdException, e:
        logger.error("notify upgrade package upload over error!"+str(traceback.format_exc()))
        return(False, e.getMsg(lang))
    except:
        logger.error("notify upgrade package upload over error!" + str(traceback.format_exc()))
        return (False, resource.getString("upload.failed"))

    return (True, "")

def compressPkg(dataDict):
    '''
    @summary: 将硬盘升级包打包成补丁包的形式
    '''
    dev = dataDict.get("dev")
    logger = dataDict.get("logger")
    homeDir = dataDict.get("home")
    
    devSN = contextUtil.getDevSN(dataDict)
    upgradePkgFile = dev.getUpgradeSetInfo().getUpgradePackageFile()
    upgradePkgPath = upgradePkgFile.getAbsolutePath()
    patchConfPath = homeDir + os.sep + config.PATCH_CONF_FILE
    try:
        #创建打包临时目录
        compressDir = os.path.join(homeDir, config.FW_TO_PACKAGE_DIR_TEMP)
        if not os.path.exists(compressDir):
            os.mkdir(compressDir)
        #复制硬盘固件包到临时目录并重命名
        diskPkgFile = os.path.join(compressDir, config.FW_PKG_NAME)
        shutil.copyfile(upgradePkgPath, diskPkgFile)
        #压缩固件包为补丁包形式
        fileList = [diskPkgFile, patchConfPath]
        GZipHandler.compressToTgz(fileList, compressDir, devSN)
        destFilePath = os.path.join(compressDir, devSN+config.FW_COMPRESS_EXT)
        #删除临时目录下的固件包
        os.remove(diskPkgFile)

        logger.info('compress pkg success !')
        return destFilePath
    except (Exception,JException), exception:
        logger.error('compress pkg exception:%s'%unicode(exception))
        return ''
    
def upload(dataDict,hotPatchTgzPkgName):
    """
    功能说明：查询阵列段补丁包路径，sftp上传补丁包到阵列端，通知阵列端分发补丁包
    输入：工具框架上下文，补丁包路径
    输出：bool执行结果，str错误信息
    """
    logger = dataDict.get("logger")

    if False == os.path.isfile(hotPatchTgzPkgName):
        logger.error('patchPath is follow:%s' % hotPatchTgzPkgName)
        raise TlvCmdException(ErrorCode(ErrorCodeSet.FILE_PATH_INVALID))

    #校验补丁包大小是否安全
    patchSize = os.stat(hotPatchTgzPkgName).st_size

    if contextUtil.isSupportParallel(dataDict):
        pkgType = constant.TLV_PACKAGE_TYPE.PARALLEL_PKG
    else:
        pkgType = constant.TLV_PACKAGE_TYPE.HOT_PATCH_PKG

    connectionAdapter = connectionFactory.getAdapter(dataDict)
    connectionAdapter.uploadDiskFw(hotPatchTgzPkgName,pkgType, patchSize)


def checkUploadState(dataDict):
    """
          功能说明：查询阵列状态
          输入：工具框架上下文
          输出：int阵列端状态
    """
    logger = dataDict.get("logger")
    connectionAdapter = connectionFactory.getAdapter(dataDict)
    status = connectionAdapter.queryExcuteResult()
    logger.info("upload statusIndex is :" + str(status))
    return status

def uploadWithSftp(dataDict):
    '''
    @summary: 使用是sftp上次固件包，不需要对硬盘固件包做特殊处理，支持上传到阵列指定路径
    '''
    protocalContext = dataDict.get("protocalContext")
    dev = dataDict.get("dev")
    sftp = protocalContext.get("SFTP")
    logger = dataDict.get("logger")
    lang = dataDict.get("language")
    
    errMsg = ""
    
    try:
        devSN = contextUtil.getDevSN(dataDict)
        upgradePkgPath = dev.getUpgradeSetInfo().getUpgradePackageFile()
        absolutePath = upgradePkgPath.getAbsolutePath()
        _,ext = common.getFileNameAndExt(absolutePath)
        serverPath = config.SERVER_UPGRADE_PKG_DIR + devSN + ext
        logger.info("upgradePkgPath :%s "%serverPath)

        # 判断系统空闲空间是否满足要求
        checkFlag, errMsg = checkMemEnough(dataDict, absolutePath)
        if not checkFlag:
            return (False, errMsg)

        user = dev.getDevNode().getLoginUser()
        devIp = dev.getDevNode().getIp()
        sftp.putFile(devIp, absolutePath, serverPath, user,None)
        dataDict['path'] = serverPath
        logger.info('upload file success for dev(%s)!'%(devIp))
        
        return (True, errMsg)
    except (Exception,JException),exception:
        logger.error('upload file occured except:'+unicode(exception))
        errMsg = common.getMsg(lang, "upload.pkg.failed")
        return (False, errMsg)

def getPkgSize(filePath):
    '''
    @summary: 获取文件大小，单位MB
    '''
    fsize = os.path.getsize(filePath)
    #转换为MB
    fsize = fsize / float(1024 * 1024)
    return fsize

def getSystemFreeMem(dataDict):
    '''
    @summary: 系统空闲空间大小，单位MB
    '''
    lang = dataDict.get("language")
    logger = dataDict.get("logger")
    cli = contextUtil.getCli(dataDict)
    cmd = "free -m"
    freeMem = 0
    execRets = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
    cliRet = execRets[1]
    if not execRets[0]:
        logger.info("[uploadUtil] get free mem error:%s" % str(execRets[2]))
        return (False, freeMem, common.getMsg(lang, "cannot.get.system.info"))
    flag,freeMem = cliUtil.getFreeMemInCliRet(cliRet)
    if not flag:
        logger.info("[uploadUtil] format free mem error")
        return (False, freeMem, common.getMsg(lang, "cannot.get.system.info"))
    logger.info("[uploadUtil]free mem:%s ." %str(freeMem))
    return (True, freeMem, "")

def checkMemEnough(dataDict, absolutePath):
    '''
    @summary: 查询阵列空闲内存
    '''
    logger = dataDict.get("logger")
    lang = dataDict.get("language")

    pkgSize = getPkgSize(absolutePath)
    logger.info("disk fw package size :%s " % pkgSize)
    flag, freeMem, errMsg = getSystemFreeMem(dataDict)
    if not flag:
        return (False, errMsg)
    
    freeMem = float(freeMem)
    # 空闲空间 > 包大小 + 80MB
    if pkgSize + config.MEM_SIZE > freeMem:
        errMsg = common.getMsg(lang, "upload.pkg.no.free.mem", math.ceil(pkgSize + 80))
        return (False, errMsg)
    return (True, "")

