# -*- coding: UTF-8 -*-
import time
SCRIPT_DEF_CONTEXT = "SCRIPT_DEF_CONTEXT"

SELECTED_DISK_INFO = "SELECTED_DISK_INFO"

ERROR_CODE_DEFINE = {
    "16797697":
        {
            "errMsg_zh":u"通信异常或系统繁忙。",
            "errMsg_en":"The communication is abnormal or the system is busy.",
            "suggestion_zh":u"",
            "suggestion_en":"",
        },
    "1073949185":
        {
            "errMsg_zh":u"与设备通信异常。",
            "errMsg_en":"Communicating with the device failed.",
            "suggestion_zh":u"请检查网络连接或设备状态是否正常。如果有任何疑问，请联系技术支持工程师协助处理。",
            "suggestion_en":"Please check that the network connection or the system is normal. If you have any problems, please contact technical support engineers for help.",
        },
    "TLV_CAN_NOT_CONNECT_CODE_SVP":
        {
            "errMsg_zh":u"与SVP通信异常。",
            "errMsg_en":"Communicating with the SVP failed.",
            "suggestion_zh":u"请检查SVP状态是否正常。如果有任何疑问，请联系技术支持工程师协助处理。",
            "suggestion_en":"Please check that the status of SVP is normal. If you have any problems, please contact technical support engineers for help.",
        },
    "1077936891":
        {
            "errMsg_zh":u"命令执行失败。",
            "errMsg_en":"Command execute failed.",
            "suggestion_zh":u"",
            "suggestion_en":"",
        },
    "1077949083":
        {
            "errMsg_zh":u"引擎无法监控。",
            "errMsg_en":"The engine can not be monitored.",
            "suggestion_zh":u"请查看系统中告警并按照告警修复建议进行处理。",
            "suggestion_en":"Please rectify the faults by referring to recommended actions.",
        },
    "1077949058":
        {
            "errMsg_zh":u"用户权限不足。",
            "errMsg_en":"The user does not have the permission.",
            "suggestion_zh":u"请联系管理员。",
            "suggestion_en": "Contact the administrator.",
        },
}
 
def getCli(context):
    '''
    @summary: 获取cli连接
    @param context: 上下文对象
    '''
    protocalContext = context.get("protocalContext")
    cli = protocalContext.get("SSH")
    return getCliInner(cli)

def getCliInner(cli):
    cmd = "show system general"
    except_counter = 0
    for _ in range(3):

        try:
            cliRet = cli.execCmd(cmd)
            if "Health Status" in cliRet:
                return cli
            raise
        except:
            try:
                time.sleep(5)
                cli.close()
                cli.reConnect()
                return cli
            except:
                except_counter += 1
    return cli

def getLogger(context):
    '''
    @summary: 获取日志打印对象
    @param context: 上下文对象
    '''
    return context.get("logger")

def getLang(context):
    return context.get("language")
 
def isSupportImport(dataDict):
    dev = dataDict.get("dev")
    supportImport = dev.isSupportImport()
    return supportImport

def getFlowchoice(context):
    return context.get('flowchoice')

def getUpgradedDiskIds(context):
    return context.get("UPGRADED_DISK_IDS")

def setUpgradeDiskIds(context, retryDisks):
    context["UPGRADED_DISK_IDS"] = retryDisks

def getDevObj(context):
    '''
    @summary: 获取上下文对象中dev对象
    @param context: 上下文对象
    '''
    return context.get("dev")

def getDevSN(context):
    '''
    @summary: 获取设备序列号Serial Number
    '''
    return getDevObj(context).getDevNode().getDeviceSerialNumber()

def getImportPkgMode(dataDict):
    '''
    @summary: 获取导包模式。硬盘升级导包模式：0表示不支持导包；1表示支持手动导包；2表示支持独立导包；
    '''
    dev = dataDict.get("dev")
    importPkgMode = dev.getImportPkgMode()
    return importPkgMode

def isOnlineUpgrade(dataDict):
    dev = dataDict.get("dev")
    upgradeModel = str(dev.getUpgradeSetInfo().getUpgradeModel())
    return "online" in upgradeModel.lower()

def getControllerNum(dataDict):
    dev = dataDict.get("dev")
    controllerNum = dev.getControllerNum()
    return controllerNum

def getSelectType(context):
    return str(getDevObj(context).getUpgradeSetInfo().getSelectDiskType())

def getSelectedDisks(context):
    return getDevObj(context).getUpgradeSetInfo().getSelectedDisks()

def isSupportParallel(context):
    return getDevObj(context).isSupportParallel()


def getTlvConn(context):
    '''
    @summary: 创建TLV连接
    '''
    protocalContext = context.get("protocalContext")
    if protocalContext:
        tlvBuilder = protocalContext.get('TLVBUILDER')
    else:
        tlvBuilder = context.get("TLVBUILDER")
    dev = getDevObj(context)
    return tlvBuilder.createTlvConnByInnerIp(dev.getDevNode())

def releaseTlvConn(context):
    '''
    @summary: 释放TLV连接
    '''
    protocalContext = context.get("protocalContext")
    tlvBuilder = protocalContext.get('TLVBUILDER')
    dev = getDevObj(context)
    tlvBuilder.releaseTlvConnection(dev.getDevNode())


def getItem(context, key):
    '''
    @summary: 获取自定义字典中的项
    @param context: 上下文对象
    @param key: 项的键
    '''
    scriptDefDict = getScriptDefDict(context)
    return scriptDefDict.get(key, None)


def setItem(context, key, value):
    '''
    @summary: 往自定义字典中添加项
    @param context: 上下文对象
    @param key: 添加项的键
    @param value: 添加项的值
    '''
    scriptDefDict = getScriptDefDict(context)
    scriptDefDict[key] = value

    if isinstance(context, dict):
        context[SCRIPT_DEF_CONTEXT] = scriptDefDict.copy()
    else:
        context.put(SCRIPT_DEF_CONTEXT, scriptDefDict.copy())
    return

def getScriptDefDict(context):
    '''
    @summary: 获取上下文自定义字典
    @param context: 上下文对象
    '''
    if isinstance(context, dict):
        if not context.has_key(SCRIPT_DEF_CONTEXT):
            context.setdefault(SCRIPT_DEF_CONTEXT, {})
    else:
        if not context.containsKey(SCRIPT_DEF_CONTEXT):
            context.put(SCRIPT_DEF_CONTEXT, {})
    return context.get(SCRIPT_DEF_CONTEXT)