from frameone.adapter.cliService import CliService
from frameone.adapter.restService import RestService, RestAdapter
from frameone.adapter.tlvService import TlvService, TlvAdapter
from frameone.util import baseUtil
from frameone.util import contextUtil


def getAdapter(dataDict):
    logger = contextUtil.getLogger(dataDict)
    devVersion = contextUtil.getCurVersion(dataDict)
    devType = contextUtil.getDevType(dataDict)
    logger.info("Enter protocol factory.devType=%s, devVersion=%s" % (devType, devVersion))
    if baseUtil.isSupportRest(devType, devVersion):
        logger.info("user rest adapter.")
        return RestAdapter(dataDict)
    else:
        logger.info("user tlv adapter.")
        return TlvAdapter(dataDict)

def getCliService(dataDict):
    return CliService(dataDict)

def getTlvService(dataDict):
    return TlvService(dataDict)

def getRestService(dataDict):
    return RestService(dataDict)