
from frameone.util import baseUtil,contextUtil
class ResourceType():
    REST="restImpl"
    TLV="tlvImpl"

class ResourceSelector():
    def __init__(self, context):
        self.logger = contextUtil.getLogger(context)
        self.devVersion = contextUtil.getCurVersion(context)
        self.devType = contextUtil.getDevType(context)


    def commonSelector(self):
        self.logger.info("commonSelector devType=%s, devVersion=%s" % (self.devType, self.devVersion))
        if baseUtil.isSupportRest(self.devType, self.devVersion):
            self.logger.info("user rest adapter.")
            return ResourceType.REST
        else:
            self.logger.info("user tlv adapter.")
            return ResourceType.TLV

    def hostLinkSelector(self):
        if baseUtil.isDoradoDev(self.devType) or self.devVersion >= "V300R003C20":
            return ResourceType.REST
        else:
            return ResourceType.TLV

