# -*- coding: UTF-8 -*-
import traceback
import time
from java.lang import Exception as JException
from com.huawei.ism.exception import IsmException
from frame.common import constant, config

from frameone.base.exception import TlvCmdException, RestCmdException, ErrorCodeSet, ErrorCode
from frameone.rest import restData
from frameone.rest.restUtil import Tlv2Rest, CommonRest, CommonRestService
from frameone.util import contextUtil

from com.huawei.ism.tlv.lang import UnsignedInt32


def transException(fn):
    '''
    将ISM异常转换为CliCmdException
    restUtil中的execCmd：
        抛出Exception异常
        CommonRest.REST_CAN_NOT_EXECUTE--
        若response中错误码不为0，则将错误码转为异常抛出
        自带3次重试
    '''

    def inner(*params):
        self = params[0]
        try:
            return fn(*params)
        except IsmException, e:
            if e.getErrorId() in [-404, -1]:
                return []
        except JException, e:
            self.logger.error("java excption:%s" % traceback.format_exc())
            raise RestCmdException(ErrorCode(ErrorCodeSet.REST_CONNECTION_EXCEPTION))

    return inner


def transException2(fn):
    '''
    将ISM异常转换为CliCmdException
    restUtil中的execCmd：
        抛出Exception异常
        CommonRest.REST_CAN_NOT_EXECUTE--
        若response中错误码不为0，则将错误码转为异常抛出
        自带3次重试
    '''

    def inner(*params):
        self = params[0]
        try:
            return fn(*params)
        except TlvCmdException, e:
            raise e
        except:
            try:
                return fn(*params)
            except:
                self.logger.error("java excption:%s" % traceback.format_exc())
            raise TlvCmdException(ErrorCode(ErrorCodeSet.REST_CONNECTION_EXCEPTION))

    return inner


class RestService():
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get('logger')

    def excuteCmd(self, cmd, params):
        rest = contextUtil.getRest(self.dataDict)
        Tlv2Rest.execCmd(rest, cmd, params)

    def getHost(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "host"
        return CommonRestService.get4Page(rest, uri)

    def getHostLink(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        self.logger.info("gethostlink=%s" % hostId)
        allDatas = []
        for initiatorType in ["223", "222", "16499"]:
            datas = self._getHostLinkByType(rest, initiatorType, hostId)
            if datas:
                allDatas.extend(datas)
        return allDatas

    def getHostLinkByType(self, hostId, type):
        rest = contextUtil.getRest(self.dataDict)
        self.logger.info("gethostlink=%s" % hostId)
        InitiatorTypeDict = dict(FC="223", ISCSI="222", IB="16499")
        initiatorType = InitiatorTypeDict.get(type)

        allDatas = []
        datas = self._getHostLinkByType(rest, initiatorType, hostId)
        if datas:
            allDatas.extend(datas)
        return allDatas

    @transException
    def _getHostLinkByType(self, rest, initiatorType, hostId):
        uri = "host_link?INITIATOR_TYPE=%s&PARENTID=%s" % (initiatorType, hostId)
        datas = CommonRestService.get4Big(rest, uri)
        return datas

    def getFcInitiator(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "fc_initiator?PARENTID=%s" % hostId
        return CommonRestService.get4Big(rest, uri)

    def getIscsiInitiator(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "iscsi_initiator?PARENTID=%s" % hostId
        return CommonRestService.get4Big(rest, uri)

    def getDataPersistence(self,domaianId, tierType, diskNumInt, diskCapacityInt):
        rest = contextUtil.getRest(self.dataDict)
        uri = "DiskPool/expansion_data_persistent_check?ID=%s&tierType=%s&diskNumInt=%s&diskCapacityInt=%s"\
        %(domaianId, tierType, diskNumInt, diskCapacityInt)
        data = CommonRestService.get(rest, uri)
        return data.get("dataPersistentCheckResult")

    @transException
    def getIbInitiator(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "ib_initiator/associate/host?ASSOCIATEOBJTYPE=21&ASSOCIATEOBJID=%s" % hostId
        return CommonRestService.get4Big(rest, uri)

    def getHostLun(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "lun/associate?TYPE=11&ASSOCIATEOBJTYPE=21&ASSOCIATEOBJID=%s" % hostId
        return CommonRestService.get4Big(rest, uri)

    def getHostLunCount(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "lun/count?ASSOCIATEOBJTYPE=21&ASSOCIATEOBJID=%s" % hostId
        return CommonRestService.get(rest, uri)

    def getHostSnapCount(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "snapshot/count?ASSOCIATEOBJTYPE=21&ASSOCIATEOBJID=%s" % hostId
        return CommonRestService.get(rest, uri)

    def getHostLunAndSnapCount(self, hostId):
        ret = self.getHostLunCount(hostId)
        try:
            snapRet = self.getHostSnapCount(hostId)
            if snapRet and ret:
                count = int(snapRet.get("COUNT", 0)) + int(ret.get("COUNT", 0))
                return {"COUNT": str(count)}
        except:
            self.logger.error("query host snap lun exception.")
        return ret

    @transException
    def getLicenseFeature(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "license/feature"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getReplicationPair(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "REPLICATIONPAIR"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getHyperMetroPair(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "HyperMetroPair"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getHyperVaultJob(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "HyperVaultJob"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getLunCopy(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "luncopy"
        return CommonRestService.get4Page(rest, uri)

    @transException
    def getMemberLunCopy(self, lunCopyId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "LUNCOPYMEMBERLUN/GET_BATCH_NEXT_LUNCOPY_MEMBERLUN?LUNCOPYID=%s" % lunCopyId
        return CommonRestService.get4Big(rest, uri)

    ### 端口反查检查主机冗余链路用到的接口
    def getFcInitiators(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "fc_initiator"
        return CommonRestService.get4Page(rest, uri)

    def getFcProts(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "FC_PORT"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getFcoeProts(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "FCoE_PORT"
        return CommonRestService.get4Big(rest, uri)

    def getFcPortLink(self, portId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "fc_initiator/associate?ASSOCIATEOBJTYPE=212&ASSOCIATEOBJID=%s" % portId
        return CommonRestService.get4Page(rest, uri)

    @transException
    def getFcoePortLink(self, portId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "fc_initiator/associate?ASSOCIATEOBJTYPE=252&ASSOCIATEOBJID=%s" % portId
        return CommonRestService.get4Page(rest, uri)

    def getIscsiInitiators(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "iscsi_initiator"
        return CommonRestService.get4Page(rest, uri)

    def getEthProts(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "ETH_PORT"
        return CommonRestService.get4Big(rest, uri)

    def getIscsiPortLink(self, portId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "iscsi_initiator/associate?ASSOCIATEOBJTYPE=213&ASSOCIATEOBJID=%s" % portId
        return CommonRestService.get4Page(rest, uri)

    @transException
    def getIbInitiators(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "ib_initiator"
        return CommonRestService.get4Page(rest, uri)

    @transException
    def getIbProts(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "ib_port"
        return CommonRestService.get4Big(rest, uri)

    @transException
    def getIbPortLink(self, portId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "ib_initiator/associate?ASSOCIATEOBJTYPE=16500&ASSOCIATEOBJID=%s" % portId
        return CommonRestService.get4Page(rest, uri)

    def getMappingViews(self):
        rest = contextUtil.getRest(self.dataDict)
        uri = "mappingview"
        return CommonRestService.get4Page(rest, uri)

    def getPortgroupByMapping(self, mappingviewId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "portgroup/associate/mappingview?TYPE=257&ASSOCIATEOBJTYPE=245&ASSOCIATEOBJID=%s" % mappingviewId
        return CommonRestService.get4Big(rest, uri)

    def getHostgroupByMapping(self, mappingviewId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "hostgroup/associate/mappingview?TYPE=14&ASSOCIATEOBJTYPE=245&ASSOCIATEOBJID=%s" % mappingviewId
        return CommonRestService.get4Big(rest, uri)

    def getHostByHostGroup(self, hostId):
        rest = contextUtil.getRest(self.dataDict)
        uri = "host/associate?TYPE=21&ASSOCIATEOBJTYPE=14&ASSOCIATEOBJID=%s" % hostId
        return CommonRestService.get4Page(rest, uri)

    def getPortByPortGroup(self, portGroupId):
        uris = []
        uris.append("fc_port/associate/portgroup?TYPE=212&ASSOCIATEOBJTYPE=257&ASSOCIATEOBJID=%s" % portGroupId)
        uris.append("fcoe_port/associate/portgroup?TYPE=252&ASSOCIATEOBJTYPE=257&ASSOCIATEOBJID=%s" % portGroupId)
        uris.append("eth_port/associate/portgroup?TYPE=213&ASSOCIATEOBJTYPE=257&ASSOCIATEOBJID=%s" % portGroupId)
        uris.append("ib_port/associate/portgroup?TYPE=16500&ASSOCIATEOBJTYPE=257&ASSOCIATEOBJID=%s" % portGroupId)
        ports = []
        for uri in uris:
            tmpData = self._getPortByPortGroup(uri)
            if tmpData:
                ports.extend(tmpData)
        return ports

    @transException
    def _getPortByPortGroup(self, uri):
        rest = contextUtil.getRest(self.dataDict)
        return CommonRestService.get4Big(rest, uri)

    @transException
    def excuteDiagnoseCmd(self, command, locationId):
        params = []
        param0 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_MSGTYPE, 0)
        param1 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_NIDLIST, "")
        param2 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_ACTIVETYPE, 0)
        param3 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_BAKPATH, "")
        param4 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXENODETYPE, "")
        param5 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEFLOW, "")
        param6 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEFLOWSEGMENT, "")
        param7 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEATOM, "")
        param8 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_SYNCPAR, "")
        param9 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_PKG_TYPE, 0)
        param12 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXC_DIAG_CMD, command)
        param13 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXC_CHECK_MODEL, locationId)
        params.extend(
            [param0, param1, param2, param3, param4, param5, param6, param7, param8, param9, param12, param13])

        self.logger.info('Execute cmd [code:%s] [%s]' % (restData.TlvCmd.EXC_UPD, params))
        rest = contextUtil.getRest(self.dataDict)
        recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.EXC_UPD, params)
        return recs

    @transException
    def getParamStrValue(self, record, index):

        paramInfo = record.get(str(index), '')
        if paramInfo == '':
            return None
        paramValue = paramInfo.get("value")
        if paramValue == "":
            return None
        return unicode(paramValue)

    @transException
    def getParamIntValue(self, record, index):
        paramInfo = record.get(str(index), '')
        if paramInfo == '':
            return None
        paramValue = paramInfo.get("value")
        if paramValue == "":
            return None
        return int(paramValue)


class RestAdapter:
    def __init__(self, dataDict):
        self.dataDict = dataDict
        self.logger = dataDict.get('logger')

    def close(self):
        contextUtil.releaseRest(self.dataDict)

    @transException2
    def uploadDiskFw(self, pkgName, pkgType, patchSize):
        dev = contextUtil.getDevObj(self.dataDict).getDevNode()
        protocalContext = self.dataDict.get("protocalContext")
        sftp = protocalContext.get("SFTP")

        # 获取补丁包上传路径
        params = []
        param0 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_TYPE, UnsignedInt32(pkgType))
        param2 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_SIZE, UnsignedInt32(patchSize))
        params.extend([param0, param2])
        rest = contextUtil.getRest(self.dataDict)
        retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params, False)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constant.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, str(params), str(retRec)))
        uploadPath = self.getParamStrValue(retRec, 1)

        # 上传升级包
        try:
            sftp.putFile(dev.getIp(), pkgName, uploadPath, dev.getLoginUser(), None)
        except:
            raise TlvCmdException(ErrorCode(ErrorCodeSet.REST_CONNECTION_EXCEPTION))

        # 通知其他控制器同步升级包
        params = []
        self.logger.info("pkg upload ip = %s, uploadpath=%s" % (str(dev.getIp()), uploadPath))
        devPkgPath = dev.getIp() + ":" + uploadPath
        param0 = (restData.Upgrade.NotifyPackagePath.CMO_NOTIFY_PACKAGE_PATH, devPkgPath)
        params.append(param0)
        rest = contextUtil.getRest(self.dataDict)
        rec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_NOTIFY_PACKAGE_PATH, params, False)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constant.TLV_CMD.OM_MSG_OP_NOTIFY_PACKAGE_PATH, str(params), str(rec)))

    def deleteUpgradePkg(self, pkgType):
        params = []
        param0 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_TYPE, UnsignedInt32(pkgType))
        param2 = (restData.Upgrade.GetPackageUploadPath.CMO_PACKAGE_SIZE, UnsignedInt32(0))
        params.extend([param0, param2])
        try:
            rest = contextUtil.getRest(self.dataDict)
            retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params, False)
            self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
                constant.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, str(params), str(retRec)))
        except:
            try:
                rest = contextUtil.getRest(self.dataDict)
                retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, params, False)
                self.logger.error('TLV cmd [%d] send[%s] receive[%s]' % (
                    constant.TLV_CMD.OM_MSG_OP_GET_PACKAGE_UPLOADPATH, str(params), str(retRec)))
            except:
                self.logger.error("Notify OM delete Package failed.")

    @transException2
    def queryExcuteResult(self):
        params = []
        rest = contextUtil.getRest(self.dataDict)
        rec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_LST_SYS_PROGRESS, params, False)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constant.TLV_CMD.OM_MSG_OP_UPD_LST_SYS_PROGRESS, str(params), str(rec)))
        status = self.getParamIntValue(rec, 3)
        return status

    @transException2
    def queryExcuteDetail(self):
        errMsg = ''
        resource = self.dataDict.get("resource")

        # 查询处理详细信息
        params = []
        rest = contextUtil.getRest(self.dataDict)
        recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_LIST_DETAILINFO, params, True)
        self.logger.info('TLV cmd [%d] send[%s] receive[%s]' % (
            constant.TLV_CMD.OM_MSG_OP_UPD_LIST_DETAILINFO, str(params), str(recs)))

        # 解析处理详细信息，生成返回信息
        for rec in recs:
            nameKey = self.getParamStrValue(rec, 0)
            errorKey = self.getParamStrValue(rec, 2)
            nodeId = self.getParamStrValue(rec, 3)
            errMsg += "%s--%s--%s\n" % (nodeId, resource.getString(nameKey), resource.getString(errorKey))
        return errMsg

    def upgradeDisksFw(self, diskUpgradeMode, upgradeType=0, diskIdStr=None):
        # 0-升级方式（1-全盘升级；2-单盘升级；3-多盘升级）
        # 4-硬盘框号（）
        params = []
        param0 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_MODE, int(diskUpgradeMode))
        param5 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_TYPE, upgradeType)
        params.extend([param0, param5])

        if diskIdStr:
            param4 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_DISKS, diskIdStr)
            params.append(param4)
        self.logger.info('Execute cmd [%d] [%s]' % (constant.TLV_CMD.OM_MSG_OP_UPD_DISK_FIRMWARE, str(params)))
        # 获取补丁包上传路径
        try:
            rest = contextUtil.getRest(self.dataDict)
            retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_DISK_FIRMWARE, params, False)
            self.logger.info("invoke tlv disk upgrade response=%s" % retRec)

            # TODO 系统正在进行硬盘升级，该命令会报错；重试升级时，忽略该错（提示正在升级）
        except:
            try:
                # 重新获取TLV连接，重试一次
                time.sleep(5)
                rest = contextUtil.getRest(self.dataDict)
                retRec = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_DISK_FIRMWARE, params, False)
                self.logger.info("invoke tlv disk upgrade response=%s" % retRec)
            except:
                self.logger.error("invoke diskupgrade tlv cmd exception:%s" % traceback.format_exc())
                raise

    def queryDiskUpgradeResult(self, diskUpgradeMode, upgradeType=0):
        try:
            params = []
            param0 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_MODE, int(diskUpgradeMode))
            param5 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_TYPE, upgradeType)
            params.extend([param0, param5])

            if diskUpgradeMode == config.DISK_UPGRADE_MODE.MULTI:
                param4 = (restData.Upgrade.UpgradeDisk.CMO_UPGRADE_DISKS, "CTE99.9")
                params.append(param4)
            self.logger.info('Execute cmd [%d] [%s]' % (constant.TLV_CMD.OM_MSG_OP_UPD_GET_DISK_RESULT, str(params)))

            rest = contextUtil.getRest(self.dataDict)
            response = Tlv2Rest.execCmd(rest, restData.TlvCmd.OM_MSG_OP_UPD_GET_DISK_RESULT, params)

            self.logger.info("cmd=%s response=%s" % (constant.TLV_CMD.OM_MSG_OP_UPD_GET_DISK_RESULT, str(response)))
            return response
        except:
            self.logger.error("invoke diskupgrade tlv cmd exception:%s" % traceback.format_exc())
            try:
                # 重新获取REST连接
                rest = contextUtil.getRest(self.dataDict)
            except:
                # 无法建立连接
                self.logger.error("create tlv con exception:%s" % traceback.format_exc())
                raise TlvCmdException(ErrorCode(ErrorCodeSet.REST_CONNECTION_EXCEPTION))
            raise TlvCmdException(ErrorCode(ErrorCodeSet.COMMON_CMD_ERROR))

    @transException
    def excuteDiagnoseCmd(self, command, locationId):
        params = []
        param0 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_MSGTYPE, 0)
        param1 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_NIDLIST, "")
        param2 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_ACTIVETYPE, 0)
        param3 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_BAKPATH, "")
        param4 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXENODETYPE, "")
        param5 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEFLOW, "")
        param6 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEFLOWSEGMENT, "")
        param7 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_EXEATOM, "")
        param8 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_SYNCPAR, "")
        param9 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXE_UPD_PKG_TYPE, 0)
        param12 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXC_DIAG_CMD, command)
        param13 = (restData.Upgrade.NotifyExcUpgrade.CMO_EXC_CHECK_MODEL, locationId)
        params.extend(
            [param0, param1, param2, param3, param4, param5, param6, param7, param8, param9, param12, param13])

        self.logger.info('Execute cmd [code:%s] [%s]' % (restData.TlvCmd.EXC_UPD, params))
        rest = contextUtil.getRest(self.dataDict)
        recs = Tlv2Rest.execCmd(rest, restData.TlvCmd.EXC_UPD, params)
        return recs

    @transException
    def getParamStrValue(self, record, index):

        paramInfo = record.get(str(index), '')
        if paramInfo == '':
            return None
        paramValue = paramInfo.get("value")
        if paramValue == "":
            return None
        return unicode(paramValue)

    @transException
    def getParamIntValue(self, record, index):
        paramInfo = record.get(str(index), '')
        if paramInfo == '':
            return None
        paramValue = paramInfo.get("value")
        if paramValue == "":
            return None
        return int(paramValue)
