# -*- coding: UTF-8 -*-
from frameone.util import baseUtil

RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"

class CheckStatus:
    PASS = "0"
    NOTPASS = "1"
    NOCHECK = "2"
    NO_SUPPORT = "3"
    WARNING = "4"

    @staticmethod
    def getMergeStatus(allStatus):
        if CheckStatus.NOTPASS in allStatus:
            return False
        if CheckStatus.NOCHECK in allStatus:
            return RESULT_NOCHECK
        if CheckStatus.WARNING in allStatus:
            return RESULT_WARNING
        if CheckStatus.NO_SUPPORT in allStatus:
            return RESULT_NOSUPPORT
        return True


class CheckResult:
    def __init__(self, status, cliRet=None, errMsg="", data=None):
        self.status = status
        self.cliRet = cliRet
        self.errMsg = errMsg
        self.data = data

    def toScriptResult(self):
        if not self.cliRet:
            self.cliRet = []
        return self.status, "\n".join(self.cliRet), self.errMsg

    @staticmethod
    def getMergeResult(allResultDict, lang):
        errKey2HostDict = {}
        for key, checkResult in allResultDict.items():
            errKey = checkResult[1]
            if not errKey:
                continue
            if not errKey2HostDict.has_key(errKey):
                errKey2HostDict[errKey] = []
            errKey2HostDict[errKey].append(key)

        allStatus = map(lambda x: x[0], allResultDict.values())
        status = CheckStatus.getMergeStatus(allStatus)
        errMsg = ""
        if errKey2HostDict:
            for errKey, hostIds in errKey2HostDict.items():
                errMsg += baseUtil.getMsg(lang, errKey, ", ".join(hostIds))
        return status, errMsg
