# -*- coding: UTF-8 -*-

class ErrorCodeSet:
    # CLI相关

    CLI_NO_LICENSE = "C0000000"
    CLI_CONNECTION_EXCEPTION = "C0000001"
    CLI_NO_SUPPORT_CMD = "C00000002"
    CLI_EXECUTE_CMD_FAILED = "C0000003"
    CLI_EXECUTE_INTERNAL_ERROR = "C0000004"
    CLI_GET_MASTER_NODE_FAILED = "C0000005"
    CLI_EXECUTE_ECHO_ERROR = "C0000006"
    CLI_NO_AVAILABLE_CON = "C0000007"
    CLI_CANNOT_LOGTO_MASTER = "C0000008"
    CLI_NO_AVAILABLE_MODE = "C0000009"
    CLI_CANNOT_SSH_REMOTE = "C0000010"
    CLI_IN_MINISYSTEM_MODE = "C0000011"
    CLI_EXECUTE_CMD_TIMEOUT = "C0000012"

    #

    # TLV相关的错误吗
    TLV_RESPONSE_NULL = "C1000000"
    TLV_CONNECTION_EXCEPTION = "C1000001"
    TLV_EXCUTE_EXCEPTION = "C1000002"

    # REST命令执行部分的异常错误码
    REST_CONNECTION_EXCEPTION = "C2000000"
    
    #通用错误
    COMMON_CMD_ERROR ="C3000000"
    SFTP_UPLOAD_PKG_FAILED = "C3000001"
    FILE_PATH_INVALID = "C3000002"



ErrorCodeMsg = {
    "C0000000": {
        "zh": u"license不存在。",
        "en": "The license does not exist."
    },
    "C0000001": {
        "zh": u"与设备通信异常，请检查网络连接或设备状态是否正常。",
        "en": "The communication between the tool and the device is abnormal. Check whether the network connection or device status is normal."
    },
    "C0000002": {
        "zh": u"当前用户没有权限执行此命令或者设备不支持此命令。",
        "en": "The current user does not have the permission to run this command, or the device does not support this command."
    },
    "C0000003": {
        "zh": u"命令执行失败，请检查网络连接或设备状态是否正常。",
        "en": "The current user does not have the permission to run this command, or the device does not support this command."
    },
    "C0000004": {
        "zh": u"系统内部错误，请联系技术工程师。",
        "en": "System error. Contact technical support engineers."
    },
    "C0000005": {
        "zh": u"获取主控节点失败，请检查网络连接或设备状态是否正常。",
        "en": "Failed to obtain the primary controller node. Check whether the network connection or device status is normal."
    },
    "C0000006": {
        "zh": u"命令结果无法解析，请联系技术工程师。",
        "en": "The command output cannot be parsed. Contact technical support engineers."
    },
    "C0000007": {
        "zh": u"无可用的管理IP，请检查网络连接或设备状态是否正常。",
        "en": "There is no available management IP address. Check whether the network connection or device status is normal."
    },
    "C0000008": {
        "zh": u"无法连接主控节点。请检查网络连接或设备状态是否正常。",
        "en": "The primary controller node cannot be connected. Check whether the network connection or device status is normal."
    },
    "C0000009": {
        "zh": u"系统繁忙，请稍后重试。",
        "en": "The system is busy. Please try later."
    },
    "C0000010": {
        "zh": u"无法通过内部心跳登陆对端控制器，请检查网络连接或设备状态是否正常。",
        "en": "Failed to log in to the peer-end controller through the internal heartbeat. Check whether the network connection or device status is normal."
    },
    "C0000011": {
        "zh": u"系统处于minisystem模式",
        "en": ""
    },
    "C0000012": {
        "zh":u"命令执行超时，请重试，重试失败请联系技术工程师",
        "en":""
    },

    # Tlv
    "C1000000": {
        "zh": u"命令返回为空",
        "en": "No information is displayed in the command output."
    },
    "C1000001": {
        "zh": u"无法建立TLV连接，请检查网络连接或设备状态是否正常。",
        "en": "Failed to establish TLV connection. Check whether the network connection or device status is normal."
    },

    # rest相关
    "C2000000": {
        "zh": u"无法建立REST连接，请检查网络连接或设备状态是否正常。",
        "en": "Failed to establish REST connection. Check whether the network connection or device status is normal."
    },

    # 通用错误
    "C3000000": {
        "zh": u"命令执行失败，请检查网络连接或设备状态是否正常。",
        "en": "Failed to execute the command. Check whether the network connection or device status is normal."
    },
    "C3000001": {
        "zh": u"通过SFTP上传硬盘固件包失败。",
        "en": "Upload failure through the SFTP transmission method."
    },
    "C3000002": {
        "zh": u"文件路径无法识别。可能的原因是：1、文件路径不存在 ；2、英文版操作系统下的文件路径中含有中文字符。",
        "en": "The file path is unrecognized. The possible causes as follows: 1.The file path is not existed; 2.The file path within English operating system contains non-English charactor."
    },




}


class ErrorCode:
    def __init__(self, id, params=None):
        self.id = id
        self.params = params

    def getId(self):
        return self.id

    def getMsg(self, lang="zh"):
        msg = ErrorCodeMsg.get(self.id)
        if msg is None:
            return unicode(ErrorCodeMsg.get(ErrorCodeSet.COMMON_CMD_ERROR).get(lang))
        return unicode(ErrorCodeMsg.get(self.id).get(lang))


class CmdExecuteException(Exception):
    def __init__(self):
        Exception.__init__(self)

    def getId(self):
        pass

    def getMsg(self, lang):
        pass



class CliCmdException(CmdExecuteException):
    def __init__(self, errorCodeInstance, cliRet=""):
        self.errorCodeInstance = errorCodeInstance
        self.cliRet = cliRet
        Exception.__init__(self)

    def getId(self):
        return self.errorCodeInstance.getId()

    def getMsg(self, lang):
        return self.errorCodeInstance.getMsg(lang)

    def getCliRet(self):
        return self.cliRet


class TlvCmdException(CmdExecuteException):
    def __init__(self, errorCodeInstance):
        self.errorCodeInstance = errorCodeInstance
        Exception.__init__(self)

    def getId(self):
        return self.errorCodeInstance.getId()

    def getMsg(self, lang):
        return self.errorCodeInstance.getMsg(lang)


class RestCmdException(CmdExecuteException):
    def __init__(self, errorCodeInstance):
        self.errorCodeInstance = errorCodeInstance
        Exception.__init__(self)

    def getId(self):
        return self.errorCodeInstance.getId()

    def getMsg(self, lang):
        return self.errorCodeInstance.getMsg(lang)
