# -*- coding: UTF-8 -*-
import time
import threading
from frameone.util import contextUtil


class RefreshProgress(threading.Thread):
    def __init__(self, context, callback):
        threading.Thread.__init__(self)
        self.context = context
        self.logger = contextUtil.getLogger(context)
        self.__running = threading.Event()
        self.__running.set()
        self.speedSteps = [(10, 80), (15, 99)]
        self.totalTime = 15
        self.setProgress = callback.setProgress
        self.stopRefresh = callback.stopRefresh

    def setSpeedSteps(self, steps):
        self.speedSteps = steps
        self.totalTime = self.speedSteps[-1][0]

    def stop(self):
        self.__running.clear()
        self.setProgress(100, 0)

    def computeCurrentProgress(self, time):
        currentProgress = 0
        lastArea = (0, 0)
        for speedStep in self.speedSteps:
            if time < speedStep[0]:
                currentProgress += time * ((speedStep[1]-lastArea[1])*1.0/(speedStep[0]-lastArea[0]))
                return currentProgress
            else:
                time -= speedStep[0]
                currentProgress = speedStep[1]
            lastArea = speedStep
        return currentProgress


    def run(self):

        currentPro = 0
        self.setProgress(currentPro, self.totalTime)

        startTime = time.clock()
        expendTime = 0
        while self.__running.isSet() and not self.stopRefresh():
            expendTime = time.clock() - startTime
            currentPro = self.computeCurrentProgress(expendTime)
            self.remainTime = self.totalTime - expendTime
            self.remainTime = 5 if self.remainTime < 5 else self.remainTime
            currentPro = 99 if currentPro > 99 else currentPro
            self.setProgress(currentPro, self.remainTime)
            time.sleep(2)
        self.logger.info("the item actual expend time=%s" % (expendTime))
        return

    def addRemainTime(self, second):
        self.remainTime += second




