# -*- coding: UTF-8 -*-
from frameone.base.exception import *
from cbb.frame.util.common import wrapAllExceptionLogged

class CliConnection(object):
    RE_CONNECTION_TIMES = 1
    _instance = None
    _cli = None


    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(CliConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance

    def __init__(self, connectorFactory, ip, sshPort, sshConnector=None):
        self.connectorFactory = connectorFactory
        self.ip = ip
        self.sshPort = sshPort
        self.sshConnector = sshConnector

    def create(self, user, pawd):
        reConnectionTimes = 0
        self.close()
        while self._cli is None and reConnectionTimes < CliConnection.RE_CONNECTION_TIMES:
            if self.sshConnector is None:
                self.sshConnector = self.connectorFactory.createSshConnector(self.ip, self.sshPort, user, pawd)
            self._cli = self.sshConnector.getConnectionNoException()
            reConnectionTimes += 1
        del pawd
        return self._cli

    @wrapAllExceptionLogged(logger=None)
    def close(self):
        if self._cli is not None:
            try:
                self.exitHeartbeatCli()
                self._cli.close()
            finally:
                self._cli = None
        return

    @wrapAllExceptionLogged(logger=None)
    def exitHeartbeatCli(self):
        for _ in range(3):
            cliRet = self._cli.execCmdNoLogTimout("exit", 5)

            while "(y/n)" in cliRet:
                cliRet = self._cli.execCmdNoLogTimout("y", 5)

                # Compatible for debug version.
            if "Storage:~ #" in cliRet:
                self._cli.execCmdNoLogTimout("exit", 5)
    
    def checkConnect(self):
        if self._cli is None:
            raise CliCmdException(ErrorCode(ErrorCodeSet.CLI_CONNECTION_EXCEPTION))
        except_counter = 0
        try:
            stdOut = self._cli.getLoginMessage()
            if "Ctrl+c to exit or Input minisystem to minisystem mode" in str(stdOut):
                self._cli.execCmd("minisystem")
            if "Local node is offline, Press any key to exit" in str(stdOut):
                self._cli.execCmd("\n")
        except:
            except_counter += 1

        cliRet = self._cli.execCmd("show cli configuration")

        if "-bash:" in cliRet or "Storage:~" in cliRet:
            raise CliCmdException(ErrorCode(ErrorCodeSet.CLI_CONNECTION_EXCEPTION))

        if "minisystem>" in cliRet:
            raise CliCmdException(ErrorCode(ErrorCodeSet.CLI_IN_MINISYSTEM_MODE))

        if "Try 'help'" in cliRet or "does not exist or has an incorrect format" in cliRet:
            raise CliCmdException(ErrorCode(ErrorCodeSet.CLI_CONNECTION_EXCEPTION))

        if "More enabled" not in cliRet:
            raise CliCmdException(ErrorCode(ErrorCodeSet.CLI_CONNECTION_EXCEPTION))
        
        return True
        
    def getCli(self, user, pawd):
        try:
            if self._cli is None:
                self.create(user, pawd)
            self.checkConnect()
        except:
            self.create(user, pawd)
            self.checkConnect()

        return self._cli
