﻿# -*- coding: UTF-8 -*-
from frameone.rest import restDataType

REST_SCOPE_DEFAULT = "0"
CMD_DEFAULT_TIMEOUT = 60*5


class Enum():
    ##-----------REST框架使用配置-----------     
    class RestMethod():
        GET = 0     #请求主要用于查询存储管理对象
        POST = 1    #请求主要用于创建存储管理对象
        PUT = 2     #请求主要用于修改存储管理对象属性和对管理对象的特殊操作
        DELETE = 3  #主要用于删除存储管理对象   

    ##-----------对象属性的枚举类型-----------
    class LicenseFeatureEnum:
        HYPER_REPLICATION = 24
        HYPER_METRO = 63

    class IbcEnum():
        PWD_CHANGED = "true"
        KEYPAIR_CHANGED = "true"

    class EthPortLogicTypeEnum():
        HOST = 0            #主机端口/业务端口
        EXP = 1             #级联端口
        MNGT = 2            #管理端口
        INNER = 3           #内部端口
        MAINTENANCE = 4     #维护端口
        MNGT_SRV = 5        #管理/业务混合口
        MAINTENANCE_SRV = 6 #维护/业务混合口
        BACKUP_MGR = 7      #备份管理网口
        PRODUCT_STORAGE = 8 #生产存储网口
        BACKUP_STORAGE = 9  #备份存储网口
        ETH_NOT_CONFIG = 10 #未配置角色网口
        IP_SCALE_OUT = 11   #用于IP Scale-Out的网口

    class CofigModelEnum():
        SINGLE_CTRL = 0 #单控
        MULTI_CTRL = 1  #多控

    class LightStatusEnum():
        ON = 1
        OFF = 2

    class IpTypeEnum():
        IPV4 = 1
        IPV6 = 2

    class EncLogicTypeEnum():
        EXP = 0   #级联框（硬盘框）
        CTRL = 1  #控制框
        DSW = 2   #数据交换机
        MSW = 3   #管理交换机
        SVP = 4   #管理服务器

    class DataTypeEnum():
        CONFIG_DATA = 3 #配置数据

    class ExportTypeEnum():
        MEMORY = 0   #从内存导出
        DISK = 1     #从硬盘导出

    class DiskEnum():
        DISK0 = "0"
        DISK1 = "1"
    class ServiceStatusEnum():
        UNKNOW = 0
        INIT = 1
        ONLINE = 2
        OFFLINE = 3
    class RecoveryPolicyEnum:
        AUTO = 1
        MANUALLY = 2

    class OperationTypeEnum():
        EXPORT = 1        #导出

    class FileIdEnum():
        CONFIG_DATA = 50  #配置数据文件

    class OperationResultEnum():
        SUCCESS = 0
        FAIL = 1

    class ParentTypeEnum():
        ENCLOSURE = 206    #框/Enclosure
        CONTROLLER = 207   #控制器/Controller
        EXPBOARD = 208     #级联板/Expand Board
        INTF_MODULE = 209  #接口模块/Interface Module

    class EnclosureModelEnum():
        CTRL_BMC = 0               #BMC控制框
        CTRL_SAS2U_12 = 1          #2U SAS 12盘主控框
        CTRL_SAS2U_24 = 2          #2U SAS 24盘主控框 
        EXPSAS2U_12 = 16           #2U SAS 12盘级联框
        EXPSAS2U_24 = 17           #2U SAS 24盘级联框
        EXPSAS4U = 18              #4U SAS 24盘级联框
        EXPFC = 19                 #4U FC 24盘级联框
        DSW_PCIe1U = 20            #1U PCIe数据交换机
        EXPSAS4U_75 = 21           #4U SAS 75盘级联框
        SVP = 22                   #SVP
        CTRL_6U = 97               #6U 4控独立机头
        CTRL_3U = 96               #3U 2控独立机头
        EXPSAS2U_25 = 24           #2U SAS 25盘2.5寸磁盘框
        EXPSAS2U_25_12GLINK = 65   #2U SSD 25盘2.5寸级联框
        EXPSAS4U_24_NEW = 25       #4U SAS 24盘3.5寸磁盘框（新）
        CTRL_12GSAS_2U25_EAR = 26  #2U 12GSAS 25盘主控框
        CTRL_12GSAS_2U12_EAR = 23  #2U 12GSAS 12盘主控框
        ARM_2U_12 = 37             #2U 12GSAS 12盘ARM主控框
        ARM_2U_25 = 38             #2U 12GSAS 25盘ARM主控框
        EXP_12G_SAS_4U_75 = 39     #12G 4U SAS 75盘 3.5寸级联框
        CTRL_NVME_2U_25 = 99       #2U NVMe 25盘 2.5寸主控框
        SSD_2U_25 = 98             #2U SSD 25盘级联框
        CTRL_12GSAS_2U25_EAR_12GLINK = 40 #2U 12G SAS 25盘主控框


    class PortEnum():
        FC_PORT = 212      #FC端口
        ETH_PORT = 213     #以太网口
        SAS_PORT = 214     #SAS端口
        FCoE_PORT = 252    #FCoE端口
        IB_PORT = 16500    #IB端口

    class NetModeEnum():
        UNKNOWN = 0        #无效值
        DIRECT = 1         #直连组网
        SWITCH = 2         #交换机组网
        DIRECT2SWITCH = 3  #直连组网转交换机组网

    class BmcChangeModeEnum():
        CHANGE = 0
        DELETE = 1
        SET = 2
        SYNC = 3

    class SystemRoleEnum():
        SYSTEM_ROLE_NORMAL = 0   #普通成员
        SYSTEM_ROLE_MASTER = 1   #集群主
        SYSTEM_ROLE_SLAVE = 2    #集群备

    class SwitchEnum():
        ON = 1  #开/On
        OFF = 2 #关/Off

    class IntfRunModelEnum():
        IOC_RUN_MODE_FC = 1         #FC
        IOC_RUN_MODE_FCOE_ISCSI = 2 #FCoE/iSCSI
        IOC_RUN_MODE_IWARP = 3      #Cluster


    class IntfModelEnum():
        '''
        Description: Type 条件类型，供生成TLV命令记录条件用（命名类似于Shell比较运算符）
        '''
        FC_4X4G = 1        #4x4G FC接口模块/4x4G FC Interface Module
        FC_2X4G = 2        #2x4G FC接口模块/2x4G FC Interface Module
        GE_RJ45_2X = 3     #2xGE 电接口模块/2xGE Electrical Interface Module
        SASI_4X = 4        #4xSAS I 接口模块/4xSAS I Interface Module
        FC_4X4G_EXPAND = 5 #Swapped FC接口模块/Swapped FC Interface Module
        ETH10G_2 = 6       #2x10GE 光接口模块/2x10GE Optical Interface Module
        FC_1X8G = 7        #1x8G FC光接口模块/1x8G FC Optical Interface Module
        FC_2X8G = 8        #2x8G FC光接口模块/2x8G FC Optical Interface Module
        SASII_2X = 9       #2xSAS II电接口模块/2xSAS II Electrical Interface Module
        SASII_4X = 10      #4xSAS II电接口模块/4xSAS II Electrical Interface Module
        Combo_2FCx2GE = 11 #2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
        iSCSI_4X = 12      #4xGE 电接口模块/4xGE Electrical Interface Module
        FC_4X8G = 13       #4x8G FC光接口模块/4x8G FC Optical Interface Module
        MINISAS_4X = 16    #4xmini-SAS接口模块/4x mini-SAS Interface Module
        FCoE_4X = 21       #4x10G FCoE光接口模块/4x10G Optical Interface Module
        SASA_2X6G = 22     #2x6G SASA接口模块/2x6G SASA Interface Module
        SASB_2X6G = 23     #2x6G SASB接口模块/2x6G SASB Interface Module
        ManagerBoard = 24  #管理板/Management Board
        TOE = 25           #4x10GE接口模块/4x10GE Interface Module
        PCIe_2X5G = 26     #2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
        FCoE_2X = 27       #2x10G FCoE光接口模块/2x10G Optical Interface Module
        iSCSI_4XGE = 28    #4xGE Optical Interface Module/4xGE光接口模块
        FC_2X16G = 29      #2x16G FC Optical Interface Module/2x16G FC光接口模块
        SAS_4X12G = 30     #4x12SAS QSFP Interface Module/4x12G SAS光电接口模块
        iSCSI_4X10 = 31    #4x10GE Electrical Interface Module/4x10GE 电接口模块
        IB_2x40G = 32      #2x40GE Infiniband Interface Module/2x40GE IB接口模块
        IB_2x56G = 33      #2x56GE Infiniband Interface Module/2x56GE IB接口模块
        GE_RJ45_4X = 34    #4xGE Electrical Interface Module/4xGE 电接口模块
        AccerationEngineCard = 35 #Express Module(ACC Acceration engine)/重删压缩加速卡
        IOC_4X10G_RJ45 = 36#4x10GE Electrical Interface Module/4x10GE 电接口模块
        IOC_4XSMART = 37   #4xSMART Optical Interface Module/4xSmart 光接口模块
        IOC_8X8G_FC = 38   #8x8G FC Optical Interface Module/8x8G FC光接口模块
        IOC_4X8G_FC = 39   #4x8G FC Optical Interface Module/4x8G FC光接口卡
        IOC_4X16G_FC = 40  #4x16G FC Optical Interface Module/4x16G FC光接口卡
        SAS_12PORT_BACKEND_MODULE = 41 #12 port 4*12Gb SAS Back-End Interconnect I/O Module/12端口4*12Gb SAS后端全互联IO模块
        PCIe_2PORT = 44    #PCIe接口模块/2 port PCIe Interface Module
        IOC_8X16G_FC = 58  #8x16G FC Optical Interface Module/8x16G FC光接口卡

    class ConditionTypeEnum():
        '''
        Description: Type 条件类型，供生成TLV命令记录条件用（命名类似于Shell比较运算符）
        '''
        LIKE = "LIKE"      #相似(采用正则表达式匹配)：支持字符串和数字,数字将自动被转换为字符串进行判断
        NLIKE = "NLIKE"    #不相似(采用正则表达式匹配)：支持字符串和数字,数字将自动被转换为字符串进行判断
        EQ = "EQ"          #等于: EQual：支持字符串和数字
        NE = "NE"          #不等于: Not Equal：支持字符串和数字
        GT = "GT"          #大于：Greater Than：仅支持数字
        GE = "GE"          #大于等于: Greater or Equal：仅支持数字
        LT = "LT"          #小于：Little Than：仅支持数字
        LE = "LE"          #大于：Little or Equal：仅支持数字
        EQOR = "EQOR"      #等于[或等于](满足多个EQ条件中任一即可): EQual OR：支持字符串和数字
        NEAND = "NEAND"    #不等于[并且不等于](同时不满足多个NE条件): Not Equal AND：支持字符串和数字
        LIKEOR = "LIKEOR"  #与*相似[或与##相似](满足多个LIKE条件中任一即可): LIKE OR：支持字符串和数字,数字将自动被转换为字符串进行判断

    class QueryType():
        '''
        Type: 查询条件类型，供生成查询条件字符串时使用
        '''
        LIKE = "LIKE"    #相似
        EQUAL = "EQUAL"  #等于
        NOT = "NOT"      #不等于
        RANGE = "RANGE"  #位于左闭右开的区间，传入的参数为列表

    class SortType():
        '''
        Type: 排序条件类型，供生成查询条件字符串时使用
        '''
        ASC = "ASC"   #升序
        DESC = "DESC" #降序

    class EnclosureTypeEnum():
        '''
        ENCLOSURE_TYPE_E
        '''
        EXP = 0            #级联框（硬盘框）
        CTRL = 1           #控制框
        DSW = 2            #数据交换机
        MSW = 3            #管理交换机
        SVP = 4            #管理服务器
        
    class UpgradePkgTypeEnum():
        UPGRADE_PKGTYPE_TYPE_SYS = 1           #系统软件包
        UPGRADE_PKGTYPE_TYPE_COLD_PATCH = 2    #冷补丁
        UPGRADE_PKGTYPE_TYPE_HOT_PATCH = 3     #热补丁

    class HealthStatusEnum():
        '''
        Description: 健康状况
        '''
        UNKNOWN = 0            #未知
        NORMAL = 1             #正常
        FAULT = 2              #故障
        PRE_FAIL = 3           #即将故障
        PART_BROKEN = 4        #部分损坏
        DEGRADE = 5            #降级
        HAS_BAD_BLOCK = 6      #有坏块
        HAS_ERR_CODE = 7       #有误码
        CONSISTENT = 8         #一致
        INCONSISTENT = 9       #不一致
        BUSY = 10              #繁忙
        POWER_NO_INPUT = 11    #无输入
        POWER_NOT_ENOUGH = 12  #电量不足
        SINGLE_LINK_FAULT = 13 #单链路故障
        INVALID = 14           #失效
        WRITE_PROTECT = 15     #写保护

    class RunningStatusEnum():
        '''
        Description: 运行状况
        '''
        UNKNOWN = 0 #未知
        NORMAL = 1 #正常
        RUNNING = 2 #运行
        NOT_RUNNING = 3 #未运行
        NOT_EXIST = 4 #不存在
        HIGH_TEMPERATURE_SLEEP = 5 #高温休眠
        STARTING = 6 #正在启动
        POWER_FAILURE_PROTECTING = 7 #掉电保护
        SLEEPING = 8 #休眠 
        SPINGUP = 9 #已启动
        LINK_UP = 10 #已连接
        LINK_DOWN = 11 #未连接
        POWER_ON = 12 #正在上电
        POWER_OFF = 13 #已下电
        PRE_COPY = 14 #预拷贝
        COPYBACK = 15 #回拷
        RECONSTRUCTION = 16 #重构
        EXPANSION = 17 #扩容
        NOT_FORMAT = 18 #未格式化
        FORMATTING = 19 #正在格式化
        UNMAPPING = 20 #未映射
        INITIAL_SYNCHRONIZING = 21 #正在初始同步
        CONSISTENT = 22 #数据一致
        SYNCHRONIZING = 23 #正在同步
        SYNCHRONIZED = 24 #已同步
        NOT_SYNCHRONIZED = 25 #未同步
        SPLIT = 26 #已分裂
        ONLINE = 27 #在线
        OFFLINE = 28 #离线
        LOCKED = 29 #已锁定
        ENABLE = 30 #已启用
        DISABLED = 31 #已禁用
        LEVELING = 32 #正在均衡
        TO_BE_RECOVERD = 33 #待恢复
        INTERRUPTED = 34 #异常断开
        INVALID = 35 #失效
        NOSTART = 36 #新创建
        QUEUING = 37 #正在排队
        STOP = 38 #已停止
        COPYING = 39 #正在拷贝
        COMPLETED = 40 #拷贝完成/完成
        PAUSE = 41 #暂停
        REVSYNCHRONIZING = 42 #正在反向同步
        ACTIVATED = 43 #已激活
        ROLLBACK = 44 #正在回滚
        INACTIVATED = 45 #未激活
        IDLE = 46 #等待
        POWERING_OFF = 47 #正在下电
        CHARGING = 48 #正在充电
        CHARGED = 49 #充电完成
        DISCHARGING = 50 #正在放电
        UPGRADING = 51 #正在升级
        POWER_LOST = 52 #掉电中
        INITIALIZING = 53 #初始化中
        APPLY_CONFIG_CHANGE = 54 #正在应用变更
        ONLINE_DISABLE = 55 #在线禁用
        OFFLINE_DISABLE = 56 #离线禁用
        ONLINE_FROZEN = 57 #在线冻结
        OFFLINE_FROZEN = 58 #离线冻结
        CLOSED = 59 #已关闭
        REMOVING = 60 #(节点)删除中
        INSERVICE = 61 #服务中
        OUTOFSERVICE = 62 #退出服务
        ERASEMENT_RUNNING_NORMAL = 63 #正在销毁
        ERASEMENT_RUNNING_FAIL = 64 #销毁失败
        ERASEMENT_RUNNING_SUCCESS = 65 #销毁成功
        SUCCESS = 66 #任务执行成功
        FAILED = 67 #任务执行失败
        WAITING = 68 #任务正在等待
        CANCELLING = 69 #任务正在取消
        CANCELLED = 70 #任务已取消
        RUNNING_PREPARE_SYNC = 71 #在线|即将灾备同步
        RUNNING_SYNCHRONINING = 72 #在线|正在灾备同步
        RUNNING_SYNC_FAILED = 73 #在线|灾备同步失败
        MIGRATION_FAULT = 74 #迁移故障
        MiGRATING = 75 #迁移中
        MIGRATION_COMPLETED = 76 #迁移完成
        ACTIVATING = 77 #正在激活
        DEACTIVATING = 78 #正在取消激活
        START_FAILED = 79 #启动失败
        STOP_FAILED = 80 #停止失败
        DECOMMISSIONING = 81 #正在退出服务
        DECOMMISSIONED = 82 #已经退出服务
        RECOMMISSIONING = 83 #重新进入服务
        REPLACING_NODE = 84 #正在替换节点
        SCHEDULING = 85 #正在调度
        PAUSING = 86 #暂停中
        SUSPENDING = 87 #挂起中
        SUSPENDED = 88 #挂起
        OVERLOAD = 89 #超载
        TO_BE_SWITCH = 90 #等待切换
        SWITCHING = 91 #切换中
        TO_BE_CLEANUP = 92 #等待清理
        FORCED_START = 93 #运行状态：强制启动
        ERROR = 94 #运行状态：故障
        JOB_COMPLETED = 95 #任务结束
        PARTITION_MIGRATING = 96 #分区迁移中
        Mount = 97 #已挂载
        Umount = 98 #未挂载
        INSTALLING = 99 #正在安装中
        TO_BE_SYNCHRONIZED = 100 #待同步
        CONNECTING = 101 #正在连接
        SERVICE_SWITCHING = 102 #服务正在切换中
        POWER_ON_ERROR = 103 #上电失败
        REPAIRING = 104 #修复中

    class ObjEnum():
        '''
        Description: 对象参数枚举
        '''
        ARRAY = 2 #阵列/阵列
        BACK_CONTROLLER = 5 #后端控制器/后端控制器
        BACK_PORT = 7 #后端端口/后端端口
        BACKUP_POLICY = 57352 #备份策略/backuppolicy
        BACKUP_POWER = 210 #备电模块/BackupPower
        BACKUP_SERVER = 57345 #备份服务器/backupserver
        BACKUP_SET = 57355 #备份集/BackupSet
        BAY = 205 #柜/Bay
        BOND_PORT = 235 #绑定端口/bondport
        CachePartition = 268 #Cache分区/CachePartition
        CAN = 57348 #计算节点代理（CNA）/CAN
        CIFS_Server = 36 #CIFS服务器/CIFSServer
        CIFS_Share = 35 #CIFS共享/CIFSShare
        CIFSSERVICE = 16453 #CIFS服务/CIFSSERVICE
        CLI_COMMON = 20480 #专用于CLI公共部分 CLI新增的特殊命令字可以挂接在此对象下 仅供CLI使用/CLI_COMMON
        CloneGroup = 254 #克隆组/CloneGroup
        CloudBackup = 44 #云备份/CloudBackup
        CLUSTER = 57347 #集群/cluster
        COM_HYPER_CLONE_CG = 32 #分裂镜像一致性组/分裂镜像一致性组
        CommConfigure = 16444 #通用配置（目前VMware使用）/CommConfigure
        CommonData = 200 #通用数据存储/CommonData
        CONSISTENTGROUP = 221 #一致性组/ConsistentGroup
        CONTROLLER = 207 #控制器/Controller
        CPU_CORE = 24 #CPU核心/CPU核心
        CPU = 16 #CPU/CPU
        DATA_RECOVER_SCHEDULE = 16405 #数据恢复计划/Datarecoveryschedule
        DATASTORE = 57349 #数据存储/datastore
        DISK_SCAN_TASK = 274 #Disk扫描任务/DISK_SCAN_TASK
        DISK = 10 #硬盘/Disk
        DiskDestroyData = 271 #Disk数据消毁/DiskDestroyData
        DISKGROUP = 20 #磁盘组/磁盘组
        DiskPool = 266 #硬盘域/DiskPool
        DNS_Server = 260 #DNS服务器/DNS_Server
        DOMAIN = 203 #域/Domain
        DOMAINMEMBER = 204 #域成员/DomainMember
        ENCLOSURE = 206 #框/Enclosure
        ETH_PORT = 213 #以太网口/EthernetPort
        EXPBOARD = 208 #级联板/ExpandBoard
        FAN_CTRL_MODULE = 306 #风扇控制器模块/FAN_CTRL_MODULE
        FAN_ENCLOSURE = 26 #风扇框/风扇框
        FAN = 211 #风扇模块/Fan
        FC_INITIATOR = 223 #FC启动器/FCInitiator
        FC_LINK = 225 #FC远端链路/FCLink
        FC_PORT = 212 #FC端口/FCPort
        FCoE_PORT = 252 #FCoE端口/FCoE_PORT
        FileSystem = 40 #文件系统/FileSystem
        FileSystemTier = 45 #文件系统分层/FileSystemTier
        FRONT_CONTROLLER = 3 #前端控制器/前端控制器
        FRONT_PORT = 6 #前端端口/前端端口
        FSSNAPSHOT = 29 #文件系统快照/FSSNAPSHOT
        FTP = 37 #FTP/FTP
        FTPOnlineLink = 16449 #FTP的在线连接/FTPOnlineLink
        FTPSERVICE = 16451 #FTP服务/FTPSERVICE
        Homedir = 16457 #用户主目录/Homedir
        HOST_LINK = 255 #主机链路/HostLink
        HOST = 21 #主机/Host
        HOSTGROUP = 14 #主机组/HostGroup
        HTTP = 38 #HTTP/HTTP
        HTTPOnlineLink = 16448 #HTTP的在线连接/HTTPOnlineLink
        HTTPSERVICE = 16450 #HTTP服务/HTTPSERVICE
        IB_INITIATOR = 16499 #IB_INITIATOR/IB启动器（主机端口）
        IB_PORT = 16500 #IB端口/IBPort
        INTF_MODULE = 209 #接口模块/InterfaceModule
        IOCLASS = 230 #IO分类/IOClass
        IOCLASSTemplate = 269 #IO分类模板/IOCLASSTemplate
        IP_LINK = 261 #IP链路/IPLINK
        IPRule = 236 #安全规则/IPRule
        IPZone = 16441 #/IPZone
        ISCSI_INITIATOR = 222 #iSCSI启动器/iSCSIInitiator
        iSCSI_LINK = 243 #iSCSI远端链路/iSCSI_LINK
        iSCSI_SESSION_SETTING = 247 #iSCSI会话初始参数信息（即连接会话时的协商参数）/iSCSISessionSettings
        ISCSI_SESSION = 229 #iSCSI会话/iSCSISession
        iSCSI_TGT_NODE = 248 #iSCSI目标器节点/iSCSITargetNode
        iSCSI_TGT_PORT = 249 #iSCSI目标器端口/iSCSITargetPort
        ISM = 49152
        LDAP_USER_MAP = 239 #ldap用户映射/LDAP_USER_MAP
        LDAPConfig = 238 #ldap配置/LDAPconfiguraion
        License = 244 #License/License
        LOCAL_RESGROUP = 16447 #本地资源用户组（统一存储使用）/LOCAL_RESGROUP
        LOCAL_RESUSER = 16446 #本地资源用户（统一存储使用）/LOCAL_RESUSER
        LUN_Migration_Task = 253 #LUN迁移任务/LUNMigrationTask
        LUN = 11 #LUN/LUN
        LUNBackgroudTask = 265 #LUN后台任务/LUNBackgroudTask
        LUNCOPY = 219 #LUN拷贝/LUNCopy
        LUNCOPYMEMBERLUN = 227 #LUN拷贝成员LUN/LUNCopyMemberLUN
        LUNDestroyData = 270 #LUN数据消毁/LUNDestroyData
        LUNGroup = 256 #LUN组/LUNGroup
        LUNPriorityStatistic = 272 #LUN优先级统计/LUNPriorityStatistic
        MAPPINGVIEW = 245 #映射视图/MappingView
        MEMORY = 237 #内存/MEMROY
        Memory = 32770 #内存信息/Memory
        MONITOR_BOARD = 251 #监控板/MonitorBoard
        NetGroup = 259 #网络组/NetGroup
        NFS_Server = 34 #NFS服务器/NFSServer
        NFS_Share = 33 #NFS共享/NFSShare
        NFSClient = 46 #NFS客户端/NFSClient
        NFSSERVICE = 16452 #NFS服务/NFSSERVICE
        NODE = 25 #节点/节点
        NOFS = 53248 #NOFS/NOFS
        PCIE_DATA_SWITCH = 232 #PCIE数据交换机/PCIEDataSwitch
        PCIE_PORT = 233 #PCIE端口/PCIEDataSwitchPort
        Pool = 41 #文件存储池/Pool
        PortGroup = 257 #Port组/PortGroup
        POWER = 23 #电源模块/Power
        PROTOCOL_CLUSTER_NODE = 16387 #SNAS协议集群节点/Protocolclusternode
        PROTOCOL_CLUSTER_ZONE = 16388 #SNAS协议集群分区/Protocolclusterzone
        PROTOCOL_CLUSTER = 16386 #SNAS协议集群/Protocolcluster
        Quota = 16458 #配额/Quota
        QUOTATREE = 16445 #/QUOTATREE
        Raid_Card = 32769 #Raid卡/Raid_Card
        RAID = 15 #RAID/RAID
        RaidCard_LogicDisk = 32774 #/RaidCard_LogicDisk
        RaidCard_LUN = 32773 #/RaidCard_LUN
        RaidCard_Raid = 32772 #/RaidCard_Raid
        REMOTE_DEVICE = 224 #远端设备/RemoteDevice
        REMOTE_LINK = 13 #远程连接链路/远程连接链路
        REMOTE_LUN = 250 #远端lun/RemoteLUN
        REMOTE_LUNCOPY = 29 #远程LUN拷贝/远程LUN拷贝
        REMOTE_MIRRORGROUP = 12 #远程镜像组/远程镜像组
        REMOTEREPLICATION = 28 #远程复制/RemoteReplication
        REMOTEREPLICATIONMEMBERLUN = 226 #远程复制成员LUN/RemoteReplicationMemberLUN
        REPLICATION_BANDWIDTH = 17 #复制带宽/复制带宽
        Replication = 39 #远程复制/Replication
        REPLICATIONPAIR = 263 #远程复制pair/REPLICATIONPAIR
        RESTORE_POLICY = 57354 #恢复策略/RestorePolicy
        SAS_Card = 32768 #SAS卡/SAS_Card
        SAS_PORT = 214 #SAS端口/SASPort
        SCHEDULE = 246 #时刻表/Schedule
        SCOPE = 9 #范围/范围
        SERIAL_PORT = 215 #串口/SerialPort
        Server_FileSystem = 32771 #服务器文件系统/Server_FileSystem
        SFP_OPTICAL_TRANSCEIVER = 234 #光模块/SFPopticaltransceiver
        Slow_disk_policy = 264 #慢盘检测/Slowdiskpolicy
        SMARTCACHE = 218 #SmartCache/SmartCache
        SmartCachePartition = 273 #SmartCache分区/SmartCachePartition
        SmartData_LogicDisk = 32777 #/SmartData_LogicDisk
        SmartData_LUN = 32776 #/SmartData_LUN
        SmartData_Raid = 32775 #/SmartData_Raid
        SNAPSHOT_CONSISTENTGROUP = 18 #快照一致性组/快照一致性组
        SNAPSHOT = 27 #快照/Snapshot
        SNAS_ACL_STRATEGY = 16410 #协议ACL策略/ACL
        SNAS_AD_CONFIG = 16414 #AD域认证源/ADdomain
        SNAS_AD_SOURCE = 16425 #SNASAD域/snasADdomain
        SNAS_ALARM_DEFINITION = 16435 #告警定义配置/snas_alarm_level
        SNAS_ALARM_THRESHOLD = 16424 #SNAS告警阈值/snasalarmthreshold
        SNAS_ALARM_VOICE = 16417 #SNAS告警声音设置/alarmvoidsetting
        SNAS_CAPACITY_STATISTIC = 16459 #集群对象容量数据采集/snascapacitycollection
        SNAS_CIFS_SERVICE = 16399 #SNASCIFS服务/CIFSserviceconfiguration
        SNAS_CIFS_SHARE_AUTH_CLIENT = 16404 #SNASCIFS用户共享/CIFSclientpermissionoffile
        SNAS_CIFS_SHARE = 16402 #SNASCIFS共享/CIFSshareoffile
        SNAS_CLIENT = 16390 #SNAS系统客户端/NASclient
        SNAS_CMD_OPINFO = 16436 #命令操作提示信息接口/snas_cmd_opinfo
        SNAS_DEVICE_SMSMODEM = 16434 #/snassmsmodem
        SNAS_DISCOVERY_SNMP = 16440 #/snassnmpdiscoveryconfig
        SNAS_DNS_CONFIG = 16391 #SNASDNS配置/DNSconfiguration
        SNAS_ENCRYPT_KEY = 16433 #AES对称加密密钥128位/snasencryptekey
        SNAS_EXTERNAL_DNS = 16437 #/snasdnsservice
        SNAS_FILE_ATIME = 16432 #/snasfileaccesstime
        SNAS_FILE_LEVEL_POLICY_ITEM = 16428 #/snasfilelevelpolicyitem
        SNAS_FILE_LEVEL_POLICY = 16427 #/snasfilelevelpolicy
        SNAS_FILE_QUOTA = 16408 #SNAS文件配额/SNASfilequota
        SNAS_FILE = 16400 #SNAS文件/SNASfileobject
        SNAS_FTP_SHARE_AUTH_CLIENT = 16454 #FTP共享权限/SNAS_FTP_SHARE_AUTH_CLIENT
        SNAS_HANDSHAKE = 16420 #握手接口/connectionhandshake
        SNAS_HEARTBEAT = 16419 #心跳/connectionheartbeat
        SNAS_HTTP_SHARE_AUTH_CLIENT = 16455 #HTTP共享权限/SNAS_HTTP_SHARE_AUTH_CLIENT
        SNAS_HTTP_SHARE = 16456 #HTTP共享/SNAS_HTTP_SHARE
        SNAS_IDMAP_CONFIG = 16395 #SNASIDMAPPING/IDMAPPING
        SNAS_IP_POOL = 16389 #动态IP池/Publicippool
        SNAS_IP_SWITCH_PORT = 16439 #/snasipswitchport
        SNAS_IP_SWITCH = 16438 #/snasipswitch
        SNAS_KEY_VALUE_STORE = 16407 #SNASKV存储接口/key-valuestore
        SNAS_LDAP_CONFIG = 16413 #LDAP认证源/LDAPconfiguration
        SNAS_LDAP_SOURCE = 16431 #/snasldapauthsource
        SNAS_LOCAL_AUTH = 16411 #本地认证源/Localauthorityconfiguration
        SNAS_LOCAL_GROUP = 16393 #本地用户组/localgroup
        SNAS_LOCAL_USER = 16392 #本地用户/localuser
        SNAS_MGR_NODE = 16421 #管理节点/checksnasmainmrgnode
        SNAS_NFS_SHARE_AUTH_CLIENT = 16409 #SNASNFS客户端共享/NFSclientpermissionoffile
        SNAS_NFS_SHARE = 16401 #SNASNFS共享/NFSshareoffile
        SNAS_NIS_CONFIG = 16412 #NIS认证源/NISconfiguration
        SNAS_NIS_SOURCE = 16430 #/snasnisauthsource
        SNAS_NODE_FS_SERV = 16397 #SNAS节点文件系统服务/FSservicerunningonnode
        SNAS_NODE_PERFORMANCE = 16422 #集群节点性能接口/snasnodeperformance
        SNAS_NODE_SHARE_SERV = 16398 #SNAS节点协议共享服务/NASservicerunningonnode
        SNAS_NODE = 16385 #SNAS集群系统节点/ScaleoutNASNODE
        SNAS_ROOT_USER = 16396 #SNAS节点root用户/Rootuserpasswordsetting
        SNAS_SECURITY_POLICY = 16418 #SNAS系统安全策略/adminusersecuritypolicies
        SNAS_SECURITY_SMTP = 16423 #SNASSMTP配置/snassuperuserpwdreset
        SNAS_SYS_ENERGY_SAVING = 16416 #SNAS系统节能开关/energysaving
        SNAS_SYS_IO_TEMP = 16429 #/snasfileiostatistic
        SNAS_SYS_TIER = 16426 #SNAS分级存储/snasstorageTier
        SNAS_SYS_WATERLEVEL = 16415 #SNAS性能节点数据迁移水位/SNASnodewaterlevel
        SNAS_SYSTEM = 16384 #ScaleoutNAS系统/SNAS_SYSTEM
        SNAS_TASK = 16406 #SNAS任务/backtask
        SNAS_USER_QUOTA = 16403 #SNAS用户配额/SNASuserquota
        SNAS_USERANDGROUP = 16394 #用户组和用户关系/user&grouprelationship
        SNMP_COMMUNITY = 241 #SNMP团体字/SNMP_COMMUNITY
        SNMP_TRAP_ADDR = 240 #SNMPTrap地址/SNMP_TRAP_ADDR
        SNMP_USM = 242 #基于用户的安全模型/SNMP_USM
        SPLITMIRROR = 220 #分裂镜像/SplitMirror
        SPLITMIRRORTARGETLUN = 228 #分裂镜像从LUN/SplitMirrorTargetLUN
        STORAGE_UNIT = 57353 #存储单元/StorageUnit
        StorageEngine = 267 #存储引擎/StorageEngine
        STORAGEPOOL = 216 #存储池/StoragePool
        STORAGETIER = 217 #存储层/StorageTier
        Subnet = 258 #子网段/Subnet
        SYSTEM = 201 #系统/System
        SystemLicense = 199 #SystemLicense/SystemLicense
        TASK = 57344 #任务/task
        THINPOOL = 30 #Thinpool(精简池)/Thinpool(精简池)
        UNIFY_CONTROLLER = 4 #前后端合一控制器/前后端合一控制器
        UPS = 231 #UPS/UPS
        USER_SECURITY_POLICY = 47 #用户安全策略/USER_SECURITY_POLICY
        USER = 202 #用户/User
        User = 42 #用户/User
        UserGroup = 262 #用户组/UserGroup
        VDI_DISK = 57351 #VDI虚拟磁盘/virtualdisk
        VIRTUAL_MACHINE = 402 #虚拟机
        VMPort = 410 #虚拟机端口
        VOLUME_CONSISTENTGROUP = 19 #一致性卷组/一致性卷组
        VOLUME = 8 #卷/卷
        VRM = 57346 #虚拟资源管理节点（VRM）/VRM
        vStore = 16442 #虚拟存储（多租户）/vStore
        Wi_Fi = 43 #Wi-Fi/Wi-Fi
        WormUser = 16443 #WORM管理员/WormUser

    '''EXPBOARD_TYPE_E'''
    class ExpboardTypeEnum():#
        SAS = 0 #SAS
        FC = 1  #FC

    '''PORT_LOGIC_TYPE_E'''
    class PortLogicTypeEnum():
        HOST = 0             #主机端口/业务端口
        EXP = 1              #级联端口
        MNGT = 2             #管理端口
        INNER = 3            #内部端口
        MAINTENANCE = 4      #维护端口
        MNGT_SRV = 5         #管理/业务混合口
        MAINTENANCE_SRV = 6  #维护/业务混合口
        BACKUP_MGR = 7       #备份管理网口
        PRODUCT_STORAGE = 8  #生产存储网口
        BACKUP_STORAGE = 9   #备份存储网口
        ETH_NOT_CONFIG = 10  #未配置角色网口
        IP_SCALE_OUT = 11    #IP Scale Out接口卡网口

    '''DISK_LOGIC_TYPE_E'''
    class DiskLogicTypeEnum():
        FREE = 1             #空闲盘
        MEMBER = 2           #成员盘
        SPARE = 3            #热备盘
        CACHE = 4            #缓存盘

    '''DISK_LIGHT_STATUS_E'''
    class DiskLightStatusEnum():
        OFF = 0#
        ON = 1#

    '''PRODUCT_MODE_E'''
    class ProductModeEnum():
        V1500 = 0    #V1500/V1500
        V1800 = 1    #V1800/V1800
        S2100 = 2    #S2100/S2100
        S2300 = 3    #S2300/S2300
        S5100 = 4    #S5100/S5100
        S5300 = 5    #S5300/S5300
        S5500 = 6    #S5500/S5500
        S5600 = 7    #S5600/S5600
        VIS = 8    #VIS/VIS
        S2600 = 9    #S2600/S2600
        S6800E = 10    #S6800E/S6800E
        V1500N = 11    #V1500N/V1500N
        S2300E = 12    #S2300E/S2300E
        COMMON = 13    #COMMON(插框混用)/COMMON
        N8000 = 15    #N8000/N8000
        S6900 = 16    #S6900/S6900
        S3900 = 17    #S3900/S3900
        S5500T = 18    #S5500T/S5500T
        S5600T = 19    #S5600T/S5600T
        S6800T = 20    #S6800T/S6800T
        S6900_M100 = 21    #S6900-M100/S6900-M100
        S3900_M200 = 22    #S3900-M200/S3900-M200
        S3900_M300 = 23    #S3900-M300/S3900-M300
        S5900_M100 = 24    #S5900-M100/S5900-M100
        S8100 = 25    #S8100/S8100
        S5800T = 26    #S5800T/S5800T
        V1600N = 27    #V1600N/V1600N
        S5900_M200 = 28    #S5900-M200/S5900-M200
        N8001 = 29    #N8001/N8001
        S2600T = 30    #S2600T/S2600T
        S8000_I = 31    #S8000-I/S8000-I
        Dorado5100 = 32    #Dorado5100/Dorado5100
        T3200 = 33    #T3200/T3200
        T3500 = 34    #T3500/T3500
        N8000_R710 = 35    #N8000-R710/N8000-R710
        N8000_C2 = 36    #N8000-C2/N8000-C2
        N8000_C2_SYMC = 40    #N8000-C2-SYMC/N8000-C2-SYMC
        VTL = 41    #VTL/VTL
        S2900 = 42    #S2900/S2900
        S2200T = 43    #S2200T/S2200T
        Dorado2100_G2 = 44    #Dorado2100 G2/Dorado2100 G2
        VIS_6000 = 45    #VIS 6000/VIS 6000
        HVS85T = 46    #HVS85T/HVS85T
        HVS88T = 47    #HVS88T/HVS88T
        P9000 = 48    #9000/9000
        T3200_G2 = 49    #T3200 G2/T3200 G2
        T3500_G2 = 50    #T3500 G2/T3500 G2
        T3200_G3 = 51    #T3200 G3/T3200 G3
        T3500_G3 = 52    #T3500 G3/T3500 G3
        S5700 = 53    #S5700/S5700
        CE6800 = 54    #CE6800/CE6800
        CE12800 = 55    #CE12800/CE12800
        HVS_18800F = 56    #HVS的纯SSD盘版本/18800F
        HVS_18500 = 57    #HVS的18500型号/18500
        HVS_18800 = 58    #HVS的18800型号/18800
        SSS = 60    #SSS/SSS
        V3_6800 = 61    #中低端V3/6800V3-6U-2/4C
        V3_5600 = 63    #中低端V3/5600V3-3U2C
        V3_5800 = 64    #中低端V3/5800V3-3U2C
        T3200_MINI = 65    #T3200/T3200/9000 C01版本(建行项目新增)
        WUSHAN_SQL = 66    #WUSHAN_SQL/WUSHAN_SQL/9000 C10版本
        WUSHAN_HD = 67    #WUSHAN_HD/WUSHAN_HD/9000 C10版本
        V3_5500 = 68    #5500 V3/5500 V3/2U盘控一体 5500 V3
        V3_2600 = 69    #2600 V3/2600 V3/2U盘控一体 2600 V3
        V3_5300 = 70    #5300 V3/5300 V3/2U盘控一体 5300 V3
        V3_2800 = 71    #2800 V3/2800 V3/2U盘控一体 2800 V3
        V3_18500 = 72    #18500 V3/18500 V3/6U独立机头
        V3_18800 = 73    #18800 V3/18800 V3/6U独立机头
        V3_2200 = 78
        V3_5100 = 79
        V3_2600ForVideo = 82
        V3_2600F = 84
        V3_5500F = 85
        V3_5600F = 86
        V3_5800F = 87
        V3_6800F = 88
        V3_18500F = 89
        V3_18800F = 90
        N5000 = 401    #N5000/N5000
        VIS8200 = 800    #VIS8200/VIS8200
        VIS8400 = 801    #VIS8400/VIS8400
        VIS8600 = 802    #VIS8600/VIS8600
        VIS8800 = 803    #VIS8800/VIS8800
        Dorado5000_V3 = 805    #Dorado5000 V3
        Dorado6000_V3 = 806    #Dorado6000 V3
        V5_2800 = 92
        V5_5300 = 93
        V5_5300F = 94
        V5_5500 = 95
        V5_5500F = 96
        V5_5600 = 97
        V5_5600F = 98
        V5_5800 = 99
        V5_5800F = 100
        V5_6800 = 101
        V5_6800F = 102
        V5_18500 = 103
        V5_18500F = 104
        V5_18800 = 105
        V5_18800F = 106
        V5_5500_Elite = 107

    class UserLevelEnum():
        SUPER_ADMIN = 1
        ADMIN = 2
        READONLY = 3
        RESOURCE_ADMIN = 4
        DEVICE_ADMIN = 5
        
    class QueryFruUpdStatus():
        UPGRADING = 0
        SUCCESS = 1


class EnumStr():
    '''
    Description: 用于枚举值转换中英文 或者缩写字母
    '''

    '''
    Description: 将健康状况转换为文字
    '''
    StrHealthStatusEnum = {
        0:'--||未知', #key=UNKNOWN
        1:'Normal||正常', #key=NORMAL
        2:'Fault||故障', #key=FAULT
        3:'Pre-Fail||即将故障', #key=PRE_FAIL
        4:'partially broken||部分损坏', #key=PART_BROKEN
        5:'Degraded||降级', #key=DEGRADE
        6:'Bad sectors found||有坏块', #key=HAS_BAD_BLOCK
        7:'Bit errors found||有误码', #key=HAS_ERR_CODE
        8:'Consistent||一致', #key=CONSISTENT
        9:'Inconsistent||不一致', #key=INCONSISTENT
        10:'Busy||繁忙', #key=BUSY
        11:'No input||无输入', #key=POWER_NO_INPUT
        12:'Low battery||电量不足', #key=POWER_NOT_ENOUGH
        13:'Single link fault||单链路故障', #key=SINGLE_LINK_FAULT
        14:'Invalid||失效', #key=INVALID
        15:'Write_protect||写保护'     #key=WRITE_PROTECT
    }

    '''
    Description: 将运行状态转为文字
    '''
    StrRunningStatusEnum = {
        0:'--||未知', #key=UNKNOWN
        1:'Normal||正常', #key=NORMAL
        2:'Running||运行', #key=RUNNING
        3:'Not running||未运行', #key=NOT_RUNNING
        4:'Not existed||不存在', #key=NOT_EXIST
        5:'Sleep in high temperature||高温休眠', #key=HIGH_TEMPERATURE_SLEEP
        6:'Starting||正在启动', #key=STARTING
        7:'Power failure protection||掉电保护', #key=POWER_FAILURE_PROTECTING
        8:'Spin down||休眠', #key=SLEEPING
        9:'Started||已启动', #key=SPINGUP
        10:'Link Up||已连接', #key=LINK_UP
        11:'Link Down||未连接', #key=LINK_DOWN
        12:'Powering on||正在上电', #key=POWER_ON
        13:'Powered off||已下电', #key=POWER_OFF
        14:'Precopy||预拷贝', #key=PRE_COPY
        15:'Copyback||回拷', #key=COPYBACK
        16:'Reconstruction||重构', #key=RECONSTRUCTION
        17:'Expansion||扩容', #key=EXPANSION
        18:'Unformatted||未格式化', #key=NOT_FORMAT
        19:'Formatting||正在格式化', #key=FORMATTING
        20:'Unmapped||未映射', #key=UNMAPPING
        21:'Initial synchronizing||正在初始同步', #key=INITIAL_SYNCHRONIZING
        22:'Consistent||数据一致', #key=CONSISTENT
        23:'Synchronizing||正在同步', #key=SYNCHRONIZING
        24:'Synchronized||已同步', #key=SYNCHRONIZED
        25:'Unsynchronized||未同步', #key=NOT_SYNCHRONIZED
        26:'Splited||已分裂', #key=SPLIT
        27:'Online||在线', #key=ONLINE
        28:'Offline||离线', #key=OFFLINE
        29:'Locked||已锁定', #key=LOCKED
        30:'Enabled||已启用', #key=ENABLE
        31:'Disabled||已禁用', #key=DISABLED
        32:'balancing||正在均衡', #key=LEVELING
        33:'To be recovered||待恢复', #key=TO_BE_RECOVERD
        34:'Interrupted||异常断开', #key=INTERRUPTED
        35:'Invalid||失效', #key=INVALID
        36:'Not start||新创建', #key=NOSTART
        37:'Queuing||正在排队', #key=QUEUING
        38:'Stopped||已停止', #key=STOP
        39:'Copying||正在拷贝', #key=COPYING
        40:'Completed||拷贝完成', #key=COMPLETED
        41:'Paused||暂停', #key=PAUSE
        42:'Reverse synchronizing||正在反向同步', #key=REVSYNCHRONIZING
        43:'Activated||已激活', #key=ACTIVATED
        44:'Restore||正在回滚', #key=ROLLBACK
        45:'Inactive||未激活', #key=INACTIVATED
        46:'Idle||等待', #key=IDLE
        47:'Powering off||正在下电', #key=POWERING_OFF
        48:'Charging||正在充电', #key=CHARGING
        49:'Charging completed||充电完成', #key=CHARGED
        50:'Discharging||正在放电', #key=DISCHARGING
        51:'Upgrading||正在升级', #key=UPGRADING
        52:'Power Lost||掉电中', #key=POWER_LOST
        53:'Initializing||初始化中', #key=INITIALIZING
        54:'Apply Change||正在应用变更', #key=APPLY_CONFIG_CHANGE
        55:'online disable||在线禁用', #key=ONLINE_DISABLE
        56:'Offline disable||离线禁用', #key=OFFLINE_DISABLE
        57:'online frozen||在线冻结', #key=ONLINE_FROZEN
        58:'offline frozen||离线冻结', #key=OFFLINE_FROZEN
        59:'closed||已关闭', #key=CLOSED
        60:'removing||(节点)删除中', #key=REMOVING
        61:'in service||服务中', #key=INSERVICE
        62:'out of service||退出服务', #key=OUTOFSERVICE
        63:'Running normal||正在销毁', #key=ERASEMENT_RUNNING_NORMAL
        64:'Running fail||销毁失败', #key=ERASEMENT_RUNNING_FAIL
        65:'Running success||销毁成功', #key=ERASEMENT_RUNNING_SUCCESS
        66:'Running success||任务执行成功', #key=SUCCESS
        67:'Running failed||任务执行失败', #key=FAILED
        68:'Waiting||任务正在等待', #key=WAITING
        69:'Cancelling||任务正在取消', #key=CANCELLING
        70:'Cancelled||任务已取消', #key=CANCELLED
        71:'About to synchronize||在线|即将灾备同步', #key=RUNNING_PREPARE_SYNC
        72:'Synchronizing data||在线|正在灾备同步', #key=RUNNING_SYNCHRONINING
        73:'Failed to synchronize||在线|灾备同步失败', #key=RUNNING_SYNC_FAILED
        74:'MIGRATION_FAULT||迁移故障', #key=MIGRATION_FAULT
        75:'MiGRATING||迁移中', #key=MiGRATING
        76:'MIGRATION_COMPLETED||迁移完成', #key=MIGRATION_COMPLETED
        103:'POWER_ON_FAILED||上电失败'#key=POWER_ON_FAILED
    }

    '''
    INTF_MODEL_E
    '''
    StrIntfModelEnum = {
        1:'4x4G FC Interface Module||4x4G FC接口模块', #key=FC_4X4G
        2:'2x4G FC Interface Module||2x4G FC接口模块', #key=FC_2X4G
        3:'2xGE Electrical Interface Module||2xGE 电接口模块', #key=GE_RJ45_2X
        4:'4xSAS I Interface Module||4xSAS I 接口模块', #key=SASI_4X
        5:'Swapped FC Interface Module||Swapped FC接口模块', #key=FC_4X4G_EXPAND
        6:'2x10GE Optical Interface Module||2x10GE 光接口模块', #key=ETH10G_2
        7:'1x8G FC Optical Interface Module||1x8G FC光接口模块', #key=FC_1X8G
        8:'2x8G FC Optical Interface Module||2x8G FC光接口模块', #key=FC_2X8G
        9:'2xSAS II Electrical Interface Module||2xSAS II电接口模块', #key=SASII_2X
        10:'4xSAS II Electrical Interface Module||4xSAS II电接口模块', #key=SASII_4X
        11:'2xFC+2xGE Interface Module||2xFC+2xGE 接口模块', #key=Combo_2FCx2GE
        12:'4xGE Electrical Interface Module||4xGE 电接口模块', #key=iSCSI_4X
        13:'4x8G FC Optical Interface Module||4x8G FC光接口模块', #key=FC_4X8G
        16:'4x mini-SAS Interface Module||4xmini-SAS接口模块', #key=MINISAS_4X
        21:'4x10G Optical Interface Module||4x10G FCoE光接口模块', #key=FCoE_4X
        22:'2x6G SAS Interface Module||2x6G SAS接口模块', #key=SAS_2X6G
        23:'2x6G SAS Interface Module||2x6G SAS接口模块', #key=SAS_2X6G
        24:'Management Board||管理板', #key=ManagerBoard
        25:'4x10GE Interface Module||4x10GE接口模块', #key=TOE
        26:'2x5Gbps PCIe Interface Module||2x5Gbps PCIe接口模块', #key=PCIe_2X5G
        27:'2x10G Optical Interface Module||2x10G FCoE光接口模块', #key=FCoE_2X
        28:'4xGE Optical Interface Module||4xGE光接口模块', #key=iSCSI_4XGE
        29:'2x16G FC Optical Interface Module||2x16G FC光接口模块', #key=FC_2X16G
        30:'4x12SAS QSFP Interface Module||4x12G SAS光电接口模块 ', #key=SAS_4X12G
        31:'4x10GE Electrical Interface Module||4x10GE 电接口模块 ', #key=iSCSI_4X10
        32:'2x40GE Infiniband Interface Module||2x40GE IB接口模块',
        33:'2 port 4*14Gb IB I/O Module||2端口 4*14Gb IB I/O模块',
        34:'4xGE Electrical Interface Module||4xGE 电接口模块',
        35:'Smart ACC Module||智能加速模块',
        36:'4x10GE Electrical Interface Module||4x10GE 电接口模块',
        37:'4 port SmartIO I/O Module||4端口 SmartIO I/O模块', #key=IOC_4XSMART
        38:'8x8G FC Optical Interface Module||8x8G FC光接口模块',
        39:'4x8G FC Optical Interface Module||4x8G FC光接口卡',
        40:'4x16G FC Optical Interface Module||4x16G FC光接口卡',
        41:'12 port 4*12Gb SAS Back-End Interconnect I/O Module||12端口4*12Gb SAS后端全互联IO模块',
        44:'2 port PCIe Interface Module||2接口PCIe接口模块',
        58:'8x16G FC Optical Interface Module||8x16G FC光接口卡'
    }

    '''
    INTF_MODEL,用于画图
    '''
    StrIntfModel = {
        1:"FC_4X4G", #4x4G FC接口模块/4x4G FC Interface Module
        2:"FC_2X4G", #2x4G FC接口模块/2x4G FC Interface Module
        3:"GE_RJ45_2X", #2xGE 电接口模块/2xGE Electrical Interface Module
        4:"SASI_4X", #4xSAS I 接口模块/4xSAS I Interface Module
        5:"FC_4X4G_EXPAND", #Swapped FC接口模块/Swapped FC Interface Module
        6:"ETH10G_2", #2x10GE 光接口模块/2x10GE Optical Interface Module
        7:"FC_1X8G", #1x8G FC光接口模块/1x8G FC Optical Interface Module
        8:"FC_2X8G""FC_2X8G", #2x8G FC光接口模块/2x8G FC Optical Interface Module
        9:"SASII_2X", #2xSAS II电接口模块/2xSAS II Electrical Interface Module
        10:"SASII_4X", #4xSAS II电接口模块/4xSAS II Electrical Interface Module
        11:"Combo_2FCx2GE", #2xFC+2xGE 接口模块/2xFC+2xGE Interface Module
        12:"iSCSI_4X", #4xGE 电接口模块/4xGE Electrical Interface Module
        13:"FC_4X8G", #4x8G FC光接口模块/4x8G FC Optical Interface Module
        16:"MINISAS_4X", #4xmini-SAS接口模块/4x mini-SAS Interface Module
        21:"FCoE_4X", #4x10G FCoE光接口模块/4x10G Optical Interface Module
        22:"SASA_2X6G", #2x6G SASA接口模块/2x6G SASA Interface Module
        23:"SASB_2X6G", #2x6G SASB接口模块/2x6G SASB Interface Module
        24:"ManagerBoard", #管理板/Management Board
        25:"TOE", #4x10GE接口模块/4x10GE Interface Module
        26:"PCIe_2X5G", #2x5Gbps PCIe接口模块/2x5Gbps PCIe Interface Module
        27:"FCoE_2X", #2x10G FCoE光接口模块/2x10G Optical Interface Module
        28:"iSCSI_4XGE", #4xGE Optical Interface Module/4xGE光接口模块
        29:"FC_2X16G", #2x16G FC Optical Interface Module    2x16G FC光接口模块
        30:"SAS_4X12G", #4x12SAS QSFP Interface Module    4x12G SAS光电接口模块
        31:"iSCSI_4X10", #4x10GE Electrical Interface Module    4x10GE 电接口模块
        32:"IB_2x40G", #2x40GE Infiniband Interface Module    2x40GE IB接口模块
        33:"IB_2x56G", #2x56GE Infiniband Interface Module    2x56GE IB接口模块
        34:"GE_RJ45_4X", #4xGE Electrical Interface Module    4xGE 电接口模块
        35:"AccerationEngineCard", #Express Module（ACC，Acceration engine）    重删压缩加速卡
        36:"IOC_4X10G_RJ45", #4x10GE Electrical Interface Module    4x10GE 电接口模块
        37:"IOC_4XSMART", #4xSMART Optical Interface Module    4xSMART 光接口模块
        38:"IOC_8X8G_FC", #8x8G FC Optical Interface Module    8x8G FC光接口模块
        39:"IOC_4X8G_FC", #4x8G FC Optical Interface Module    4x8G FC光接口卡
        40:"IOC_4X16G_FC", #4x16G FC Optical Interface Module    4x16G FC光接口卡
        41:"SAS_12PORT_BACKEND_MODULE", #12 port 4*12Gb SAS Back-End Interconnect I/O Module     12端口4*12Gb SAS后端全互联IO模块
        44:"PCIe_2PORT", #2 port PCIe Interface Module||2接口PCIe接口模块
        58:"IOC_8X16G_FC" #8x16G FC Optical Interface Module||8x16G FC光接口卡
    }

    StrEnclosureModel = {
        0:"CTRL_BMC", #BMC控制框
        1:"CTRL_SAS2U_12", #2U SAS 12盘主控框
        2:"CTRL_SAS2U_24", #2U SAS 24盘主控框
        16:"EXPSAS2U_12", #2U SAS 12盘级联框
        17:"EXPSAS2U_24", #2U SAS 24盘级联框
        18:"EXPSAS4U", #4U SAS 24盘级联框
        19:"EXPFC", #4U FC 24盘级联框
        20:"DSW_PCIe1U", #1U PCIe数据交换机
        21:"EXPSAS4U_75", #4U SAS 75盘级联框
        22:"SVP", #SVP/SVP Controller Enclosure
        97:"CTRL_6U", #6U 4控独立机头
        96:"CTRL_3U", #3U 2控独立机头
        24:"EXPSAS2U_25", #2U SAS 25盘2.5寸磁盘框
        25:"EXPSAS4U_24_NEW", #4U SAS 24盘3.5寸磁盘框（新）
        26:"CTRL_12GSAS_2U25_EAR", #2U 12GSAS 25盘主控框
        23:"CTRL_12GSAS_2U12_EAR", #2U 12GSAS 12盘主控框
        39:"EXP_12G_SAS_4U_75",#EXP_12G_SAS_4U_75
        40:"CTRL_12GSAS_2U25_EAR_12GLINK",#2U 12G SAS 25盘主控框
    }
    StrExpboardType = {
        0:"SAS",
        1:"FC",
    }

    StrEnclosureType = {
        0:"EXP", #级联框（硬盘框）
        1:"CTRL", #控制框
        2:"DSW", #数据交换机
        3:"MSW", #管理交换机
        4:"SVP"#管理服务器
    }

    '''
    BACKUP_POWER_TYPE_E
    '''
    StrBackupPowerTypeEnum = {
        0:'BBU||BBU' #key=BBU
    }

    '''
    DISK_TYPE_E
    '''
    StrDiskTypeEnum = {
        0:'FC||FC', #key=FC
        1:'SAS||SAS', #key=SAS
        2:'SATA||SATA', #key=SATA
        3:'SSD||SSD', #key=SSD
        4:'NL_SAS||NL_SAS', #key=NL_SAS
        5:'SLC SSD||SLC SSD', #key=SLC_SSD
        6:'MLC SSD||MLC SSD', #key=MLC_SSD
        7:'FC_SED||FC_SED', #key=FC_SED
        8:'SAS_SED||SAS_SED', #key=SAS_SED
        9:'SATA_SED||SATA_SED', #key=SATA_SED
        10:'SSD_SED||SSD_SED', #key=SSD_SED
        11:'NL_SAS_SED||NL_SAS_SED', #key=NL_SAS_SED
        12:'SLC_SSD_SED||SLC_SSD_SED', #key=SLC_SSD_SED
        13:'MLC_SSD_SED||MLC_SSD_SED', #key=MLC_SSD_SED
        14:'NVMe SSD||NVMe SSD', #key=NVMe_SSD
        16:'NVME_SSD_SED||NVME_SSD_SED', #key=NVME_SSD_SED
    }

    '''
    OM_OBJ_E
    '''
    StrObjEnum = {
        2:'Array||阵列', #key=ARRAY
        3:'Front Controller||前端控制器', #key=FRONT_CONTROLLER
        4:'Unify Controller||前后端合一控制器', #key=UNIFY_CONTROLLER
        5:'Back Controller||后端控制器', #key=BACK_CONTROLLER
        6:'Front Port||前端端口', #key=FRONT_PORT
        7:'Back Port||后端端口', #key=BACK_PORT
        8:'Volume||卷', #key=VOLUME
        9:'Scope||范围', #key=SCOPE
        12:'Remote Mirror Group||远程镜像组', #key=REMOTE_MIRRORGROUP
        13:'Remote Link||远程连接链路', #key=REMOTE_LINK
        15:'RAID||RAID', #key=RAID
        17:'Replication Bandwidth||复制带宽', #key=REPLICATION_BANDWIDTH
        18:'Snapshot Consistent Group||快照一致性组', #key=SNAPSHOT_CONSISTENTGROUP
        19:'Volume Consistent Group||一致性卷组', #key=VOLUME_CONSISTENTGROUP
        20:'Disk Group||磁盘组', #key=DISKGROUP
        24:'CPU Core||CPU核心', #key=CPU_CORE
        25:'Node||节点', #key=NODE
        26:'Fan Enclosure||风扇框', #key=FAN_ENCLOSURE
        29:'Remote LUN Copy||远程LUN拷贝', #key=REMOTE_LUNCOPY
        30:'Thin Pool||Thin pool(精简池)', #key=THINPOOL
        32:'Hyper Clone Consistent Group||分裂镜像一致性组', #key=COM_HYPER_CLONE_CG
        33:'NFS Share||NFS共享', #key=NFS_Share
        34:'NFS Server||NFS服务器', #key=NFS_Server
        35:'CIFS Share||CIFS共享', #key=CIFS_Share
        36:'CIFS Server||CIFS服务器', #key=CIFS_Server
        37:'FTP||FTP', #key=FTP
        38:'HTTP||HTTP', #key=HTTP
        39:'Replication||远程复制', #key=Replication
        40:'FileSystem||文件系统', #key=FileSystem
        41:'Pool||文件存储池', #key=Pool
        42:'User||用户', #key=User
        43:'Wi-Fi||Wi-Fi', #key=Wi-Fi
        44:'Cloud Backup||云备份', #key=Cloud Backup
        45:'File System Tier||文件系统分层', #key=FileSystemTier
        46:'NFS Client||NFS客户端', #key=NFSClient
        47:'User Security Policy||用户安全策略', #key=USER_SECURITY_POLICY
        10:'Disk||硬盘', #key=DISK
        11:'LUN||LUN', #key=LUN
        14:'Host Group||主机组', #key=HOSTGROUP
        16:'CPU||CPU', #key=CPU
        21:'Host||主机', #key=HOST
        23:'Power||电源模块', #key=POWER
        27:'Snapshot||快照', #key=SNAPSHOT
        28:'Remote Replication||远程复制', #key=REMOTEREPLICATION
        29:'File System Snapshot||文件系统快照', #key=FSSNAPSHOT
        199:'SystemLicense||SystemLicense', #key=SystemLicense
        200:'CommonData||通用数据存储', #key=CommonData
        201:'System||系统', #key=SYSTEM
        202:'User||用户', #key=USER
        203:'Domain||域', #key=DOMAIN
        204:'Domain Member||域成员', #key=DOMAINMEMBER
        205:'Bay||柜', #key=BAY
        206:'Enclosure||框', #key=ENCLOSURE
        207:'Controller||控制器', #key=CONTROLLER
        208:'Expand Board||级联板', #key=EXPBOARD
        209:'Interface Module||接口模块', #key=INTF_MODULE
        210:'Backup Power||BBU模块', #key=BACKUP_POWER
        211:'Fan||风扇模块', #key=FAN
        212:'FC Port||FC端口', #key=FC_PORT
        16500:'IB Port||IB端口', #key=IB_PORT
        213:'Ethernet Port||以太网口', #key=ETH_PORT
        214:'SAS Port||SAS端口', #key=SAS_PORT
        215:'Serial Port||串口', #key=SERIAL_PORT
        216:'Storage Pool||存储池', #key=STORAGEPOOL
        217:'Storage Tier||存储层', #key=STORAGETIER
        218:'SmartCache||SmartCache', #key=SMARTCACHE
        219:'LUN Copy||LUN拷贝', #key=LUNCOPY
        220:'Split Mirror||分裂镜像', #key=SPLITMIRROR
        221:'Consistent Group||一致性组', #key=CONSISTENTGROUP
        222:'iSCSI Initiator||iSCSI启动器', #key=ISCSI_INITIATOR
        223:'FC Initiator||FC启动器', #key=FC_INITIATOR
        224:'Remote Device||远端设备', #key=REMOTE_DEVICE
        225:'FC Link||FC远端链路', #key=FC_LINK
        226:'Remote Replication Member LUN||远程复制成员LUN', #key=REMOTEREPLICATIONMEMBERLUN
        227:'LUN Copy Member LUN||LUN拷贝成员LUN', #key=LUNCOPYMEMBERLUN
        228:'Split Mirror Target LUN||分裂镜像从LUN', #key=SPLITMIRRORTARGETLUN
        229:'iSCSI Session||iSCSI会话', #key=ISCSI_SESSION
        230:'IO Class||IO分类', #key=IOCLASS
        231:'UPS||UPS', #key=UPS
        232:'PCIE Data Switch||PCIE数据交换机', #key=PCIE_DATA_SWITCH
        233:'PCIE Data Switch Port||PCIE端口', #key=PCIE_PORT
        234:'SFP optical transceiver||光模块', #key=SFP_OPTICAL_TRANSCEIVER
        235:'bond port||绑定端口', #key=BOND_PORT
        236:'IPRule||安全规则', #key=IPRule
        237:'Memory||内存', #key=MEMORY
        238:'LDAP configuraion||ldap配置', #key=LDAPConfig
        239:'LDAP User Map||ldap用户映射', #key=LDAP_USER_MAP
        240:'SNMP Trap Address||SNMP Trap地址', #key=SNMP_TRAP_ADDR
        241:'SNMP Community||SNMP 团体字', #key=SNMP_COMMUNITY
        242:'SNMP USM||基于用户的安全模型', #key=SNMP_USM
        243:'iSCSI Link||iSCSI远端链路', #key=iSCSI_LINK
        244:'License||License', #key=License
        245:'Mapping View||映射视图', #key=MAPPINGVIEW
        246:'Schedule||时刻表', #key=SCHEDULE
        247:'iSCSI Session Settings||iSCSI会话初始参数信息（即连接会话时的协商参数）', #key=iSCSI_SESSION_SETTING
        248:'iSCSI Target Node||iSCSI目标器节点', #key=iSCSI_TGT_NODE
        249:'iSCSI Target Port||iSCSI目标器端口', #key=iSCSI_TGT_PORT
        250:'Remote LUN||远端lun', #key=REMOTE_LUN
        251:'Monitor Board||监控板', #key=MONITOR_BOARD
        252:'FCoE Port||FCoE端口', #key=FCoE_PORT
        253:'LUN Migration Task||LUN迁移任务', #key=LUN_Migration_Task
        254:'Clone Group||克隆组', #key=CloneGroup
        255:'Host Link||主机链路', #key=HOST_LINK
        256:'LUN Group||LUN组', #key=LUNGroup
        257:'Port Group||Port组', #key=PortGroup
        258:'Subnet||子网段', #key=Subnet
        259:'NetGroup||网络组', #key=NetGroup
        260:'DNS Server||DNS服务器', #key=DNS_Server
        261:'IP LINK||IP链路', #key=IP_LINK
        262:'User Group||用户组', #key=UserGroup
        263:'REPLICATION PAIR||远程复制pair', #key=REPLICATIONPAIR
        264:'Slow disk policy||慢盘检测', #key=Slow_disk_policy
        265:'LUNBackgroudTask||LUN后台任务', #key=LUNBackgroudTask
        266:'DiskPool||硬盘域', #key=DiskPool
        267:'StorageEngine||存储引擎', #key=StorageEngine
        268:'CachePartition||Cache分区', #key=CachePartition
        269:'IOCLASSTemplate||IO分类模板', #key=IOCLASSTemplate
        270:'LUNDestroyData||LUN数据消毁', #key=LUNDestroyData
        271:'DiskDestroyData||Disk数据消毁', #key=DiskDestroyData
        272:'LUNPriorityStatistic||LUN优先级统计', #key=LUNPriorityStatistic
        273:'SmartCachePartition||SmartCache分区', #key=SmartCachePartition
        274:'DISK_SCAN_TASK||Disk扫描任务', #key=DISK_SCAN_TASK
        20480:'CLI_COMMON||专用于CLI公共部分，CLI新增的特殊命令字可以挂接在此对象下，仅供CLI使用，框架不允许使用此处新增的对象或命令字', #key=CLI_COMMON
        32768:'SAS_Card||SAS卡', #key=SAS_Card
        32769:'Raid_Card||Raid卡', #key=Raid_Card
        32770:'Memory||内存信息', #key=Memory
        32771:'Server_FileSystem||服务器文件系统', #key=Server_FileSystem
        32772:'RaidCard_Raid||RaidCard_Raid', #key=RaidCard_Raid
        32773:'RaidCard_LUN||RaidCard_LUN', #key=RaidCard_LUN
        32774:'RaidCard_LogicDisk||RaidCard_LogicDisk', #key=RaidCard_LogicDisk
        32775:'SmartData_Raid||SmartData_Raid', #key=SmartData_Raid
        32776:'SmartData_LUN||SmartData_LUN', #key=SmartData_LUN
        32777:'SmartData_LogicDisk||SmartData_LogicDisk', #key=SmartData_LogicDisk
        16384:'SNAS_SYSTEM||Scale out NAS系统', #key=SNAS_SYSTEM
        16385:'Scale out NAS NODE||SNAS集群系统节点', #key=SNAS_NODE
        16386:'Protocol cluster||SNAS协议集群', #key=PROTOCOL_CLUSTER
        16387:'Protocol cluster node||SNAS协议集群节点', #key=PROTOCOL_CLUSTER_NODE
        16388:'Protocol cluster zone||SNAS协议集群分区', #key=PROTOCOL_CLUSTER_ZONE
        16389:'Public ip pool||动态IP池', #key=SNAS_IP_POOL
        16390:'NAS client||SNAS系统客户端', #key=SNAS_CLIENT
        16391:'DNS configuration||SNAS DNS 配置', #key=SNAS_DNS_CONFIG
        16392:'local user||本地用户', #key=SNAS_LOCAL_USER
        16393:'local group||本地用户组', #key=SNAS_LOCAL_GROUP
        16394:'user&group relationship||用户组和用户关系', #key=SNAS_USERANDGROUP
        16395:'ID MAPPING||SNAS ID MAPPING', #key=SNAS_IDMAP_CONFIG
        16396:'Root user password setting||SNAS节点root用户', #key=SNAS_ROOT_USER
        16397:'FS service running on node||SNAS节点文件系统服务', #key=SNAS_NODE_FS_SERV
        16398:'NAS service running on node||SNAS节点协议共享服务', #key=SNAS_NODE_SHARE_SERV
        16399:'CIFS service configuration||SNAS CIFS 服务', #key=SNAS_CIFS_SERVICE
        16400:'SNAS file object||SNAS 文件', #key=SNAS_FILE
        16401:'NFS share of file||SNAS NFS共享', #key=SNAS_NFS_SHARE
        16402:'CIFS share of file||SNAS CIFS 共享', #key=SNAS_CIFS_SHARE
        16403:'SNAS user quota||SNAS用户配额', #key=SNAS_USER_QUOTA
        16404:'CIFS client permission of file||SNAS CIFS用户共享', #key=SNAS_CIFS_SHARE_AUTH_CLIENT
        16405:'Data recovery schedule||数据恢复计划', #key=DATA_RECOVER_SCHEDULE
        16406:'back task||SNAS任务', #key=SNAS_TASK
        16407:'key-value store||SNAS KV存储接口', #key=SNAS_KEY_VALUE_STORE
        16408:'SNAS file quota||SNAS文件配额', #key=SNAS_FILE_QUOTA
        16409:'NFS client permission of file||SNAS NFS 客户端共享', #key=SNAS_NFS_SHARE_AUTH_CLIENT
        16410:'ACL||协议 ACL策略', #key=SNAS_ACL_STRATEGY
        16411:'Local authority configuration||本地认证源', #key=SNAS_LOCAL_AUTH
        16412:'NIS configuration||NIS认证源', #key=SNAS_NIS_CONFIG
        16413:'LDAP configuration||LDAP认证源', #key=SNAS_LDAP_CONFIG
        16414:'AD domain||AD域认证源', #key=SNAS_AD_CONFIG
        16415:'SNAS node water level||SNAS性能节点数据迁移水位', #key=SNAS_SYS_WATERLEVEL
        16416:'energy saving||SNAS系统节能开关', #key=SNAS_SYS_ENERGY_SAVING
        16417:'alarm void setting||SNAS告警声音设置', #key=SNAS_ALARM_VOICE
        16418:'admin user security policies||SNAS 系统安全策略', #key=SNAS_SECURITY_POLICY
        16419:'connection heart beat||心跳', #key=SNAS_HEARTBEAT
        16420:'connection hand shake||握手接口', #key=SNAS_HANDSHAKE
        16421:'check snas main mrg node||管理节点', #key=SNAS_MGR_NODE
        16422:'snas node performance||集群节点性能接口', #key=SNAS_NODE_PERFORMANCE
        16423:'snas super user pwd reset||SNAS SMTP配置', #key=SNAS_SECURITY_SMTP
        16424:'snas alarm threshold||SNAS告警阈值', #key=SNAS_ALARM_THRESHOLD
        16425:'snas AD domain||SNAS AD域', #key=SNAS_AD_SOURCE
        16426:'snas storage Tier||SNAS 分级存储', #key=SNAS_SYS_TIER
        16427:'snas file level policy||SNAS_FILE_LEVEL_POLICY', #key=SNAS_FILE_LEVEL_POLICY
        16428:'snas file level policy item||SNAS_FILE_LEVEL_POLICY_ITEM', #key=SNAS_FILE_LEVEL_POLICY_ITEM
        16429:'snas file io statistic||SNAS_SYS_IO_TEMP', #key=SNAS_SYS_IO_TEMP
        16430:'snas nis auth source||SNAS_NIS_SOURCE', #key=SNAS_NIS_SOURCE
        16431:'snas ldap auth source||SNAS_LDAP_SOURCE', #key=SNAS_LDAP_SOURCE
        16432:'snas file access time||SNAS_FILE_ATIME', #key=SNAS_FILE_ATIME
        16433:'snas encrypte key||AES对称加密密钥128位', #key=SNAS_ENCRYPT_KEY
        16434:'snas sms modem||SNAS_DEVICE_SMSMODEM', #key=SNAS_DEVICE_SMSMODEM
        16435:'snas_alarm_level||告警定义配置', #key=SNAS_ALARM_DEFINITION
        16436:'snas_cmd_opinfo||命令操作提示信息接口', #key=SNAS_CMD_OPINFO
        16437:'snas dns service||SNAS_EXTERNAL_DNS', #key=SNAS_EXTERNAL_DNS
        16438:'snas ip switch||SNAS_IP_SWITCH', #key=SNAS_IP_SWITCH
        16439:'snas ip switch port||SNAS_IP_SWITCH_PORT', #key=SNAS_IP_SWITCH_PORT
        16440:'snas snmp discovery config||SNAS_DISCOVERY_SNMP', #key=SNAS_DISCOVERY_SNMP
        16441:'IPZone||IPZone', #key=IPZone
        16442:'vStore||虚拟存储（多租户）', #key=vStore
        16443:'WormUser||WORM管理员', #key=WormUser
        16444:'CommConfigure||通用配置（目前VMware使用）', #key=CommConfigure
        16445:'QUOTATREE||QUOTATREE', #key=QUOTATREE
        16446:'LOCAL_RESUSER||本地资源用户（统一存储使用）', #key=LOCAL_RESUSER
        16447:'LOCAL_RESGROUP||本地资源用户组（统一存储使用）', #key=LOCAL_RESGROUP
        16448:'HTTPOnlineLink||HTTP的在线连接', #key=HTTPOnlineLink
        16449:'FTPOnlineLink||FTP的在线连接', #key=FTPOnlineLink
        16450:'HTTPSERVICE||HTTP服务', #key=HTTPSERVICE
        16451:'FTPSERVICE||FTP服务', #key=FTPSERVICE
        16452:'NFSSERVICE||NFS服务', #key=NFSSERVICE
        16453:'CIFSSERVICE||CIFS服务', #key=CIFSSERVICE
        16454:'SNAS_FTP_SHARE_AUTH_CLIENT||FTP共享权限', #key=SNAS_FTP_SHARE_AUTH_CLIENT
        16455:'SNAS_HTTP_SHARE_AUTH_CLIENT||HTTP共享权限', #key=SNAS_HTTP_SHARE_AUTH_CLIENT
        16456:'SNAS_HTTP_SHARE||HTTP共享', #key=SNAS_HTTP_SHARE
        16457:'Homedir||用户主目录', #key=Homedir
        16458:'Quota||配额', #key=Quota
        16459:'snas capacity collection||集群对象容量数据采集', #key=SNAS_CAPACITY_STATISTIC
        49152:'ISM||ISM',
        53248:'NOFS||NOFS', #key=NOFS
        57344:'task||任务', #key=TASK
        57345:'backup server||备份服务器', #key=BACKUP_SERVER
        57346:'VRM||虚拟资源管理节点（VRM）', #key=VRM
        57347:'cluster||集群', #key=CLUSTER
        57348:'CAN||计算节点代理（CNA）', #key=CAN
        57349:'datastore||数据存储', #key=DATASTORE
        57350:'virtual machine||虚拟机', #key=VIRTUAL_MACHINE
        57351:'virtualdisk||VDI虚拟磁盘', #key=VDI_DISK
        57352:'backup policy||备份策略', #key=BACKUP_POLICY
        57353:'Storage Unit||存储单元', #key=STORAGE_UNIT
        57354:'Restore Policy||恢复策略', #key=RESTORE_POLICY
        57355:'Backup Set||备份集' #key=BACKUP_SET
    }

    '''
    POWER_TYPE_E
    '''
    StrPowerTypeEnum = {
        0:'DC||DC', #key=DC
        1:'AC||AC' #key=AC
    }

    '''ENCLOSURE_MODEL'''
    StrEnclosureModel = {
        0:"CTRL_BMC", #BMC控制框/
        1:"CTRL_SAS2U_12", #2U SAS 12盘主控框/
        2:"CTRL_SAS2U_24", #2U SAS 24盘主控框/
        16:"EXPSAS2U_12", #2U SAS 12盘级联框/
        17:"EXPSAS2U_24", #2U SAS 24盘级联框/
        18:"EXPSAS4U", #4U SAS 24盘级联框/
        19:"EXPFC", #4U FC 24盘级联框/
        20:"DSW_PCIe1U", #1U PCIe数据交换机/
        21:"EXPSAS4U_75", #4U SAS 75盘级联框/
        22:"SVP", #SVP/SVP Controller Enclosure
        97:"CTRL_6U", #6U 4控独立机头/
        96:"CTRL_3U", #3U 2控独立机头/
        24:"EXPSAS2U_25", #2U SAS 25盘2.5寸磁盘框/
        25:"EXPSAS4U_24_NEW", #4U SAS 24盘3.5寸磁盘框（新）/
        26:"CTRL_12GSAS_2U25_EAR", #2U 12GSAS 25盘主控框/
        23:"CTRL_12GSAS_2U12_EAR", #2U 12GSAS 12盘主控框/
        98:"SSD_2U_25", #2U SSD 25盘级联框/
        99:"CTRL_NVME_2U_25", #2U NVMe 25盘 2.5寸主控框/
        39:"EXP_12G_SAS_4U_75",#EXP_12G_SAS_4U_75
    }

    '''ENCLOSURE_MODEL_E'''
    StrEnclosureModelEnum = {
        0:'CTRL_BMC||BMC控制框', #key=CTRL_BMC
        1:'CTRL_SAS2U_12||2U SAS 12盘主控框', #key=CTRL_SAS2U_12
        2:'CTRL_SAS2U_24||2U SAS 24盘主控框', #key=CTRL_SAS2U_24
        16:'EXPSAS2U_12||2U SAS 12盘级联框', #key=EXPSAS2U_12
        17:'EXPSAS2U_24||2U SAS 24盘级联框', #key=EXPSAS2U_24
        18:'EXPSAS4U||4U SAS 24盘级联框', #key=EXPSAS4U
        19:'EXPFC||4U FC 24盘级联框', #key=EXPFC
        20:'DSW_PCIe1U||1U PCIe数据交换机', #key=DSW_PCIe1U
        21:'EXPSAS4U_75||4U SAS 75盘级联框', #key=EXPSAS4U_75
        22:'SVP Controller Enclosure||SVP', #key=SVP
        97:'CTRL_6U||6U 4控独立机头', #key=CTRL_6U
        96:'CTRL_3U||3U 2控独立机头', #key=CTRL_3U
        24:'EXPSAS2U_25||2U SAS 25盘2.5寸磁盘框', #key=EXPSAS2U_25
        65:'2U 25 Slot 2.5 SSD Disks Enclosure||2U SSD 25盘2.5寸级联框', #key=EXPSAS2U_25_12GLINK
        25:'EXPSAS4U_24_NEW||4U SAS 24盘3.5寸磁盘框（新）', #key=EXPSAS4U_24_NEW
        26:'CTRL_12GSAS_2U25_EAR||2U 12GSAS 25盘主控框', #key=CTRL_12GSAS_2U25_EAR
        23:'CTRL_12GSAS_2U12_EAR||2U 12GSAS 12盘主控框', #key=CTRL_12GSAS_2U12_EAR
        98:'2U 25 Slot 2.5 SSD Disks Enclosure||2U SSD 25盘级联框', #key=SSD_2U_25
        99:'2U 25-slot 2.5-inch active NVMe controller enclosure||2U NVMe 25盘 2.5寸主控框', #key=CTRL_NVME_2U_25
        39:"EXP_12G_SAS_4U_75",#EXP_12G_SAS_4U_75

    }

    '''ENCLOSURE_TYPE_E'''
    StrEnclosureTypeEnum = {
        0:'EXP||级联框（硬盘框）', #key=EXP
        1:'CTRL||控制框', #key=CTRL
        2:'DSW||数据交换机', #key=DSW
        3:'MSW||管理交换机', #key=MSW
        4:'SVP||管理服务器'       #key=SVP
    }

    '''EXPBOARD_TYPE_E'''
    StrExpboardTypeEnum = {
        0:'SAS||SAS', #key=SAS
        1:'FC||FC'    #key=FC
    }

    '''PRODUCT_MODE_E'''
    StrProductModeEnum = {
        0:'V1500||V1500', #key=V1500
        1:'V1800||V1800', #key=V1800
        2:'S2100||S2100', #key=S2100
        3:'S2300||S2300', #key=S2300
        4:'S5100||S5100', #key=S5100
        5:'S5300||S5300', #key=S5300
        6:'S5500||S5500', #key=S5500
        7:'S5600||S5600', #key=S5600
        8:'VIS||VIS', #key=VIS
        9:'S2600||S2600', #key=S2600
        10:'S6800E||S6800E', #key=S6800E
        11:'V1500N||V1500N', #key=V1500N
        12:'S2300E||S2300E', #key=S2300E
        13:'COMMON||COMMON(插框混用)', #key=COMMON
        15:'N8000||N8000', #key=N8000
        16:'S6900||S6900', #key=S6900
        17:'S3900||S3900', #key=S3900
        18:'S5500T||S5500T', #key=S5500T
        19:'S5600T||S5600T', #key=S5600T
        20:'S6800T||S6800T', #key=S6800T
        21:'S6900-M100||S6900-M100', #key=S6900_M100
        22:'S3900-M200||S3900-M200', #key=S3900_M200
        23:'S3900-M300||S3900-M300', #key=S3900_M300
        24:'S5900-M100||S5900-M100', #key=S5900_M100
        25:'S8100||S8100', #key=S8100
        26:'S5800T||S5800T', #key=S5800T
        27:'V1600N||V1600N', #key=V1600N
        28:'S5900-M200||S5900-M200', #key=S5900_M200
        29:'N8001||N8001', #key=N8001
        30:'S2600T||S2600T', #key=S2600T
        31:'S8000-I||S8000-I', #key=S8000_I
        32:'Dorado5100||Dorado5100', #key=Dorado5100
        33:'T3200||T3200', #key=T3200
        34:'T3500||T3500', #key=T3500
        35:'N8000-R710||N8000-R710', #key=N8000-R710
        36:'N8000-C2||N8000-C2', #key=N8000-C2
        40:'N8000-C2-SYMC||N8000-C2-SYMC', #key=N8000-C2-SYMC
        41:'VTL||VTL', #key=VTL
        42:'S2900||S2900', #key=S2900
        43:'S2200T||S2200T', #key=S2200T
        44:'Dorado2100 G2||Dorado2100 G2', #key=Dorado2100 G2
        45:'VIS 6000||VIS 6000', #key=VIS 6000
        46:'HVS85T||HVS85T', #key=HVS85T
        47:'HVS88T||HVS88T', #key=HVS88T
        48:'9000||9000', #key=N9000
        49:'T3200 G2||T3200 G2', #key=T3200 G2
        50:'T3500 G2||T3500 G2', #key=T3500 G2
        51:'T3200 G3||T3200 G3', #key=T3200 G3
        52:'T3500 G3||T3500 G3', #key=T3500 G3
        53:'S5700||S5700', #key=S5700
        54:'CE6800||CE6800', #key=CE6800
        55:'CE12800||CE12800', #key=CE12800
        56:'18800F||18800F', #key=HVS_18800F
        57:'18500||18500', #key=HVS_18500
        58:'18800||18800', #key=HVS_18800
        60:'SSS||SSS', #key=SSS
        61:'6800V3||6800V3', #key=6800V3
        62:'6900V3||6900V3', #key=6900V3
        63:'5600V3||5600V3', #key=5600V3
        64:'5800V3||5800V3', #key=5800V3
        65:'T3200||T3200', #key=T3200 MINI
        66:'WUSHAN_SQL||WUSHAN_SQL', #key=WUSHAN_SQL
        67:'WUSHAN_HD||WUSHAN_HD', #key=WUSHAN_HD
        68:'5500V3||5500V3', #key=5500V3
        69:'2600V3||2600V3', #key=2600V3
        70:'5300V3||5300V3', #key=5300V3
        71:'2800V3||2800V3', #key=2800V3
        72:'18500V3', #key=18500V3
        73:'18800V3', #key=18800V3
        78:'2200V3||2200V3', #key=2200V3
        79:'5100V3||5100V3', #key=5100V3
        84:"2600FV3||2600FV3",
        85:"5500FV3||5500FV3",
        86:"5600FV3||5600FV3",
        87:"5800FV3||5800FV3",
        88:"6800FV3||6800FV3",
        89:"18500FV3||18500FV3",
        90:"18800FV3||18800FV3",
    
        401:'N5000||N5000', #key=N5000
        800:'VIS8200||VIS8200', #key=VIS8200
        801:'VIS8400||VIS8400', #key=VIS8400
        802:'VIS8600||VIS8600', #key=VIS8600
        803:'VIS8800||VIS8800', #key=VIS8800
        805:'Dorado5000 V3||Dorado5000 V3', #key=Dorado5000 V3
        806:'Dorado6000 V3||Dorado6000 V3', #key=Dorado6000 V3
        
        92:"2800V5||2800V5",
        93:"5300V5||5300V5",
        94:"5300FV5||5300FV5",
        95:"5500V5||5500V5",
        96:"5500FV5||5500FV5",
        97:"5600V5||5600V5",
        98:"5600FV5||5600FV5",
        99:"5800V5||5800V5",
        100:"5800FV5||5800FV5",
        101:"6800V5||6800V5",
        102:"6800FV5||6800FV5",
        103:"18500V5||18500V5",
        104:"18500FV5||18500FV5",
        105:"18800V5||18800V5",
        106:"18800FV5||18800FV5",
        107:"5500V5Elite||5500V5Elite",
        112:"2200V3 Enhanced||2200V3 Enhanced",
        113:"2600V3 Enhanced||2600V3 Enhanced",
        114:"2600FV3 Enhanced||2600FV3 Enhanced",
        115:"5300V5 Enhanced||5300V5 Enhanced"
    }


###--------对象URI配置-------
##单个查询，批量查询和修改的对象
class OBJ():
    SYSTEM = "system/"
    ENCLOSURE = "enclosure"
    CONTROLLER = "controller"
    BAY = "bay"
    EXPANSION_BOARD = "expboard"
    INTERFACE_MODULE = "intf_module"
    DISK = "disk"
    FAN = "fan"
    POWER = "power"
    BACKUP_POWER = "backup_power"
    ETH_PORT = "eth_port"
    PCIE_PORT = "pcie_port"
    SAS_PORT = "sas_port"
    FC_PORT = "fc_port"
    FCoE_PORT = "FCoE_PORT"
    IB_PORT = "ib_port"
    REPLICATIONPAIR = "REPLICATIONPAIR"
    IBC = "check_ibc_password_changed"
    CONTROLLER_IO = "backend_concurrent"
    SFP_OPTICAL_TRANSCEIVER = "SFP_OPTICAL_TRANSCEIVER"
    FC_LINK = "FC_LINK"
    iSCSI_LINK = "iSCSI_LINK"
    EXPORT_DB_CONFIG = "export_db_config"         #导出配置文件
    CLEAR_EXPORT_DATA = "clear_export_data"       #清除导出数据
    VM = "vm"   #虚拟机

##特殊REST接口，无法在OBJ中实现的接口

class SpecialUri():
    QUERY_USER_INFO = "user" #查询用户信息
    QUERY_CURRENT_ALARM_INFO = "alarm/currentalarm"      #查询系统当前告警列表信息
    COUNT_CURRENT_ALARMS = "alarm/currentalarm/count"    #查询系统当前告警列表信息
    QUERY_HISTORICAL_ALARMS_INFO = "alarm/historyalarm"  #查询历史告警和事件
    COUNT_HISTORICA_ALARMS = "alarm/historyalarm/count"  #查询历史告警和事件个数
    SYNC_REPLICATION_PAIR = "REPLICATIONPAIR/sync"       #同步远程复制Pair
    ACTIVELICENSE = "license/activelicense"              #查询license使用情况
    OFFLINE_CONTROLLER = "offline_controller" #离线控制器
    OFFLINE_CONTROLLER_SIGNLE = "safe_power_off_system"

#-------------新增rest参数------------

class TlvCmd():
    '''
    Description: 命令集合
    '''
    STOP_FEED = {'cmd':3080266, 'timeout':120} #重启待扩容引擎
    INTEGRATIVE_QUERY = {'cmd':8596488204, 'timeout':120} #查询NAS引擎的用户名和密码
    OM_MSG_OP_LST_VER = {'cmd':8599109735, 'timeout':120} #查询版本信息
    OM_MSG_OP_UPD_LST_SYS_PROGRESS = {'cmd':8599109744, 'timeout':120} #查询整体升级状态
    OM_MSG_OP_GET_PACKAGE_UPLOADPATH = {'cmd':8599109754, 'timeout':120} #查询升级包上传路径
    OM_MSG_OP_UPD_LST_PACKAGE_INFO = {'cmd':8599109756, 'timeout':120} #查询升级包信息
    OM_MSG_OP_UPD_EXECUTE = {'cmd':8599117931, 'timeout':120} #通知执行一个升级流程，查询CPU利用率等信息
    OM_MSG_OP_UPD_DISK_FIRMWARE = {'cmd':8599117938, 'timeout':120} #升级硬盘
    OM_MSG_OP_UPD_GET_DISK_RESULT = {'cmd':8599117939, 'timeout':120} #获取硬盘升级状态
    OM_MSG_OP_NOTIFY_PACKAGE_PATH = {'cmd':8599117947, 'timeout':120} #通知软件包上传完成
    OM_MSG_OP_UPD_GET_MGTBOARD_RESULT = {'cmd':8599117975, 'timeout':120} #获取管理板升级状态
    OM_MSG_OP_EXC_HOTPATCH_DELETE = {'cmd':8599118950, 'timeout':120} #删除热补丁
    OM_MSG_OP_UPD_LST_ACTIVEMODE = {'cmd':8599150994, 'timeout':120} #查询激活方式
    OM_MSG_OP_UPD_LST_DETAILINFO = {'cmd':8599150995, 'timeout':120} #查询升级详细信息
    GET = {'cmd':55834574848, 'timeout':90} #查询单个对象
    MODIFY = {'cmd':55834583040, 'timeout':90} #修改对象
    START = {'cmd':55834583049, 'timeout':120} #开始任务
    STOP = {'cmd':55834583050, 'timeout':120} #停止任务
    PAUSE = {'cmd':55834583051, 'timeout':120} #暂停任务
    CONTINUE = {'cmd':55834583052, 'timeout':120} #继续任务
    GET_NEXT_AVAILABLE_ID = {'cmd':55834583053, 'timeout':120} #查询下一个可用的ID号
    CREATE = {'cmd':55834591232, 'timeout':120} #创建对象
    CREATE_ASSOCIATE = {'cmd':55834595328, 'timeout':120} #建立关联
    DELETE = {'cmd':55834599424, 'timeout':120} #删除对象
    REMOVE_ASSOCIATE = {'cmd':55834603520, 'timeout':120} #移除关联
    ASSOCIATE = {'cmd':55834615808, 'timeout':90} #关联查询对象
    GET_BATCH_NEXT = {'cmd':55834624000, 'timeout':90} #批量查询对象
    COUNT = {'cmd':55834632192, 'timeout':120} #查询对象的数量
    DISK_POWER_ON = {'cmd':55835230209, 'timeout':120} #硬盘上电
    DISK_POWER_OFF = {'cmd':55835230210, 'timeout':120} #硬盘下电
    DISK_RESET = {'cmd':55835230211, 'timeout':120} #DISK_RESET
    GET_DISK_NCQ_SWITCH = {'cmd':55835230212, 'timeout':120} #GET_DISK_NCQ_SWITCH
    SET_DISK_NCQ_SWITCH = {'cmd':55835230213, 'timeout':120} #SET_DISK_NCQ_SWITCH
    GET_DISK_UNPLUG = {'cmd':55835230214, 'timeout':120} #GET_DISK_UNPLUG
    SET_DISK_UNPLUG = {'cmd':55835230215, 'timeout':120} #SET_DISK_UNPLUG
    GET_DISK_WRITECACHESW = {'cmd':55835230216, 'timeout':120} #GET_DISK_WRITECACHESW
    SET_DISK_WRITECACHESW = {'cmd':55835230217, 'timeout':120} #SET_DISK_WRITECACHESW
    GET_DISK_PRECOPYSW = {'cmd':55835230218, 'timeout':120} #GET_DISK_PRECOPYSW
    SET_DISK_PRECOPYSW = {'cmd':55835230219, 'timeout':120} #SET_DISK_PRECOPYSW
    GET_DISK_BST = {'cmd':55835230220, 'timeout':120} #GET_DISK_BST
    CLEAR_DISK_BST = {'cmd':55835230221, 'timeout':120} #CLEAR_DISK_BST
    SET_DISK_LITHTSW = {'cmd':55835230222, 'timeout':90} #硬盘定位灯开启/关闭
    FORCE_READ_DISK = {'cmd':55835230223, 'timeout':120} #强制接入硬盘并使用它对其它硬盘进行重构
    START_DISK_PRECOPY = {'cmd':55835230224, 'timeout':90} #启动预拷贝
    GET_DISK_ROUTINE_TEST = {'cmd':55835230225, 'timeout':120} #获取硬盘例测周期
    SWITCH_WORKING_CONTROLLER = {'cmd':55835295745, 'timeout':120} #切换LUN的归属控制器
    LUN_TRANSFERM = {'cmd':55835295746, 'timeout':120} #Thin LUN与Fat LUN之间的相互转换
    EXPAND_LUN_CAPACITY = {'cmd':55835295747, 'timeout':120} #LUN的扩容
    GET_BATCH_NEXT_SNAPSHOT_LUN_CANUSE = {'cmd':55835295748, 'timeout':120} #查询可创建快照的LUN
    SET_WORM_STATE = {'cmd':55835295749, 'timeout':120} #设置WORM状态
    SET_SYS_WORM_SW = {'cmd':55835295750, 'timeout':120} #设置全局WORM开关
    GET_SYS_WORM_SW = {'cmd':55835295751, 'timeout':120} #查询全局WORM开关
    ADD_LUN_BY_WWN = {'cmd':55835295752, 'timeout':120} #根据WWN添加LUN到映射视图
    REMOVE_LUN_BY_WWN = {'cmd':55835295753, 'timeout':120} #根据WWN移除LUN从映射视图
    GET_BATCH_NEXT_LUN_FOR_MIGRATION = {'cmd':55835295754, 'timeout':120} #查询LUN迁移的源LUN或目标LUN
    COUNT_LUN_FOR_MIGRATION = {'cmd':55835295755, 'timeout':120} #查询LUN迁移的源LUN或目标LUN的总数
    GET_FREQUENCYSWITCH = {'cmd':55835623425, 'timeout':120} #查询调频开关
    SET_FREQUENCYSWITCH = {'cmd':55835623426, 'timeout':120} #设置调频开关
    CREATE_HYPERIMAGE_COPY = {'cmd':55836344321, 'timeout':120} #创建虚拟快照副本
    ENABLE_HYPERIMAGE = {'cmd':55836344322, 'timeout':120} #重建虚拟快照
    DISABLE_HYPERIMAGE = {'cmd':55836344323, 'timeout':120} #停用虚拟快照
    ACTIVE_HYPERIMAGE = {'cmd':55836344324, 'timeout':120} #激活虚拟快照
    ROLLBACK_HYPERIMAGE = {'cmd':55836344325, 'timeout':120} #回滚虚拟快照
    CANCEL_ROLLBACK_HYPERIMAGE = {'cmd':55836344326, 'timeout':120} #取消回滚虚拟快照
    GET_NEXT_FITTING_MIRROR = {'cmd':55836409857, 'timeout':120} #查询符合条件加入一致性组的远程复制(NEXT)
    LOCK_USER = {'cmd':55837327366, 'timeout':120} #锁定用户
    UNLOCK_USER = {'cmd':55837327367, 'timeout':120} #解锁用户
    REQUEST_TOKEN = {'cmd':55837327368, 'timeout':120} #获取一次性登陆令牌
    UNLOCK_IP = {'cmd':55837327369, 'timeout':120} #解锁IP
    GET_BATCH_ROUTE = {'cmd':55847747585, 'timeout':120} #查询端口的路由信息
    ADD_ROUTE = {'cmd':55847747586, 'timeout':120} #增加路由
    REMOVE_ROUTE = {'cmd':55847747587, 'timeout':120} #移除路由
    SET_ISCSI_DEVICE_NAME = {'cmd':55847747588, 'timeout':120} #设置iSCSI设备名称
    GET_ISCSI_DEVICE_NAME = {'cmd':55847747589, 'timeout':120} #查询iSCSI设备名称
    GET_ISNS_SERVER = {'cmd':55847747590, 'timeout':120} #查询iSNS服务
    SET_ISNS_SERVER = {'cmd':55847747591, 'timeout':120} #设置iSNS服务地址
    CONFIG_POOL_ANALYSIS = {'cmd':55847747592, 'timeout':120} #配置Pool的预测分析功能
    SHOW_POOL_ANALYSIS_RESULT = {'cmd':55847747593, 'timeout':120} #显示Pool的预测分析结果
    SHOW_POOL_ANALYSIS_PROPERTY = {'cmd':55847747594, 'timeout':120} #显示Pool的预测分析属性
    GET_POOL_TASK = {'cmd':55847747595, 'timeout':90} #查询指定POOL的后台任务
    GET_POOL_TASK_BATCH_NEXT = {'cmd':55847747596, 'timeout':120} #批量查询POOL后台任务
    CLEAR_ERROR_CODE = {'cmd':55847747597, 'timeout':120} #清除误码
    GET_FC_ERROR_CODE = {'cmd':55847747598, 'timeout':120} #查询FC误码
    GET_ISCSI_ERROR_CODE = {'cmd':55847747599, 'timeout':120} #查询ISCSI误码
    GET_SAS_ERROR_CODE = {'cmd':55847747600, 'timeout':120} #查询SAS误码
    IMPORT_DB_CONFIG_DIR = {'cmd':55847747601, 'timeout':120} #获取导入配置文件路径
    IMPORT_DB_CONFIG = {'cmd':55847747602, 'timeout':120} #导入配置文件
    EXPORT_DB_CONFIG = {'cmd':55847747603, 'timeout':90} #导出配置文件
    CLEAR_EXPORT_DATA = {'cmd':55847747604, 'timeout':90} #清除导出数据
    GET_SYSTEM_CONFIG = {'cmd':55847747605, 'timeout':120} #导出运行数据
    PACKAGE_ALARM_OR_LOG = {'cmd':55847747606, 'timeout':120} #打包设备数据
    OM_MSG_OP_EXPORT_ALARM_OR_LOG = {'cmd':55847747607, 'timeout':120} #获取收集信息导出路径
    GET_SYS_UTC_TIME = {'cmd':55847747608, 'timeout':120} #查询系统本地时间
    SET_SYS_UTC_TIME = {'cmd':55847747609, 'timeout':120} #设置系统本地时间
    GET_SYS_DST = {'cmd':55847747610, 'timeout':120} #查询系统中指定时区的夏令时配置
    SET_SYS_DST = {'cmd':55847747611, 'timeout':120} #设置系统中指定时区的夏令时配置
    GET_SYS_NTP_CLNT_CONF = {'cmd':55847747612, 'timeout':120} #查询系统NTP客户端配置
    SET_SYS_NTP_CLNT_CONF = {'cmd':55847747613, 'timeout':120} #设置系统NTP客户端配置
    GET_SFTP_USER = {'cmd':55847747614, 'timeout':120} #SFTP用户信息
    SET_ALARM_RESTORE_ENABLE = {'cmd':55847747615, 'timeout':120} #SET_ALARM_RESTORE_ENABLE
    SET_ALARM_RESTORE_ADDRESS = {'cmd':55847747616, 'timeout':120} #SET_ALARM_RESTORE_ADDRESS
    GET_ALARM_RESTORE_ADDRESS = {'cmd':55847747617, 'timeout':120} #GET_ALARM_RESTORE_ADDRESS
    SET_STATISTIC_STRATEGY = {'cmd':55847747618, 'timeout':120} #SET_STATISTIC_STRATEGY
    GET_STATISTIC_STRATEGY = {'cmd':55847747619, 'timeout':120} #GET_STATISTIC_STRATEGY
    SET_STATISTIC_RESTORE_INFO = {'cmd':55847747620, 'timeout':120} #设置性能统计数据自动转储信息
    OM_MSG_OP_SET_THRESHOLD = {'cmd':55847747621, 'timeout':120} #设置性能告警阈值
    OM_MSG_OP_GET_THRESHOLD = {'cmd':55847747622, 'timeout':120} #查询性能告警阈值
    OM_MSG_OP_GETBATCH_THRESHOLD = {'cmd':55847747623, 'timeout':120} #查询所有性能告警阈值
    RECOVER_ALARM_THRESHOLD = {'cmd':55847747624, 'timeout':120} #恢复性能统计默认告警阈值
    EXPORT_STATISTIC_DATA = {'cmd':55847747625, 'timeout':120} #EXPORT_STATISTIC_DATA
    GET_STATISTIC_OBJECT_DATA_MAP = {'cmd':55847747626, 'timeout':120} #GET_STATISTIC_OBJECT_DATA_MAP
    GET_STATISTIC_TIME_SPAN = {'cmd':55847747627, 'timeout':120} #GET_STATISTIC_TIME_SPAN
    SET_PERFORMANCE_SWITCH = {'cmd':55847747628, 'timeout':120} #SET_PERFORMANCE_SWITCH
    GET_CUR_STATISTIC_DATA = {'cmd':55847747629, 'timeout':120} #GET_CUR_STATISTIC_DATA
    GET_HIS_STATISTIC_DATA = {'cmd':55847747630, 'timeout':120} #GET_HIS_STATISTIC_DATA
    DEL_STATISTIC_DATA_FILE = {'cmd':55847747631, 'timeout':120} #DEL_STATISTIC_DATA_FILE
    GET_STATISTIC_DATA_FILE = {'cmd':55847747632, 'timeout':120} #GET_STATISTIC_DATA_FILE
    GET_PERFORMANCE_SWITCH = {'cmd':55847747633, 'timeout':120} #GET_PERFORMANCE_SWITCH
    START_NOTIFY = {'cmd':55847747634, 'timeout':120} #通知上报
    STOP_NOTIFY = {'cmd':55847747635, 'timeout':120} #停止上报
    NOTIFY_CREATE = {'cmd':55847747636, 'timeout':120} #组件添加
    NOTIFY_CHANGE = {'cmd':55847747637, 'timeout':120} #组件属性变化
    NOTIFY_DELETE = {'cmd':55847747638, 'timeout':120} #组件删除
    SET_EMAIL_INFO = {'cmd':55847747639, 'timeout':120} #配置告警Email
    GET_EMAIL_INFO = {'cmd':55847747640, 'timeout':120} #查询告警Email配置
    SET_SMS_INFO = {'cmd':55847747641, 'timeout':120} #配置告警短信
    GET_SMS_INFO = {'cmd':55847747642, 'timeout':120} #查询告警短信配置
    SET_ALARM_CONFIG = {'cmd':55847747643, 'timeout':120} #设置远程告警发送
    GET_ALARM_CONFIG = {'cmd':55847747644, 'timeout':120} #查询远程告警发送
    GET_CLIENT_INFO = {'cmd':55847747645, 'timeout':120} #GET_CLIENT_INFO
    SET_CLIENT_INFO = {'cmd':55847747646, 'timeout':120} #SET_CLIENT_INFO
    REPORT_ALARM = {'cmd':55847747647, 'timeout':120} #上报告警
    GET_CURRENT_ALARM = {'cmd':55847747648, 'timeout':90} #查询当前告警
    GET_HISTORY_ALARM = {'cmd':55847747649, 'timeout':90} #查询所有事件（GETBATCH）
    CLEAR_ALARM = {'cmd':55847747650, 'timeout':120} #清除告警
    GET_SYS_TIMEZONE = {'cmd':55847747651, 'timeout':120} #查询系统时区配置
    SET_SYS_TIME_ZONE = {'cmd':55847747652, 'timeout':120} #设置系统时区配置
    SEND_TEST_EMAIL = {'cmd':55847747653, 'timeout':120} #发送测试Email
    SEND_TEST_SMS = {'cmd':55847747654, 'timeout':120} #发送测试短信
    SEND_TEST_TRAPMSG = {'cmd':55847747655, 'timeout':120} #发送测试TRAP消息
    OM_MSG_OP_SET_ALARM_SYSLOG_CFG = {'cmd':55847747656, 'timeout':120} #设置syslog配置
    OM_MSG_OP_GET_ALARM_SYSLOG_CFG = {'cmd':55847747657, 'timeout':120} #查询syslog配置
    REBOOT = {'cmd':55847747658, 'timeout':120} #设备重启
    POWEROFF = {'cmd':55847747659, 'timeout':120} #设备下电
    GET_STATISTIC_RESTORE_INFO = {'cmd':55847747660, 'timeout':120} #查询性能统计数据自动转储信息
    GET_SNMP_CONFIG = {'cmd':55847747661, 'timeout':120} #查询SNMP配置信息
    MODIFY_SNMP_ENGINEBOOTS = {'cmd':55847747662, 'timeout':120} #修改SNMP引擎重启次数
    GET_OEM_MANUFACTORY = {'cmd':55847747663, 'timeout':120} #查询OEM厂商信息
    SET_OEM_MANUFACTORY = {'cmd':55847747664, 'timeout':120} #设置OEM厂商信息
    MODIFY_CONFIG_ITEM = {'cmd':55847747665, 'timeout':120} #修改系统配置项
    SET_DHA_POLICY = {'cmd':55847747666, 'timeout':120} #设置DHA策略
    GET_DHA_POLICY = {'cmd':55847747667, 'timeout':120} #查询DHA策略
    SET_DHA_SERVICE_STATES = {'cmd':55847747668, 'timeout':120} #设置DHA服务状态
    GET_DHA_SERVICE_STATES = {'cmd':55847747669, 'timeout':120} #查询DHA服务状态
    SET_DHA_EXPORT = {'cmd':55847747670, 'timeout':120} #导出DHA信息
    GET_DISKSCANCONF = {'cmd':55847747671, 'timeout':120} #查询DiskScanConf
    MODIFY_DISKSCANCONF = {'cmd':55847747672, 'timeout':120} #修改DiskScanConf
    GET_SERVICE_STATUS = {'cmd':55847747673, 'timeout':120} #查指定节点agent状态
    GET_SERVICE_STATUS_BATCH_NEXT = {'cmd':55847747674, 'timeout':120} #查所有节点agent状态
    START_SERVICE = {'cmd':55847747675, 'timeout':120} #启动agent
    STOP_SERVICE = {'cmd':55847747676, 'timeout':120} #停止agent
    DELETE_ISNS_SERVER = {'cmd':55847747677, 'timeout':120} #删除ISNS SERVER配置
    CLEAR_DB = {'cmd':55847747678, 'timeout':120} #清除集群配置
    GET_BACK_DB_INFO = {'cmd':55847747679, 'timeout':120} #查询DB备份信息
    BACKUP_DB = {'cmd':55847747680, 'timeout':120} #备份DB
    RESTORE_DB = {'cmd':55847747681, 'timeout':120} #恢复DB
    GET_DB_VERSION = {'cmd':55847747682, 'timeout':120} #查询DB版本
    SET_DHA_SINGLE_TASK_SWITCH = {'cmd':55847747683, 'timeout':120} #设置DHA singletask开关
    GET_DHA_LAST_RESULT = {'cmd':55847747684, 'timeout':120} #查询DHA last result
    GET_POWER_CONSUMPTION = {'cmd':55847747685, 'timeout':120} #查询系统能耗
    GET_REPAIRVERIFYCONF = {'cmd':55847747686, 'timeout':120} #查询RepairVerifyConf
    MODIFY_REPAIRVERIFYCONF = {'cmd':55847747687, 'timeout':120} #修改RepairVerifyConf
    GET_BSTCONF = {'cmd':55847747688, 'timeout':120} #查询BSTConf
    MODIFY_BSTCONF = {'cmd':55847747689, 'timeout':120} #修改BSTConf
    GET_CHUNKISOLATECONF = {'cmd':55847747690, 'timeout':120} #查询ChunkIsolateConf
    MODIFY_CHUNKISOLATECONF = {'cmd':55847747691, 'timeout':120} #修改ChunkIsolateConf
    FORCE_REBOOT = {'cmd':55847747692, 'timeout':120} #强制重启
    GET_POWERON_INFO = {'cmd':55847747693, 'timeout':120} #获取指定节点或本节点上电结果
    GET_NEXT_BATCH_POWERON_RESULT = {'cmd':55847747694, 'timeout':120} #获取所有节点上电结果
    VERIFY_VEIW_PASSWD = {'cmd':55847747695, 'timeout':120} #验证视图密码
    CHANGE_VIEW_PASSWD = {'cmd':55847747696, 'timeout':120} #修改视图密码
    RETSET_VIEW_PASSWD = {'cmd':55847747697, 'timeout':120} #重置视图密码
    GETBATCH_ENUM_INFO = {'cmd':55847747698, 'timeout':120} #查询某个枚举定义详情
    INTEGRATIVE_SET_IP = {'cmd':55847747700, 'timeout':120} #设置NAS引擎的机头IP
    INTEGRATIVE_SET_USERINFO = {'cmd':55847747701, 'timeout':120} #设置NAS引擎的用户名和密码
    INTEGRATIVE_DEL = {'cmd':55847747702, 'timeout':120} #重置NAS用户名和密码、IP
    INTEGRATIVE_SHOW = {'cmd':55847747703, 'timeout':120} #显示DB中存的NAS引擎的所有用户名和密码
    GET_FILE_DATA = {'cmd':55847747704, 'timeout':120} #获取文件数据
    GET_CURRENT_NODE_STATUS = {'cmd':55847747705, 'timeout':120} #查当前节点状态
    GET_SYSTEM_STATUS = {'cmd':55847747706, 'timeout':120} #查系统状态
    SPA_OPCODE_QUERY_ROOT_CKGID = {'cmd':55847747707, 'timeout':120} #查询指定Pool的rootckg0 ID
    SPA_OPCODE_EXPORT_ROOT_CKG = {'cmd':55847747708, 'timeout':120} #导出指定CKG上的元数据
    SPA_OPCODE_EXPORT_BTREE = {'cmd':55847747709, 'timeout':120} #导出指定节点上的元数据
    SPA_OPCODE_IMPORT_ROOT_CKG = {'cmd':55847747710, 'timeout':120} #导入指定CKG上的元数据
    SPA_OPCODE_IMPORT_BTREE = {'cmd':55847747711, 'timeout':120} #导入指定节点上的元数据
    GET_FILE_META = {'cmd':55847747712, 'timeout':120} #获取文件描述信息
    UPLOAD_FILE_DATA = {'cmd':55847747713, 'timeout':120} #上传文件数据
    SPA_OPCODE_BTREE_SMO_CHECK_BEGIN = {'cmd':55847747714, 'timeout':120} #启动元数据校验
    SPA_OPCODE_BTREE_SMO_CHECK_QUERY = {'cmd':55847747715, 'timeout':120} #查询元数据校验结果
    NOTIFY_NEW_FILE_CREATE = {'cmd':55847747716, 'timeout':120} #通知新的文件产生
    GET_ALARM_COUNT = {'cmd':55847747717, 'timeout':90} #查询告警数量
    show_dps_statistic = {'cmd':55847747718, 'timeout':120} #查询备份软件统计信息
    show_processor_statistic = {'cmd':55847747719, 'timeout':120} #查询备份服务器统计信息
    query_progress = {'cmd':55847747720, 'timeout':120} #进度查询
    query_bacth_service = {'cmd':55847747721, 'timeout':120} #查询批量系统服务
    start_service = {'cmd':55847747722, 'timeout':120} #启动系统服务
    stop_service = {'cmd':55847747723, 'timeout':120} #停止系统服务
    restart_service = {'cmd':55847747724, 'timeout':120} #重启系统服务
    start_backup = {'cmd':55847747725, 'timeout':120} #手动执行备份任务
    activate_policy = {'cmd':55847747726, 'timeout':120} #激活策略
    import_backupset = {'cmd':55847747727, 'timeout':120} #导入备份集
    expired_backupset = {'cmd':55847747728, 'timeout':120} #立即过期备份集
    query_storage_unit_capacity = {'cmd':55847747729, 'timeout':120} #查询存储单元容量
    del_license = {'cmd':55847747730, 'timeout':120} #删除license
    EXPORT_ALARM = {'cmd':55847747731, 'timeout':120} #导出告警
    NOTIFY_CMD_EXECUTE = {'cmd':55847747732, 'timeout':120} #命令执行上报
    CLEAR_LICENSE_FILE = {'cmd':55847747733, 'timeout':120} #清除License文件
    GET_HISTORY_ALARM_COUNT = {'cmd':55847747734, 'timeout':90} #查询历史告警数量
    CONFIRM_ALARM = {'cmd':55847747735, 'timeout':120} #告警确认
    GET_DISKPOOL_TASK = {'cmd':55847747736, 'timeout':120} #查询指定DISKPOOL的后台任务
    SCAN_AND_CREATE_HOST = {'cmd':55847747737, 'timeout':120} #自动扫描并创建主机
    TEST_NTP_COMM = {'cmd':55847747738, 'timeout':120} #测试NTP服务通信
    RECORD_OPERATION_LOG = {'cmd':55847747739, 'timeout':90} #记录转储或导出操作日志
    CHECK_IBC_PASSWORD = {'cmd':55847747746, 'timeout':90} #检查ibc_os_hs用户是否为默认密码,检查ibc_os_hs公私钥对是否被修改
    CHECK_SAS_CARD_LINK_STATUS = {'cmd':55847747759, 'timeout':90} #获取接口卡下所连接的所有硬盘中是否不存在链路不完整的硬盘
    GET_VIRTUAL_MACHINE = {'cmd':55847747925, 'timeout':120} #虚拟机特性升级前检查
    USER_LOGIN = {'cmd':55847813121, 'timeout':120} #用户登陆
    USER_LOGOUT = {'cmd':55847813122, 'timeout':120} #用户注销
    OFFLINE_USER = {'cmd':55847813123, 'timeout':120} #踢除用户
    INITIALIZE_USER_PWD = {'cmd':55847813124, 'timeout':120} #初始化密码
    HANDSHAKE = {'cmd':55847813125, 'timeout':120} #用户握手
    GET_EXPANSION_BAY_ID = {'cmd':55848009729, 'timeout':90} #获取待扩容柜id,IP Scale Out扩容,获取配置文件控制器数量
    CAPACITY_EXPAND = {'cmd':55848009730, 'timeout':90} #扩容系统柜
    CANCEL_CAPACITY_EXPAND = {'cmd':55848009731, 'timeout':120} #取消系统柜扩容
    MODIFY_BAY_CONFIG = {'cmd':55848009732, 'timeout':90} #IP Scale Out扩容,修改控制器数量和柜ID
    MODIFY_EXPAND_BAY = {'cmd':55848017920, 'timeout':120} #IP Scale Out扩容,修改控制器数量
    POWERON_ENCLOSURE = {'cmd':55848075265, 'timeout':120} #框上电
    SWAP_CONTROLLER = {'cmd':55848140801, 'timeout':120} #主从切换控制器
    REBOOT_CONTROLLER = {'cmd':55848140802, 'timeout':120} #重启控制器
    GET_INITIATOR_NAME = {'cmd':55848140803, 'timeout':120} #查询控制器作为启动器的名称
    SET_INITIATOR_NAME = {'cmd':55848140804, 'timeout':120} #设置控制器作为启动器的名称
    GET_FRONT_END_CONCURRENT = {'cmd':55848140805, 'timeout':120} #获取前端并发
    GET_BACK_END_CONCURRENT = {'cmd':55848140806, 'timeout':90} #获取后端并发
    OFFLINE_CONTROLLER = {'cmd':55848140807, 'timeout':90} #离线控制器
    OFFLINE_CONTROLLER_SERVICE = {'cmd':55848140808, 'timeout':90} #切换控制器业务
    ONLINE_CONTROLLER_SERVICE = {'cmd':55848140809, 'timeout':90} #切回控制器业务
    SAFE_POWER_OFF_SYSTEM = {'cmd':55848140812, 'timeout':600} #2800V3单控新增安全下电（其内部包含1.前置条件检查2.备份控制器信息3.离线控制器）   原id:OM_OPCODE_SAFE_POWER_OFF_SYSTE
    INTF_MODULE_POWER_ON = {'cmd':55848271873, 'timeout':120} #上电
    INTF_MODULE_POWER_OFF = {'cmd':55848271874, 'timeout':90} #下电
    GET_GLOBLE_MIGRATE_LEVEL = {'cmd':55848730625, 'timeout':120} #查询全局迁移速率
    SET_GLOBLE_MIGRATE_LEVEL = {'cmd':55848730626, 'timeout':120} #设置全局迁移速率
    ADD_ALL_REMAIN_DISK_TO_POOL = {'cmd':55848730627, 'timeout':120} #添加所有剩余磁盘到pool中
    EXPAND_POOL = {'cmd':55848730628, 'timeout':120} #POOL扩展磁盘
    MODIFY_MIGRATIONMODE = {'cmd':55848730629, 'timeout':120} #修改迁移模式
    MODIFY_MIGRATIONTIME = {'cmd':55848730630, 'timeout':120} #修改迁移时刻表
    OPEN_OR_CLOSE_MIGRATION = {'cmd':55848730631, 'timeout':120} #开启或关闭立即迁移
    PAUSE_OR_RESUME_MIGRATION = {'cmd':55848730632, 'timeout':120} #暂停/恢复迁移
    SHOW_POOL_ANALYSIS_DEFAULT_PROPERTY = {'cmd':55848730633, 'timeout':120} #显示Pool的预测分析默认属性
    STOP_HYPERCOPY = {'cmd':55848927233, 'timeout':120} #停止LUN拷贝
    PAUSE_HYPERCOPY = {'cmd':55848927234, 'timeout':120} #暂停LUN拷贝
    CONTINUE_HYPERCOPY = {'cmd':55848927235, 'timeout':120} #继续LUN拷贝
    MARK_HYPERCOPY = {'cmd':55848927236, 'timeout':120} #给增量LUN拷贝打标签
    ADD_TGT_LUN = {'cmd':55848927237, 'timeout':120} #增加目标LUN
    START_HYPERCOPY = {'cmd':55848927238, 'timeout':120} #启动LUN拷贝
    SYNCHRONIZE_CONSISTENCY_GROUP = {'cmd':55849058305, 'timeout':120} #同步一致性组
    SWITCH_GROUP_ROLE = {'cmd':55849058306, 'timeout':120} #一致性组主从切换
    DO_SWITCHROLE_GROUP = {'cmd':55849058307, 'timeout':120} #一致性组强制主从切换
    ADD_MIRROR = {'cmd':55849058308, 'timeout':120} #向一致性组添加远程复制
    DEL_MIRROR = {'cmd':55849058309, 'timeout':120} #删除一致性组中的远程复制
    DO_DEL_MIRROR = {'cmd':55849058310, 'timeout':120} #强制删除一致性组中的远程复制
    SPLIT_CONSISTENCY_GROUP = {'cmd':55849058311, 'timeout':120} #分裂一致性组
    START_VERIFY = {'cmd':55849058312, 'timeout':120} #接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
    REMOVE_iSCSI_FROM_HOST = {'cmd':55849123841, 'timeout':120} #将iSCSI启动器从HOST移除
    REMOVE_FC_FROM_HOST = {'cmd':55849189377, 'timeout':120} #将FC启动器从HOST移除
    CREATE_REMOTE_DEVICE = {'cmd':55849254913, 'timeout':120} #创建远端设备
    ADD_FCLINK_TO_REMOTE_DEVICE = {'cmd':55849320449, 'timeout':120} #将FC链路添加给远端设备
    REMOVE_FCLINK_FROM_REMOTE_DEVICE = {'cmd':55849320450, 'timeout':120} #从远端设备移除FC链路
    SPLIT_HYPERMIRROR = {'cmd':55849385985, 'timeout':120} #分裂
    SYNCRONIZE_HYPERMIRROR = {'cmd':55849385986, 'timeout':90} #同步
    SWITCHROLE_HYPERMIRROR = {'cmd':55849385987, 'timeout':120} #主从切换
    DO_SWITCHROLE_HYPERMIRROR = {'cmd':55849385988, 'timeout':120} #强制主从切换
    MODIFY_REMOTE_REPLICATION_MEMBER_LUN = {'cmd':55849385989, 'timeout':120} #修改远程复制成员LUN属性
    GET_REMOTE_REPLICATION_MEMBER_LUN = {'cmd':55849385990, 'timeout':120} #查询远程复制成员LUN的详细信息
    GET_BATCH_NEXT_REMOTE_REPLICATION_MEMBER_LUN = {'cmd':55849385991, 'timeout':120} #批量查询远程复制成员LUN的详细信息
    GET_BATCH_NEXT_MIRROR_LUN_CANUSE = {'cmd':55849385992, 'timeout':120} #查询可以用来创建远程复制LUN(NEXT)/查询可以用来加入一致性组的Pair
    GET_BATCH_NEXT_MIRROR_LUN_DETAIL = {'cmd':55849385993, 'timeout':120} #查询远程复制成员LUN的详细信息信息
    ADD_SECONDARY_LUN = {'cmd':55849385994, 'timeout':120} #增加远程复制从LUN
    REMOVE_SENCONDARY_LUN = {'cmd':55849385995, 'timeout':120} #删除远程复制从LUN
    DO_REMOVE_SENCONDARY_LUN = {'cmd':55849385996, 'timeout':120} #强制删除远程复制从LUN
    START_VERIFY_SENCONDARY_LUN_CONF = {'cmd':55849385997, 'timeout':120} #接口中有该操作，但是目前代码中并不会用到，请东哥确认是否需要该命令字
    GET_LUNCOPY_MEMBERLUN = {'cmd':55849451521, 'timeout':120} #查询LUN Copy 成员LUN信息
    GET_BATCH_NEXT_LUNCOPY_MEMBERLUN = {'cmd':55849451522, 'timeout':120} #批量查询LUN拷贝成员LUN信息(GETBATCH)
    REMOVE_LUNCOPY_MEMBERLUN = {'cmd':55849451523, 'timeout':120} #删除LUN Copy 成员LUN
    GET_HYPERCOPY_MEMLUN_INFO = {'cmd':55849451524, 'timeout':120} #查询成员LUN信息
    GET_BATCH_NEXT_HYPERCOPY_MEMLUN_INFO = {'cmd':55849451525, 'timeout':120} #批量查询LUN拷贝成员LUN信息(GETBATCH)
    GET_BATCH_NEXT_AVAILABLE_LUNS = {'cmd':55849451526, 'timeout':120} #批量查询LUNCopy候选成员LUN
    GET_BATCH_NEXT_AVAILABLE_LUNS_BY_SOURCELUN = {'cmd':55849451527, 'timeout':120} #批量查询LUNCopy候选成员LUN
    ADD_HYPERCLONE_SLAVE = {'cmd':55849517057, 'timeout':120} #添加从Lun
    DELETE_HYPERCLONE_SLAVE_LUN = {'cmd':55849517058, 'timeout':120} #删除从Lun
    SPLIT_HYPERCLONE_SLAVE = {'cmd':55849517059, 'timeout':120} #分裂从Lun
    SYNCHRONIZE_HYPERCLONE_SLAVE = {'cmd':55849517060, 'timeout':120} #同步从Lun
    REVERSE_SYCH_HYPERCLONE_SLAVE = {'cmd':55849517061, 'timeout':120} #反向同步从Lun
    GET_BATCH_NEXT_HYPERCLONE_LUN_CANUSE = {'cmd':55849517062, 'timeout':120} #查询创建分裂镜像时需要的LUN
    GET_HYPERCLONE_LUN_DETAILS = {'cmd':55849517063, 'timeout':120} #查询分裂镜像的LUN
    GET_BATCH_NEXT_HYPERCLONE_LUN_INFO = {'cmd':55849517064, 'timeout':120} #批量查询分裂镜像的LUN（NEXT）
    SPLIT_MULTI_HYPERCLONE_SLAVE = {'cmd':55849517065, 'timeout':120} #分类多个从Lun
    MODIYF_IOCLASS_SWITCH = {'cmd':55849648129, 'timeout':120} #修改IO分类开关
    GET_IPRULE_SWITCH = {'cmd':55850041345, 'timeout':120} #查询ip规则开关状态
    MODIFY_IPRULE_SWITCH = {'cmd':55850041346, 'timeout':120} #设置IP规则
    GET_DEFAULT_LDAP_CONFIG = {'cmd':55850172417, 'timeout':120} #查询LDAP的默认属性
    CONNECT_ISCSI_TARGET = {'cmd':55850500097, 'timeout':120} #连接iSCSI链路
    DISCONNECT_ISCSI_TARGET = {'cmd':55850500098, 'timeout':120} #断开iSCSI链路
    CREATE_AND_CONNECT = {'cmd':55850500099, 'timeout':120} #创建并连接iSCSI TGT
    DISCONNECT_AND_DELETE = {'cmd':55850500100, 'timeout':120} #断开并删除iSCSI TGT
    GET_BATCH_NEXT_ISCSI_TGT = {'cmd':55850500101, 'timeout':120} #查询所有iSCSI链路目标器详细信息
    GET_ISCSI_TGT = {'cmd':55850500102, 'timeout':120} #查询iSCSI链路目标器详细信息
    MODIFY_ISCSI_TGT = {'cmd':55850500103, 'timeout':120} #修改iSCSI链路目标器信息
    GET_INACTIVE_LICENSE_HEAD = {'cmd':55850565633, 'timeout':120} #查询未激活License文件头信息
    GET_LICENSE_HEAD = {'cmd':55850565634, 'timeout':120} #查询已激活License文件头信息
    GET_INACTIVE_LICENSE = {'cmd':55850565635, 'timeout':120} #查询未激活License信息
    GET_LICENSE = {'cmd':55850565636, 'timeout':120} #查询已激活License信息
    GET_LICENSE_FUNC = {'cmd':55850565637, 'timeout':120} #批量查询License功能配置项
    GET_INACTIVE_LICENSE_FUNC = {'cmd':55850565638, 'timeout':120} #批量查询未激活License功能配置项
    GET_LICENSE_RESOURCE = {'cmd':55850565639, 'timeout':120} #批量查询License资源配置项
    GET_INACTIVE_LICENSE_RESOURCE = {'cmd':55850565640, 'timeout':120} #批量查询未激活License资源配置项
    GET_LICENSE_INFO = {'cmd':55850565641, 'timeout':120} #单个查询License使用情况
    GETBATCH_LICENSE_INFO = {'cmd':55850565642, 'timeout':120} #批量查询License使用情况
    USER_IMPORT_LICENSE = {'cmd':55850565643, 'timeout':120} #激活License
    OM_MSG_OP_GET_LICENSE_PATH = {'cmd':55850565644, 'timeout':120} #查询License导入路径
    GET_LICENSE_EXPORT_PATH = {'cmd':55850565645, 'timeout':120} #查询License导出路径
    SCAN_REMOTE_LUN = {'cmd':55850958849, 'timeout':120} #手动扫描Remote LUN
    OM_MSG_OP_LST_SYS_UPSTAT = {'cmd':56908316673, 'timeout':120} #查询集群总体以及各节点升级状态
    OM_MSG_OP_UPD_NODE_REPORT = {'cmd':56908316674, 'timeout':120} #查询集群各节点升级报告
    OM_MSG_OP_UPD_SYS_REPORT = {'cmd':56908316675, 'timeout':120} #查询集群整体升级报告
    OM_MSG_OP_UPD_PRE_TEST = {'cmd':56908316676, 'timeout':120} #集群升级预检测
    OM_MSG_OP_LST_DLD_VERPKG = {'cmd':56908316677, 'timeout':120} #通知节点下载软件升级包
    EXPANSION_AD_PROCESS = {'cmd':56908316701, 'timeout':120} #IP Scale Out扩容,启停AD模块
    EXPANSION_AD_NOTIFY = {'cmd':56908316702, 'timeout':120} #IP Scale Out扩容,下发是否扩容配置
    EXPANSION_GET_BOARDS = {'cmd':56908316703, 'timeout':120} #IP Scale Out扩容,查询框和节点
    EXPANSION_GET_ROUTE_INFO = {'cmd':56908316704, 'timeout':120} #IP Scale Out扩容,查询路由信息
    EXPANSION_AD_FORWARD = {'cmd':56908316705, 'timeout':120} #IP Scale Out扩容,AD模块转发
    READ_IP_CLUST_BASE_INFO = {'cmd':56908316706, 'timeout':120} #IP Scale Out扩容,获取基地址IP\组网类型\端口ID\交换机ID等
    MODIFY_IP_CLUST_BASE_INFO = {'cmd':56908316707, 'timeout':120} #IP Scale Out扩容,修改配置文件基本信息
    CHANGE_BMC_INFO = {'cmd':56908316708, 'timeout':120} #修改BMC信息
    SET_FILELEVEL_PRIORITIES = {'cmd':56911134721, 'timeout':120} #设置SNAS分级存储策略优先级
    GET_FILELEVEL_PRIORITIES = {'cmd':56911134722, 'timeout':120} #查询SNAS分级存储策略优先级
    TEST_SWITCH_COMM = {'cmd':56911134742, 'timeout':120} #测试交换机SNMP通信
    CLI_CMD_END = {'cmd':57176817663, 'timeout':120} #CLI专用命令字结束位置（框架不允许使用）
    GET_INTF_MODULE_STATUS = {'cmd':57176883201, 'timeout':90} #获取接口卡状态信息，专用于更换IP scale-out接口卡
    GET_ALL_PORTS_BY_INTF_SLOT = {'cmd':57176883202, 'timeout':90} #获取接口卡下的所有端口信息，专用于更换IP scale-out接口卡
    query_backupset_import_info = {'cmd':59592671232, 'timeout':120} #查询导入备份集信息
    query_backuoset_import_log = {'cmd':59592671233, 'timeout':120} #查询导入备份集日志
    sync_vm = {'cmd':59592671234, 'timeout':120} #同生产端同步虚拟机
    backup_task_cancel = {'cmd':59592671235, 'timeout':120} #备份任务取消
    sync_backup_server_ip = {'cmd':59592671236, 'timeout':120} #同步服务器的IP信息
    get_config_file = {'cmd':59592671237, 'timeout':120} #查询告警配置文件、错误码配置文件
    get_storage_usage_top = {'cmd':59592671238, 'timeout':120} #查询存储单元TOP5
    get_backup_server_status = {'cmd':59592671239, 'timeout':120} #强制刷新备份服务器状态
    repair_storage_unit = {'cmd':59592671240, 'timeout':120} #修复存储单元
    PRO_SYS_TIME_MANUAL_SYNC = {'cmd':59592671241, 'timeout':120} #在processor上手动同步系统时间
    get_local_role = {'cmd':59592671242, 'timeout':120} #获取本地服务器角色
    DELETE_SHNAPSHOT = {'cmd':59592671243, 'timeout':120} #删除快照
    get_single_CBT = {'cmd':59592671244, 'timeout':120} #查询单个备份服务器CBT状态
    set_local_CBT = {'cmd':59592671245, 'timeout':120} #设置本地CBT状态
    set_vm_CBT = {'cmd':59592671246, 'timeout':120} #设置虚拟机CBT状态
    DELETE_BITMAP = {'cmd':59592671247, 'timeout':120} #删除位图卷
    QUERY_BITMAP = {'cmd':59592671248, 'timeout':120} #查询位图卷
    DELET_SNAPSHOT_PROCESS = {'cmd':59592671249, 'timeout':120} #查询删除快照进度
    QUERY_SNAPSHOT_INFO = {'cmd':59592671250, 'timeout':120} #查询快照信息
    get_single_transMode = {'cmd':59592671251, 'timeout':120} #查询单个备份服务器传输模式
    set_local_transMode = {'cmd':59592671252, 'timeout':120} #设置本地传输模式
    NOTIFY_SERVICE_SWITCHOVER_FOR_FRU_REPLACE = {'cmd':8599150996, 'timeout':90}#主动通知阵列切换业务
    QUERY_FRU_UPD_STATUS = {'cmd':8599151052, 'timeout':90}#FRU升级状态查询
    EXC_UPD = {'cmd': 8599117931, 'timeout': CMD_DEFAULT_TIMEOUT}  # 执行命令字，根据下发参数不同执行相应的命令
    VMMS_OPCODE_VMMS_UPD = {'cmd': 55847747925, 'timeout': CMD_DEFAULT_TIMEOUT}  # 新增升级前检查项接口
    GET_IS_EXIST_URGENT_ALM_CLEARED = {'cmd': 55847747768, 'timeout': CMD_DEFAULT_TIMEOUT}  # 查询是否存在被清除的重要紧急故障告警
    OM_MSG_OP_GET_PACKAGE_INFO = {'cmd': 8599109756, 'timeout': CMD_DEFAULT_TIMEOUT}  # 获取升级包信息
    OM_MSG_OP_UPD_LIST_DETAILINFO = {'cmd': 8599150995, 'timeout': CMD_DEFAULT_TIMEOUT}  # 查询升级详细信息
    CMO_DB_EXPORT_CONFIG = {'cmd': 55847747603, 'timeout': CMD_DEFAULT_TIMEOUT}  # 导出配置文件
    GET_BATCH = {'cmd': 55834624000, 'timeout': 300}  # 轮询版本信息命令

class DaignoseCmd():
    """
    @summary: cmd:diagnose命令; checkModel检查模式（1：只检查主控；2：检查所有控制器）
    """
    IS_MEMUSEDUP = {'cmd':"sys ismemusedup", 'checkModel':2}
    IS_SAMEVER = {'cmd':"upd issameversion", 'checkModel':2}
    IS_DOUBLECTRL = {'cmd':"sys isalldoublectrl", 'checkModel':2}
    IS_SYSNORMAL = {'cmd':"sys issysnormal", 'checkModel':1}
    IS_POOLUPGRADE = {'cmd':"pmgr isallpoolcanupgrade", 'checkModel':2}
    IS_SYSBUSY = {'cmd':"sys issystembusy", 'checkModel':1}

    CHECK_BBUPOWER = {'cmd':"upg checkbbupower", 'checkModel':2}
    CHECK_DISKSLOW = {'cmd':"ld checkdiskslow", 'checkModel':1}
    CHECK_SYSCOMPATIBLE = {'cmd':"upd syscompatiblecheck", 'checkModel':2}
    CHECK_ALARM = {'cmd':"upg UrgentAlm", 'checkModel':1}
    CHECK_BLACK_WHITE_LSIT = {'cmd':"upd checkblackwhitelist", 'checkModel':2}
    CHECK_DISKUSAGE = {'cmd':"upd diskusagecheck", 'checkModel':2}
    CHECK_IOBANDWIDTH = {'cmd':"ioperf iobandwidth 5", 'checkModel':2}
    CHECK_SINGLELINK = {'cmd':"ld checksinglelink", 'checkModel':2}
    CHECK_EXTLUNLINK = {'cmd':"ld checkextlunsinglelink", 'checkModel':1}
    CHECK_FWVERINFO = {'cmd':"upg checkfwverinfo", 'checkModel':2}
    CHECK_SYSRESOURCE = {'cmd':"upd sysresourcecheck", 'checkModel':2}
    CHECK_DIAG = {'cmd':"sddebug checkdiag", 'checkModel':2}
    CHECK_VERSION = {'cmd':"upg checkversion", 'checkModel':1}
    CHECK_XNETPRESSURE = {'cmd':"xnet checkpressure", 'checkModel':2}

    SHOW_UPDATE = {'cmd':"rsf showupdate", 'checkModel':1}

#---对象参数属性---

class PublicAttributes():
    '''
    Description:硬件公共属性
    '''
    TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}           #类型
    ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}           #ID
    NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}         #名称
    PARENT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}    #父对象类型
    PARENT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}    #父对象ID
    PARENT_NAME = {"index":5, "type":restDataType.DATA_TYPE_STRING}  #父对象名称
    LOCATION = {"index":6, "type":restDataType.DATA_TYPE_STRING}     #位置
    HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}  #健康状态
    RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM} #运行状态

class PublicAttributesExtend(PublicAttributes):
    '''
    Description:对象公共属性
    '''
    DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}          #描述
    COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}           #数量
    ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}    #关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
    ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}    #对单个对象无效，仅用于查询此与关联对象有关系的对象
    ASSOCIATE_METADATA = {"index":13, "type":restDataType.DATA_TYPE_JSON}    #对单个对象无效，仅用于表示两个对象之间存在关联关系后附加的数据，如LUN与Host建立关联后，附加了一个HostLunID，此时可以在这个字段里表示。此字段必须是一个JSON对象，对象的定义根据应用的场景不同而不同
    APPLICATION = {"index":14, "type":restDataType.DATA_TYPE_STRING}         #应用
    QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}       #查询条件
    ASSOCIATE_OBJ_IDLIST = {"index":16, "type":restDataType.DATA_TYPE_ARRAY} #对单个对象无效，仅用于批量创建关联关系，如将多个硬盘一次性关联到Pool
    TENANCY_ID = {"index":17, "type":restDataType.DATA_TYPE_STRING}          #租户ID
    TENANCY_NAME = {"index":18, "type":restDataType.DATA_TYPE_STRING}        #租户名称
    SUB_TYPE = {"index":19, "type":restDataType.DATA_TYPE_UNSIGN_INT}        #对管理对象类型的子类型划分，取值由具体业务指定，比如FileSystem对象，可以划分为普通文件系统和WORM文件系统。
    OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}        #原有位置
    EXPAND_RECORD_TAG = {"index":4092, "type":restDataType.DATA_TYPE_STRING} #值固定为"_EXPANDCELL"。表示该record为扩展record
    IMPORTANT_PSW = {"index":4093, "type":restDataType.DATA_TYPE_STRING}     #重要事务的鉴权密码
    ERROR_CODE_PARAM = {"index":4094, "type":restDataType.DATA_TYPE_STRING}  #错误码参数,逗号分割的字符串（涉及逗号转义的方式和告警保持一致）
    ERROR_CODE = {"index":4095, "type":restDataType.DATA_TYPE_UNSIGN_INT}    #错误码

class Hardware():
    class NotifyServiceSwitchover():
        TYPE = {"index":1, "type":restDataType.DATA_TYPE_ENUM}           #类型
        ID = {"index":2, "type":restDataType.DATA_TYPE_STRING}

    class Enclosure(PublicAttributes):
        '''
        Description: 机框
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        MODEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#型号
        LOGIC_TYPE = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#类型
        TEMPERATURE = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度
        SERIAL_NUM = {"index":68, "type":restDataType.DATA_TYPE_STRING}#序列号
        MAC_ADDRESS = {"index":69, "type":restDataType.DATA_TYPE_STRING}#MAC地址
        HEIGHT = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#高度
        EXPANDER_DEPTH = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#级联深度
        EXPANDER_PORT = {"index":72, "type":restDataType.DATA_TYPE_STRING}#SAS域或FC环路
        SWITCH = {"index":73, "type":restDataType.DATA_TYPE_ENUM}#定位灯状态
        SOFT_VER = {"index":76, "type":restDataType.DATA_TYPE_STRING}#Firmware版本
        CPU_USAGE = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#CPU占用率
        MEMORY_USAGE = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#内存使用率
        CHASSIS_PACKAGE_TYPE = {"index":79, "type":restDataType.DATA_TYPE_ENUM}#节点类型
        ELABEL = {"index":80, "type":restDataType.DATA_TYPE_STRING}#电子标签


    class Controller(PublicAttributes):
        '''
        Description: 控制器
        '''
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#
        SOFT_VER = {"index":64, "type":restDataType.DATA_TYPE_STRING}#Firmware版本
        TEMPERATURE = {"index":65, "type":restDataType.DATA_TYPE_SIGN_INT}#温度
        IS_MASTER = {"index":66, "type":restDataType.DATA_TYPE_BOOL}#主备状态
        ELABEL = {"index":67, "type":restDataType.DATA_TYPE_STRING}#电子标签
        PCB_VER = {"index":68, "type":restDataType.DATA_TYPE_STRING}#PCB版本
        SES_VER = {"index":69, "type":restDataType.DATA_TYPE_STRING}#SES版本
        BMC_VER = {"index":70, "type":restDataType.DATA_TYPE_STRING}#BMC版本
        LOGIC_VER = {"index":71, "type":restDataType.DATA_TYPE_STRING}#逻辑版本
        BIOS_VER = {"index":72, "type":restDataType.DATA_TYPE_STRING}#BIOS版本
        ALL_TEMPERATURE = {"index":73, "type":restDataType.DATA_TYPE_ARRAY}#所有温度
        MEMORY_SIZE = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Cache大小
        CPU_INFO = {"index":75, "type":restDataType.DATA_TYPE_STRING}#CPU信息
        ROLE = {"index":76, "type":restDataType.DATA_TYPE_ENUM}#
        CPU_USAGE = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#CPU占用率
        MEMORY_USAGE = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#内存使用率
        VOLTAGE = {"index":79, "type":restDataType.DATA_TYPE_UNSIGN_INT}#电压值
        LIGHT_STATUS = {"index":80, "type":restDataType.DATA_TYPE_ENUM}#定位灯状态
        DIRTY_DATA_RATE = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#脏页面的占用率
        MULT_MODE = {"index":82, "type":restDataType.DATA_TYPE_BOOL}#是否支持多工作模式
        RUN_MODE = {"index":83, "type":restDataType.DATA_TYPE_ENUM}#工作模式
        RUN_MODE_LIST = {"index":84, "type":restDataType.DATA_TYPE_ARRAY}#支持的工作模式列表
        SALES_ELABEL = {"index":85, "type":restDataType.DATA_TYPE_STRING}#销售电子标签
        INTER_IP = {"index":86, "type":restDataType.DATA_TYPE_JSON}#控制器内部IP地址，CLI使用。
        INNER_ID = {"index":87, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        SERVICE_STATUS = {"index":88, "type":restDataType.DATA_TYPE_ENUM}

    class Expboard(PublicAttributes):
        '''
        Description: 级联板
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        MODEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#型号
        LOGIC_VER = {"index":65, "type":restDataType.DATA_TYPE_STRING}#逻辑版本
        PCB_VER = {"index":66, "type":restDataType.DATA_TYPE_STRING}#PCB版本 
        SES_VER = {"index":67, "type":restDataType.DATA_TYPE_STRING}#SES版本
        ELABEL = {"index":68, "type":restDataType.DATA_TYPE_STRING}#电子标签
        VOLTAGE = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#电压值
        LIGHT_STATUS = {"index":70, "type":restDataType.DATA_TYPE_ENUM}#定位灯

    class IntfModule(PublicAttributes):
        '''
         Description: 接口模块
         '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        MODEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#型号
        ELABEL = {"index":65, "type":restDataType.DATA_TYPE_STRING}#电子标签
        LOGIC_VER = {"index":66, "type":restDataType.DATA_TYPE_STRING}#逻辑版本
        PCB_VER = {"index":67, "type":restDataType.DATA_TYPE_STRING}#PCB版本
        TEMPERATURE = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度值
        LIGHT_STATUS = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        MULT_MODE = {"index":70, "type":restDataType.DATA_TYPE_BOOL}#是否支持多工作模式
        RUN_MODE = {"index":71, "type":restDataType.DATA_TYPE_ENUM}#工作模式
        RUN_MODE_LIST = {"index":72, "type":restDataType.DATA_TYPE_ARRAY}#支持的工作模式列表
        WHETHER_SWITCH_BUSINESS = {"index":73, "type":restDataType.DATA_TYPE_BOOL}#下电前是否切换业务

    class Disk(PublicAttributes):
        '''
        Description: 硬盘
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        DISK_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#硬盘类型
        SECTORS = {"index":65, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#扇区数量
        BANDWIDTH = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接口带宽
        SECTOR_SIZE = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#扇区大小
        SPEED_RPM = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#转速
        TEMPERATURE = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度
        MODEL = {"index":70, "type":restDataType.DATA_TYPE_STRING}#型号
        FIRMWARE_VER = {"index":71, "type":restDataType.DATA_TYPE_STRING}#固件版本号
        MANUFACTURER = {"index":72, "type":restDataType.DATA_TYPE_STRING}#生产厂商
        SERIAL_NUMBER = {"index":73, "type":restDataType.DATA_TYPE_STRING}#序列号
        LIGHT_STATUS = {"index":74, "type":restDataType.DATA_TYPE_ENUM}#
        LOGIC_TYPE = {"index":75, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        POOL_ID = {"index":76, "type":restDataType.DATA_TYPE_STRING}#所属POOL
        POOL_NAME = {"index":77, "type":restDataType.DATA_TYPE_STRING}#所属POOL名称
        POOL_TIER_ID = {"index":78, "type":restDataType.DATA_TYPE_STRING}#所属Pool的Tier层
        IS_COFFER_DISK = {"index":79, "type":restDataType.DATA_TYPE_BOOL}#是否保险箱盘
        RUN_TIME = {"index":80, "type":restDataType.DATA_TYPE_UNSIGN_INT}#运行天数
        PROGRESS = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#重构、回拷、预拷贝、销毁等的进度
        NCQ_SWITCH = {"index":82, "type":restDataType.DATA_TYPE_BOOL}#磁盘类型相关的全局配置，磁盘Native Command Queuing 开关
        UNPLUG = {"index":83, "type":restDataType.DATA_TYPE_UNSIGN_INT}#全局配置，磁盘调优参数
        WRITE_CACHE_SWITCH = {"index":84, "type":restDataType.DATA_TYPE_BOOL}#全局配置
        PRE_COPY_SWITCH = {"index":85, "type":restDataType.DATA_TYPE_BOOL}#全局配置
        START_LBA = {"index":86, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        LEN = {"index":87, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        BST_TYPE = {"index":88, "type":restDataType.DATA_TYPE_ENUM}#logic/physic
        BADTIME = {"index":89, "type":restDataType.DATA_TYPE_SIGN_INT}#故障时间
        BADTYPE = {"index":90, "type":restDataType.DATA_TYPE_UNSIGN_INT}#类型
        SENSEKEY = {"index":91, "type":restDataType.DATA_TYPE_UNSIGN_INT}#sensekey
        SENSECODE = {"index":92, "type":restDataType.DATA_TYPE_UNSIGN_INT}#sensecode
        FRU = {"index":93, "type":restDataType.DATA_TYPE_UNSIGN_INT}#fru
        BARCODE = {"index":94, "type":restDataType.DATA_TYPE_STRING}#编码
        BADRATE = {"index":95, "type":restDataType.DATA_TYPE_UNSIGN_INT}#坏盘率
        CAPACITY_USAGE = {"index":96, "type":restDataType.DATA_TYPE_UNSIGN_INT}#容量利用率
        MULTI_PATH = {"index":97, "type":restDataType.DATA_TYPE_ARRAY}#
        HEALTH_MARK = {"index":98, "type":restDataType.DATA_TYPE_UNSIGN_INT}#硬盘的健康评分
        INVALID_TIME = {"index":99, "type":restDataType.DATA_TYPE_TIME}#发生故障时间
        DISK_IFTYPE = {"index":100, "type":restDataType.DATA_TYPE_ENUM}#硬盘接口类型
        DISK_FORM = {"index":101, "type":restDataType.DATA_TYPE_ENUM}#硬盘外形尺寸
        DISK_PORT_ADDR = {"index":102, "type":restDataType.DATA_TYPE_STRING}#对于不同接口的硬盘该值不同： FC:为FC PortWWN SAS：为SAS Addrees，16位十六进制数 SATA：该字段为空
        SMART_CACHE_POOL_ID = {"index":103, "type":restDataType.DATA_TYPE_STRING}#所属SmartCache的ID
        BST_NUM = {"index":104, "type":restDataType.DATA_TYPE_UNSIGN_INT}#BST数量
        ABRASION_RATE = {"index":105, "type":restDataType.DATA_TYPE_UNSIGN_INT}#磨损度
        REMAIN_LIFE = {"index":106, "type":restDataType.DATA_TYPE_UNSIGN_INT}#剩余寿命
        FORMAT_PROGRESS = {"index":107, "type":restDataType.DATA_TYPE_UNSIGN_INT}#格式化进度
        FORMAT_REMAIN_TIME = {"index":108, "type":restDataType.DATA_TYPE_UNSIGN_INT}#格式化剩余时间
        AUTO_LOCK_STATUS = {"index":109, "type":restDataType.DATA_TYPE_BOOL}#盘AK开启状态
        SED_STATE = {"index":110, "type":restDataType.DATA_TYPE_ENUM}#
        ENCRYPT_DISK_TYPE = {"index":111, "type":restDataType.DATA_TYPE_ENUM}#
        STORAGE_ENGINE_ID = {"index":112, "type":restDataType.DATA_TYPE_STRING}#存储引擎ID
        ITEM = {"index":113, "type":restDataType.DATA_TYPE_STRING}#硬盘的BOM号
        ELECTRONIC_LABEL = {"index":114, "type":restDataType.DATA_TYPE_STRING}#电子标签

    class Power(PublicAttributes):
        '''
        Description: 电源模块
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        TEMPERATURE = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度
        POWER_TYPE = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#电源类型
        INPUT_VOLTAGE = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#输入电压
        OUTPUT_VOLTAGE = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#输出电压
        MANUFACTURER = {"index":68, "type":restDataType.DATA_TYPE_STRING}#生产厂商
        MODEL = {"index":69, "type":restDataType.DATA_TYPE_STRING}#型号
        VERSION = {"index":70, "type":restDataType.DATA_TYPE_STRING}#版本号
        PRODUCE_DATE = {"index":71, "type":restDataType.DATA_TYPE_STRING}#生产日期
        SERIAL_NUMBER = {"index":72, "type":restDataType.DATA_TYPE_STRING}#序列号
        LIGHT_STATUS = {"index":73, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        RATED_POWER = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#额定功率
        TOTAL_OUTPUT_POWER = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#电源总功耗
        BUNDLE_ID = {"index":76, "type":restDataType.DATA_TYPE_STRING}#一体化硬件的槽位号的ID
        BOM_CODE = {"index":77, "type":restDataType.DATA_TYPE_STRING}#电源模块BOM编码

    class BackupPower(PublicAttributes):
        '''
        Description: 备电模块
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        BACKUP_POWER_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#
        VOLTAGE = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#当前电压
        REMAIN_LIFE_DAYS = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#剩余寿命
        CHARGE_TIMES = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#放电次数
        FIRMWARE_VER = {"index":68, "type":restDataType.DATA_TYPE_STRING}#Firmware版本
        ELABEL = {"index":69, "type":restDataType.DATA_TYPE_STRING}#电子标签
        MANUFACTURED_DATE = {"index":70, "type":restDataType.DATA_TYPE_STRING}#出厂日期
        CONTROLLER_ID = {"index":71, "type":restDataType.DATA_TYPE_STRING}#控制器ID
        LIGHT_STATUS = {"index":72, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        BUNDLE_ID = {"index":73, "type":restDataType.DATA_TYPE_STRING}#一体化硬件的槽位号的ID

    class Fan(PublicAttributes):
        '''
        Description: 风扇
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        RUN_LEVEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#运行档位
        ELABEL = {"index":65, "type":restDataType.DATA_TYPE_STRING}#电子标签
        LIGHT_STATUS = {"index":66, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        MANUFACTURER = {"index":67, "type":restDataType.DATA_TYPE_STRING}#厂家信息
        MODEL = {"index":68, "type":restDataType.DATA_TYPE_STRING}#型号
        SERIAL_NUMBER = {"index":69, "type":restDataType.DATA_TYPE_STRING}#序列号
        VERSION = {"index":70, "type":restDataType.DATA_TYPE_STRING}#版本号
        ELEMENT_NAME = {"index":71, "type":restDataType.DATA_TYPE_STRING}#类型+id（槽位置）
        IDENTIFYING_NUMBER = {"index":72, "type":restDataType.DATA_TYPE_STRING}#可选，可用序列号
        VENDOR = {"index":73, "type":restDataType.DATA_TYPE_STRING}#生产厂商（集成厂商）
        BUNDLE_ID = {"index":74, "type":restDataType.DATA_TYPE_STRING}#一体化硬件的槽位号的ID

    class FanCtrlModule(PublicAttributes):
        '''
        Description: 风扇控制模块
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ELABEL = {"index":65, "type":restDataType.DATA_TYPE_STRING}#电子标签
        PCB_VER = {"index":66, "type":restDataType.DATA_TYPE_STRING}#PCB版本

    class EthPortRoute(PublicAttributes):
        '''
        Description: 路由信息
        '''
        PORT_ID = {"index":0, "type":restDataType.DATA_TYPE_STRING}#端口ID
        DESTINATION = {"index":1, "type":restDataType.DATA_TYPE_STRING}#目的地址
        MASK = {"index":2, "type":restDataType.DATA_TYPE_STRING}#掩码
        GATEWAY = {"index":3, "type":restDataType.DATA_TYPE_STRING}#网关
        TYPE = {"index":4, "type":restDataType.DATA_TYPE_ENUM}#类型

    class FcPort(PublicAttributes):
        '''
        Description: FC 端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        RUN_SPEED = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#运行速率
        CONF_SPEED = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#配置速率
        WWN = {"index":67, "type":restDataType.DATA_TYPE_STRING}#WWN
        INI_OR_TGT = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#启动器/目标器
        SFP_STATUS = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#光模块状态
        FC_CONF_MODE = {"index":70, "type":restDataType.DATA_TYPE_ENUM}#配置模式
        FC_RUN_MODE = {"index":71, "type":restDataType.DATA_TYPE_ENUM}#运行模式
        LOST_SIGNALS = {"index":73, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Loss of Signal,类型错误数目
        BAD_CHAR_NUMBER = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Bad RX Char类型错误数目 
        LOST_SYNC = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Loss of Sync类型错误数目
        LINK_FAIL = {"index":76, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Link Fail,类型错误数目   
        START_TIME = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}# 起始时间
        FLOGIN_DELAY_TIMES = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        MAX_SUPPORT_SPEED = {"index":79, "type":restDataType.DATA_TYPE_UNSIGN_INT}#最大支持速率
        LIGHT_STATUS = {"index":80, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        ULTRAPATH_SWITCH = {"index":81, "type":restDataType.DATA_TYPE_ENUM}#多路径切换标志
        FAST_WRITE_SUPPORTED = {"index":82, "type":restDataType.DATA_TYPE_UNSIGN_INT}#是否支持FC立即数
        FAST_WRITE_ENABLE = {"index":83, "type":restDataType.DATA_TYPE_UNSIGN_INT}#FC立即数开关
        FAST_WRITE_BURST_LEN = {"index":84, "type":restDataType.DATA_TYPE_UNSIGN_INT}#FC立即数传输IO大小
        PORT_SWITCH = {"index":85, "type":restDataType.DATA_TYPE_BOOL}#
        MAX_SPEED = {"index":86, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#最大工作速率

    class BondPort(PublicAttributes):
        '''
        Description: 绑定端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        PORT_IDLIST = {"index":64, "type":restDataType.DATA_TYPE_ARRAY}#
        MTU = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#MTU
        USED_TYPE = {"index":66, "type":restDataType.DATA_TYPE_ENUM}#端口的使用类型
        DEVICE_NAME = {"index":67, "type":restDataType.DATA_TYPE_STRING}#端口的设备名称
        PORT_FILTER = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#端口作用过滤器

    class EthPort(PublicAttributes):
        '''
        Description: ETH端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        MAC_ADDRESS = {"index":65, "type":restDataType.DATA_TYPE_STRING}#MAC地址
        INI_OR_TGT = {"index":66, "type":restDataType.DATA_TYPE_ENUM}#启动器/目标器
        ETH_DUPLEX = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#双工模式
        ETH_NEGOTIATE = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#自协商模式
        MTU = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#MTU
        BOND_NAME = {"index":70, "type":restDataType.DATA_TYPE_STRING}#绑定名称
        IPV4_ADDR = {"index":71, "type":restDataType.DATA_TYPE_STRING}#IPv4地址
        IPV4_MASK = {"index":72, "type":restDataType.DATA_TYPE_STRING}#IPv4掩码
        IPV4_GATEWAY = {"index":73, "type":restDataType.DATA_TYPE_STRING}#IPv4网关
        IPV6_ADDR = {"index":74, "type":restDataType.DATA_TYPE_STRING}#IPv6地址
        IPV6_MASK = {"index":75, "type":restDataType.DATA_TYPE_STRING}#IPv6掩码
        IPV6_GATEWAY = {"index":76, "type":restDataType.DATA_TYPE_STRING}#IPv6网管
        ISCSI_TCP_PORT = {"index":77, "type":restDataType.DATA_TYPE_STRING}#iSCSI端口号
        ISCSI_NAME = {"index":78, "type":restDataType.DATA_TYPE_STRING}#iSCSI名称
        ERROR_PACKETS = {"index":80, "type":restDataType.DATA_TYPE_UNSIGN_INT}#错误包数
        LOST_PACKETS = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#丢失包数
        OVERFLOWED_PACKETS = {"index":82, "type":restDataType.DATA_TYPE_UNSIGN_INT}#溢出包数
        START_TIME = {"index":83, "type":restDataType.DATA_TYPE_UNSIGN_INT}#统计起始时间
        SPEED = {"index":84, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        LIGHT_STATUS = {"index":85, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        ULTRAPATH_SWITCH = {"index":86, "type":restDataType.DATA_TYPE_ENUM}#多路径切换标志
        VLAN = {"index":87, "type":restDataType.DATA_TYPE_STRING}#VLAN的ID
        SELECT_TYPE = {"index":88, "type":restDataType.DATA_TYPE_ENUM}#查询类型
        MAX_SPEED = {"index":89, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#以太网口支持的最大速度，最大工作速率
        PROTOCOL_IFTYPE = {"index":90, "type":restDataType.DATA_TYPE_ENUM}#
        ZONE_ID = {"index":91, "type":restDataType.DATA_TYPE_STRING}#zone ID
        DSW_ID = {"index":92, "type":restDataType.DATA_TYPE_STRING}#交换机 ID
        DSW_LINK_RIGHT = {"index":93, "type":restDataType.DATA_TYPE_STRING}#端口与交换机链接状态
        INTERFACE_MODEL_TYPE = {"index":94, "type":restDataType.DATA_TYPE_ENUM}#接口卡类型
        BOND_ID = {"index":95, "type":restDataType.DATA_TYPE_STRING}#绑定端口ID
        USED_TYPE = {"index":96, "type":restDataType.DATA_TYPE_ENUM}#端口的使用类型
        DEVICE_NAME = {"index":97, "type":restDataType.DATA_TYPE_STRING}#端口的设备名称
        PORT_SWITCH = {"index":98, "type":restDataType.DATA_TYPE_BOOL}#
        PORT_USAGE = {"index":99, "type":restDataType.DATA_TYPE_ENUM}#端口的用途
        PORT_FILTER = {"index":100, "type":restDataType.DATA_TYPE_ENUM}#端口作用过滤器
        OWNING_CONTROLLER = {"index":101, "type":restDataType.DATA_TYPE_STRING}#端口归属控制器
        SHARE_TYPE = {"index":102, "type":restDataType.DATA_TYPE_ENUM}#端口的共享类型

    class FcoePort(PublicAttributes):
        '''
        Description: FCoE 端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        RUN_SPEED = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#运行速率
        WWN = {"index":66, "type":restDataType.DATA_TYPE_STRING}#WWN
        INI_OR_TGT = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#启动器/目标器
        SFP_STATUS = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#光模块状态
        ERROR_PACKETS = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#错误包数
        LOST_PACKETS = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#丢失包数
        OVERFLOWED_PACKETS = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#溢出包数
        START_TIME = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#统计起始时间
        ULTRAPATH_SWITCH = {"index":73, "type":restDataType.DATA_TYPE_ENUM}#多路径切换标志
        VLAN_ID = {"index":74, "type":restDataType.DATA_TYPE_SIGN_INT}#vlanID
        PORT_SWITCH = {"index":75, "type":restDataType.DATA_TYPE_BOOL}#
        MAX_SPEED = {"index":76, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#最大工作速率

    class SasPort(PublicAttributes):
        '''
        Description: SAS端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        RUN_SPEED = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#运行速率
        WWN = {"index":66, "type":restDataType.DATA_TYPE_STRING}#WWN
        INI_OR_TGT = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#启动器/目标器
        PORT_SWITCH = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#
        INVALID_DWORD = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#无效DWORD数
        DISPARITY_ERROR = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#一致性错误数
        LOSS_DWORD = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#丢失DWORD同步数
        _PHYRESET_ERRORS = {"index":73, "type":restDataType.DATA_TYPE_UNSIGN_INT}#PHY reset 失败数
        START_TIME = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#开始统计时间
        CURRENT_PEER_PORT_ID = {"index":75, "type":restDataType.DATA_TYPE_STRING}#当前连接的对端端口ID
        SUGGEST_PEER_PORT_ID = {"index":76, "type":restDataType.DATA_TYPE_STRING}#应该连接的对端端口ID
        LIGHT_STATUS = {"index":77, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        IS_MINI_SAS = {"index":78, "type":restDataType.DATA_TYPE_BOOL}#
        ENABLE_BUFFER = {"index":79, "type":restDataType.DATA_TYPE_BOOL}#设置12G SAS Buffer开关状态 
        ENCLOSURE_WWNLIST = {"index":80, "type":restDataType.DATA_TYPE_STRING}#指定SAS端口下连接的所有硬盘框wwn列表
        CHANNEL_NUMBER = {"index":81, "type":restDataType.DATA_TYPE_STRING}#通道数
        MAX_SPEED = {"index":82, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#最大工作速率

    class IbPort(PublicAttributes):
        '''
        Description: IB端口
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型
        RUN_SPEED = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#运行速率
        WWN = {"index":67, "type":restDataType.DATA_TYPE_STRING}#WWN
        INI_OR_TGT = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#启动器/目标器
        PORT_SWITCH = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#端口开关
        SYMBOL_ERROR_COUNTER = {"index":73, "type":restDataType.DATA_TYPE_UNSIGN_INT}#符号错误统计
        LINK_ERROR_RECOVERY_COUNTER = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#连接错误恢复数据统计
        PORT_RCV_ERRORS = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#端口接收错误
        PORT_RCV_REMOTE_PHYSICAL_ERRORS = {"index":76, "type":restDataType.DATA_TYPE_UNSIGN_INT}#端口远程接收错误   
        PORT_RCV_SWITCH_RELAY_ERRORS = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#端口接收转发错误
        PORT_XMIT_CONSTRAINT_ERRORS = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#未被switch端口发送的包计数
        PORT_RCV_CONSTRAINT_ERRORS = {"index":79, "type":restDataType.DATA_TYPE_UNSIGN_INT}#端口接收强制错误
        LOCAL_LINK_INTEGRITY_ERRORS = {"index":80, "type":restDataType.DATA_TYPE_UNSIGN_INT}#本地连接错误
        EXCESSIVE_BUFFER_OVERRUN_ERRORS = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#buffer溢出错误
        START_TIME = {"index":82, "type":restDataType.DATA_TYPE_UNSIGN_INT}# 起始时间
        MAX_SPEED = {"index":83, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#最大工作速率

    class SerialPort(PublicAttributes):
        '''
        Description: 串口
        '''
        LOGIC_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#逻辑类型

    class PciePort(PublicAttributes):
        '''
        Description: PCIE端口
        '''
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        PCIE_SPEED = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#PCIE链路数据速率
        CURRENT_PEER_PORT_ID = {"index":65, "type":restDataType.DATA_TYPE_STRING}#当前连接的对端端口ID
        SUGGEST_PEER_PORT_ID = {"index":66, "type":restDataType.DATA_TYPE_STRING}#应该链接的对端端口ID
        LOST_SIGNALS = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#PCIE端口误码数量
        PORT_SWITCH = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#端口开或关
        LIGHT_STATUS = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#定位灯
        ECRC_ERROR = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#ECRC错误数 
        BAD_TLP = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#坏TLP个数
        BAD_DLLP = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#坏DLLP个数
        RECV_ERROR = {"index":73, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接收器错误个数
        CHIP_ECC_ERROR = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#芯片ECC错误个数
        START_TIME = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#开始统计时间
        DSW_ID = {"index":76, "type":restDataType.DATA_TYPE_UNSIGN_INT}#当前连接的PCIE交换机平面号
        DSW_PORT_INDEX = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#当前连接的PCIE交换机上端口的下标
        CTRL_ID = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#端口所在控制器ID
        SUGGEST_ENGINE_ID = {"index":79, "type":restDataType.DATA_TYPE_UNSIGN_INT}#当前连接的PCIE交换机上端口对应的引擎ID
        MAX_SPEED = {"index":80, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#最大工作速率

    class CmdOnly():
        '''
        Description: 仅具有命令字的操作
        '''
        ENABLE = {"index":0, "type":restDataType.DATA_TYPE_BOOL}#

    class Memory():
        '''
        Description: 内存
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#对象类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#内存编号
        PARENT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}#控制器
        PARENT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#控制器ID
        SN = {"index":64, "type":restDataType.DATA_TYPE_STRING}#内存序列号
        CAPACITY = {"index":65, "type":restDataType.DATA_TYPE_SIGN_INT}#容量
        VENDOR = {"index":66, "type":restDataType.DATA_TYPE_STRING}#厂商

    class Cpu(PublicAttributes):
        '''
        Description: CPU
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#对象类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#对象ID
        PARENT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}#控制器
        PARENT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#控制器ID
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#健康状态
        CORE_TEMP = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#核心温度
        VOLTS = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#核心电压
        E_CCERROR = {"index":66, "type":restDataType.DATA_TYPE_STRING}#ECC错误
        WORK_FREQUENCY = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CURRENT_FREQUENCY = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        FREQUENCY_SWITCH = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#
        CORE_NUM = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#核心数
        MODEL = {"index":71, "type":restDataType.DATA_TYPE_STRING}#型号
        CACHE_SIZE = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#cache大小
        TEMP_STATUS = {"index":73, "type":restDataType.DATA_TYPE_ENUM}#温度状态

    class SfpOpticalTransceiver(PublicAttributes):
        '''
        Description: 光模块
        '''
        OLD_LOCATION = {"index":20, "type":restDataType.DATA_TYPE_STRING}#
        SFP_MODE_TYPE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#单模/多模
        WAVE_LENGTH = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#波长
        RX_POWER = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接收功率
        TX_POWER = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#发送功率
        SPEED = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#速率
        TEMPERATURE = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#温度
        VOLTAGE = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#电压
        VENDOR = {"index":71, "type":restDataType.DATA_TYPE_STRING}#
        MODEL = {"index":72, "type":restDataType.DATA_TYPE_STRING}#
        SN = {"index":73, "type":restDataType.DATA_TYPE_STRING}#

    class Bay(PublicAttributes):
        '''
        Description: 机架
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#对象类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#对象ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#
        LOCATION = {"index":6, "type":restDataType.DATA_TYPE_STRING}#
        MODEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#MODEL
        NEW_ID = {"index":65, "type":restDataType.DATA_TYPE_STRING}#
        CTRL_TOTAL = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        IS_IPSCALE_OUT = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#

    class DiskScanTask(PublicAttributes):
        '''
        Description: 硬盘扫描
        '''
        PROGRESS = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#进度
        REMAIN_TIME = {"index":66, "type":restDataType.DATA_TYPE_STRING}#剩余时间
        SCAN_SCOPE = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#扫描范围
        SCAN_OBJ_LIST = {"index":69, "type":restDataType.DATA_TYPE_ARRAY}#
        SCAN_ERROR = {"index":70, "type":restDataType.DATA_TYPE_ENUM}#扫描不通过的原因

    class IbInitiator(PublicAttributes):
        '''
        Description: IB启动器（主机端口）
        '''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#
        IS_FREE = {"index":64, "type":restDataType.DATA_TYPE_BOOL}#是否空闲
        MULTI_PATH_TYPE = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#多路径类型


    class BmcInfoDefine():
        FLAG = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}


#####原有遗留class####
class Uri():
    TLV_COMMUNICATION = "ToolkitRequest/TLVCommunication"
class ErrorInfo:
    CODE = {"index":"code", "type":restDataType.DATA_TYPE_STRING}
    DESCRIPTION = {"index":"description", "type":restDataType.DATA_TYPE_STRING}
class ExportData():
    EXPORT_DATA_TYPE = {"index":"exportDataType", "type":restDataType.DATA_TYPE_ENUM}
    NODE_ID = {"index":"nodeId", "type":restDataType.DATA_TYPE_STRING}
    CMO_EXPORT_DB_TYPE = {"index":"CMO_EXPORT_DB_TYPE", "type":restDataType.DATA_TYPE_ENUM}
    CMO_EXPORT_DRIVE_ID = {"index":"CMO_EXPORT_DRIVE_ID", "type":restDataType.DATA_TYPE_ENUM}
class OperationLog():
    OPER_TYPE = {"index":"operType", "type":restDataType.DATA_TYPE_UNSIGN_32INT}
    FILE_TYPE = {"index":"fileType", "type":restDataType.DATA_TYPE_ENUM}
    FILE_NAME = {"index":"fileName", "type":restDataType.DATA_TYPE_STRING}
    RETURN_VALUE = {"index":"retValue", "type":restDataType.DATA_TYPE_UNSIGN_32INT}
    NODE_ID = {"index":"nodeId", "type":restDataType.DATA_TYPE_STRING}


#---对象参数枚举---

'''
Description: (公共)系统管理
'''
class MagBoardUpgrade():
    '''
    Description: 查询管理板升级状态
    '''
    TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}
    LOCATION = {"index":6, "type":restDataType.DATA_TYPE_STRING}
    
    ISUPDSUCC = {"index":7, "type":restDataType.DATA_TYPE_BOOL}


class Upgrade():
    class BmcInfoDefine():
        FLAG = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    class NotifyExcUpgrade():
        CMO_EXE_UPD_MSGTYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXE_UPD_NIDLIST = {"index": 1, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_ACTIVETYPE = {"index": 2, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXE_UPD_BAKPATH = {"index": 3, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXENODETYPE = {"index": 4, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEFLOW = {"index": 5, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEFLOWSEGMENT = {"index": 6, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_EXEATOM = {"index": 7, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_SYNCPAR = {"index": 8, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXE_UPD_PKG_TYPE = {"index": 9, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_RESULT = {"index": 10, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_ERROR_INFO = {"index": 11, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_EXC_DIAG_CMD = {"index": 12, "type": restDataType.DATA_TYPE_STRING}
        CMO_EXC_CHECK_MODEL = {"index": 13, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    class UpgradeDisk():
        CMO_UPGRADE_MODE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPGRADE_DISKS = {"index": 4, "type": restDataType.DATA_TYPE_STRING}
        CMO_UPGRADE_TYPE = {"index": 5, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    class QueryDiskUpgradeProgress():
        CMO_UPGRADE_MODE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPGRADE_DISKS = {"index": 4, "type": restDataType.DATA_TYPE_STRING}
        CMO_UPGRADE_TYPE = {"index": 5, "type": restDataType.DATA_TYPE_UNSIGN_INT}


    # 查询整体升级状态
    class LstSysProgress():
        CMO_UPD_SYS_MODE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_ID = {"index": 1, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_REMAINTIME = {"index": 2, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_TASK_STATUS = {"index": 3, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_STEP_PERCENT = {"index": 4, "type": restDataType.DATA_TYPE_UNSIGN_32INT}

    class RecordParam():
        RECORD_NODE_ID = {"index": 0, "type": restDataType.DATA_TYPE_STRING}
        RECORD_RESULT = {"index": 1, "type": restDataType.DATA_TYPE_STRING}

    class GetPackageUploadPath():
        CMO_PACKAGE_TYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_PACKAGE_DIR_FILE = {"index": 1, "type": restDataType.DATA_TYPE_STRING}
        CMO_PACKAGE_SIZE = {"index": 2, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    class NotifyPackagePath():
        CMO_NOTIFY_PACKAGE_PATH = {"index": 0, "type": restDataType.DATA_TYPE_STRING}

    # 查询升级详细信息
    class UpdListDetaiInfo():
        NAME_KEY = {"index": 0, "type": restDataType.DATA_TYPE_STRING}
        ITEM_STATE = {"index": 1, "type": restDataType.DATA_TYPE_STRING}
        ERROY_KEY = {"index": 2, "type": restDataType.DATA_TYPE_STRING}
        NODE_ID = {"index": 3, "type": restDataType.DATA_TYPE_STRING}

    class UpdLstSysProgress():
        CMO_UPD_SYS_MODE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPD_SYS_STEP_ID = {"index": 1, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_REMAINTIME = {"index": 2, "type": restDataType.DATA_TYPE_UNSIGN_32INT}
        CMO_UPD_SYS_STEP_TASK_STATUS = {"index": 3, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_UPD_SYS_STEP_STEP_PERCENT = {"index": 4, "type": restDataType.DATA_TYPE_UNSIGN_32INT}

    class LstVer():
        CMO_VER_PACKAGE_TYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_RESULT = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_CUR_VERSION = {"index": 4, "type": restDataType.DATA_TYPE_STRING}
        CMO_VER_SAVED_VERSION = {"index": 5, "type": restDataType.DATA_TYPE_STRING}
        CMO_VER_CUR_VERSION_SUPPORT_MODE = {"index": 8, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_CUR_VERSION_SUPPORT_PAUSE = {"index": 9, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_VER_SHIELD_ALARM = {"index": 10, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    class ExportConfig():
        CMO_EXPORT_DB_TYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        CMO_EXPORT_DB_DATA_DIR = {"index": 2, "type": restDataType.DATA_TYPE_STRING}

    class OperationLog():
        OPER_TYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        FILE_TYPE = {"index": 1, "type": restDataType.DATA_TYPE_UNSIGN_INT}
        RET_VALUE = {"index": 3, "type": restDataType.DATA_TYPE_UNSIGN_INT}

    # 查询License导出路径
    class LicenseExportPath():
        CMO_LICENSE_DIR_INFO_DIR = {"index": 0, "type": restDataType.DATA_TYPE_STRING}

    # 查询升级包信息
    class PackageInfo():
        CMO_PACKAGE_TYPE = {"index": 0, "type": restDataType.DATA_TYPE_UNSIGN_INT}  # 升级包类型
        CMO_PACKAGE_NODE_ID = {"index": 1, "type": restDataType.DATA_TYPE_UNSIGN_INT}  # 节点ID
        CMO_PACKAGE_INNER_VERSION = {"index": 2, "type": restDataType.DATA_TYPE_STRING}  # 系统软件内部版本号
        CMO_PACKAGE_SPC_VERSION = {"index": 6, "type": restDataType.DATA_TYPE_STRING}  # 系统软件外部版本号

    # 新增升级前检查项接口
    class VmmsUpd():
        VMMS_UPD_TYPE = {"index": 64, "type": restDataType.DATA_TYPE_UNSIGN_INT}  # 升级包类型
        VMMS_CTRL_ID = {"index": 65, "type": restDataType.DATA_TYPE_STRING}  # 控制器ID
        VMMS_VM_STATUS = {"index": 66, "type": restDataType.DATA_TYPE_UNSIGN_INT}  # 虚拟机状态
        VMMS_UPD_ISINNER = {"index": 67, "type": restDataType.DATA_TYPE_UNSIGN_INT}  # 节点ID

    class UrgentAlmCleared():
        CMO_ALARM_LOCATION = {"index": 13, "type": restDataType.DATA_TYPE_UNSIGN_INT}  #
        URGENT_ALM_RESULT = {"index": 71, "type": restDataType.DATA_TYPE_STRING}


class Sys():
    class System():
        '''
        Description: 系统信息
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}
        LOCATION = {"index":6, "type":restDataType.DATA_TYPE_STRING}
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#
        PRODUCT_MODE = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#产品型号
        PRODUCT_VERSION = {"index":65, "type":restDataType.DATA_TYPE_STRING}#产品版本号
        DOMAIN_NAME = {"index":66, "type":restDataType.DATA_TYPE_STRING}#归属域
        HIGH_WATER_LEVEL = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#高水位
        LOW_WATER_LEVEL = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#低水位
        CACHE_WRITE_QUOTA = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Cache写配额
        MEMBER_DISKS_CAPACITY = {"index":70, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        HOT_SPARE_DISKS_CAPACITY = {"index":71, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        FREE_DISKS_CAPACITY = {"index":72, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        UNAVAILABLE_DISKS_CAPACITY = {"index":73, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        STORAGE_POOL_RAW_CAPACITY = {"index":74, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        STORAGE_POOL_CAPACITY = {"index":75, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        STORAGE_POOL_USED_CAPACITY = {"index":76, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        STORAGE_POOL_FREE_CAPACITY = {"index":77, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        STORAGE_POOL_HOST_SPARE_CAPACITY = {"index":78, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        THICKLUNS_ALLOCATE_CAPACITY = {"index":79, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        THICKLUNS_USED_CAPACITY = {"index":80, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        THINLUNS_MAX_CAPACITY = {"index":81, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        THINLUNS_ALLOCATE_CAPACITY = {"index":82, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        THINLUNS_USED_CAPACITY = {"index":83, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        SECTOR_SIZE = {"index":84, "type":restDataType.DATA_TYPE_UNSIGN_INT}#扇区大小
        VASA_SUPPORT_BLOCK = {"index":85, "type":restDataType.DATA_TYPE_STRING}#支持的块访问接口类型
        VASA_SUPPORT_FILESYSTEM = {"index":86, "type":restDataType.DATA_TYPE_STRING}#支持的文件系统接口类型
        VASA_ALTERNATE_NAME = {"index":87, "type":restDataType.DATA_TYPE_STRING}#阵列别名
        VASA_SUPPORT_PROFILE = {"index":88, "type":restDataType.DATA_TYPE_STRING}#支持的配置文件类型
        WWN = {"index":89, "type":restDataType.DATA_TYPE_STRING}#WWN
        ENABLE_MULTI_TENANT = {"index":90, "type":restDataType.DATA_TYPE_BOOL}#是否启用多租户模式
        MIN_NUMBER_NEEDED = {"index":91, "type":restDataType.DATA_TYPE_UNSIGN_INT}#最小可用节点数
        MAX_NUMBER_SUPPORTED = {"index":92, "type":restDataType.DATA_TYPE_UNSIGN_INT}#最大可用节点数
        WRITE_THROUGH_SW = {"index":93, "type":restDataType.DATA_TYPE_BOOL}#单控转透开关
        WRITE_THROUGH_TIME = {"index":94, "type":restDataType.DATA_TYPE_UNSIGN_INT}#透写超时时间
        TOTAL_CAPACITY = {"index":95, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#系统总容量
        USED_CAPACITY = {"index":96, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#系统已用容量
        CONFIG_MODEL = {"index":101, "type":restDataType.DATA_TYPE_ENUM}#配置型号
        MAPPED_LUNS_COUNT_CAPACITY = {"index":102, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        UN_MAPPED_LUNS_COUNT_CAPACITY = {"index":103, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        VASA__RPO_RANGE = {"index":104, "type":restDataType.DATA_TYPE_STRING}#
        USER_FREE_CAPACITY = {"index":105, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#系统可用容量
        PATCH_VERSION = {"index":106, "type":restDataType.DATA_TYPE_STRING}#补丁版本号
        SYS_DISK_AVG_REMAIN_LIFE = {"index":107, "type":restDataType.DATA_TYPE_UNSIGN_INT}#系统的盘的平均剩余寿命
        SYS_DISK_TOTAL_USAGE_DATE = {"index":108, "type":restDataType.DATA_TYPE_UNSIGN_INT}#系统的盘总使用时间
        SYS_DISK_REMAIN_USAGE_DATE = {"index":109, "type":restDataType.DATA_TYPE_UNSIGN_INT}#系统的盘剩余使用时间

    class NotifyEnum():
        '''
        Description: 通知上报
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#

    class Alarm():
        '''
        Description: 上报告警
        '''
        CMO_ALARM_TYPE = {"index":0, "type":restDataType.DATA_TYPE_SIGN_INT}#告警类型/查询规则
        CMO_ALARM_ID = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#告警标识/起始告警流水号
        CMO_ALARM_LEVEL = {"index":2, "type":restDataType.DATA_TYPE_ENUM}#告警级别/查询告警级别
        CMO_ALARM_SEQUENCE = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#告警流水号/告警起始时间
        CMO_ALARM_TIME = {"index":4, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#告警发生时间/结束时间
        CMO_ALARM_CLEAR_TIME = {"index":5, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#告警清除时间
        CMO_ALARM_RECOVERY_TIME = {"index":6, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#告警恢复时间
        CMO_ALARM_CLEAR_USER_NAME = {"index":7, "type":restDataType.DATA_TYPE_STRING}#告警清除用户名
        CMO_ALARM_PARMETER = {"index":8, "type":restDataType.DATA_TYPE_STRING}#告警(事件)参数
        CMO_ALARM_COUNT = {"index":9, "type":restDataType.DATA_TYPE_UNSIGN_INT}#网管一次查询的数量<=1000条
        CMO_ALARM_STATUS = {"index":10, "type":restDataType.DATA_TYPE_ENUM}#告警的状态
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        ALARM_CONFIRM_USER = {"index":64, "type":restDataType.DATA_TYPE_STRING}#告警确认人(user id)
        ALARM_CONFIRM_TIME = {"index":65, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#告警确认时间
        ALARM_OBJ_TYPE = {"index":66, "type":restDataType.DATA_TYPE_ENUM}#告警来源对象类型
        ALARM_OBJ_ID = {"index":67, "type":restDataType.DATA_TYPE_STRING}#告警来源对象ID
        USER_ID = {"index":68, "type":restDataType.DATA_TYPE_STRING}#用户ID，仅在操作日志查询时有意义
        ALARM_STATE = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#告警状态
        ROOT_CAUSE_SEQUENCE = {"index":70, "type":restDataType.DATA_TYPE_ARRAY}#根因告警流水号。例如：[sequence1, sequence2]
        URGENT_ALM_RESULT = {"index":71, "type":restDataType.DATA_TYPE_STRING}#

    class Email():
        '''
        Description: 告警Email
        '''
        CMO_EMAIL_SMTP_SERVER = {"index":0, "type":restDataType.DATA_TYPE_STRING}#SMTP服务ip地址（IPV4/IPV6共用）
        CMO_EMAIL_SENDER = {"index":1, "type":restDataType.DATA_TYPE_STRING}#发件人
        CMO_EMAIL_NEED_SMTP_CHECK = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#是否需要SMTP验证
        CMO_EMAIL_NEED_SEND = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#是否发送
        CMO_EMAIL_SMTP_USER_NAME = {"index":5, "type":restDataType.DATA_TYPE_STRING}#身份验证用户名
        CMO_EMAIL_SMTP_USER_PASSWD = {"index":6, "type":restDataType.DATA_TYPE_STRING}#身份验证密码
        CMO_EMAIL_RECEIVER = {"index":7, "type":restDataType.DATA_TYPE_STRING}#接收Email地址列表
        CMO_EMAIL_SSL = {"index":8, "type":restDataType.DATA_TYPE_UNSIGN_INT}#是否使用SSL连接
        CMO_EMAIL_SMTP_SERVER_PORT = {"index":9, "type":restDataType.DATA_TYPE_UNSIGN_INT}#SMTP端口号
        CMO_EMAIL_SMTP_SEND_LANGUAGE = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#告警语言的选择
        CMO_EMAIL_CHECK_SERVERCERT = {"index":11, "type":restDataType.DATA_TYPE_UNSIGN_INT}#认证邮件服务端证书
        NEW_RECIPIENT_EMAIL = {"index":12, "type":restDataType.DATA_TYPE_STRING}#告警通知收件人新邮箱
        ALARM_SEVERITY_LIST = {"index":13, "type":restDataType.DATA_TYPE_ARRAY}#告警通知级别
        OLD_RECIPIENT_EMAIL = {"index":14, "type":restDataType.DATA_TYPE_STRING}#告警通知收件人原邮箱
        CMO_EMAIL_SUBJECT = {"index":15, "type":restDataType.DATA_TYPE_STRING}#告警通知邮件标题前缀
        SHOW_ALARM_SEVERITY_FOR_ALARM_TITLE = {"index":16, "type":restDataType.DATA_TYPE_ENUM}#邮件标题是否显示告警级别

    class AlarmSms():
        '''
        Description: 告警短信
        '''
        CMO_SMS_NEED_SEND = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#是否发送
        CMO_SMS_SEND_COUNTRY = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#发送国家
        CMO_SMS_RECEIVER = {"index":3, "type":restDataType.DATA_TYPE_STRING}#接收短信号码
        CMO_SMS_SERVICE_CENTRE = {"index":4, "type":restDataType.DATA_TYPE_STRING}#短信服务中心号码，国家编码+手机号码
        CMO_SMS_SEND_LANGUAGE = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#告警语言的选择码
        NEW_RECIPIENT_PHONE_NUMBER = {"index":6, "type":restDataType.DATA_TYPE_STRING}#告警通知收件人新号码
        ALARM_SEVERITY_LIST = {"index":7, "type":restDataType.DATA_TYPE_ARRAY}#告警通知级别
        OLD_RECIPIENT_PHONE_NUMBER = {"index":8, "type":restDataType.DATA_TYPE_STRING}#告警通知收件人原号码

    class AlarmRestore():
        '''
        Description: 告警转储
        '''
        CMO_ALARM_RESTORE_ENABLE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#自动转储使能
        CMO_ALARM_RESTORE_ADDRESS = {"index":1, "type":restDataType.DATA_TYPE_STRING}#IP地址
        CMO_ALARM_RESTORE_VISUALPATH = {"index":2, "type":restDataType.DATA_TYPE_STRING}#转储的FTP路径
        CMO_ALARM_RESTORE_ACCOUNT = {"index":3, "type":restDataType.DATA_TYPE_STRING}#用户
        CMO_ALARM_RESTORE_PASSWD = {"index":4, "type":restDataType.DATA_TYPE_STRING}#密码
        CMO_ALARM_RESTORE_PROTOCOL = {"index":5, "type":restDataType.DATA_TYPE_ENUM}#协议

    class ClearExportData():
        '''
        Description: 清除数据
        '''
        EXPORT_DATA_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#需要清除的数据的类型
        NODE_ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#

    class RemoteAlarm():
        '''
        Description: 远程告警
        '''
        CMO_HEALTH_WATCH_INFO_ENABLE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#远程告警发送开关
        CMO_HEALTH_WATCH_INFO_PERIOD = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#远程告警发送周期

    class SyslogInfo():
        '''
        Description: SYSLOG
        '''
        OM_MSG_OP_SET_ALARM_SYSLOG_CFG = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#开关
        CMO_ALARM_SYSLOG_SEVERITY = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#发送级别
        CMO_ALARM_SYSLOG_SERVER_IP = {"index":2, "type":restDataType.DATA_TYPE_STRING}#日志服务器IP
        CMO_SYSLOG_ALARM_ENABLE = {"index":3, "type":restDataType.DATA_TYPE_BOOL}#告警发送开关
        CMO_SYSLOG_ALARM_RECOVERY_ENABLE = {"index":4, "type":restDataType.DATA_TYPE_BOOL}#告警恢复开关
        CMO_SYSLOG_EVENT_ENABLE = {"index":5, "type":restDataType.DATA_TYPE_BOOL}#事件开关
        WHETHER_SEND_DEVICE_NAME = {"index":6, "type":restDataType.DATA_TYPE_BOOL}#是否发送设备名称

    class PerformanceMapping():
        '''
        Description: 统计对象类型与统计数据映射
        '''
        CMO_STATISTIC_OBJECT_ID = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#统计对象类型ID
        CMO_STATISTIC_DATA_ID = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#统计数据ID
        CMO_STATISTIC_TIME_SPAN = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#统计时段
        CMO_STATISTIC_MIN_PERIOD = {"index":3, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#统计最小周期

    class PerformanceStatistic():
        '''
        Description: 性能统计
        '''
        CMO_STATISTIC_UUID = {"index":0, "type":restDataType.DATA_TYPE_STRING}#指定统计对象的UUID
        CMO_STATISTIC_DATA_ID = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#指定统计数据ID
        CMO_STATISTIC_TIME_SPAN = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计粒度，
        CMO_STATISTIC_DATA = {"index":3, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能值
        CMO_STATISTIC_TIMESTAMP = {"index":4, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#时间戳
        SKIP_SWITCH = {"index":5, "type":restDataType.DATA_TYPE_BOOL}#
        START_TIME = {"index":6, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        END_TIME = {"index":7, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        CMO_STATISTIC_DATA_ID_LIST = {"index":8, "type":restDataType.DATA_TYPE_STRING}#统计数据ID列表
        CMO_STATISTIC_DATA_LIST = {"index":9, "type":restDataType.DATA_TYPE_STRING}#性能值列表

    class PerformanceStatisticSwitch():
        '''
        Description: 性能统计开关
        '''
        CMO_PERFORMANCE_SWITCH = {"index":0, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计开关
        CMO_PERFORMANCE_BEGIN_TIME = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计开始时间
        CMO_PERFORMANCE_END_TIME = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计开始时间

    class PerformanceData():
        '''
        Description: 性能数据
        '''
        CMO_EXPORT_PERF_OBJECT_ID = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#统计对象类型ID
        CMO_EXPORT_PERF_TIME_SPAN = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#统计的采样周期
        CMO_EXPORT_PERF_ADDRESS = {"index":2, "type":restDataType.DATA_TYPE_STRING}#导出的路径

    class PerformanceAlarmThreshold():
        '''
        Description: 性能告警阈值
        '''
        OBJ_TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        CMO_THRESHOLD_PARAMID = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计参数
        CMO_THRESHOLD_ATTRID = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#统计对象属性
        CMO_THRESHOLD_VALUE = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#性能告警阈值

    class PeformanceStatisticStrategy():
        '''
        Description: 性能统计策略
        '''
        CMO_STATISTIC_INTERVAL = {"index":0, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#实时性能数据收集时间间隔
        CMO_STATISTIC_ARCHIVE_SWITCH = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计数据文件存档开关
        CMO_STATISTIC_ARCHIVE_TIME = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计数据文件保存间隔，V200R001仅提供接口，不提供设置界面，值只允许与实时性能数据收集时间间隔值一致
        CMO_STATISTIC_AUTO_STOP = {"index":3, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计自动停止开关，V200R001目前只允许取值为1
        CMO_STATISTIC_MAX_TIME = {"index":4, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#性能统计采集天数

    class PerformanceStatisticFile():
        '''
        Description: 性能统计数据文件
        '''
        CMO_STATISTIC_FILE = {"index":0, "type":restDataType.DATA_TYPE_STRING}#设备性能统计数据文件
        CMO_FILE_UPDATE_TIME = {"index":1, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#文件最后更新时间
        CMO_FILE_UPDATE_SIZE = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#设备性能统计数据文件大小
        CMO_FILE_NODE_ID = {"index":3, "type":restDataType.DATA_TYPE_STRING}#查询条件中节点ID
        CMO_FILE_START_TIME = {"index":4, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#查询条件中文件更新起始时间
        CMO_FILE_END_TIME = {"index":5, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#查询条件中文件更新结束时间
        CMO_FILE_TAG = {"index":6, "type":restDataType.DATA_TYPE_STRING}#查询条件中标签信息
        CMO_FILE_NUM = {"index":7, "type":restDataType.DATA_TYPE_UNSIGN_INT}#查询历时性能统计文件个数
        CMO_KEY_WORDS = {"index":8, "type":restDataType.DATA_TYPE_STRING}#关键字段过滤

    class PerfDataRestore():
        '''
        Description: 性能统计数据自动转储信息
        '''
        CMO_STATISTIC_RESTORE_ENABLE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#自动转储使能
        CMO_STATISTIC_RESTORE_ADDRESS = {"index":1, "type":restDataType.DATA_TYPE_STRING}#FTP IP地址
        CMO_STATISTIC_RESTORE_VISUALPATH = {"index":2, "type":restDataType.DATA_TYPE_STRING}#转储的FTP路径
        CMO_STATISTIC_RESTORE_ACCOUNT = {"index":3, "type":restDataType.DATA_TYPE_STRING}#用户
        CMO_STATISTIC_RESTORE_PASSWD = {"index":4, "type":restDataType.DATA_TYPE_STRING}#密码
        CMO_STATISTIC_RESTORE_PROTOCOL = {"index":5, "type":restDataType.DATA_TYPE_ENUM}#协议

    class PowerConsumption():
        '''
        Description: 系统能耗
        '''
        START_TIME = {"index":0, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#起始时间
        TIME_TYPE = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#统计类型
        TIME_STAMP = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#UTC时间戳
        POWER_CONSUMPTION_VALUE = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#能耗值

    class LicenseInfo():
        '''
        Description: License信息
        '''
        CMO_LICENSE_ESN = {"index":0, "type":restDataType.DATA_TYPE_STRING}#硬件设备序列号或唯一的软件序列号
        CMO_LICENSE_SERVICE_AUTH_TYPE = {"index":1, "type":restDataType.DATA_TYPE_STRING}#授权类型
        CMO_LICENSE_SWM_TIME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#软件维护截止日期
        CMO_LICENSE_HWM_TIME = {"index":3, "type":restDataType.DATA_TYPE_STRING}#硬件维护截止日期
        CMO_LICENSE_SFUPDATE_TIME = {"index":4, "type":restDataType.DATA_TYPE_STRING}#软件免费升级截止日期
        CMO_LICENSE_VERSION = {"index":5, "type":restDataType.DATA_TYPE_STRING}#产品的版本信息
        CMO_LICENSE_LIBVER = {"index":6, "type":restDataType.DATA_TYPE_STRING}#License文件的格式版本
        CMO_LICENSE_COMMENT = {"index":7, "type":restDataType.DATA_TYPE_STRING}#包含与产品相关的一些注释信息
        CMO_IS_TEMP_LICENSE = {"index":8, "type":restDataType.DATA_TYPE_BOOL}#是否临时license文件

    class LicenseFuncConfigitem():
        '''
        Description: License功能配置项
        '''
        CMO_LICENSE_FEATURE_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#Feature 的名称
        CMO_LICENSE_TRIAL_TIME = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#总试用天数
        CMO_LICENSE_RUN_TIME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#运行截止日期
        CMO_LICENSE_FUNC = {"index":3, "type":restDataType.DATA_TYPE_STRING}#功能配置信息的名称
        CMO_LICENSE_FUNC_SWITCH = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#功能配置开关
        CMO_LICENSE_FUNC_FEATURE_ID = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#License特性ID

    class LicenseResConfigitem():
        '''
        Description: License资源配置项
        '''
        CMO_LICENSE_FEATURE_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#Feature 的名称
        CMO_LICENSE_TRIAL_TIME = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#总试用天数
        CMO_LICENSE_RUN_TIME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#运行截止日期
        CMO_LICENSE_RESOURCE = {"index":3, "type":restDataType.DATA_TYPE_STRING}#资源配置项的名称
        CMO_LICENSE_RESOURCE_NUM = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#资源配置项允许的个数
        CMO_LICENSE_FUNC_FEATURE_ID = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#License特性ID
        CMO_LICENSE_RESOURCE_UNIT = {"index":6, "type":restDataType.DATA_TYPE_ENUM}#

    class LicenseFileHead():
        '''
        Description: License文件头信息
        '''
        CMO_LICENSE_HEAD_COPYRIGHT = {"index":0, "type":restDataType.DATA_TYPE_STRING}#版权信息
        CMO_LICENSE_HEAD_SERIALNO = {"index":1, "type":restDataType.DATA_TYPE_STRING}#文件生成序列号
        CMO_LICENSE_HEAD_CREATOR = {"index":2, "type":restDataType.DATA_TYPE_STRING}#文件创建者
        CMO_LICENSE_HEAD_CREATEDTIME = {"index":3, "type":restDataType.DATA_TYPE_STRING}#创建时间
        CMO_LICENSE_HEAD_COUNTRY = {"index":4, "type":restDataType.DATA_TYPE_STRING}#所在国家
        CMO_LICENSE_HEAD_CUSTOM = {"index":5, "type":restDataType.DATA_TYPE_STRING}#运营商名称
        CMO_LICENSE_HEAD_OFFICE = {"index":6, "type":restDataType.DATA_TYPE_STRING}#所在地区

    class LicenseFileUsage():
        '''
        Description: License使用情况
        '''
        CMO_LICENSE_INFO_FEATURE_ID = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#License特性ID
        CMO_LICENSE_INFO_STATUS = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#License的状态
        CMO_LICENSE_INFO_OPEN_STATUS = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#Licnese打开状态
        CMO_LICENSE_INFO_LEFT_TIME = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#时间限制
        CMO_LICENSE_INFO_RESOURCE_LIMIT = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#资源数限制
        CMO_LINCENS_INFO_TOTAL = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#全部License数目
        CMO_CMO_LINCENS_INFO_USAGE = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#已用License数目
        CMO_LICENSE_INFO_UNIT = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#

    class LicensePath():
        '''
        Description: License导入路径
        '''
        CMO_LICENSE_DIR_INFO_DIR = {"index":0, "type":restDataType.DATA_TYPE_STRING}#License导入路径

    class ExportConfigData():
        '''
        Description: 配置
        '''
        CMO_EXPORT_DB_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#导出方式
        CMO_EXPORT_DRIVE_ID = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#硬盘编号
        CMO_EXPORT_DB_DATA_DIR = {"index":2, "type":restDataType.DATA_TYPE_STRING}#导出路径

    class ExportRunningData():
        '''
        Description: 运行数据
        '''
        CMO_SYSTEM_CONFIG_DIR = {"index":0, "type":restDataType.DATA_TYPE_STRING}#

    class ImportConfigData():
        '''
        Description: 设备配置导入路径
        '''
        CMO_IMPORT_DB_CONFIG_DIR = {"index":0, "type":restDataType.DATA_TYPE_STRING}#配置导入的路径 

    class ConfigItem():
        '''
        Description: 配置项
        '''
        CMO_INI_SECTION_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#段名
        CMO_INI_ITEM_NAME = {"index":1, "type":restDataType.DATA_TYPE_STRING}#配置项名
        CMO_INI_ITEM_VALUE = {"index":2, "type":restDataType.DATA_TYPE_STRING}#配置项值

    class ExportAllLog():
        '''
        Description: 信息打包
        '''
        CMO_EXPORT_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#导出类型
        CMO_EXPORT_PATH = {"index":1, "type":restDataType.DATA_TYPE_STRING}#导出的路径
        CMO_EXPORT_RESULT = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#导出结果
        CMO_NODE_ID = {"index":3, "type":restDataType.DATA_TYPE_STRING}#
        CMO_EXPORT_SINGLE_NID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#单节点导出ID
        CMO_EXPORT_SINGLE_FILE_GETED = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#单控节点文件是否取走
        CMO_EXPORT_SINGLE_RESULT = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#单控文件导出结果
        CMO_DOWNLOAD_SINGLE_PKG_PATH = {"index":7, "type":restDataType.DATA_TYPE_STRING}#单控文件路径(IP+路径)
        CMO_EXPORT_PROGRESS = {"index":8, "type":restDataType.DATA_TYPE_UNSIGN_INT}#打包收集文件进度
        ENCRYPT_PASSWORD = {"index":9, "type":restDataType.DATA_TYPE_STRING}#压缩/解压文件包使用的密码
        CMO_CUSTOM_CONFIG_ITEMS = {"index":10, "type":restDataType.DATA_TYPE_JSON}#自定义导入导出项
        CMO_EXPORTING_TIME = {"index":11, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#所耗时间 单位：秒

    class OemInfo():
        '''
        Description: OEM厂商信息
        '''
        CMO_OEM_MANUFACTORY_INFO = {"index":0, "type":restDataType.DATA_TYPE_STRING}#产商信息
        CMO_OEM_BRAND_INFO = {"index":1, "type":restDataType.DATA_TYPE_STRING}#品牌信息
        CMO_OEM_PRODUCT_MODEL = {"index":2, "type":restDataType.DATA_TYPE_STRING}#产品型号信息

    class ClientInfo():
        '''
        Description: 客户信息
        '''
        CMO_CLIENT_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#维护中心地址信息

    class SystemTimezone():
        '''
        Description: 系统时区
        '''
        CMO_SYS_TIME_ZONE_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#时区名称
        CMO_SYS_TIME_ZONE = {"index":1, "type":restDataType.DATA_TYPE_STRING}#时区
        CMO_SYS_TIME_ZONE_NAME_STYLE = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#时区名称的显示风格
        CMO_SYS_TIME_ZONE_USE_DST = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#此时区是否使用了夏令时

    class SystemUtcTime():
        '''
        Description: 系统本地时间
        '''
        CMO_SYS_UTC_TIME = {"index":0, "type":restDataType.DATA_TYPE_SIGN_INT}#UTC时间

    class SystemDstConfig():
        '''
        Description: 夏令时配置
        '''
        CMO_SYS_DST_CONF_TIME_ZONE_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#时区名称
        CMO_SYS_DST_CONF_DATE_TIME_BEGIN = {"index":1, "type":restDataType.DATA_TYPE_STRING}#系统当前时区夏令时起始日期时间
        CMO_SYS_DST_CONF_DATE_TIME_END = {"index":2, "type":restDataType.DATA_TYPE_STRING}#系统当前时区夏令时结束日期时间
        CMO_SYS_DST_CONF_ADJUST_TIME = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#夏令时调整时间
        CMO_SYS_DST_CONF_MODE = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#夏令时的配置方式 

    class NtpClientConfig():
        '''
        Description: NTP客户端配置
        '''
        CMO_SYS_NTP_CLNT_CONF_SWITCH = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#NTP服务开启状态 默认为关闭"
        CMO_SYS_NTP_CLNT_CONF_SERVER_IP = {"index":1, "type":restDataType.DATA_TYPE_STRING}#NTP服务器IP
        CMO_SYS_NTP_SYNC_PERIOD = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#同步时间周期

    class SftpUser():
        '''
        Description: SFTP用户信息
        '''
        CMO_SFTP_USER_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户类型
        CMO_SFTP_USER_NAME = {"index":1, "type":restDataType.DATA_TYPE_STRING}#用户名
        CMO_SFTP_USER_PASSWORD = {"index":2, "type":restDataType.DATA_TYPE_STRING}#密码
        CMO_SFTP_USER_OLD_PASSWORD = {"index":3, "type":restDataType.DATA_TYPE_STRING}#旧密码

    class SnmpConfig():
        '''
        Description: SNMP配置信息
        '''
        CMO_SNMP_ADDRESS = {"index":0, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SNMP_PORT = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CMO_SYS_ROOTOID = {"index":2, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SYS_DESC = {"index":3, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SYSS_OBJID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SNMP_NODE_CODE = {"index":5, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SNMP_NODE_TYPE = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CMO_SNMP_CONTEXTNAME = {"index":7, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SNMP_ENGINEBOOTS = {"index":8, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CMO_SNMP_SNMPV1_V2_C_STATUS = {"index":9, "type":restDataType.DATA_TYPE_ENUM}#

    class SnmpCommunity():
        '''
        Description: SNMP团体字
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#团体字ID
        CMO_SNMP_RDCOMMUNITY = {"index":64, "type":restDataType.DATA_TYPE_STRING}#
        CMO_SNMP_WRCOMMUNITY = {"index":65, "type":restDataType.DATA_TYPE_STRING}#

    class SnmpUsm():
        '''
        Description: 安全名
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#同安全用户名
        CMO_USM_USER = {"index":64, "type":restDataType.DATA_TYPE_STRING}#
        CMO_USM_PASSWD = {"index":65, "type":restDataType.DATA_TYPE_STRING}#
        CMO_USM_ISDEFAULT = {"index":66, "type":restDataType.DATA_TYPE_BOOL}#
        CMO_USM_AUTH_PROT = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#USM用户鉴权协议类型 目前枚举和9000的定义有冲突，暂不基线。"
        CMO_USM_PRIV_PROT = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#USM数据加密协议类型 目前枚举和9000的定义有冲突，暂不基线。"
        CMO_USM_PRIV_PASSWD = {"index":69, "type":restDataType.DATA_TYPE_STRING}#数据加密密码
        CMO_USM_USER_LEVEL = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#USM用户级别

    class SnmpTrapAddr():
        '''
        Description: Trap地址
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#Trap 标识
        CMO_TRAP_VERSION = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#
        CMO_TRAP_SERVER_IP = {"index":65, "type":restDataType.DATA_TYPE_STRING}#
        CMO_TRAP_SERVER_PORT = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CMO_TRAP_SERVER_TYPE = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#
        CMO_TRAP_USM_USER_NAME = {"index":68, "type":restDataType.DATA_TYPE_STRING}#USM用户名

    class DhaPolicy():
        '''
        Description: DHA策略
        '''
        CMO_START_TIME = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#采集开始时间
        CMO_CPU_USE_RATE = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#CPU使用阈值
        CMO_MEMORY_USE_RATE = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#内存使用阈值
        CMO_TIMING_RETRY = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#定时采集重试次数
        CMO_EXCEPT_RETRY = {"index":4, "type":restDataType.DATA_TYPE_UNSIGN_INT}#异常采集延时时间
        CMO_TIMING_DELAY = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#定时采集延时时间
        CMO_EXCEPT_DELAY = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#异常采集延时时间
        CMO_TASK_CYCLE = {"index":7, "type":restDataType.DATA_TYPE_UNSIGN_INT}#单次任务最大采集时间
        CMO_COLLECT_CYCLE = {"index":8, "type":restDataType.DATA_TYPE_UNSIGN_INT}#采集周期
        CMO_FILES_SPACE = {"index":9, "type":restDataType.DATA_TYPE_UNSIGN_INT}#采集数据占用最大空间

    class DhaPolicySwitch():
        '''
        Description: DHA策略
        '''
        CMO_DHA_SERVICE_STATUS = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#HAD服务启停状态


    class DhaExport():
        '''
        Description: DHA策略
        '''
        CMO_DHA_EXPORT_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#导出状态
        CMO_DHA_EXPORT_PATH = {"index":1, "type":restDataType.DATA_TYPE_STRING}#导出路径

    class DhaLastResult():
        '''
        Description: 
        '''
        TASK_TYPE = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        TASK_STATUS = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        TASK_EXECUTION_RESULT = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#

    class DhaSingleTaskSwitch():
        '''
        Description: 
        '''
        SWITCH = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#

    class BackDb():
        '''
        Description: BACK_DB
        '''
        PRODUCT = {"index":0, "type":restDataType.DATA_TYPE_STRING}#
        VERSION = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        SAVE_TIME = {"index":2, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#

    class DbVersion():
        '''
        Description: BACK_DB
        '''
        VERSION = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        MODIFY_TIME = {"index":1, "type":restDataType.DATA_TYPE_TIME}#

    class Service():
        '''
        Description: service
        '''
        NODE_ID = {"index":0, "type":restDataType.DATA_TYPE_STRING}#
        NAME = {"index":1, "type":restDataType.DATA_TYPE_STRING}#
        PID = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        STATUS = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        MEMORY = {"index":4, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#
        CPU = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CONNECTED_CLIENTS = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#

    class User():
        '''
        Description: 用户
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#用户ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#用户名
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#用户描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户数
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联的对象，比如USER
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#关联对象的ID
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        TENANCY_ID = {"index":17, "type":restDataType.DATA_TYPE_STRING}#
        LEVEL = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#级别
        PASSWORD = {"index":65, "type":restDataType.DATA_TYPE_STRING}#密码（传输的是明文）
        OLD_PASSWORD = {"index":66, "type":restDataType.DATA_TYPE_STRING}#旧密码
        ADDRESS_INFO = {"index":67, "type":restDataType.DATA_TYPE_STRING}#登录客户端的IP地址或串口特定字符串
        SESSION_KEY = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#登录时获取的用户SessionKey
        USER_STATE_IS_ONLINE = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#用户是否在线
        CREATE_TIME = {"index":70, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#创建时间
        SCOPE = {"index":71, "type":restDataType.DATA_TYPE_ENUM}#本地用户或者域用户
        USER_GROUP_NAME = {"index":72, "type":restDataType.DATA_TYPE_STRING}#用户组名称
        EMAIL = {"index":73, "type":restDataType.DATA_TYPE_STRING}#邮箱地址
        PWD_CHANGE_TIME = {"index":74, "type":restDataType.DATA_TYPE_TIME}#上一次密码更新时间
        TOKEN = {"index":75, "type":restDataType.DATA_TYPE_STRING}#
        ACCOUNT_STATE = {"index":76, "type":restDataType.DATA_TYPE_ENUM}#帐号当前状态
        LOGINLOG = {"index":77, "type":restDataType.DATA_TYPE_BOOL}#
        LEVEL_GROUP_TYPE = {"index":78, "type":restDataType.DATA_TYPE_ENUM}#级别所归属的组的类型
        LOCK_STATUS = {"index":79, "type":restDataType.DATA_TYPE_ENUM}#是否锁定
        LAST_LOGIN_TIME = {"index":80, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#用户上一次登录时间
        LAST_LOGIN_IP = {"index":81, "type":restDataType.DATA_TYPE_STRING}#用户上一次登录客户端IP
        ADMIN_PASSWORD = {"index":82, "type":restDataType.DATA_TYPE_STRING}#
        IS_SAVING_LOG_INFO = {"index":83, "type":restDataType.DATA_TYPE_BOOL}#
        DEST_PORT_LIFIP = {"index":84, "type":restDataType.DATA_TYPE_STRING}#登录业务口或管理口的逻辑IP地址
        MM_USER_SCENE = {"index":85, "type":restDataType.DATA_TYPE_ENUM}#机机用户应用场景：1：设备管理2：SystemReporter 3：SNMP 4：远程复制 5：SVP系统控制台"

    class Usergroup():
        '''
        Description: 用户组
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#用户组ID，默认情况下超级管理员组不可见
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#用户组名
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#用户描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户数
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        CREATE_TIME = {"index":64, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#创建时间
        LEVEL = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#

    class IpRule():
        '''
        Description: 访问控制列表
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#规则ID
        SECURE_IP = {"index":64, "type":restDataType.DATA_TYPE_STRING}#IP白名单
        STRATEGY = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#规则策略
        ENABLE = {"index":66, "type":restDataType.DATA_TYPE_BOOL}#安全规则开关

    class LdapConfig():
        '''
        Description: LDAP配置
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        SERVER_IP = {"index":64, "type":restDataType.DATA_TYPE_STRING}#逗号分隔的LDAP服务器IP，最多4个IP
        PORT = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#LDAP服务端口
        DIRECTORY_TYPE = {"index":66, "type":restDataType.DATA_TYPE_ENUM}#LDAP目录类型
        TRANSFER_TYPE = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#底层通讯协议类型
        BIND_DN = {"index":68, "type":restDataType.DATA_TYPE_STRING}#查询LDAP中数据时需要鉴权时的绑定目录
        BIND_PASSWD = {"index":69, "type":restDataType.DATA_TYPE_STRING}#查询密码
        USER_SEARCH_PATH = {"index":70, "type":restDataType.DATA_TYPE_STRING}#用户信息所在的LDAP目录地址
        GROUP_SEARCH_PATH = {"index":71, "type":restDataType.DATA_TYPE_STRING}#用户组信息所在的LDAP目录地址
        USER_ID_ATTR = {"index":72, "type":restDataType.DATA_TYPE_STRING}#LDAP中的用户id属性
        USER_NAME_ATTR = {"index":73, "type":restDataType.DATA_TYPE_STRING}#LDAP中的用户名属性
        GROUP_NAME_ATTR = {"index":74, "type":restDataType.DATA_TYPE_STRING}#LDAP中的用户组属性名
        GROUP_MEMBER_ATTR = {"index":75, "type":restDataType.DATA_TYPE_STRING}#LDAP中的组成员属性名
        USER_OBJECT_CLASS = {"index":76, "type":restDataType.DATA_TYPE_STRING}#LDAP中用户节点中使用的ObjectClass
        GROUP_OBJECT_CLASS = {"index":77, "type":restDataType.DATA_TYPE_STRING}#LDAP中组节点中使用的ObjectClass
        BASE_DN = {"index":78, "type":restDataType.DATA_TYPE_STRING}#查询LDAP中数据时的起始目录
        PASSWORD_HASH = {"index":79, "type":restDataType.DATA_TYPE_STRING}#指定密码哈希方法 
        GROUP_ID_ATTR = {"index":80, "type":restDataType.DATA_TYPE_STRING}#LDAP中的组id属性

    class SysStatus():
        '''
        Description: 
        '''
        STATUS = {"index":1, "type":restDataType.DATA_TYPE_ENUM}#

    class PoweronResult():
        '''
        Description: 
        '''
        STATUS = {"index":1, "type":restDataType.DATA_TYPE_ENUM}#
        ERR_CODE = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        PARAM = {"index":3, "type":restDataType.DATA_TYPE_STRING}#

    class MonitorBoard():
        '''
        Description: 监控板
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#
        TEMPE = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        PCB_VER = {"index":65, "type":restDataType.DATA_TYPE_STRING}#
        ELABEL = {"index":66, "type":restDataType.DATA_TYPE_STRING}#电子标签

    class CliView():
        '''
        Description: cli视图
        '''
        VIEW = {"index":2, "type":restDataType.DATA_TYPE_STRING}#
        SRC_VIEW = {"index":3, "type":restDataType.DATA_TYPE_STRING}#
        PASSWORD = {"index":65, "type":restDataType.DATA_TYPE_STRING}#
        OLDPASSWD = {"index":66, "type":restDataType.DATA_TYPE_STRING}#

    class Commondata():
        '''
        Description: 通用数据存储
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#
        VALUE = {"index":64, "type":restDataType.DATA_TYPE_JSON}#数据Value

    class EnumInfo():
        '''
        Description: 枚举详情
        '''
        ENUM_NAME = {"index":0, "type":restDataType.DATA_TYPE_STRING}#枚举的名称
        ENUM_INDEX = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#枚举的索引值
        ENUM_GLOSSARY_CN = {"index":2, "type":restDataType.DATA_TYPE_STRING}#枚举的中文术语
        ENUM_GLOSSARY_EN = {"index":3, "type":restDataType.DATA_TYPE_STRING}#枚举的英文术语
        ENUM_DESCRIPTION_CN = {"index":4, "type":restDataType.DATA_TYPE_STRING}#枚举的中文描述
        ENUM_DESCRIPTION_EN = {"index":5, "type":restDataType.DATA_TYPE_STRING}#枚举的英文描述

    class FileEngineer():
        '''
        Description: 文件引擎
        '''
        CMO_INTEGRATION_IP_A = {"index":0, "type":restDataType.DATA_TYPE_STRING}#设备A控制器IP
        CMO_INTEGRATION_IP_B = {"index":1, "type":restDataType.DATA_TYPE_STRING}#设备B控制器IP
        CMO_INTEGRATION_USER = {"index":2, "type":restDataType.DATA_TYPE_STRING}#设备登陆用户名
        CMO_INTEGRATION_PASSWD = {"index":3, "type":restDataType.DATA_TYPE_STRING}#设备登陆密码
        CMO_INTEGRATION_DEV_TYPE = {"index":4, "type":restDataType.DATA_TYPE_STRING}#设备类型
        CMO_INTEGRATION_USER_LEVEL = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户级别

    class SpecialityList():
        '''
        Description: 特性列表
        '''
        SPECIALITY = {"index":0, "type":restDataType.DATA_TYPE_STRING}#特性

    class DiskRoutineTest():
        '''
        Description: 硬盘例测
        '''
        ENABLE_ROUTINE_TEST = {"index":0, "type":restDataType.DATA_TYPE_BOOL}#例测周期状态
        ROUTINE_TEST_PERIOD = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#例测周期

    class ControllerIo():
        '''
        Description: 控制器Io并发
        '''
        ID = {"index":0, "type":restDataType.DATA_TYPE_STRING}#控制器ID
        FRONT_END_IO = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#前端并发
        FRONT_END_LIMIT = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#前端并发的上限值
        PORT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}#后端端口类型
        PORT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#后端端口ID
        BACK_END_IO = {"index":5, "type":restDataType.DATA_TYPE_UNSIGN_INT}#后端并发
        BACK_END_LIMIT = {"index":6, "type":restDataType.DATA_TYPE_UNSIGN_INT}#后端并发的上限值

    class FileTransfer():
        '''
        Description: 文件传输
        '''
        FILE_ID = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#特性
        VERSION = {"index":1, "type":restDataType.DATA_TYPE_STRING}#文件版本
        CONTENT_TYPE = {"index":2, "type":restDataType.DATA_TYPE_STRING}#
        START = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        END = {"index":4, "type":restDataType.DATA_TYPE_STRING}#
        DATA = {"index":5, "type":restDataType.DATA_TYPE_MEMORY}#
        FILE_NAME = {"index":6, "type":restDataType.DATA_TYPE_STRING}#文件名

    class Subnet():
        '''
        Description: 子网段
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#对象名
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        MASK_AND_PREFIX = {"index":65, "type":restDataType.DATA_TYPE_STRING}#掩码或前缀
        GATE_WAY = {"index":66, "type":restDataType.DATA_TYPE_STRING}#子网网关
        DNS_IP = {"index":66, "type":restDataType.DATA_TYPE_STRING}#子网内DNS服务IP

    class Netgroup():
        '''
        Description: 网络组
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#名称
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_STRING}#
        NET_GROUP_NAME = {"index":64, "type":restDataType.DATA_TYPE_STRING}#网络名称

    class DnsServer():
        '''
        Description: DNS服务器
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        TENANCY_ID = {"index":17, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        ADDRESS = {"index":64, "type":restDataType.DATA_TYPE_ARRAY}#地址

    class SlowDiskPolicy():
        '''
        Description: 快慢盘策略
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        CHECK_INTERVAL = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        SLOW_SERVICE_TIME = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        CHECK_TIMES = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        SLOW_CYCLE_THRESHOLD = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        COMBINATED_CYCLE = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#

    class Systemlicense():
        '''
        Description: SystemLicense
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#ID

    class CmdNotifyE():
        '''
        Description: 命令执行上报
        '''
        CMD = {"index":0, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#

    class UserSecurityPolicy():
        '''
        Description: 管理用户安全策略
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#
        PASSWORD_MIN_LENGTH = {"index":64, "type":restDataType.DATA_TYPE_UNSIGN_INT}#口令最小长度，默认值8
        PASSWORD_MAX_LENGTH = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}#口令最大长度，默认值16
        PWD_COMPLEX = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#密码复杂性（是否支持特殊字符）
        REDUPLICATE_CHAR_COUNT = {"index":67, "type":restDataType.DATA_TYPE_UNSIGN_INT}#同一字符连续出现的最大次数
        ENABLE_PWD_LOCK = {"index":68, "type":restDataType.DATA_TYPE_BOOL}#是否开启密码锁机制
        PWD_LOCK_TIME = {"index":69, "type":restDataType.DATA_TYPE_UNSIGN_INT}#密码锁定时间
        PWD_INCORRECT_TIMES = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#不正确密码次数
        SESSION_EXPIRED_TIME = {"index":71, "type":restDataType.DATA_TYPE_UNSIGN_INT}#会话过期时间
        MIN_VALID_PERIOD = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#人机登陆用户最短过期时间
        MAX_VALID_PERIOD = {"index":73, "type":restDataType.DATA_TYPE_UNSIGN_INT}#人机登陆用户密码过期时间
        PROMPT_AHEAD = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#人机登陆用户提前提示的天数
        HISTORY_COUNT = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#人机登陆用户口令历史记录
        M2M_USER_PWD_MIN_VALID_PERIOD = {"index":76, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接口对接用户最短过期时间
        M2M_USER_PWD_MAX_VALID_PERIOD = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接口对接用户最大过期时间
        M2M_USER_PWD_PROMPT_AHEAD = {"index":78, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接口对接用户提前提示的天数
        M2M_USER_PWD_HISTORY_COUNT = {"index":79, "type":restDataType.DATA_TYPE_UNSIGN_INT}#接口对接用户口令历史记录
        IPPWD_INCORRECT_TIMES = {"index":80, "type":restDataType.DATA_TYPE_UNSIGN_INT}#不正确密码次数锁定IP
        PWD_INCORRECT_INTERVAL = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#不正确密码输入间隔
        ENABLE_USER_REVIEW = {"index":82, "type":restDataType.DATA_TYPE_BOOL}#是否开启用户账号审计机制
        USER_REVIEW_INTERVAL = {"index":83, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户账号审计间隔时间
        ENABLE_INACTIVE_USER_LOCK = {"index":84, "type":restDataType.DATA_TYPE_BOOL}#是否开启闲置锁定机制
        INACTIVE_USER_LOCK_TIME = {"index":85, "type":restDataType.DATA_TYPE_UNSIGN_INT}#闲置锁定时间间隔
        USER_MIN_LENGTH = {"index":86, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用户名最小长度，默认值为6
        ENABLE_LOGIN_NOTES = {"index":87, "type":restDataType.DATA_TYPE_BOOL}#是否开启登录提示，默认false
        ENABLE_USER_DEF_NOTES = {"index":88, "type":restDataType.DATA_TYPE_BOOL}#是否开启用户自定义提示，默认false
        USER_DEF_NODES = {"index":89, "type":restDataType.DATA_TYPE_STRING}#用户定义的提示信息

    class DpsStatis():
        '''
        Description: DPSVM虚拟机统计信息
        '''
        NUM_ALL_VM = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        NUM_VMFAIL = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        NUM_VMSUCCESS = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        NUM_VM = {"index":3, "type":restDataType.DATA_TYPE_UNSIGN_INT}#

    class ConfigFileInfo():
        '''
        Description: 配置文件
        '''
        FILE_ID = {"index":0, "type":restDataType.DATA_TYPE_STRING}#文件唯一标识
        FILE_TYPE = {"index":1, "type":restDataType.DATA_TYPE_ENUM}#配置文件类型
        LANGUAGE_TYPE = {"index":2, "type":restDataType.DATA_TYPE_ENUM}#语言类型
        FILE_PATH = {"index":3, "type":restDataType.DATA_TYPE_STRING}#文件路径

    class SyncTime():
        '''
        Description: 同步系统时间
        '''
        SERVER_ID = {"index":10, "type":restDataType.DATA_TYPE_STRING}#服务器ID标识

    class Ibc():
        '''
        Description: IBC检查
        '''
        PASS_WORD_CHANGED = {"index":0, "type":restDataType.DATA_TYPE_BOOL}#返回IBC密码是否为默认密码
        KEY_PAIR_ISCHANGED = {"index":1, "type":restDataType.DATA_TYPE_BOOL}#返回ibc_os_hs公私钥对是否已被修改
        NEW_PASSWORD = {"index":2, "type":restDataType.DATA_TYPE_STRING}#
        OLD_PASSWORD = {"index":3, "type":restDataType.DATA_TYPE_STRING}#

    class VirtualMachine():
        '''
        Description：虚拟机
        '''
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#对象名 
        OWNER_CONTROLLER_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#运行状态
        RUNNING_CONTROLLER_ID = {"index":64, "type":restDataType.DATA_TYPE_STRING}#

    class VmPorts():
        '''
        Description: 虚拟机端口信息
        '''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#ID
        PARENT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}#父对象类型
        PARENT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#父对象ID
        PARENT_NAME = {"index":5, "type":restDataType.DATA_TYPE_STRING}#父对象名称
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#运行状态
        MAC = {"index":64, "type":restDataType.DATA_TYPE_STRING}#Mac地址
        MAPPING_MODE = {"index":65, "type":restDataType.DATA_TYPE_UNSIGN_INT}# 映射模式(0：直通1：网桥)
        USE_TYPE = {"index":66, "type":restDataType.DATA_TYPE_UNSIGN_INT}#用途:0普通端口，1镜像端口,
        BOND_NAME = {"index":67, "type":restDataType.DATA_TYPE_STRING}#所属的绑定口的名称
        PORT_TYPE = {"index":68, "type":restDataType.DATA_TYPE_UNSIGN_INT}#与其依赖的物理口 1:eth  2:bond 
        PORT_ID = {"index":69, "type":restDataType.DATA_TYPE_STRING}#与其依赖的实际口ID，物理口返回物理口ID，绑定口返回绑定口ID
        PORT_LOCATION = {"index":70, "type":restDataType.DATA_TYPE_STRING}#, 与其依赖的物理口Location，Location之间逗号间隔
        MIRROR_VM_PORT_ID = {"index":71, "type":restDataType.DATA_TYPE_STRING}#当userType是镜像端口时，此字段表示对控的互为镜像的VMportID

    class SasCardLinkInfo():
        '''
        Description: 检查大卡链路连接
        '''
        NID = {"index":0, "type":restDataType.DATA_TYPE_UNSIGN_INT}#控制器节点ID。
        SAS_CARD_SLOT_NUM = {"index":1, "type":restDataType.DATA_TYPE_UNSIGN_INT}#SAS卡槽位号
        CMD_TYPE = {"index":2, "type":restDataType.DATA_TYPE_UNSIGN_INT}#命令类型

    class CheckIBCPassword():
        PASS_WORD_CHANGED = 0#返回IBC密码是否为默认密码
        KEY_PAIR_ISCHANGED = 1#返回ibc_os_hs公私钥对是否已被修改


    #记录转储或导出操作日志参数位置
    class RecordOperationLog():
        OPER_TYPE = 0
        FILE_TYPE = 1
        RET_VALUE = 3

'''
Description: (公共)系统管理
'''
class PoolLunMap():
    class Diskpool():
        '''Description: 硬盘池'''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#名称
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#运行状态
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#描述
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，如硬盘
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#关联对象ID
        ASSOCIATE_OBJ_IDLIST = {"index":16, "type":restDataType.DATA_TYPE_ARRAY}#对单个对象无效，仅用于批量创建关联关系，如将多个硬盘一次性关联到Pool
        TOTAL_CAPACITY = {"index":64, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#总可用裸容量
        SPARE_CAPACITY = {"index":65, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#总热备裸容量
        USED_SPARE_CAPACITY = {"index":66, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#已用热备裸容量
        FREE_CAPACITY = {"index":67, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#空闲容量
        SSDTOTAL_CAPACITY = {"index":68, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SSD总可用裸容量
        SSDSPARE_CAPACITY = {"index":69, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SSD总热备裸容量
        SSDUSED_SPARE_CAPACITY = {"index":70, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SSD已用热备裸容量
        SSDFREE_CAPACITY = {"index":71, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SSD空闲裸容量
        SASTOTAL_CAPACITY = {"index":72, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SAS总可用裸容量
        SASSPARE_CAPACITY = {"index":73, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SAS总热备裸容量
        SASUSED_SPARE_CAPACITY = {"index":74, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SAS已用热备裸容量
        SASFREE_CAPACITY = {"index":75, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SAS空闲裸容量
        NLSASTOTAL_CAPACITY = {"index":76, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#NLSAS总可用裸容量
        NLSASSPARE_CAPACITY = {"index":77, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#NLSAS总热备裸容量
        NLSASUSED_SPARE_CAPACITY = {"index":78, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#NLSAS已用热备裸容量
        NLSASFREE_CAPACITY = {"index":79, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#NLSAS空闲裸容量
        SSDHOTSPARE_STRATEGY = {"index":80, "type":restDataType.DATA_TYPE_ENUM}#SSD热备策略
        SASHOTSPARE_STRATEGY = {"index":81, "type":restDataType.DATA_TYPE_ENUM}#SAS热备策略
        NLSASHOTSPARE_STRATEGY = {"index":82, "type":restDataType.DATA_TYPE_ENUM}#NLSAS热备策略
        SSDDISK_NUM = {"index":83, "type":restDataType.DATA_TYPE_SIGN_INT}#SSD成员盘个数
        SASDISK_NUM = {"index":84, "type":restDataType.DATA_TYPE_SIGN_INT}#SAS成员盘个数
        NLSASDISK_NUM = {"index":85, "type":restDataType.DATA_TYPE_SIGN_INT}#NLSAS成员盘个数
        USED_CAPACITY = {"index":86, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#已分配裸容量
        SSDUSED_CAPACITY = {"index":87, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SSD已分配裸容量
        SASUSED_CAPACITY = {"index":88, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#SAS已分配裸容量
        NLSASUSED_CAPACITY = {"index":89, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#NLSAS已分配裸容量
        FORMAT_PROGRESS = {"index":90, "type":restDataType.DATA_TYPE_UNSIGN_INT}#格式化进度
        FORMAT_REMAIN_TIME = {"index":91, "type":restDataType.DATA_TYPE_UNSIGN_INT}#格式化剩余时间
        ENCRYPT_DISK_TYPE = {"index":92, "type":restDataType.DATA_TYPE_ENUM}#加密硬盘类型
        POOL_TYPE = {"index":93, "type":restDataType.DATA_TYPE_ENUM}#FLASH POOL 混合 POOL
        SPACE_REDUCTION_PERCENTAGE = {"index":94, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数据缩减率
        DEDUPLICATION_PERCENTAGE = {"index":95, "type":restDataType.DATA_TYPE_UNSIGN_INT}#重删率
        COMPRESSION_PERCENTAGE = {"index":96, "type":restDataType.DATA_TYPE_UNSIGN_INT}#压缩率
        RECONSTRUCT_TYPE = {"index":97, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数据重建类型
        SECURE_VIDEO_STATUS = {"index":98, "type":restDataType.DATA_TYPE_ENUM}#录像模式状态
        SECURE_VIDEO_SERVICE_TIME = {"index":99, "type":restDataType.DATA_TYPE_UNSIGN_INT}#录像模式故障服务时间
        SECURE_VIDEO_REDU_DISK_NUM = {"index":100, "type":restDataType.DATA_TYPE_UNSIGN_INT}#录像模式支持的最大故障冗余盘数
        UPDATE_ENCRYPT_KEY = {"index":101, "type":restDataType.DATA_TYPE_BOOL}#是否更新密钥，默认不更新密钥
        DEEPLY_DELETE = {"index":102, "type":restDataType.DATA_TYPE_BOOL}#是否深度删除，默认普通删除
        FREE_CAPACITY_LIST = {"index":103, "type":restDataType.DATA_TYPE_JSON}#每层不同成员盘对应的空闲容量列表
        TIER2_DISK_TYPE = {"index":104, "type":restDataType.DATA_TYPE_ENUM}#容量层(NLSAS层)支持选择NL_SAS盘或SATA盘（两种盘类型互斥）
        TIER1_DISK_TYPE = {"index":105, "type":restDataType.DATA_TYPE_ENUM}#性能层(SAS层)支持选择SAS盘或SAS_SED盘（两种盘类型互斥）
        TIER0_DISK_TYPE = {"index":106, "type":restDataType.DATA_TYPE_ENUM}#高性能层(SSD层)支持选择SSD盘或SSD_SED盘（两种盘类型互斥）
        ABRASION_RATE = {"index":107, "type":restDataType.DATA_TYPE_UNSIGN_INT}#平均磨损度
        REMAIN_LIFE = {"index":108, "type":restDataType.DATA_TYPE_UNSIGN_INT}#平均预估剩余寿命
        WEAR_LEVEL = {"index":109, "type":restDataType.DATA_TYPE_ENUM}#磨损均衡状态
        UNBALANCE_DISK_ID_LIST = {"index":110, "type":restDataType.DATA_TYPE_ARRAY}#反磨损均衡硬盘ID列表

    class Host(PublicAttributes):
        '''Description: 主机'''
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_METADATA = {"index":13, "type":restDataType.DATA_TYPE_JSON}#对单个对象无效，仅用于表示两个对象之间存在关联关系后附加的数据，如LUN与Host建立关联后，附加了一个HostLunID，此时可以在这个字段里表示。此字段必须是一个JSON对象，对象的定义根据应用的场景不同而不同
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        TENANCY_ID = {"index":17, "type":restDataType.DATA_TYPE_STRING}#租户ID
        OPERATION_SYSTEM = {"index":64, "type":restDataType.DATA_TYPE_ENUM}#操作系统
        NETWORK_NAME = {"index":65, "type":restDataType.DATA_TYPE_STRING}#域名
        IP = {"index":66, "type":restDataType.DATA_TYPE_STRING}#IP
        MODEL = {"index":68, "type":restDataType.DATA_TYPE_STRING}#型号
        IS_ADD2_HOST_GROUP = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#是否已添加给HostGroup
        INITIATOR_NUM = {"index":70, "type":restDataType.DATA_TYPE_UNSIGN_INT}#主机启动器的数量

    class IscsiInitiator(PublicAttributes):
        '''Description: iSCSI启动器（主机端口）'''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#对象统计数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_METADATA = {"index":13, "type":restDataType.DATA_TYPE_JSON}#对单个对象无效，仅用于表示两个对象之间存在关联关系后附加的数据，如LUN与Host建立关联后，附加了一个HostLunID，此时可以在这个字段里表示。此字段必须是一个JSON对象，对象的定义根据应用的场景不同而不同
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#按条件查询及排序需要下发的属性HVS C00版本之后所有设备管理版本（包括C10，C20等）：必须要下发查询范围"range"："i-j"
        IS_FREE = {"index":64, "type":restDataType.DATA_TYPE_BOOL}#是否空闲
        USE_CHAP = {"index":65, "type":restDataType.DATA_TYPE_BOOL}#是否启用CHAP
        CHAP_NAME = {"index":66, "type":restDataType.DATA_TYPE_STRING}#CHAP名
        CHAP_PASSWORD = {"index":67, "type":restDataType.DATA_TYPE_STRING}#CHAP密码
        MULTI_PATH_TYPE = {"index":68, "type":restDataType.DATA_TYPE_ENUM}#多路径类型
        OPERATION_SYSTEM = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#操作系统
        CHAP_OLD_PASSWORD = {"index":70, "type":restDataType.DATA_TYPE_STRING}#CHAP密码
        CHAP_NAME_INITATOR_VER_TARGET = {"index":71, "type":restDataType.DATA_TYPE_STRING}#Normal阶段或Discovery阶段的启动器认证目标器的chap名
        CHAP_PASSWORD_INITATOR_VER_TARGET = {"index":72, "type":restDataType.DATA_TYPE_STRING}#Normal阶段或Discovery阶段的启动器认证目标器的chap密码
        CHAP_OLD_PASSWORD_INITATOR_VER_TARGET = {"index":73, "type":restDataType.DATA_TYPE_STRING}#Normal阶段或Discovery阶段的启动器认证目标器的旧密码
        DISCOVERY_VER_MODE = {"index":74, "type":restDataType.DATA_TYPE_ENUM}#discovery阶段的认证模式
        NORMAL_VER_MODE = {"index":75, "type":restDataType.DATA_TYPE_ENUM}#normal阶段的认证模式

    class FcInitiator(PublicAttributes):
        '''Description: FC启动器（主机端口）'''
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#对象统计数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_METADATA = {"index":13, "type":restDataType.DATA_TYPE_JSON}#对单个对象无效，仅用于表示两个对象之间存在关联关系后附加的数据，如LUN与Host建立关联后，附加了一个HostLunID，此时可以在这个字段里表示。此字段必须是一个JSON对象，对象的定义根据应用的场景不同而不同
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#按条件查询及排序需要下发的属性HVS C00版本之后所有设备管理版本（包括C10，C20等）：必须要下发查询范围"range"："i-j"
        IS_FREE = {"index":64, "type":restDataType.DATA_TYPE_BOOL}#是否空闲
        MULTI_PATH_TYPE = {"index":65, "type":restDataType.DATA_TYPE_ENUM}#多路径类型
        OPERATION_SYSTEM = {"index":69, "type":restDataType.DATA_TYPE_ENUM}#操作系统


'''
Description: (公共)系统管理
'''
class ValueAdd():
    class PublicRemoteDevPortAttribute:
        DEVICE_ID = {"index":64, "type":restDataType.DATA_TYPE_STRING}#设备ID
        LOCAL_PORT_ID = {"index":67, "type":restDataType.DATA_TYPE_STRING}#本端端口ID
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#链路健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#链路运行状态：已连接、未连接

    class FcLink():
        '''Description: FC链路'''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#链路
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#链路ID 私有链路ID区间为[0,511], 第三方阵列ID区间为[512, 10240]
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#链路健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#链路运行状态：已连接、未连接
        DESCRIPTION = {"index":9, "type":restDataType.DATA_TYPE_STRING}#描述
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#对单个对象无效，仅用于查询此与关联对象有关系的对象
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        DEVICE_ID = {"index":64, "type":restDataType.DATA_TYPE_STRING}#设备ID
        LOCAL_CONTROL_ID = {"index":65, "type":restDataType.DATA_TYPE_STRING}#本端控制器ID
        REMOTE_CONTROL_ID = {"index":66, "type":restDataType.DATA_TYPE_STRING}#远端控制器ID
        LOCAL_PORT_ID = {"index":67, "type":restDataType.DATA_TYPE_STRING}#本端端口ID
        REMOTE_PORT_ID = {"index":68, "type":restDataType.DATA_TYPE_STRING}#远端端口ID
        FC_LINK_LOCAL_PORT_WWPN = {"index":69, "type":restDataType.DATA_TYPE_STRING}#FC链路本地端口WWPN
        FC_LINK_REMOTE_PORT_WWPN = {"index":70, "type":restDataType.DATA_TYPE_STRING}#FC链路远端端口WWPN
        LINK_USAGE = {"index":71, "type":restDataType.DATA_TYPE_BOOL}#链路用途
        BANDWIDTH_LIMIT_SWITCH = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#带宽限制开关
        BANDWIDTH_LIMIT_SIZE = {"index":73, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#限制带宽大小
        BANDWIDTH_LIMIT_UNIT = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#限制带宽单位
        BANDWIDTH_LIMIT_UTILIZATION = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#带宽利用率
        ARRAY_TYPE = {"index":76, "type":restDataType.DATA_TYPE_ENUM}#本厂商、第三方
        DEVICE_NAME = {"index":77, "type":restDataType.DATA_TYPE_STRING}#远端设备名称
        DEVICE_WWN = {"index":78, "type":restDataType.DATA_TYPE_STRING}#远端设备WWN
        REMOTE_USERNAME = {"index":79, "type":restDataType.DATA_TYPE_STRING}#远端阵列登录用户名
        REMOTE_PASSWORD = {"index":80, "type":restDataType.DATA_TYPE_STRING}#远端阵列登录密码
        REMOTE_LOGINTYPE = {"index":81, "type":restDataType.DATA_TYPE_ENUM}#远端阵列登录方式
        REMOTE_SN = {"index":82, "type":restDataType.DATA_TYPE_STRING}#远端设备SN
        DEVICE_MODEL = {"index":83, "type":restDataType.DATA_TYPE_STRING}#远端设备型号
        VENDOR = {"index":84, "type":restDataType.DATA_TYPE_STRING}#厂商
        LUN_NUM = {"index":85, "type":restDataType.DATA_TYPE_UNSIGN_INT}#链路上LUN的个数
        FAST_WRITE_ENABLED = {"index":86, "type":restDataType.DATA_TYPE_BOOL}#FC写立即数功能是否开启


    class IscsiLink():
        '''Description: iSCSI链路'''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#链路
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#链路ID 私有链路ID区间为[0,511], 第三方阵列ID区间为[512, 10240]
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#链路健康状态
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#链路运行状态：已连接、未连接
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，对单个对象无效，仅用于查询此与关联对象有关系的对象
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#对单个对象无效，仅用于查询此与关联对象有关系的对象
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_JSON}#查询条件
        DEVICE_ID = {"index":64, "type":restDataType.DATA_TYPE_STRING}#设备ID
        LOCAL_CONTROL_ID = {"index":65, "type":restDataType.DATA_TYPE_STRING}#本端控制器ID
        REMOTE_CONTROL_ID = {"index":66, "type":restDataType.DATA_TYPE_STRING}#远端控制器ID
        LOCAL_PORT_ID = {"index":67, "type":restDataType.DATA_TYPE_STRING}#本端端口ID
        REMOTE_PORT_ID = {"index":68, "type":restDataType.DATA_TYPE_STRING}#远端端口ID
        LINK_USAGE = {"index":69, "type":restDataType.DATA_TYPE_BOOL}#链路用途
        TARGET_NAME = {"index":70, "type":restDataType.DATA_TYPE_STRING}#iSCSI目标器名称
        INITIATOR_NAME = {"index":71, "type":restDataType.DATA_TYPE_STRING}#iSCSI启动器名称
        BANDWIDTH_LIMIT_SWITCH = {"index":72, "type":restDataType.DATA_TYPE_UNSIGN_INT}#带宽限制开关
        BANDWIDTH_LIMIT_SIZE = {"index":73, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#限制带宽大小
        BANDWIDTH_LIMIT_UNIT = {"index":74, "type":restDataType.DATA_TYPE_UNSIGN_INT}#限制带宽单位
        BANDWIDTH_LIMIT_UTILIZATION = {"index":75, "type":restDataType.DATA_TYPE_UNSIGN_INT}#带宽利用率
        ARRAY_TYPE = {"index":76, "type":restDataType.DATA_TYPE_ENUM}#本厂商、第三方
        RECOVERY_POLICY = {"index":77, "type":restDataType.DATA_TYPE_ENUM}#修复策略
        ENABLE_CHAP = {"index":78, "type":restDataType.DATA_TYPE_BOOL}#是否启动CHAP
        CHAP_USER = {"index":79, "type":restDataType.DATA_TYPE_STRING}#CHAP名
        CHAP_PASSWD = {"index":80, "type":restDataType.DATA_TYPE_STRING}#CHAP密码
        IP = {"index":81, "type":restDataType.DATA_TYPE_STRING}#对端IP
        PORT = {"index":82, "type":restDataType.DATA_TYPE_UNSIGN_INT}#对端端口号
        REMOTE_USERNAME = {"index":83, "type":restDataType.DATA_TYPE_STRING}#远端阵列登录用户名
        REMOTE_PASSWORD = {"index":84, "type":restDataType.DATA_TYPE_STRING}#远端阵列登录密码
        REMOTE_LOGINTYPE = {"index":85, "type":restDataType.DATA_TYPE_ENUM}#远端阵列登录方式
        LOCAL_IP = {"index":86, "type":restDataType.DATA_TYPE_STRING}#
        LOCALISID = {"index":87, "type":restDataType.DATA_TYPE_STRING}#启动器会话标识符
        REMOTE_TGPT = {"index":88, "type":restDataType.DATA_TYPE_UNSIGN_INT}#目标器端口组标签
        DEVICE_MODEL = {"index":89, "type":restDataType.DATA_TYPE_STRING}#远端设备型号
        VENDOR = {"index":90, "type":restDataType.DATA_TYPE_STRING}#厂商
        REMOTE_WWN = {"index":91, "type":restDataType.DATA_TYPE_STRING}#远端设备WWN
        REMOTE_SN = {"index":92, "type":restDataType.DATA_TYPE_STRING}#远端设备SN
        DEVICE_NAME = {"index":93, "type":restDataType.DATA_TYPE_STRING}#远端设备名称
        LUN_NUM = {"index":94, "type":restDataType.DATA_TYPE_UNSIGN_INT}#链路上LUN的个数

    class ReplicationPair():
        '''Description: 远程复制pair'''
        TYPE = {"index":0, "type":restDataType.DATA_TYPE_ENUM}#对象类型
        ID = {"index":1, "type":restDataType.DATA_TYPE_STRING}#对象ID
        NAME = {"index":2, "type":restDataType.DATA_TYPE_STRING}#对象名称（海量目录远程复制添加）
        PARENT_TYPE = {"index":3, "type":restDataType.DATA_TYPE_ENUM}#源LUN
        PARENT_ID = {"index":4, "type":restDataType.DATA_TYPE_STRING}#源LUNID
        PARENT_NAME = {"index":5, "type":restDataType.DATA_TYPE_STRING}#源LUN名称
        HEALTH_STATUS = {"index":7, "type":restDataType.DATA_TYPE_ENUM}#当运行状态为正常、同步中、已分裂时，健康状态为“正常”；当运行状态为待恢复、异常断开、镜像失效时，健康状态为“故障”；
        RUNNING_STATUS = {"index":8, "type":restDataType.DATA_TYPE_ENUM}#用于表示Pair复制关系状态（正常、同步中、待恢复、异常断开、已分裂、镜像失效）
        COUNT = {"index":10, "type":restDataType.DATA_TYPE_UNSIGN_INT}#对象统计数量
        ASSOCIATE_OBJ_TYPE = {"index":11, "type":restDataType.DATA_TYPE_ENUM}#关联对象类型，如LUN
        ASSOCIATE_OBJ_ID = {"index":12, "type":restDataType.DATA_TYPE_STRING}#关联对象ID
        ASSOCIATE_METADATA = {"index":13, "type":restDataType.DATA_TYPE_JSON}#因关联查询而需要下发的附加数据
        QUERY_CONDITION = {"index":15, "type":restDataType.DATA_TYPE_STRING}#按条件查询及排序需要下发的属性9000 V1R1C30只支持‘名称、本端目录、远端目录’的精确查询和排序、支持range查询）
        TENANCY_ID = {"index":17, "type":restDataType.DATA_TYPE_STRING}#租户ID
        IS_PRIMARY = {"index":64, "type":restDataType.DATA_TYPE_BOOL}#是否是主端
        LOCAL_RES_ID = {"index":65, "type":restDataType.DATA_TYPE_STRING}#本端资源的ID
        LOCAL_RES_NAME = {"index":66, "type":restDataType.DATA_TYPE_STRING}#本端资源的名称(海量512)（海量中表示本端目录名称）
        LOCAL_RES_TYPE = {"index":67, "type":restDataType.DATA_TYPE_ENUM}#本端资源的类型（LUN或FS）
        REMOTE_DEVICE_ID = {"index":68, "type":restDataType.DATA_TYPE_STRING}#远端设备的ID
        REMOTE_DEVICE_SN = {"index":69, "type":restDataType.DATA_TYPE_STRING}#远端设备序列号
        REMOTE_DEVICE_NAME = {"index":70, "type":restDataType.DATA_TYPE_STRING}#远端设备名称
        REMOTE_RES_ID = {"index":71, "type":restDataType.DATA_TYPE_STRING}#远端资源的ID（LUN或FS）
        REMOTE_RES_NAME = {"index":72, "type":restDataType.DATA_TYPE_STRING}#远端资源的名称（LUN或FS）(海量512)(目录远程复制中表示远端的目录)
        IS_FIRST_SYNC = {"index":73, "type":restDataType.DATA_TYPE_BOOL}#是否初始同步(0：不初始同步  1：初始同步)默认：不初始化同步，此参数废弃，不用下发
        SYNCHRONIZE_TYPE = {"index":74, "type":restDataType.DATA_TYPE_ENUM}#同步类型：默认手动
        CAPACITY = {"index":75, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#主端资源的容量(如果是查询远端可用的资源时此字段为远端资源的容量）
        RECOVERY_POLICY = {"index":76, "type":restDataType.DATA_TYPE_ENUM}#恢复策略：默认为自动
        REPLICATION_PROGRESS = {"index":77, "type":restDataType.DATA_TYPE_UNSIGN_INT}#进度
        START_TIME = {"index":78, "type":restDataType.DATA_TYPE_TIME}#开始时间
        END_TIME = {"index":79, "type":restDataType.DATA_TYPE_TIME}#结束时间
        SPEED = {"index":80, "type":restDataType.DATA_TYPE_ENUM}#速率
        TIMING_VAL = {"index":81, "type":restDataType.DATA_TYPE_UNSIGN_INT}#定时时长（数据同步周期，单位：秒）,当>=60时，必须是60的整数倍,(取值范围3-59sec、1-1440min)
        IS_ROLLBACK = {"index":82, "type":restDataType.DATA_TYPE_BOOL}#从端资源是否正在回滚
        SEC_RES_DATA_STATUS = {"index":83, "type":restDataType.DATA_TYPE_ENUM}#从端资源数据状态（LUN或FS）
        POOL_NAME = {"index":84, "type":restDataType.DATA_TYPE_STRING}#从端资源所属存储池名称（LUN或FS）
        REPLICATION_MODEL = {"index":85, "type":restDataType.DATA_TYPE_ENUM}#复制模式
        PRI_RES_DATA_STATUS = {"index":86, "type":restDataType.DATA_TYPE_ENUM}#主端资源数据状态（LUN或FS）
        SEC_RES_ACCESS = {"index":87, "type":restDataType.DATA_TYPE_ENUM}#从LUN读写设置，用于设置从LUN的写保护
        IS_SEC_RES_BE_WRITE = {"index":88, "type":restDataType.DATA_TYPE_BOOL}#从LUN是否被主机写入过数据
        IS_IN_CG = {"index":89, "type":restDataType.DATA_TYPE_BOOL}#是否属于一致性组
        CG_ID = {"index":90, "type":restDataType.DATA_TYPE_STRING}#所属一致性组ID
        CG_NAME = {"index":91, "type":restDataType.DATA_TYPE_STRING}#所属一致性组名称
        IS_DATA_SYNC = {"index":92, "type":restDataType.DATA_TYPE_BOOL}#主从端数据是否一致
        IS_LOCAL_DELETE = {"index":93, "type":restDataType.DATA_TYPE_BOOL}#在链路断开时是否允许本地删除，不下发此参数时默认为“否”，即不允许本地删除
        TO_SYNC_SRWHEN_DELETE = {"index":94, "type":restDataType.DATA_TYPE_BOOL}#删除时是否要维护从LUN的一致性，不下发此参数时默认为“是”，即需要保持一致性，此时，如果从LUN数据不一致底层会强制回滚后再删除
        ENABLE_ENCRYPT = {"index":95, "type":restDataType.DATA_TYPE_BOOL}#传输数据是否加密  默认：false
        ENABLE_COMPRESS = {"index":96, "type":restDataType.DATA_TYPE_BOOL}#传输数据是否压缩  默认：false
        TRANSPORT_DATA_SIZE = {"index":99, "type":restDataType.DATA_TYPE_U64LONG_TYPE}#已传输数据大小
        SYNCHRONIZE_SCHEDULE = {"index":100, "type":restDataType.DATA_TYPE_JSON}#定时规则，定时规则，使用JSON表示，便于后续扩展。{"Week":{"WeekNum":"0","time":"12:01"},"Day":"12:10","Month":{"Day":"1","Time":"13:10"}}其中Week、Day、Month可分别表示按周、天、月的定时规则，对应Value为空表示不设置该规则，且三种schedule只支持配置一种。
        REMOTE_SNAP_EXPIRATION_TYPE = {"index":102, "type":restDataType.DATA_TYPE_ENUM}#快照老化类型：支持按照份数、过期时间，不老化 3钟类型
        REMOTE_SNAP_VERS = {"index":103, "type":restDataType.DATA_TYPE_UNSIGN_INT}#从端快照保留份数
        REMOTE_SNAP_EXPIRATION_UNIT = {"index":104, "type":restDataType.DATA_TYPE_ENUM}#执行调度：天/周/年(海量快照老化机制时间单位为天，周，月，最大12个月）（默认为：天，每月按30天计算）)
        REMOTE_SNAP_EXPIRATION_TIME = {"index":105, "type":restDataType.DATA_TYPE_UNSIGN_INT}#过期时间
        WORKER_PER_NODE = {"index":110, "type":restDataType.DATA_TYPE_UNSIGN_INT}#单节点Worker数（海量：现在未使用，暂时保留）
        IS_ENABLE_DEDUPE = {"index":111, "type":restDataType.DATA_TYPE_BOOL}#是否启用重删
        USER_TYPE = {"index":113, "type":restDataType.DATA_TYPE_UNSIGN_INT}#
        LOCAL_DEVICE_NAME = {"index":114, "type":restDataType.DATA_TYPE_STRING}#本端集群的名称
        COPY_SPEED = {"index":115, "type":restDataType.DATA_TYPE_ENUM}#平均复制速率 单位是 KB/S,表示在同步过程中，平均的复制速率 新添加，与低保真修改一致  @since 9000 V1R1C30
        COMPRESS_VALID = {"index":116, "type":restDataType.DATA_TYPE_BOOL}#
        REPLICATION_CHANNEL_ID = {"index":117, "type":restDataType.DATA_TYPE_STRING}#replication channel id
        REPLICATION_CHANNEL_NAME = {"index":118, "type":restDataType.DATA_TYPE_STRING}#replication channel name
        REM_TIMEOUT_PERIOD = {"index":119, "type":restDataType.DATA_TYPE_UNSIGN_INT}#远端IO超时时间

class RestCfg():
    REST_CMD_TIMEOUT = 120
    REST_SCOPE_DEFAULT = "0"

    class PublicAttributes():
        TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
        ID = {"key":"ID", "type":restDataType.DataType.DATA_TYPE_STRING}
        NAME = {"key":"NAME", "type":restDataType.DataType.DATA_TYPE_STRING}
        PARENT_TYPE = {"key":"PARENTTYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
        PARENT_ID = {"key":"PARENTID", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCATION = {"key":"LOCATION", "type":restDataType.DataType.DATA_TYPE_STRING}
        HEALTH_STATUS = {"key":"HEALTHSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
        RUNNING_STATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class System(PublicAttributes):
        CONFIG_MODEL = {"key":"CONFIGMODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}
        PRODUCT_VERSION = {"key":"PRODUCTVERSION", "type":restDataType.DataType.DATA_TYPE_STRING}

    #控制器属性
    class Controller (PublicAttributes):
        CPU_USAGE = {"key":"CPUUSAGE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
        LIGHT_STATUS = {"key":"LIGHT_STATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

    #框属性
    class Enclosure (PublicAttributes):
        LOGIC_TYPE = {"key":"LOGICTYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
        MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}
        HEIGHT = {"key":"HEIGHT", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}

    #IBC属性    
    class IBC ():
        PWD_CHANGED = {"key":"passwordChanged", "type":restDataType.DataType.DATA_TYPE_STRING}
        KEYPAIR_CHANGED = {"key":"keyPairChanged", "type":restDataType.DataType.DATA_TYPE_STRING}

    class ControllerIo():
        ID = {"key":"id", "type":restDataType.DataType.DATA_TYPE_STRING}
        PORT_TYPE = {"key":"portType", "type":restDataType.DataType.DATA_TYPE_ENUM}
        PORT_ID = {"key":"portID", "type":restDataType.DataType.DATA_TYPE_STRING}
        BACKEND_IO = {"key":"backEndIO", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}
        BACKEND_LIMIT = {"key":"backEndLimit", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}

    class ErrorInfo:
        CODE = {"key":"code", "type":restDataType.DataType.DATA_TYPE_STRING}
        DESCRIPTION = {"key":"description", "type":restDataType.DataType.DATA_TYPE_STRING}

    class SfpOpticalTransceiver(PublicAttributes):
        CMO_EXPORT_DB_DATA_DIR = {"key":"CMO_EXPORT_DB_DATA_DIR", "type":restDataType.DataType.DATA_TYPE_STRING}

    class FcPort(PublicAttributes):
        pass

    class IntfModule(PublicAttributes):
        MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class EthPort(PublicAttributes):
        IPV4_ADDR = {"key":"IPV4ADDR", "type":restDataType.DataType.DATA_TYPE_STRING}
        IPV6_ADDR = {"key":"IPV6_ADDR", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOGIC_TYPE = {"key":"LOGICTYPE", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}

    class FcoePort(PublicAttributes):
        pass

    class License:
        LICENSE_USAGE_INFO = {"key":"LicenseUsageInfo", "type":restDataType.DataType.DATA_TYPE_JSON}
        LICENSE_RESOURCE = {"key":"LicenseResource", "type":restDataType.DataType.DATA_TYPE_JSON}

    class LicenseUsageInfo:
        FEATURE_ID = {"key":"FeatureId", "type":restDataType.DataType.DATA_TYPE_ENUM}
        STATE = {"key":"State", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}

    class LicenseResource:
        FEATURE_ID = {"key":"FeatureId", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class ReplicationPair(PublicAttributes):
        LOCAL_RES_NAME = {"key":"LOCALRESNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
        REMOTE_RES_NAME = {"key":"REMOTERESNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
        REMOTE_DEVICE_ID = {"key":"REMOTEDEVICEID", "type":restDataType.DataType.DATA_TYPE_STRING}
        RECOVERY_POLICY = {"key":"RECOVERYPOLICY", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class PubRemoteDevPortAttr:
        DEVICE_ID = {"key":"DEVICEID", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCAL_PORT_ID = {"key":"LOCALPORTID", "type":restDataType.DataType.DATA_TYPE_STRING}
        HEALTH_STATUS = {"key":"HEALTHSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
        RUNNING_STATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
    class FcLink(PubRemoteDevPortAttr):
        pass

    class IscsiLink(PubRemoteDevPortAttr):
        pass
    
    class QuorumServerLink():
        TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
        ID = {"key":"ID", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCALCONTROLLERID = {"key":"LOCALCONTROLLERID", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCALCONTROLLERNAME = {"key":"LOCALCONTROLLERNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCALPORTID = {"key":"LOCALPORTID", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCALPORTNAME = {"key":"LOCALPORTNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
        PARENTID = {"key":"PARENTID", "type":restDataType.DataType.DATA_TYPE_STRING}
        PARENTTYPE = {"key":"PARENTTYPE", "type":restDataType.DataType.DATA_TYPE_STRING}
        QUORUMSERVERIP = {"key":"QUORUMSERVERIP", "type":restDataType.DataType.DATA_TYPE_STRING}
        RUNNINGSTATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class ExportData():
        EXPORT_DATA_TYPE = {"key":"exportDataType", "type":restDataType.DataType.DATA_TYPE_ENUM}
        NODE_ID = {"key":"nodeId", "type":restDataType.DataType.DATA_TYPE_STRING}
        CMO_EXPORT_DB_TYPE = {"key":"CMO_EXPORT_DB_TYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
        CMO_EXPORT_DRIVE_ID = {"key":"CMO_EXPORT_DRIVE_ID", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class Expboard(PublicAttributes):
        WWN = {"key":"WWN", "type":restDataType.DataType.DATA_TYPE_STRING}
        MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}

    class BackupPower(PublicAttributes):
        pass

    class SasPort(PublicAttributes):
        enclosureWWNList = {"key":"ENCLOSURE_WWN_LIST", "type":restDataType.DataType.DATA_TYPE_STRING}
        WWN = {"key":"WWN", "type":restDataType.DataType.DATA_TYPE_STRING}
        CURRENT_PEER_PORT_ID = {"key":"CURRENT_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}
        SUGGEST_PEER_PORT_ID = {"key":"SUGGEST_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}

    class PciePort(PublicAttributes):
        CURRENT_PEER_PORT_ID = {"key":"CURRENT_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}
        SUGGEST_PEER_PORT_ID = {"key":"SUGGEST_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}

    class Alarm:
        EVENTID = {"key":"eventID", "type":restDataType.DataType.DATA_TYPE_STRING}
        SUGGESTION = {"key":"suggestion", "type":restDataType.DataType.DATA_TYPE_STRING}
        STREVENTID = {"key":"strEventID", "type":restDataType.DataType.DATA_TYPE_STRING}
        DESCRIPTION = {"key":"description", "type":restDataType.DataType.DATA_TYPE_STRING}
        LEVEL = {"key":"level", "type":restDataType.DataType.DATA_TYPE_ENUM}
        SOURCEID = {"key":"sourceID", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        EVENTPARAM = {"key":"eventParam", "type":restDataType.DataType.DATA_TYPE_STRING}
        SEQUENCE = {"key":"sequence", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        RECOVERTIME = {"key":"recoverTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        CLEARTIME = {"key":"clearTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        DETAIL = {"key":"detail", "type":restDataType.DataType.DATA_TYPE_STRING}
        SOURCETYPE = {"key":"sourceType", "type":restDataType.DataType.DATA_TYPE_STRING}
        CLEARNAME = {"key":"clearName", "type":restDataType.DataType.DATA_TYPE_STRING}
        ROOM = {"key":"room", "type":restDataType.DataType.DATA_TYPE_STRING}
        LOCATION = {"key":"location", "type":restDataType.DataType.DATA_TYPE_STRING}
        STARTTIME = {"key":"startTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        CONFIRMTIME = {"key":"confirmTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
        POSITION = {"key":"position", "type":restDataType.DataType.DATA_TYPE_STRING}
        ALARMOBJTYPE = {"key":"alarmObjType", "type":restDataType.DataType.DATA_TYPE_STRING}
        TYPE = {"key":"type", "type":restDataType.DataType.DATA_TYPE_ENUM}
        NAME = {"key":"name", "type":restDataType.DataType.DATA_TYPE_STRING}

    class OperationLog():
        OPER_TYPE = {"key":"operType", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}
        FILE_TYPE = {"key":"fileType", "type":restDataType.DataType.DATA_TYPE_ENUM}
        FILE_NAME = {"key":"fileName", "type":restDataType.DataType.DATA_TYPE_STRING}
        RETURN_VALUE = {"key":"retValue", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}
        NODE_ID = {"key":"nodeId", "type":restDataType.DataType.DATA_TYPE_STRING}
    
    class ExpandEvaluaCheck():
        TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
        RET_CODE = {"key":"expandEvaluationRet", "type":restDataType.DataType.DATA_TYPE_STRING}
        SHOW_DATA = {"key":"expandEvaluationShowData", "type":restDataType.DataType.DATA_TYPE_STRING}

    ##--------对象URI配置-------                       
    #单个查询，批量查询和修改的对象
    class OBJ():

        SYSTEM = "system/"
        ENCLOSURE = "enclosure"
        CONTROLLER = "controller"
        BAY = "bay"
        EXPANSION_BOARD = "expboard"
        INTERFACE_MODULE = "intf_module"
        DISK = "disk"
        FAN = "fan"
        POWER = "power"
        BACKUP_POWER = "backup_power"
        ETH_PORT = "eth_port"
        PCIE_PORT = "pcie_port"
        SAS_PORT = "sas_port"
        FC_PORT = "fc_port"
        FCoE_PORT = "FCoE_PORT"
        IB_PORT = "ib_port"
        REPLICATIONPAIR = "REPLICATIONPAIR"
        IBC = "check_ibc_password_changed"
        CONTROLLER_IO = "backend_concurrent"
        SFP_OPTICAL_TRANSCEIVER = "SFP_OPTICAL_TRANSCEIVER"
        FC_LINK = "FC_LINK"
        iSCSI_LINK = "iSCSI_LINK"
        EXPORT_DB_CONFIG = "export_db_config"         #导出配置文件
        CLEAR_EXPORT_DATA = "clear_export_data"       #清除导出数据
        VM = "vm"   #虚拟机
        QUORUM_SERVER_LINK = "QuorumServerLink"  #仲裁服务器链路
        EXPANSION_EVAL = "expansion_evaluation"  #Dorado扩容评估，用于V3R2C00及以后版本
        EXPANSION_DISKDOMAIN = "diskpool"  #Dorado 扩容硬盘域，用于V3R2C00及以后版本

    #特殊REST接口，无法在OBJ中实现的接口
    class SpecialUri():
        QUERY_USER_INFO = "user" #查询用户信息
        QUERY_CURRENT_ALARM_INFO = "alarm/currentalarm"        #查询系统当前告警列表信息
        COUNT_CURRENT_ALARMS = "alarm/currentalarm/count"      #查询系统当前告警列表信息
        QUERY_HISTORICAL_ALARMS_INFO = "alarm/historyalarm"    #查询历史告警和事件
        COUNT_HISTORICA_ALARMS = "alarm/historyalarm/count"    #查询历史告警和事件个数
        SYNC_REPLICATION_PAIR = "REPLICATIONPAIR/sync"         #同步远程复制Pair
        ACTIVELICENSE = "license/activelicense"                #查询license使用情况
        OFFLINE_CONTROLLER = "offline_controller"              #离线控制器
        OFFLINE_CONTROLLER_SIGNLE = "safe_power_off_system"
        INTERNAL_DEVICE_INFO = "scale_out/get_internal_device_info"  # 查询内部产品型号

    ##-----------REST框架使用配置-----------     
    class RestMethod():
        GET = 0     #请求主要用于查询存储管理对象
        POST = 1    #请求主要用于创建存储管理对象
        PUT = 2     #请求主要用于修改存储管理对象属性和对管理对象的特殊操作
        DELETE = 3  #主要用于删除存储管理对象   

    ##-----------对象属性的枚举类型-----------
    class HealthStatusEnum:
        UNKNOWN = 0
        NORMAL = 1
        FAULT = 2
        PRE_FAIL = 3
        PART_BROKEN = 4
        DEGRADE = 5
        HAS_BAD_BLOCK = 6
        HAS_ERR_CODE = 7
        CONSISTENT = 8
        INCONSISTENT = 9
        BUSY = 10
        POWER_NO_INPUT = 11
        POWER_NOT_ENOUGH = 12
        SINGLE_LINK_FAULT = 13
        INVALID = 14
        WRITE_PROTECT = 15

    class RunningStatusEnum:
        UNKNOWN = 0
        NORMAL = 1
        RUNNING = 2
        NOT_RUNNING = 3
        NOT_EXIST = 4
        HIGH_TEMPERATURE_SLEEP = 5
        STARTING = 6
        POWER_FAILURE_PROTECTING = 7
        SLEEPING = 8
        SPINGUP = 9
        LINK_UP = 10
        LINK_DOWN = 11
        POWER_ON = 12
        POWER_OFF = 13
        PRE_COPY = 14
        COPYBACK = 15
        RECONSTRUCTION = 16
        EXPANSION = 17
        NOT_FORMAT = 18
        FORMATTING = 19
        UNMAPPING = 20
        INITIAL_SYNCHRONIZING = 21
        CONSISTENT = 22
        SYNCHRONIZING = 23
        SYNCHRONIZED = 24
        NOT_SYNCHRONIZED = 25
        SPLIT = 26
        ONLINE = 27
        OFFLINE = 28
        LOCKED = 29
        ENABLE = 30
        DISABLED = 31
        LEVELING = 32
        TO_BE_RECOVERD = 33
        INTERRUPTED = 34
        INVALID = 35
        NOSTART = 36
        QUEUING = 37
        STOP = 38
        COPYING = 39
        COMPLETED = 40
        PAUSE = 41
        REVSYNCHRONIZING = 42
        ACTIVATED = 43
        ROLLBACK = 44
        INACTIVATED = 45
        IDLE = 46
        POWERING_OFF = 47
        CHARGING = 48
        CHARGED = 49
        DISCHARGING = 50
        UPGRADING = 51
        POWER_LOST = 52
        INITIALIZING = 53
        APPLY_CONFIG_CHANGE = 54
        ONLINE_DISABLE = 55
        OFFLINE_DISABLE = 56
        ONLINE_FROZEN = 57
        OFFLINE_FROZEN = 58
        CLOSED = 59
        REMOVING = 60
        INSERVICE = 61
        OUTOFSERVICE = 62
        ERASEMENT_RUNNING_NORMAL = 63
        ERASEMENT_RUNNING_FAIL = 64
        ERASEMENT_RUNNING_SUCCESS = 65
        SUCCESS = 66
        FAILED = 67
        WAITING = 68
        CANCELLING = 69
        CANCELLED = 70
        RUNNING_PREPARE_SYNC = 71
        RUNNING_SYNCHRONINING = 72
        RUNNING_SYNC_FAILED = 73
        MIGRATION_FAULT = 74
        MiGRATING = 75
        MIGRATION_COMPLETED = 76

    class LicenseFeatureEnum:
        HYPER_REPLICATION = 24
        HYPER_METRO = 63


    class IbcEnum():
        PWD_CHANGED = "true"
        KEYPAIR_CHANGED = "true"

    class EthPortLogicTypeEnum():
        HOST = 0        #主机端口/业务端口
        EXP = 1         #级联端口
        MNGT = 2        #管理端口
        INNER = 3       #内部端口
        MAINTENANCE = 4     #维护端口
        MNGT_SRV = 5        #管理/业务混合口
        MAINTENANCE_SRV = 6 #维护/业务混合口
        BACKUP_MGR = 7      #备份管理网口
        PRODUCT_STORAGE = 8 #生产存储网口
        BACKUP_STORAGE = 9  #备份存储网口
        ETH_NOT_CONFIG = 10 #未配置角色网口
        IP_SCALE_OUT = 11   #用于IP Scale-Out的网口

    class CofigModelEnum():
        SINGLE_CTRL = 0 #单控
        MULTI_CTRL = 1  #多控

    class LightStatusEnum():
        ON = 1
        OFF = 2

    class IpTypeEnum():
        IPV4 = 1
        IPV6 = 2

    class EncLogicTypeEnum():
        EXP = 0   #级联框（硬盘框）
        CTRL = 1  #控制框
        DSW = 2   #数据交换机
        MSW = 3   #管理交换机
        SVP = 4   #管理服务器

    class DataTypeEnum():
        CONFIG_DATA = 3 #配置数据

    class ExportTypeEnum():
        MEMORY = 0 #从内存导出
        DISK = 1 #从硬盘导出

    class DiskEnum():
        DISK0 = "0"
        DISK1 = "1"

    class RecoveryPolicyEnum:
        AUTO = 1
        MANUALLY = 2

    class OperationTypeEnum():
        EXPORT = 1  #导出

    class FileIdEnum():
        CONFIG_DATA = 50    #配置数据文件

    class OperationResultEnum():
        SUCCESS = 0
        FAIL = 1

    class ParentTypeEnum():
        ENCLOSURE = 206#框/Enclosure
        CONTROLLER = 207#控制器/Controller
        EXPBOARD = 208#级联板/Expand Board
        INTF_MODULE = 209#接口模块/Interface Module

    class EnlosureModelEnum():
        CTRL_BMC = 0    #BMC控制框
        CTRL_SAS2U_12 = 1   #2U SAS 12盘主控框
        CTRL_SAS2U_24 = 2   #2U SAS 24盘主控框 
        EXPSAS2U_12 = 16    #2U SAS 12盘级联框
        EXPSAS2U_24 = 17    #2U SAS 24盘级联框
        EXPSAS4U = 18   #4U SAS 24盘级联框
        EXPFC = 19  #4U FC 24盘级联框
        DSW_PCIe1U = 20 #1U PCIe数据交换机
        EXPSAS4U_75 = 21    #4U SAS 75盘级联框
        SVP = 22    #SVP
        CTRL_6U = 97    #6U 4控独立机头
        CTRL_3U = 96    #3U 2控独立机头
        EXPSAS2U_25 = 24    #2U SAS 25盘2.5寸磁盘框
        EXPSAS4U_24_NEW = 25    #4U SAS 24盘3.5寸磁盘框（新）
        CTRL_12GSAS_2U25_EAR = 26   #2U 12GSAS 25盘主控框
        CTRL_12GSAS_2U12_EAR = 23   #2U 12GSAS 12盘主控框
        ARM_2U_12 = 37  #2U 12GSAS 12盘ARM主控框/
        ARM_2U_25 = 38  #2U 12GSAS 25盘ARM主控框/
        EXP_12G_SAS_4U_75 = 39     #12G 4U SAS 75盘 3.5寸级联框
        ENCLOSURE_MODEL_EXPSAS2U_25_12GLINK = 65 #2U SSD 25盘2.5寸级联框/
        CTRL_12GSAS_2U25_EAR_12GLINK = 40,#2U 12G SAS 25盘主控框     

    class ObjectEnum():
        FC_PORT = 212   #FC端口
        ETH_PORT = 213  #以太网口
        SAS_PORT = 214  #SAS端口
        FCoE_PORT = 252 #FCoE端口
        IB_PORT = 16500 #IB端口

    class NetModeEnum():
        UNKNOWN = 0 #无效值
        DIRECT = 1  #直连组网
        SWITCH = 2  #交换机组网
        DIRECT2SWITCH = 3   #直连组网转交换机组网
    
    class QuorumLinkCheckEnum():
        CONTROLLER = 0       #控制器
        IP_SCALEOUT_INTF = 1 #IPScaleOut接口卡
        PCIE_INTF = 2        #PCIe接口卡
        FRONTEND_INTF = 3    #前端接口卡
        MANAGE_BOARD = 4     #管理模块
        FIBRE_MODULE = 5     #光模块
        CABLE_FRONTEND = 6   #前端线缆

class InternalDeviceInfo():
    '''
    Description: Dorado6000 C21增强版内部设备信息
    '''
    INTERNAL_PRODUCT_MODEL = {"key": "internalProductModel", "type": restDataType.DATA_TYPE_STRING}  # 内部产品型号
    CPU_MODEL_INFO = {"key": "cpuModelInfo", "type": restDataType.DATA_TYPE_STRING}  #  CPU型号信息
    CPU_NUMBER = {"key": "cpuNumber", "type": restDataType.DATA_TYPE_UNSIGN_INT}  # CPU核数量


        
