﻿# -*- coding: UTF-8 -*-
import time

from java.lang import Exception as JException

from frameone.util import jsonUtil

class RestConnection(object):
    AUTHENTICATE_URI = r"https://%s:%s/deviceManager/rest/%s/sessions"
    REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
    RE_CONNECTION_TIMES = 3
    PROXY_OF_SVP_CONNECTION_TIMES = 2
    RE_CONNECTION_INTERVAL = 5
    REST_PORT_DEFAULT = 8088
    REST_SCOPE_DEFAULT = "0"
    REST_CAN_NOT_CONNECT_CODE = "1073949185" #与设备通信异常，请检查网络连接或设备状态是否正常
    REST_INVALID_CODE = ["-401", "1077949069"]
    _instance = {}
    _rest = None
       
    def __new__(cls, *args, **kwargs):
        sn = args[2]
        if sn not in cls._instance:
            # 根据设备单例
            cls._instance[sn] = super(RestConnection, cls).__new__(cls, *args,
                                                                   **kwargs)
        return cls._instance.get(sn)

    def __init__(self, connectorFactory, ip, devSN, restPort = REST_PORT_DEFAULT):
        self.connectorFactory = connectorFactory
        self.ip = ip
        self.restPort = restPort
        self.devSN = devSN
        self.baseUri = self.REST_BASE_URI % (self.getUrlIp(ip), str(restPort), str(devSN))
        self.loginUri = self.AUTHENTICATE_URI % (self.getUrlIp(ip), str(restPort), str(devSN))
        self._rest = None
        
    def create(self, user, pawd, scope = REST_SCOPE_DEFAULT):
        """
        @summary: 创建rest连接
        @param user: 用户名
        @param pawd: 密码
        @param scope: 用户类型
        @return: 
            True:建立成功
            False:建立失败   
        """
        successFlag = False
        exception = ""
        reConnectionTimes = 0
        while self._rest is None and reConnectionTimes < \
                RestConnection.RE_CONNECTION_TIMES + RestConnection.PROXY_OF_SVP_CONNECTION_TIMES:
            try:
                restConnector = self.connectorFactory.createRestConnector(self.loginUri, user, pawd, scope)
                restConnection = restConnector.getConnection()
                if reConnectionTimes % 2 == 0:
                    content = restConnection.login().getContent()
                else:
                    content = restConnection.loginSvpProxy().getContent()
                responseInfo = jsonUtil.jsonStr2Dict(content)
                data = responseInfo["data"]
                iBaseToken = data.get("iBaseToken", None)
                if iBaseToken is not None:
                    successFlag = True
                    self._rest = restConnection
                    break
                reConnectionTimes += 1
                safe_sleep(RestConnection.RE_CONNECTION_INTERVAL)
            except (Exception, JException) as e:
                exception = e
                reConnectionTimes += 1
                safe_sleep(RestConnection.RE_CONNECTION_INTERVAL)
        del pawd
        if not successFlag:
            raise Exception(self.REST_CAN_NOT_CONNECT_CODE, unicode(exception))
        
        return successFlag
    
    def close(self):
        if self._rest is not None:
            try:
                self._rest.execDelete(self.loginUri)
            except:
                return
            finally:
                self._rest = None
        return
    
    def getRestConnection(self, user, pawd, scope):
        try:
            if self._rest is None or not self.checkConnetionNormal():
                if self._rest:
                    try:
                        self._rest.close()
                        self._rest = None
                    except:
                        self._rest = None
                self.create(user, pawd, scope)
        except Exception,e:
            raise Exception(self.REST_CAN_NOT_CONNECT_CODE, unicode(e))
        
        return self._rest
    
    def getBaseUri(self):
        return self.baseUri
    
    def getRest(self):
        return self._rest

    def checkConnetionNormal(self):
        uri = self.baseUri + "system/"
        paramsStr = ""
        try:
            records = jsonUtil.jsonStr2Dict(
                self._rest.execGet(uri, paramsStr).getContent())
            error = records["error"]
            error_code = str(error.get("code", "")).strip()
            return error_code not in self.REST_INVALID_CODE
        except:
            return False
    
    def getUrlIp(self,ip):
        if ":" in str(ip):
            return "[%s]" % str(ip)
        return str(ip)


def self_sleep(sec):
    """
    睡眠
    :param sec: 睡眠时间（秒）
    :return:
        True: 执行成功
        False: 执行失败
    """
    try:
        time.sleep(sec)
    except (Exception, JException):
        return False
    return True


def safe_sleep(seconds):
    """
    安全睡眠时间
    :param seconds:  seconds为睡眠时间，单位：秒；数据类型：整数或小数
    :return:
        True: 执行成功
        False: 执行失败
    """
    # noinspection PyBroadException
    try:
        if type(seconds) not in [int, long, float] or seconds <= 0:
            return False

        startTime = time.clock()
        while True:
            if (time.clock() - startTime) >= seconds:
                return True

            # 睡眠一下，避免长时间占用cpu，该时间设置过长会影响睡眠时间精度
            # noinspection PyBroadException
            self_sleep(0.1)
    except (Exception, JException):
        return False
