#coding:utf-8
from frameone.cli import cliUtil
import resource
import logger
import os
import re
import decimal

FILE_SUFFIX = "."

# basePath到tools/xx/这层目录
basePath = os.path.abspath(".")

# 工具配置xml路径文件。
tool_rule_config_path_dict = {
    "inspect" : os.path.join(basePath, "packages", "inspector", "products", "pyframe", "frameone", "ruleConfig",
     "check_item_rule.xml"),
}

def getMsg(lang, msg, args=""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @return: 经过国际化处理后的消息
    '''
    return cliUtil.getMsg(lang, msg, args, resource.MESSAGES_DICT)


def getSoftwarePatchVersion(cli, LANG):
    '''
    @summary: get current device patch version
    '''
    productVersion = ''
    hotPatchVersion = ''
    ((echoStatus, cliRet, errMsg), softwareVersionList, hotPatchVersionList) = parse_upgradePackage(cli, LANG)
    if not echoStatus:
        return False, "", '', errMsg

    for upgradeInfoMap in hotPatchVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if currentVersion:
            hotPatchVersion = currentVersion

    for upgradeInfoMap in softwareVersionList:
        currentVersion = upgradeInfoMap.get("Current Version", "")
        if currentVersion:
            productVersion = currentVersion

    if productVersion and hotPatchVersion:
        return True, productVersion, hotPatchVersion, ''

    return False, "", '', getMsg(LANG, "cannot.get.upgrade.package.info")


def parse_upgradePackage(cli, lang):
    '''
    @summary: 执行show upgrade packge命令，将Software Version与HotPatch Version的
              回显存放到同一个字典列表中，并增加Version Type键来区分Version类型,并返回CLI回显
    @param cli: cli对象
    @param lang: 语言lang
    '''
    cmd = "show upgrade package"
    softwareVersionList = []
    hotPatchVersionList = []

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    if flag != True:
        return ((flag, cliRet, errMsg), softwareVersionList, hotPatchVersionList)

    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[(softwareVersionIndex):hotPatchVersionIndex])
    hotPatchVersionList = cliUtil.getHorizontalCliRet(cliRet[(hotPatchVersionIndex):])

    return ((flag, cliRet, errMsg), softwareVersionList, hotPatchVersionList)


def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""

    if not originLines:
        return postLines

    if not postLines:
        return originLines

    return "\n".join([originLines, postLines])


def paseResult(noRecordsExitCheckResult):
    # 对True和False做转换。
    if noRecordsExitCheckResult:
        if noRecordsExitCheckResult == 'True':
            noRecordsExitCheckResult = True
        elif noRecordsExitCheckResult == 'False':
            noRecordsExitCheckResult = False

    return noRecordsExitCheckResult


def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name


def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)


def getRuleXmlABSPath(toolName):
    return tool_rule_config_path_dict.get(toolName)


def changUnit2GBDecimal(strValue):
    '''
    @summary: 根据传入的值转换单位为GB
    @return: True/False, floatValue
    '''
    floatValue = decimal.Decimal("0.0")
    unitValue = decimal.Decimal("1024")

    try:
        if not strValue:
            return (False, floatValue)

        if re.search("PB", strValue):
            floatValue = decimal.Decimal(strValue.split('P')[0].strip()) * unitValue * unitValue
        elif re.search("TB", strValue):
            floatValue = decimal.Decimal(strValue.split('T')[0].strip()) * unitValue
        elif re.search("GB", strValue):
            floatValue = decimal.Decimal(strValue.split('G')[0].strip())
        elif re.search("MB", strValue):
            floatValue = decimal.Decimal(strValue.split('M')[0].strip()) / unitValue
        elif re.search("KB", strValue):
            floatValue = decimal.Decimal(strValue.split('K')[0].strip()) / unitValue / unitValue
        elif re.search("B", strValue):
            floatValue = decimal.Decimal(strValue.split('B')[0].strip()) / unitValue / unitValue / unitValue
        elif decimal.Decimal(strValue.strip()) == decimal.Decimal("0.0"):
            return (True, floatValue)
        else:
            return (False, floatValue)

        return (True, floatValue)

    except Exception:
        return (False, floatValue)


def compareSnsVersionBigThan(productVersion, targetProduct):
    """
    :param productVersion: v8.1.0b
    :param targetProduct: 'v7.4'
    :return:
    """
    try:
        tmpProductVersionA = '.'.join(productVersion.split('.')[:2]).replace("v", '')
        tmpProductVersionB = targetProduct.replace("v", '')
        return float(tmpProductVersionA) > float(tmpProductVersionB)
    except:
        return tmpProductVersionA > tmpProductVersionB

def compareSnsVersionNotSmarllerThan(productVersion, targetProduct):
    """
    :param productVersion: v8.1.0b
    :param targetProduct: 'v7.4'
    :return:
    """
    try:
        tmpProductVersionA = '.'.join(productVersion.split('.')[:2]).replace("v", '')
        tmpProductVersionB = targetProduct.replace("v", '')
        return float(tmpProductVersionA) >= float(tmpProductVersionB)
    except:
        return tmpProductVersionA >= tmpProductVersionB
