# coding:utf-8
'''
Created on 2018-11-19
'''
from resource import MESSAGES_DICT
from xmlParserByTag import xmlParserByTag
import common
import re
from frameone.cli import cliUtil
from frameone.util import contextUtil
from frameone.rest import restData
from frameone.rest import restUtil
import os
import traceback
import config

checkResult = []


LOGGER = None
DEVTYPE = None


def execute(item_id, cli, py_java_env, LOG):
    """
    入口调用函数
    :param item_id:
    :param cli:
    :param py_java_env:
    :param LOG:
    :return:
    """
    global LOGGER, checkResult
    checkResult = []
    LOGGER = LOG
    LANG = py_java_env.get("lang")
    # 如果其他工具，需要自己配置xml路径。
    xmlPathStr = common.getRuleXmlABSPath("inspect")
    LOGGER.logInfo("xmlPathStr:%s" % str(xmlPathStr))
    ruleDict = xmlParserByTag(xmlPathStr)
    LOGGER.logInfo("ruleDict:%s" % str(ruleDict))
    item_rule_config_list = ruleDict.get(item_id)
    try:
        return executorWraper(item_rule_config_list, cli, py_java_env)
    except cliUtil.RuleExecuteException, e:
        LOGGER.logError(str(traceback.format_exc()))
        errMsg = e.errMsg
        if not errMsg:
            errMsg = common.getMsg(LANG, "query.result.abnormal")
        return e.flag, e.cliRet, errMsg
    except Exception, e:
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "query.result.abnormal")
    finally:
        cliUtil.enterCliModeFromSomeModel(cli, LANG)


def executorWraper(item_rule_config_list, cli, py_java_env):
    """
    执行rule
    :param item_rule_config_list:
    :param cli:
    :param py_java_env:
    :return:
    """
    global DEVTYPE, productVersion, productModel, hotpatchVersion
    LANG = py_java_env.get("lang")
    # 计划增加3个全局变量，任何规则都可配。
    productModel = str(py_java_env.get("devInfo").getDeviceType())
    DEVTYPE = py_java_env.get("devInfo").getItDeviceType().getName()
    LOGGER.logInfo("DEVTYPE:%s," % DEVTYPE)
    if DEVTYPE == "Storage":
        __, productVersion, hotpatchVersion, __ = common.getSoftwarePatchVersion(cli, LANG)
    else:
        productVersion = str(py_java_env.get("devInfo").getProductVersion())
        productModel = config.SNS_TO_TYPE_MAPPING.get(productModel, productModel)
        hotpatchVersion = ''
    retErrMsgList = []
    allCliRetList = []

    LOGGER.logInfo(
        "productVersion:%s,productModel:%s,hotpatchVersion:%s," % (productVersion, productModel, hotpatchVersion))

    if not item_rule_config_list:
        raise cliUtil.RuleExecuteException(cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "rule.config.error"), "")

    # 根据规则过滤后，每条命令的结果List。
    stepDataList = []
    isRiskVersion = True
    # need to check risk version
    needCheckRiskVersion = item_rule_config_list.get("checkRiskVersion", {}).get("needCheck", False)
    if needCheckRiskVersion == True:
        operExp = item_rule_config_list.get("checkRiskVersion", {}).get("operExp", "")
        LOGGER.logInfo("operExp:%s" % operExp)
        if not operExp:
            isRiskVersion = False
        else:
            operExp = eval(operExp.replace("productVersion", "'%s'" % productVersion).replace("productModel", "'%s'" % productModel).replace("hotpatchVersion", "'%s'" % hotpatchVersion))
            LOGGER.logInfo("resutl:%s" % operExp)
            if operExp is True:
                isRiskVersion = True
            else:
                isRiskVersion = False

    LOGGER.logInfo("needCheckRiskVersion:%s,isRiskVersion:%s" % (needCheckRiskVersion, isRiskVersion))
    # 非风险版本，直接通过
    if not isRiskVersion:
        return True, '\n'.join(allCliRetList), ''

    item_rule_list = item_rule_config_list.get("stepList", [])
    for cmd_rule in item_rule_list:
        cmdStr = cmd_rule.get("cmd")
        cmd_param = cmd_rule.get("cmdParam", {})
        LOGGER.logInfo("cmdStr:%s" % str(cmdStr))
        if cmd_param:  # 命令有参数场景， "xx %s"
            param_list = []
            sourDataList = []
            dataIndex = cmd_param.get("cmdId")
            sourDataList = stepDataList[int(dataIndex)]
            valueKey = cmd_param.get("valueKeyList", "")
            param_list = valueKey.split(",")

            for soData in sourDataList:
                param_data_list = []
                for param_key in param_list:
                    param_data_list.append(soData.get(param_key.strip()))
                tmpCmdStr = cmdStr % tuple(param_data_list)
                LOGGER.logInfo("tmpCmdStr:%s" % tmpCmdStr)
                filterDataList = filterRule(py_java_env, cli, tmpCmdStr, LANG, cmd_rule, allCliRetList, retErrMsgList)

        else:  # 命令无参数场景
            filterDataList = filterRule(py_java_env, cli, cmdStr, LANG, cmd_rule, allCliRetList, retErrMsgList)

        LOGGER.logInfo("filterDataList:%s" % str(filterDataList))
        noRecordsExitCheckResult = cmd_rule.get("noRecordsExitCheckResult")

        # 当配置了无结果记录直接返回时生效。
        if not filterDataList and noRecordsExitCheckResult:
            if not retErrMsgList:
                retErrMsgList.append(common.getMsg(LANG, "query.result.abnormal"))
            res_flag = common.paseResult(noRecordsExitCheckResult)
            if res_flag is True or res_flag == "RESULT_NOSUPPORT":
                return res_flag, "\n".join(allCliRetList), ''
            return common.paseResult(noRecordsExitCheckResult), "\n".join(allCliRetList), "\n".join(retErrMsgList)

        stepDataList.append(filterDataList)

    if retErrMsgList:
        if False in checkResult:
            return False, "\n".join(allCliRetList), "".join(retErrMsgList)
        if cliUtil.RESULT_WARNING in checkResult:
            return cliUtil.RESULT_WARNING, "\n".join(allCliRetList), "".join(retErrMsgList)
        elif cliUtil.RESULT_NOCHECK in checkResult:
            return cliUtil.RESULT_NOCHECK, "\n".join(allCliRetList), "".join(retErrMsgList)
        else:
            return False, "\n".join(allCliRetList), "".join(retErrMsgList)
    return True, "\n".join(allCliRetList), ''


def filterRule(py_java_env, cli, cmdStr, LANG, cmd_rule, allCliRetList, retErrMsgList):
    """
    主逻辑。执行命令，提取错误消息。返回结果。
    :param py_java_env:
    :param cli:
    :param cmdStr:
    :param LANG:
    :param cmd_rule:
    :param allCliRetList:
    :param retErrMsgList:
    :return:
    """
    global checkResult
    filterDataList = []
    executeModel = cmd_rule.get("executeModel")
    flag = True
    cliRet = ''
    errMsg = ''
    if cliUtil.executeView.cli == executeModel:
        cliUtil.enterCliModeFromSomeModel(cli, LANG)
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmdStr, True, LANG)

    elif cliUtil.executeView.developer == executeModel:
        # developer下执行命令，默认都是先从CLI模式开始，最后退回到CLI模式
        cliUtil.enterCliModeFromSomeModel(cli, LANG)
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmdStr, True, LANG)

    elif cliUtil.executeView.minisysterm == executeModel:
        # minisysterm下执行命令，默认都是先从CLI模式开始，最后退回到CLI模式
        cliUtil.enterCliModeFromSomeModel(cli, LANG)
        flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmdStr, True, LANG)

    elif cliUtil.executeView.debug == executeModel:
        # debug下执行命令，默认都是先从CLI模式开始，最后退回到CLI模式
        cliUtil.enterCliModeFromSomeModel(cli, LANG)
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmdStr, LANG)

    elif cliUtil.executeView.rest == executeModel:
        # rest命令执行
        flag = True
        dataDict = contextUtil.getContext(py_java_env)
        rest = contextUtil.getRest(dataDict)
        cmdCliRet = rest.getBaseUri() + cmdStr
        allCliRetList.append(cmdCliRet)
        try:
            cliRet = restUtil.CommonRestService.get4Big(rest, cmdStr)
            LOGGER.logInfo("rest cliRet:%s" % str(cliRet))
        except Exception, e:
            flag = cliUtil.RESULT_NOCHECK
            LOGGER.logInfo("rest except:%s" % str(e))
            cliRet = []
        errMsg = ''
    elif cliUtil.executeView.brocadeCli == executeModel:
        cliRet = cli.execCmdWithTimout(cmdStr, 300)
        LOGGER.logInfo("no execute cmd :%s." % str(cmdStr))
        flag, cliRet, errMsg = cliUtil.checkSwitchExcuteSuccess(cliRet, LANG)

    allCliRetList.append(str(cliRet))
    if flag != True:
        raise cliUtil.RuleExecuteException(flag, errMsg, "\n".join(allCliRetList))

    anaMethod = cmd_rule.get("analysisMethod")
    anaMethod = cliUtil.analysisMethodMappingView.get(anaMethod)
    dataDictList = anaMethod(cliRet)
    LOGGER.logInfo("anaMethod dataDictList:%s" % str(dataDictList))
    if not dataDictList:
        return filterDataList

    conditions = cmd_rule.get("rule")
    for dataDict in dataDictList:
        if not conditions:
            filterDataList.append(dataDict)
            continue

        # 遍历所有规则，处理规则和错误信息。
        for condi in conditions:
            # 获取规则信息
            ruleOper = condi.get("condition", "")
            conditionRes = condi.get("conditionRes", "")
            cmd_errMsg = condi.get("errMsg", {})

            veriableReg = re.compile(r'\$\[(.*?)\]')
            veriableList = veriableReg.findall(ruleOper)

            for veriableStr in veriableList:
                velueStr = dataDict.get(veriableStr, "")
                ruleOper = ruleOper.replace("$[%s]" % veriableStr, "'%s'" % velueStr)
            ruleOper = ruleOper.replace("productVersion",
                    "'%s'" % productVersion).replace("productModel", "'%s'" % productModel).replace("hotpatchVersion",
                    "'%s'" % hotpatchVersion)
            LOGGER.logInfo('ruleOper : %s' % ruleOper)
            result = eval(ruleOper)
            LOGGER.logInfo('result : %s' % result)
            if result is True:

                # 记录命中规则的记录
                if dataDict not in filterDataList:
                    filterDataList.append(dataDict)

                if not cmd_errMsg:
                    continue
                checkResult.append(conditionRes)
                msgId = cmd_errMsg.get("msgId")
                errStr = MESSAGES_DICT.get(msgId, {}).get(LANG)

                # 判断错误提示中是否有参数
                errKeyStr = cmd_errMsg.get("errKey")
                if not errKeyStr:
                    if errStr not in retErrMsgList:
                        retErrMsgList.append(errStr)
                else:
                    # 处理参数
                    errMsgParam = []
                    errKeyList = errKeyStr.split(",")
                    for errKey in errKeyList:
                        data_err_msg = None
                        err_msg_para = errKey.strip()
                        if not err_msg_para:
                            continue
                        if isinstance(dataDict, dict):
                            data_err_msg = dataDict.get(err_msg_para, None)
                        if data_err_msg:
                            errMsgParam.append(data_err_msg)
                        else:
                            # 支持错误信息传入常量
                            if err_msg_para == "productVersion":
                                errMsgParam.append(productVersion)
                            elif err_msg_para == "productModel":
                                errMsgParam.append(productModel)
                            elif err_msg_para == "hotpatchVersion":
                                errMsgParam.append(hotpatchVersion)
                            else:
                                errMsgParam.append(err_msg_para)
                    LOGGER.logInfo('errMsgParam : %s' % errMsgParam)
                    LOGGER.logInfo('errStr : %s' % errStr)
                    tmpErrMsg = errStr % tuple(errMsgParam)
                    if tmpErrMsg not in retErrMsgList:
                        retErrMsgList.append(tmpErrMsg)

    return filterDataList