# coding:utf-8
'''
Created on 2019-1-15

'''
import defusedxml.ElementTree as ET


def xmlParserByTag(rule_path):
    xmlElementTree = ET.parse(rule_path)
    checkItems = xmlElementTree.getiterator("checkItem")
    ruleDict = {}
    # 打印每部电影的详细信息
    for checkItem in checkItems:
        if checkItem.attrib.get("id"):
            checkId = checkItem.attrib.get("id")
        checkRiskVersion = {"needCheck":False}
        # 处理风险版本检查
        checkRiskVersionList = checkItem.getiterator('checkRiskVersion')
        if checkRiskVersionList:
            needCheck = checkRiskVersionList[0].attrib.get("needCheck")
            if needCheck == "True":
                tmpNode = checkRiskVersionList[0]
                operExp = tmpNode.text.strip()
                checkRiskVersion["operExp"] = operExp
                    
                checkRiskVersion["needCheck"] = True

        stepNodeList = checkItem.getiterator('step')
        
        stepList = []
        for stepNode in stepNodeList:
            stepDict = {}
            
            stepId = stepNode.attrib.get("id")
            stepDict["id"]=stepId
            
            cmdList = stepNode.getiterator("cmd")
            if cmdList:
                cmdStr = cmdList[0].text
                exeModel = cmdList[0].attrib.get("executeModel")
                analysisMethod = cmdList[0].attrib.get("analysisMethod")
                noRecordsExitCheckResult = cmdList[0].attrib.get(
                    "noRecordsExitCheckResult")
                stepDict["cmd"]=cmdStr
                stepDict["executeModel"]=exeModel
                stepDict["analysisMethod"]=analysisMethod
                stepDict["noRecordsExitCheckResult"] = noRecordsExitCheckResult

            cmdParamsList = stepNode.getiterator("cmdParams")
            if cmdParamsList:
                cmdId = cmdParamsList[0].attrib.get("stepId")
                valueKeyList = cmdParamsList[0].attrib.get("valueKeyList")
                stepDict["cmdParam"] = {"cmdId":cmdId, "valueKeyList":valueKeyList}
            ruleNodeList = stepNode.getiterator("rules")
            ruleList = []
            if ruleNodeList:
                for ruleNode in ruleNodeList[0].getiterator("rule"):
                    ruleDetailDict = {}
                    conditionList = ruleNode.getiterator("condition")
                    if conditionList:
                        condition = conditionList[0].text
                        conditionRes = conditionList[0].attrib.get("result")
                        ruleDetailDict["condition"] = condition
                        if not conditionRes or conditionRes == "False":
                            conditionRes = False
                        ruleDetailDict["conditionRes"] = conditionRes
                    errMsgList = ruleNode.getiterator("errMsg")
                    if errMsgList:
                        msgId = errMsgList[0].attrib.get("msgId")
                        errKey = errMsgList[0].attrib.get("errKey")
                        ruleDetailDict["errMsg"] = {
                                          "msgId":msgId, 
                                          "errKey":errKey
                                          }
                    ruleList.append(ruleDetailDict)
            stepDict["rule"] = ruleList
            stepList.append(stepDict)
        ruleDict[checkId] = {}
        ruleDict[checkId]["checkRiskVersion"] = checkRiskVersion
        ruleDict[checkId]["stepList"] = stepList
    return ruleDict
