# coding:utf-8
""" 
@version: Toolkit V200R005C00
@time: 2018/09/09 
@file: common.py 
@function: 
@modify: 
"""
import functools
import traceback
import threading
import time

errInfoDict = {"query.result.abnormal":
    {
        "zh": u"\n获取信息失败",
        "en": "\nThere is an error in getting information",
    }}


def getErrorLogFunc(logger):
    errorLogFun = None
    if logger and hasattr(logger, 'error'):
        errorLogFun = getattr(logger, 'error', None)
    elif logger and hasattr(logger, 'logError'):
        errorLogFun = getattr(logger, 'logError', None)

    return errorLogFun


def wrapInspectException(lan='en', logger=None, originalInfo=''):
    """封装巡检项执行脚本异常，执行异常时返回未检测。

    如果要带回原始信息，则需要在巡检脚本中将原始信息变量定义为全局变量。

    :param lan: 语言信息
    :param logger: 日志对象，方便记录巡检异常堆栈信息。
    :param originalInfo: 原始信息（异常出现过程时，可能执行了部分检查过程，这些过程的执行结果可以返回到报告中）。
    :return:
    """
    recordErrorLogFunc = getErrorLogFunc(logger)

    def wrapper(func):
        @functools.wraps(func)
        def inner(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except:
                if recordErrorLogFunc:
                    recordErrorLogFunc("exception caught:" + traceback.format_exc())
                return 'NOCHECK', originalInfo, errInfoDict.get("query.result.abnormal").get(lan)

        return inner

    return wrapper


def wrapAllException(func):
    """封装所有异常信息，保证执行函数不会抛出任何异常.

    :param func:
    :return:
    """

    @functools.wraps(func)
    def inner(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except:
            return

    return inner


def wrapAllExceptionLogged(logger=None):
    """封装所有异常信息，并记录日志， 保证执行函数不会抛出任何异常.

    :param logger:
    :return:
    """

    recordErrorLogFunc = getErrorLogFunc(logger)

    def wrapper(func):
        @functools.wraps(func)
        def inner(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except Exception, e:
                if recordErrorLogFunc:
                    recordErrorLogFunc('Exception caught:%s' % e)
                    recordErrorLogFunc('Exception trace:%s) ' % traceback.format_exc())
            except:
                if recordErrorLogFunc:
                    recordErrorLogFunc('Java exception caught?')
                    recordErrorLogFunc('Java exception trace:%s) ' % traceback.format_exc())
                return

        return inner

    return wrapper


def fakeProgress(py_java_env, totalSeconds=1 * 30, logger=None, interval=1):
    """根据预估总体执行时间，模拟进度条.

    :param py_java_env:
    :param totalSeconds: 预估总体执行时间
    :param interval: 进度刷新时间间隔（每次刷新，进度会均匀增长）
    :param logger: 日志对象
    :return:
    """

    def wrapper(func):
        @functools.wraps(func)
        def inner(*args, **kwargs):
            try:
                event = threading.Event()
                t = threading.Thread(target=refreshProgress, args=(py_java_env, totalSeconds, interval, logger, event))
                t.start()
                ret = func(*args, **kwargs)
            finally:
                event.set()
            return ret

        return inner

    return wrapper


def refreshProgress(py_java_env, totalSeconds, intervalSeconds, logger, event):
    """调用UI的进度刷新对象的方法，更新进度.

    :param py_java_env:java上下文
    :param totalSeconds: 预估执行时间
    :param intervalSeconds:进度刷新间隔时间
    :param logger:日志对象
    :return:
    """
    recordErrorLogFunc = getErrorLogFunc(logger)

    def setProgress(progress):
        if observer:
            try:
                observer.updateProgress(int(progress))
            except:
                if recordErrorLogFunc:
                    recordErrorLogFunc('Update progress exception:%s' % traceback.format_exc())

    observer = py_java_env.get("progressObserver")
    cnt = totalSeconds / intervalSeconds
    intervalCnt = 0
    setProgress(1)
    while not event.isSet():
        time.sleep(intervalSeconds)
        intervalCnt += 1
        progress = int(100.0 / cnt * intervalCnt)
        progress = progress if progress < 100 else 99
        setProgress(progress)

    setProgress(100)
