#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import traceback

from py.common.entity.check_result import CheckResult
from py.common.java_adapter import java_adapter
from py.common.entity.task_env import TaskEnv
from py.common.util import common


class CheckItem(object):
    """
    检查项基类
    """
    def __init__(self, env):
        self.task_env = TaskEnv(env)
        # info error warn
        self.logger = java_adapter.get_logger()
        # zh en
        self.lang = java_adapter.get_language()

    def execute(self, method):
        try:
            return getattr(self, str(method))().to_dict()
        except (Exception, java_adapter.get_java_exception_class()):
            self.logger.error(traceback.format_exc())
            return CheckResult(CheckResult.NOT_PASS, "", self.get_msg("get.message.fail")).to_dict()

    def do_check(self):
        # 子类重写
        pass

    def rollback(self):
        # 子类按需重写
        pass

    def get_msg(self, key, args=""):
        return common.get_msg(key, args)
