#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

class CheckResult(object):
    """
    检查结果：结果(int)，原始信息(string)，错误信息(string)
    """
    PASS = 0
    NOT_PASS = 1
    NOT_INVOLVED = 2

    def __init__(self, result, ori_info, err_info, decode_unicode=False):
        self.result = result
        self.ori_info = ori_info
        self.err_info = err_info
        self.decode_unicode = decode_unicode

    def to_dict(self):
        return {
            "result": self.result,
            "ori_info": self._get_decode_info(self.ori_info),
            "err_info": unicode(str(self.err_info)),
        }

    def _get_decode_info(self, info):
        return unicode(str(info)) if not self.decode_unicode \
            else str(info).encode("utf-8").decode("unicode_escape", "ignore")
