#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

class TaskEnv(object):
    """
    任务上下文封装
    """
    def __init__(self, java_task_env):
        if not java_task_env:
            return
        self._context = java_task_env
        self._cluster_node = self._context.getCluster()
        self._cluster_node_dict = self._context.getClusterNodeMap()
        self._no_root_cluster_node_dict = self._context.getNoRootClusterNodeMap()
        self._master_fsm_dev_node = self._context.getMasterFsmClusterNode()
        self._expansion_conf_nodes = self._context.getExpansionConfNodes()
        self._task_cache = self._context.getCache()

    def get_dev_node(self):
        return self._cluster_node

    def get_omm_pass(self):
        return self._context.getOmmPassword()

    def get_master_fsm_dev_node(self):
        return self._master_fsm_dev_node

    def get_cluster_node_dict(self):
        return self._cluster_node_dict

    def get_no_root_cluster_node_dict(self):
        return self._no_root_cluster_node_dict

    def get_task_cache(self):
        return self._task_cache

    def get_expansion_conf_nodes(self):
        return self._expansion_conf_nodes
