#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.


def get_language():
    """
    获取工具当前语言环境
    :return: "zh": 中文，"en": 英文
    """
    from com.huawei.ism.tool.obase.utils import ApplicationContext
    return ApplicationContext.getInstance().getCurrentLanguage().getLanguage()


def get_logger():
    """
    获取日志实例

    :return: 日志实例
    """
    from com.huawei.ism.tool.scaleout.expansion.entity.pyitem import PyItem
    return PyItem.getLogger()


def get_rest_util():
    """
    获取连接工具类，用于拼接URL等

    :return:
    """
    from com.huawei.ism.tool.protocol.utils import RestUtil
    return RestUtil


def get_rest_manager():
    """
    获取rest连接管理器，用于新建、销毁rest连接

    :return: rest连接管理器
    """
    from com.huawei.ism.tool.protocol.rest import RestConnectionManager
    return RestConnectionManager


def get_ssh_manager():
    """
    获取ssh连接管理器，用于新建、销毁ssh连接

    :return: ssh连接管理器
    """
    from com.huawei.ism.tool.obase.connection import SshConnectionManager
    return SshConnectionManager


def get_complete_dev_version(dev_node):
    """
    获取设备完整的版本号

    :param dev_node: 设备
    :return: 完整版本号
    """
    from com.huawei.ism.tool.service.common.DevInfoUtil import getCompleteDevVersion
    return getCompleteDevVersion(dev_node)


def get_script_util():
    """
    获取脚本工具类

    :return: 脚本工具类
    """
    from com.huawei.ism.tool.scaleout.expansion.util import ScriptUtils
    return ScriptUtils.INS


def get_connect_factor_instance():
    """
    获取连接工厂

    :return: 连接工厂
    """
    from com.huawei.ism.tool.protocol.factory.ConnectorFactory import getInstance
    return getInstance()


def get_java_exception_class():
    """
    获取Java异常基类

    :return: Java异常基类
    """
    from java.lang import Exception
    return Exception


def get_base64_encode_util():
    """
    获取base64加解密工具

    :return: base64加解密工具
    """
    from com.huawei.ism.tool.obase.utils import Base64EncodeUtils
    return Base64EncodeUtils


def get_aes_encrypt():
    """
    获取aes加解密工具

    :return: aes加解密工具
    """
    from com.huawei.ism.tool.base.utils import AESEncrypt
    return AESEncrypt

