#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

def check_cm_list(ssh_service, ip_list, ori_info):
    """
    检查新老cm节点cm相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/cm/config/cm.cfg|" \
          "grep -E 'cm_data_ip_list|cm_url|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_ccdb_monitor_list(ssh_service, ip_list, ori_info):
    """
    检查新老ccdb节点ccdb_monitor相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/ccdb/ccdb_monitor/config/ccdb_monitor.cfg|" \
          "grep -E 'deploy_ip_list|cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_djob_list(ssh_service, ip_list, ori_info):
    """
    检查新老djob节点djob相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/djob/config/djob.cfg|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_ccdb_server_list(ssh_service, ip_list, ori_info):
    """
    检查新老ccdb节点ccdb_server相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg|" \
          "grep -E 'deploy_ip_list|cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_dlm_vm_list(ssh_service, ip_list, ori_info):
    """
    检查新老dlm_vm节点dlm_vm相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/dlm_vm/config/dlm_vm.cfg|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_dlm_mm_list(ssh_service, ip_list, ori_info):
    """
    检查新老dlm_mm节点dlm_mm相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/dlm_mm/config/dlm_mm.cfg|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|ns_global_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_ebs_list(ssh_service, ip_list, ori_info):
    """
    检查eds节点ebs相关配置项是否正确
    """
    cmd = "cat /opt/dsware/eds/eds/conf/ebs_server.conf|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    # 未创池的情况下认为ebs通过检查
    if "{{cm_url}}" in cli_ret:
        return True
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_kmm_server_list(ssh_service, ip_list, ori_info):
    """
    检查新老kmm_server节点kmm_server相关配置项是否正确
    """
    cmd = "cat /opt/dfv/oam/oam-u/data/kmm-server/kmm_server.cfg|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_node_sentry_list(ssh_service, ip_list, ori_info):
    """
    检查NodeSentry节点NodeSentry相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/snm/OSM/config/nodesentry.cfg|" \
          "grep -E 'cm_url|cm_be_ip_list|cm_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_vbs_list(ssh_service, ip_list, ori_info):
    """
    检查vbs节点vbs相关配置项是否正确
    """
    cmd1 = "cat /opt/dsware/vbs/conf/vbs_*_config.cfg|grep -E 'cm_ip_list'|cat"
    cmd2 = "cat /opt/dsware/vbs/conf/dr_driver.cfg|grep -E 'ns_global_ip_list'|cat"
    return (check_missing_ip(ssh_service.execute_cmd(cmd1), ip_list, ori_info) and
            check_missing_ip(ssh_service.execute_cmd(cmd2), ip_list, ori_info))


def check_cms_worker_list(ssh_service, ip_list, ori_info):
    """
    检查存储节点cmsworker相关配置项是否正确
    """
    cmd = "cat /opt/dsware/infrastructure/snm/OSM/config/cmsworker.cfg|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|cms_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_fdsa_core_list(ssh_service, ip_list, ori_info):
    """
    检查控制集群节点fdsaCore相关配置项是否正确
    """
    cmd = "cat /opt/fusionstorage/fdsa/conf/fdsa_cluster_srv.conf|" \
          "grep -E 'cm_data_url|cm_url|cm_data_ip_list|cm_be_ip_list|cm_ip_list|cms_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_osd_list(ssh_service, ip_list, ori_info):
    """
    检查存储池节点osd相关配置项是否正确
    """
    cmd = "cat /opt/fusionstorage/persistence_layer/osd/conf/osd_*_conf.cfg|" \
          "grep -E 'g_kms_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_ls_list(ssh_service, ip_list, ori_info):
    """
    检查存储节点ls相关配置项是否正确
    """
    cmd = "cat /opt/dfv/obs_service_layer/objectroutingservice/ls/conf/obs_sod_from_fsm.ini|" \
          "grep -E 'kms_ip_list'|cat"
    cli_ret = ssh_service.execute_cmd(cmd)
    return check_missing_ip(cli_ret, ip_list, ori_info)


def check_missing_ip(cli_ret, ip_list, ori_info):
    """
    检查每一行配置ip是否正确
    """
    for line in cli_ret.splitlines()[1:-1]:
        ip_line = line.split("=")
        if len(ip_line) <= 1:
            ori_info.append(cli_ret)
            return False
        # 配置项cm_be_ip_list使用后端存储ip，其他使用前端ip
        if "cm_be_ip_list" in ip_line[0]:
            check_list = ip_list[1]
        else:
            check_list = ip_list[0]
        missing_ips = [ip for ip in check_list if ip not in ip_line[1]]
        if missing_ips:
            ori_info.append(cli_ret)
            return False
    return True
