#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from py.common.java_adapter import java_adapter


class RestService:
    """
    rest服务类
    """

    def __init__(self, dev_node):
        self.node = dev_node
        self.base_uri = java_adapter.get_rest_util().getDstorageUrlHead(self.node)

    def release_rest(self):
        java_adapter.get_rest_manager().releaseConn(self.node)

    def execute_get(self, url, params=""):
        rest_conn = self.get_rest_connection()
        response = rest_conn.execGet("{}{}".format(self.base_uri, url), params)
        if not response.isSuccess():
            return ""
        return response.getContent()

    def execute_post(self, url, params=""):
        rest = self.get_rest_connection()
        response = rest.execPost("{}{}".format(self.base_uri, url), params)
        if not response.isSuccess():
            return ""
        return response.getContent()

    def get_rest_connection(self):
        """
        获取rest链接
        :return:
        """

        return java_adapter.get_rest_manager().getRestConnection(self.node)


class SshService:
    """
    ssh连接服务类
    """

    def __init__(self, dev_node):
        self.node = dev_node

    def execute_cmd(self, cmd):
        ssh_conn = self.get_ssh_connection()
        return ssh_conn.execCmdWithTimout(cmd, 2 * 60)

    def execute_cmd_with_timeout(self, cmd, timeout):
        ssh_conn = self.get_ssh_connection()
        return ssh_conn.execCmdWithKeepAlive(cmd, 30, timeout)

    def execute_cmd_no_log(self, cmd):
        ssh_conn = self.get_ssh_connection()
        return ssh_conn.execCmdNoLogTimout(cmd, 2 * 60)

    def execute_cmd_no_check_result(self, cmd, end_str):
        ssh_conn = self.get_ssh_connection()
        return ssh_conn.execCmdWithTimout(cmd, 2 * 60, end_str)

    def release_ssh(self):
        java_adapter.get_ssh_manager().releaseConnection(self.node)

    def get_ssh_connection(self):
        """
        获取ssh链接
        :return:
        """
        return java_adapter.get_ssh_manager().getSshConnection(self.node)
