#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import json

from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult
from py.common.util.connection_util import RestService

QUERY_UNRECOVERED_ALARM_URL = "/api/v2/common/alarms?filter=alarmStatus::1"


def execute(env, method):
    return CheckAlarm(env).execute(method)


class CheckAlarm(CheckItem):
    def __init__(self, env):
        super(CheckAlarm, self).__init__(env)
        self.cluster = self.task_env.get_dev_node()
        self.cache_dict = self.task_env.get_task_cache()

    def do_check(self):
        """
        检查是否有新增告警信息
        """
        alarm_sequence_list_before = self.cache_dict.get("alarmSequence")
        res_dict = json.loads(RestService(self.cluster).execute_get(QUERY_UNRECOVERED_ALARM_URL))
        if (not res_dict) or (res_dict.get("result").get("code") != 0):
            err_msg = self.get_msg("record.alarm.information.fail")
            return CheckResult(CheckResult.NOT_PASS, res_dict, err_msg, True)
        new_alarm_list = self.get_new_alarm_info(res_dict.get("data"), alarm_sequence_list_before)
        if new_alarm_list:
            new_alarm_names = [info.get("alarm_name") for info in new_alarm_list]
            err_msg = self.get_msg("check.alarm.information.not.pass", "\n".join(new_alarm_names))
            return CheckResult(CheckResult.NOT_PASS, json.dumps(new_alarm_list).replace("\\n", ""), err_msg, True)
        return CheckResult(CheckResult.PASS, res_dict, "", True)

    @staticmethod
    def get_new_alarm_info(alarm_info_list_after, alarm_info_list_before):
        new_alarm_list = []
        for alarm_info in alarm_info_list_after:
            alarm_sequence = alarm_info.get("sequence")
            if alarm_sequence in alarm_info_list_before:
                continue
            new_alarm_list.append(alarm_info)
        return new_alarm_list
