#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from py.common.util import common
from py.common.entity.check_result import CheckResult
from py.common.entity.check_item import CheckItem
from py.common.util.connection_util import SshService


def execute(env, method):
    return CheckDlmMm(env).execute(method)


class CheckDlmMm(CheckItem):
    def __init__(self, env):
        super(CheckDlmMm, self).__init__(env)
        self.fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        self.path = self.task_env.get_task_cache().get("unzip_folder_path")
        self.expansion_conf_node_list = self.task_env.get_expansion_conf_nodes()
        self.dev_node_dict = self.task_env.get_cluster_node_dict()

    def do_check(self):
        """
        检查DLM_MM进程
        """
        err_msg, ori_info = [], []
        # 获得DlmMmNode.List文件节点ip列表
        dlm_mm_node_ip_list = common.get_list_file_ips(
            SshService(self.fsm_dev_node), self.task_env, "DlmMmNode.List")
        # 待检查节点=文件记录ip节点+新扩节点
        node_list = []
        for dlm_mm_node_ip in dlm_mm_node_ip_list:
            node_list.append(self.dev_node_dict.get(dlm_mm_node_ip))
        for expansion_node in self.expansion_conf_node_list:
            node_list.append(self.dev_node_dict.get(expansion_node.getIp()))
        self.check_dlm_local_status(node_list, ori_info, err_msg)
        if err_msg:
            return CheckResult(CheckResult.NOT_PASS, ori_info, "\n".join(err_msg))
        return CheckResult(CheckResult.PASS, ori_info, "")

    def check_dlm_local_status(self, node_list, ori_info, err_msg):
        # 依次登录节点检查dlm_mm进程状态
        master_node_list = []
        for node in node_list:
            ssh_service = SshService(node)
            common.attach_app(ssh_service, "dlm_mm")
            cli_ret = ssh_service.execute_cmd("dlm election show status")
            ori_info.append(cli_ret)
            local_status = self.get_dlm_local_status(cli_ret)
            if local_status not in ["BeMaster", "BeSlave"]:
                err_msg.append(self.get_msg("check.dlm.status.not.pass", (node.getIp(), local_status)))
            if local_status == "BeMaster":
                master_node_list.append(node.getIp())
            ssh_service.release_ssh()
        # master节点必须唯一
        if not master_node_list:
            err_msg.append(self.get_msg("check.dlm.status.no.master.fail"))
        elif len(master_node_list) != 1:
            err_msg.append(self.get_msg("check.dlm.status.not.one.master.fail", ",".join(master_node_list)))

    @staticmethod
    def get_dlm_local_status(cli_ret):
        for line in cli_ret.splitlines():
            line = line.strip().split()
            if line[0] == "Local_Status":
                return line[-1]
        return ""
