#  coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import json
from py.common.java_adapter import java_adapter
from py.common.entity.check_item import CheckItem
from py.common.util.connection_util import RestService
from py.common.entity.check_result import CheckResult


def execute(env, method):
    """
    :return: 脚本执行结果
    """
    return CheckMultiIp(env).execute(method)


class CheckMultiIp(CheckItem):
    def __init__(self, env):
        super(CheckMultiIp, self).__init__(env)
        self.ori_infos = list()
        self.multi_ip_infos = list()

    def do_check(self):
        """
        zk扩容
        检查产品版本号参看check_product_version.py
        该环境为801版本或812版本但是接口查询显示为非多IP环境则符要求
        1、801版本默认不支持多IP环境，如果版本号为801直接认为通过
        2、8.1.x版本可通过接口查询网络平面配置，判断响应字段multi_ip_flag的值是否为false；为false则通过
        :return:
        """
        cluster = self.task_env.get_dev_node()
        rest_service = RestService(cluster)
        version = java_adapter.get_complete_dev_version(cluster)
        if version.startswith("8.0.1"):
            return CheckResult(CheckResult.NOT_INVOLVED, "", "")
        if self._is_multi_ip(rest_service, "storage_frontend"):
            return CheckResult(CheckResult.NOT_PASS, "\n".join(self.ori_infos),
                               self.get_msg("exist.multi.ip.failed", cluster.getIp()))
        if self._is_multi_ip(rest_service, "storage_backend"):
            return CheckResult(CheckResult.NOT_PASS, "\n".join(self.ori_infos),
                               self.get_msg("exist.multi.ip.failed", cluster.getIp()))
        return CheckResult(CheckResult.PASS, "\n".join(self.ori_infos), "")

    def _is_multi_ip(self, rest_service, network_type):
        uri = "/api/v2/network_service/network_platform?network_type={}".format(network_type)
        network_type_info = rest_service.execute_get(uri)
        json_network_type = json.loads(network_type_info)
        self.ori_infos.append(network_type_info)
        return json_network_type.get("data", {}).get("multi_ip_flag", "")
