#  coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from py.common.util import common
from py.common.util.connection_util import SshService
from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult

ENE_STR = ["This operation is high risk,please input y to continue:"]
RESULT = "result(0)"


def execute(env, method):
    return CheckNodeLink(env).execute(method)


class CheckNodeLink(CheckItem):
    def do_check(self):
        """
        zk扩容
        SSH登录主FSM节点后，执行检查链路状态的指令，判断回显是否存在错误
        :return:
        """
        target_path = self.task_env.get_task_cache().get("unzip_folder_path")
        ssh_service = SshService(self.task_env.get_master_fsm_dev_node())

        ip_list_result = common.command_result_redirect_to_file_strip_cc(ssh_service, self.task_env, "GetIpList",
                                                                         "GetIpList.txt")
        if RESULT not in ip_list_result:
            return CheckResult(CheckResult.NOT_PASS, ip_list_result, self.get_msg("get.ip.list.file"))

        node_link_result = common.command_result_redirect_to_file_strip_cc(ssh_service, self.task_env, "CheckNodeLink",
                                                                           "CheckNodeLink.txt")
        if RESULT not in node_link_result:
            return CheckResult(CheckResult.NOT_PASS, node_link_result, self.get_msg("check.node.list.error"))
        return CheckResult(CheckResult.PASS, "{}\n{}".format(ip_list_result, node_link_result), "")
