#  coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

from py.common.util import common
from py.common.java_adapter import java_adapter
from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult

BLOCK_LIST = ["8.0.1", "8.0.1.1", "8.0.1.SPH5", "8.0.1.SPH8", "8.0.1.3", "8.0.1.SPH9", "8.0.1.SPH10", "8.0.1.SPH11",
              "8.0.1.SPH302", "8.0.1.SPH12", "8.0.1.SPH303", "8.0.1.5", "8.0.1.SPH13", "8.1.0", "8.1.0.SPH1",
              "8.1.0.SPH2"]

SUPPORT_LIST_STARTSWITH = \
    ["8.0.1", "8.1.0", "8.1.2", "8.1.3", "8.1.5", "8.1.RC7", "8.1.6", "8.2.0", "8.2.1", "1.0"]


def execute(env, method):
    return CheckProductVersion(env).execute(method)


class CheckProductVersion(CheckItem):
    def do_check(self):
        """
        zk扩容：
        检查产品版本号
        801,810在产品黑名单中的不支持扩容，812及以后不需要区分补丁版本，都支持扩容
        :return:
        """
        version = self.task_env.get_dev_node().getProductVersionToShow()
        org_info = self.get_msg("node.product.version", version)
        if version.upper() in BLOCK_LIST:
            return CheckResult(CheckResult.NOT_PASS, org_info,
                               self.get_msg("check.product.version.not.match", version))
        if self._is_support_version(version):
            return CheckResult(CheckResult.PASS, org_info, "")
        return CheckResult(CheckResult.NOT_PASS, org_info,
                           common.get_msg("check.product.version.not.match", version))

    def _is_support_version(self, version):
        for support_version in SUPPORT_LIST_STARTSWITH:
            if version.startswith(support_version):
                return True
        return False
