#  coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import json
from py.common.util.connection_util import RestService
from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult

CLIENT_DATA = {
    "op": "drCmd",
    "serviceType": "dr",
    "subOp": "queryControlCluster",
}


def execute(env, method):
    return CheckReplicationCluster(env).execute(method)


class CheckReplicationCluster(CheckItem):
    def do_check(self):
        """
        zk扩容
        当前集群不存在复制控制集群符合要求
        使用接口：https://${ip}:${port}/dsware/service/serviceCmd
        固定参数为：op=drCmd,serviceType=dr,subOp=queryControlCluster
        判断标准：serviceCmdData列表为空则符合
        :return: 执行结果
        """
        uri = "/dsware/service/serviceCmd"
        rest_service = RestService(self.task_env.get_dev_node())
        response_info = rest_service.execute_post(uri, CLIENT_DATA)
        response_json = json.loads(response_info)
        if response_json.get("result", -1) != 0:
            return CheckResult(CheckResult.NOT_PASS, str(response_json),
                               self.get_msg("query.replication.cluster.info.failed"))
        if len(response_json.get("serviceCmdData", [])) != 0:
            return CheckResult(CheckResult.NOT_PASS, str(response_json),
                               self.get_msg("exist.replication.cluster"))
        return CheckResult(CheckResult.PASS, str(response_json), "")
