#  coding: UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import re
from py.common.util.connection_util import SshService
from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult
from py.common.java_adapter import java_adapter


def execute(env, method):
    return CheckStoragePool(env).execute(method)


class CheckStoragePool(CheckItem):
    def do_check(self):
        """
        zk扩容
        检查产品版本号参看check_product_version.py
        1、801存储就是块存储，默认都支持
        2、8.1.x版本需要在管理节点上根据/opt/network/network_config.ini
           配置中的product_series的值判断存储类型：pacific表示融合环境，atlantic表示块环境
        :return:
        """
        version = java_adapter.get_complete_dev_version(self.task_env.get_dev_node())
        if version.startswith("8.0.1"):
            return CheckResult(CheckResult.NOT_INVOLVED, "", "")
        fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        ssh_service = SshService(fsm_dev_node)
        cmd = "cat /opt/network/network_config.ini"
        config_info = ssh_service.execute_cmd(cmd)
        config_row_infos = config_info.splitlines()
        if len(config_row_infos) < 3:
            return CheckResult(CheckResult.NOT_PASS, config_info,
                               self.get_msg("no.environment.failed"))
        for row_info in config_row_infos:
            product_series = re.compile("(?<=product_series=).*").findall(row_info)
            if (len(product_series) > 0) and (product_series[0] == "pacific"):
                return CheckResult(CheckResult.NOT_PASS, config_info,
                                   self.get_msg("block.environment.failed", fsm_dev_node.getIp()))
        return CheckResult(CheckResult.PASS, config_info, "")
