#  coding=utf-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from py.common.util import common
from py.common.entity.check_item import CheckItem
from py.common.entity.check_result import CheckResult
from py.common.util.connection_util import SshService


def execute(env, method):
    return ExpansionCm(env).execute(method)


class ExpansionCm(CheckItem):
    def __init__(self, env):
        super(ExpansionCm, self).__init__(env)
        self.fsm_dev_node = self.task_env.get_master_fsm_dev_node()
        self.path = self.task_env.get_task_cache().get("unzip_folder_path")
        self.expand_result_file = "cm_expand_result.txt"
        self.rollback_result_file = "cm_rollback_result.txt"

    def do_check(self):
        """
        扩容CM节点
        """
        self.clean_fix_log()
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "ExpandEdsCmCluster", self.expand_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "CM"))
        return CheckResult(CheckResult.PASS, last_line, "")

    def rollback(self):
        """
        回退逻辑
        """
        ssh_service = SshService(self.fsm_dev_node)
        last_line = common.command_result_redirect_to_file_strip_cc(
            ssh_service, self.task_env, "RollbackEdsCmCluster", self.rollback_result_file)
        if "result(0)" not in last_line:
            return CheckResult(CheckResult.NOT_PASS, last_line,
                               self.get_msg("eds.cluster.expand.fail", "CM"))
        return CheckResult(CheckResult.PASS, last_line, "")

    def clean_fix_log(self):
        # 清理记录文件防止对第二次扩容产生影响，临时实现，以后改为产品脚本侧修改
        ssh_service = SshService(self.fsm_dev_node)
        ssh_service.execute_cmd("cd {}".format(self.path))
        ssh_service.execute_cmd("rm -f fix_*")
